/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security;

import java.io.IOException;
import java.nio.file.Path;
import jdk.test.lib.Platform;
import jdk.test.lib.artifacts.Artifact;
import jdk.test.lib.artifacts.ArtifactResolver;
import jdk.test.lib.process.ProcessTools;
import jtreg.SkippedException;

public class OpensslArtifactFetcher {
    private static final String OPENSSL_BUNDLE_VERSION = "3.5.1";
    private static final String OPENSSL_ORG = "jpg.tests.jdk.openssl";

    public static String getOpensslPath() {
        String path = OpensslArtifactFetcher.getOpensslFromSystemProp(OPENSSL_BUNDLE_VERSION);
        if (path != null) {
            System.out.println("Using OpenSSL from system property.");
            return path;
        }
        path = OpensslArtifactFetcher.getDefaultSystemOpensslPath(OPENSSL_BUNDLE_VERSION);
        if (path != null) {
            System.out.println("Using OpenSSL from system.");
            return path;
        }
        if (Platform.isX64()) {
            if (Platform.isLinux()) {
                return OpensslArtifactFetcher.fetchOpenssl(LINUX_X64.class);
            }
            if (Platform.isOSX()) {
                return OpensslArtifactFetcher.fetchOpenssl(MACOSX_X64.class);
            }
            if (Platform.isWindows()) {
                return OpensslArtifactFetcher.fetchOpenssl(WINDOWS_X64.class);
            }
        } else if (Platform.isAArch64()) {
            if (Platform.isLinux()) {
                return OpensslArtifactFetcher.fetchOpenssl(LINUX_AARCH64.class);
            }
            if (Platform.isOSX()) {
                return OpensslArtifactFetcher.fetchOpenssl(MACOSX_AARCH64.class);
            }
        }
        throw new SkippedException(String.format("No OpenSSL %s found for %s/%s", OPENSSL_BUNDLE_VERSION, Platform.getOsName(), Platform.getOsArch()));
    }

    private static String getOpensslFromSystemProp(String version) {
        String path = System.getProperty("test.openssl.path");
        System.out.println("System Property - test.openssl.path: " + path);
        if (!OpensslArtifactFetcher.verifyOpensslVersion(path, version)) {
            path = null;
        }
        return path;
    }

    private static String getDefaultSystemOpensslPath(String version) {
        if (OpensslArtifactFetcher.verifyOpensslVersion("openssl", version)) {
            return "openssl";
        }
        if (OpensslArtifactFetcher.verifyOpensslVersion("/usr/local/bin/openssl", version)) {
            return "/usr/local/bin/openssl";
        }
        return null;
    }

    private static boolean verifyOpensslVersion(String path, String version) {
        if (path != null) {
            try {
                ProcessTools.executeCommand(path, "version").shouldHaveExitValue(0).shouldContain(version);
                return true;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    private static String fetchOpenssl(Class<?> clazz) {
        try {
            return ArtifactResolver.fetchOne(clazz).resolve("openssl", new String[]{"bin", "openssl"}).toString();
        }
        catch (IOException exc) {
            throw new SkippedException("Could not find openssl", exc);
        }
    }

    public static Path getProviderPath(String opensslPath) {
        Path openSslRootPath = Path.of(opensslPath, new String[0]).getParent().getParent();
        String libDir = "lib";
        if (Platform.isX64() && (Platform.isLinux() || Platform.isWindows())) {
            libDir = "lib64";
        }
        return openSslRootPath.resolve(libDir, new String[]{"ossl-modules"});
    }

    public static String getTestOpensslBundleVersion() {
        return OPENSSL_BUNDLE_VERSION;
    }

    @Artifact(organization="jpg.tests.jdk.openssl", name="openssl-linux_x64", revision="3.5.1", extension="zip")
    private static class LINUX_X64 {
        private LINUX_X64() {
        }
    }

    @Artifact(organization="jpg.tests.jdk.openssl", name="openssl-macosx_x64", revision="3.5.1", extension="zip")
    private static class MACOSX_X64 {
        private MACOSX_X64() {
        }
    }

    @Artifact(organization="jpg.tests.jdk.openssl", name="openssl-windows_x64", revision="3.5.1", extension="zip")
    private static class WINDOWS_X64 {
        private WINDOWS_X64() {
        }
    }

    @Artifact(organization="jpg.tests.jdk.openssl", name="openssl-linux_aarch64", revision="3.5.1", extension="zip")
    private static class LINUX_AARCH64 {
        private LINUX_AARCH64() {
        }
    }

    @Artifact(organization="jpg.tests.jdk.openssl", name="openssl-macosx_aarch64", revision="3.5.1", extension="zip")
    private static class MACOSX_AARCH64 {
        private MACOSX_AARCH64() {
        }
    }
}

