/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: thread_command_full_64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the thread_command_full_64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=thread_command_full_64.class)
public class thread_command_full_64Pointer extends StructurePointer {

	// NULL
	public static final thread_command_full_64Pointer NULL = new thread_command_full_64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected thread_command_full_64Pointer(long address) {
		super(address);
	}

	public static thread_command_full_64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static thread_command_full_64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static thread_command_full_64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new thread_command_full_64Pointer(address);
	}

	public thread_command_full_64Pointer add(long count) {
		return thread_command_full_64Pointer.cast(address + (thread_command_full_64.SIZEOF * count));
	}

	public thread_command_full_64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public thread_command_full_64Pointer addOffset(long offset) {
		return thread_command_full_64Pointer.cast(address + offset);
	}

	public thread_command_full_64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public thread_command_full_64Pointer sub(long count) {
		return thread_command_full_64Pointer.cast(address - (thread_command_full_64.SIZEOF * count));
	}

	public thread_command_full_64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public thread_command_full_64Pointer subOffset(long offset) {
		return thread_command_full_64Pointer.cast(address - offset);
	}

	public thread_command_full_64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public thread_command_full_64Pointer untag(long mask) {
		return thread_command_full_64Pointer.cast(address & ~mask);
	}

	public thread_command_full_64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return thread_command_full_64.SIZEOF;
	}

	// Implementation methods

	// U32 cmd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cmdOffset_", declaredType="U32")
	public UDATA cmd() throws CorruptDataException {
		return new U32(getIntAtOffset(thread_command_full_64._cmdOffset_));
	}

	// U32 cmd
	public UDATAPointer cmdEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread_command_full_64._cmdOffset_));
	}

	// U32 cmdsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cmdsizeOffset_", declaredType="U32")
	public UDATA cmdsize() throws CorruptDataException {
		return new U32(getIntAtOffset(thread_command_full_64._cmdsizeOffset_));
	}

	// U32 cmdsize
	public UDATAPointer cmdsizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thread_command_full_64._cmdsizeOffset_));
	}

	// x86_exception_state_t exceptions
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_exceptionsOffset_", declaredType="x86_exception_state_t")
	public x86_exception_statePointer exceptions() throws CorruptDataException {
		return x86_exception_statePointer.cast(nonNullFieldEA(thread_command_full_64._exceptionsOffset_));
	}

	// x86_exception_state_t exceptions
	public PointerPointer exceptionsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread_command_full_64._exceptionsOffset_));
	}

	// x86_float_state_t float_state
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_float_stateOffset_", declaredType="x86_float_state_t")
	public x86_float_statePointer float_state() throws CorruptDataException {
		return x86_float_statePointer.cast(nonNullFieldEA(thread_command_full_64._float_stateOffset_));
	}

	// x86_float_state_t float_state
	public PointerPointer float_stateEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread_command_full_64._float_stateOffset_));
	}

	// x86_thread_state_t thread_state
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_thread_stateOffset_", declaredType="x86_thread_state_t")
	public x86_thread_statePointer thread_state() throws CorruptDataException {
		return x86_thread_statePointer.cast(nonNullFieldEA(thread_command_full_64._thread_stateOffset_));
	}

	// x86_thread_state_t thread_state
	public PointerPointer thread_stateEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thread_command_full_64._thread_stateOffset_));
	}

}
