/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.le;

import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpace;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpaceImageInputStream;
import com.ibm.dtfj.corereaders.zos.le.Caa;
import com.ibm.dtfj.corereaders.zos.le.Ceexedb32Template;
import com.ibm.dtfj.corereaders.zos.le.Ceexedb64Template;
import com.ibm.dtfj.corereaders.zos.le.CeexedbTemplate;
import com.ibm.dtfj.corereaders.zos.le.Dll;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class Edb {
    private long address;
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private Properties envVars;
    CeexedbTemplate ceexedbTemplate;
    private static Logger log = Logger.getLogger(Edb.class.getName());

    public Edb(long l, AddressSpace addressSpace) {
        this.address = l;
        this.space = addressSpace;
        this.inputStream = addressSpace.getImageInputStream();
        this.createTemplates(addressSpace);
    }

    void createTemplates(AddressSpace addressSpace) {
        if (this.ceexedbTemplate == null) {
            this.ceexedbTemplate = addressSpace.is64bit() ? new Ceexedb64Template() : new Ceexedb32Template();
        }
    }

    public long address() {
        return this.address;
    }

    public long ceeedb_ceeosigr() throws IOException {
        return this.ceexedbTemplate.getCeeedb_ceeosigr(this.inputStream, this.address);
    }

    public long ceeedbdba() throws IOException {
        return this.ceexedbTemplate.getCeeedbdba(this.inputStream, this.address);
    }

    public static Edb getSampleEdb(AddressSpace addressSpace) {
        Caa[] caaArray = Caa.getCaas(addressSpace);
        for (int i = 0; i < caaArray.length; ++i) {
            Edb edb = caaArray[i].getEdb();
            log.fine("found edb " + edb + " for caa " + caaArray[i]);
            try {
                if (edb.getFirstDll() == null) continue;
                log.fine("edb has a dll: " + edb.getFirstDll());
                return edb;
            }
            catch (IOException iOException) {
                log.fine("caught exception: " + iOException);
            }
        }
        log.fine("no sample edb found");
        return null;
    }

    public Dll getFirstDll() throws IOException {
        long l = this.ceexedbTemplate.getCeeedb_dlcb_first(this.inputStream, this.address);
        log.fine("ceeedb_dlcb_first = " + Edb.hex(l));
        return l == 0L ? null : new Dll(l, this.space);
    }

    public Properties getEnvVars() throws IOException {
        if (this.envVars != null) {
            return this.envVars;
        }
        this.envVars = new Properties();
        long l = this.ceexedbTemplate.getCeeedbenvar(this.inputStream, this.address);
        long l2 = 0L;
        while ((l2 = this.space.readWord(l)) != 0L) {
            String string = this.space.readEbcdicCString(l2);
            int n = string.indexOf(61);
            if (n > 0) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                this.envVars.put(string2, string3);
            } else {
                this.envVars.put(string, "");
            }
            l += (long)this.space.getWordLength();
        }
        return this.envVars;
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }

    private static String hex(int n) {
        return Integer.toHexString(n);
    }

    public String toString() {
        return Edb.hex(this.address);
    }
}

