/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.monitor;

import com.ibm.dtfj.javacore.parser.framework.tag.LineRule;
import com.ibm.dtfj.javacore.parser.framework.tag.TagParser;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonPatternMatchers;
import com.ibm.dtfj.javacore.parser.j9.section.monitor.IMonitorTypes;
import com.ibm.dtfj.javacore.parser.j9.section.monitor.MonitorObjectLineRule;

public class MonitorTagParser
extends TagParser
implements IMonitorTypes {
    public MonitorTagParser() {
        super("LOCKS");
    }

    @Override
    protected void initTagAttributeRules() {
        this.addTag("1LKPOOLINFO", null);
        this.addPoolTotal();
        this.addTag("1LKMONPOOLDUMP", null);
        this.addMonInUse();
        this.addMonObject();
        this.addTag("3LKWAITERQ", null);
        this.addWaiter();
        this.addTag("3LKNOTIFYQ", null);
        this.addWaitNotify();
        this.addTag("1LKREGMONDUMP", null);
        this.addRegMon();
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String string, int n) {
                this.addToken("LOCKS", CommonPatternMatchers.allButLineFeed);
            }
        };
        this.addTag("1LKFLATMONDUMP", lineRule);
        LineRule lineRule2 = new LineRule(){

            @Override
            public void processLine(String string, int n) {
                this.addPrefixedHexToken("monitor_flat_id");
                this.addToken("monitor_thd_name", CommonPatternMatchers.quoted_stringvalue);
                this.addPrefixedHexToken("monitor_thread_id");
                this.addPrefixedHexToken("monitor_thread_ee");
            }
        };
        this.addTag("2LKFLATMON", lineRule2);
        this.addTag("1LKOBJMONDUMP", null);
        MonitorObjectLineRule monitorObjectLineRule = new MonitorObjectLineRule(){

            @Override
            public void processLine(String string, int n) {
                this.addMonitorObjectNameAndAddress();
            }
        };
        this.addTag("2LKINFLATEDMON", monitorObjectLineRule);
        this.addTag("3LKINFLDETAILS", null);
        this.addTag("2LKFLATLOCKED", monitorObjectLineRule);
        LineRule lineRule3 = new LineRule(){

            @Override
            public void processLine(String string, int n) {
                this.addPrefixedHexToken("monitor_flat_id");
            }
        };
        this.addTag("3LKFLATDETAILS", lineRule3);
    }

    private void addPoolTotal() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String string, int n) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.addToken("mon_total_monitors", CommonPatternMatchers.dec);
            }
        };
        this.addTag("2LKPOOLTOTAL", lineRule);
    }

    private void addMonInUse() {
        MonitorObjectLineRule monitorObjectLineRule = new MonitorObjectLineRule(){

            @Override
            public void processLine(String string, int n) {
                this.addSystemAndInflatedThdInfo();
            }
        };
        this.addTag("2LKMONINUSE", monitorObjectLineRule);
    }

    private void addMonObject() {
        MonitorObjectLineRule monitorObjectLineRule = new MonitorObjectLineRule(){

            @Override
            public void processLine(String string, int n) {
                this.addMonitorObjectNameAndAddress();
            }
        };
        this.addTag("3LKMONOBJECT", monitorObjectLineRule);
    }

    private void addWaiter() {
        MonitorObjectLineRule monitorObjectLineRule = new MonitorObjectLineRule(){

            @Override
            public void processLine(String string, int n) {
                this.addVMThreadInformation();
            }
        };
        this.addTag("3LKWAITER", monitorObjectLineRule);
    }

    private void addWaitNotify() {
        MonitorObjectLineRule monitorObjectLineRule = new MonitorObjectLineRule(){

            @Override
            public void processLine(String string, int n) {
                this.addVMThreadInformation();
            }
        };
        this.addTag("3LKWAITNOTIFY", monitorObjectLineRule);
    }

    private void addRegMon() {
        MonitorObjectLineRule monitorObjectLineRule = new MonitorObjectLineRule(){

            @Override
            public void processLine(String string, int n) {
                this.addMonitorLockNameAndAddress();
            }
        };
        this.addTag("2LKREGMON", monitorObjectLineRule);
    }
}

