/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.Table;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm29.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.io.PrintStream;

public class FindInstances
extends Command {
    private String className;
    private J9ClassPointer classPointer;
    private Table data;
    private long corruptCount;
    private long objectsFound;

    public FindInstances() {
        this.addCommand("findinstances", "<classname>", "find all instances of the specific class and its subclasses");
    }

    private static void printUsage(PrintStream printStream) {
        printStream.println("findinstances <name> - find all instances of the specific class and its subclasses");
    }

    private boolean parseArgs(PrintStream printStream, String[] stringArray) throws DDRInteractiveCommandException {
        if (stringArray == null || stringArray.length != 1) {
            printStream.println("Exactly one argument expected");
            return false;
        }
        String string = stringArray[0];
        if (string.equals("help")) {
            FindInstances.printUsage(printStream);
            return false;
        }
        this.className = string;
        return true;
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (!this.parseArgs(printStream, stringArray)) {
            return;
        }
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            ClassSegmentIterator classSegmentIterator = new ClassSegmentIterator(j9JavaVMPointer.classMemorySegments());
            printStream.format("Searching for class named '%s' in VM=%s%n", this.className, Long.toHexString(j9JavaVMPointer.getAddress()));
            this.classPointer = null;
            while (classSegmentIterator.hasNext()) {
                J9ClassPointer j9ClassPointer = (J9ClassPointer)classSegmentIterator.next();
                String string2 = J9ClassHelper.getJavaName(j9ClassPointer);
                if (!this.className.equals(string2)) continue;
                String string3 = j9ClassPointer.getHexAddress();
                this.classPointer = j9ClassPointer;
                printStream.format("Found !j9class %s named %s%n", string3, string2);
                break;
            }
            if (this.classPointer == null) {
                printStream.format("No class named %s found%n", this.className);
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
        this.data = new Table("Instances of " + this.className);
        this.data.row("Address", "Class Name");
        this.corruptCount = 0L;
        this.objectsFound = 0L;
        this.scanHeap();
        printStream.format("Objects found: %d%n", this.objectsFound);
        printStream.format("Corruptions encountered: %d%n", this.corruptCount);
        this.data.render(printStream);
    }

    private void scanHeap() {
        try {
            GCHeapRegionIterator gCHeapRegionIterator = GCHeapRegionIterator.from();
            while (gCHeapRegionIterator.hasNext()) {
                GCHeapRegionDescriptor gCHeapRegionDescriptor = gCHeapRegionIterator.next();
                this.scanObjects(gCHeapRegionDescriptor);
            }
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace();
        }
    }

    private void scanObjects(GCHeapRegionDescriptor gCHeapRegionDescriptor) throws CorruptDataException {
        GCObjectHeapIterator gCObjectHeapIterator = GCObjectHeapIterator.fromHeapRegionDescriptor(gCHeapRegionDescriptor, true, true);
        while (gCObjectHeapIterator.hasNext()) {
            J9ObjectPointer j9ObjectPointer = gCObjectHeapIterator.next();
            try {
                J9ClassPointer j9ClassPointer = J9ObjectHelper.clazz(j9ObjectPointer);
                if (!j9ClassPointer.notNull() || !J9ClassHelper.isSameOrSuperClassOf(this.classPointer, j9ClassPointer)) continue;
                this.data.row(j9ObjectPointer.getHexAddress(), J9ClassHelper.getJavaName(j9ClassPointer));
                ++this.objectsFound;
            }
            catch (CorruptDataException corruptDataException) {
                ++this.corruptCount;
            }
        }
    }
}

