/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.EncKDCRepPart;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.Ticket;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KDCRep {
    public PrincipalName cname;
    public Ticket ticket;
    public EncryptedData encPart;
    public EncKDCRepPart encKDCRepPart;
    private int pvno;
    private int msgType;
    public PAData[] pAData = null;
    private boolean DEBUG = Krb5.DEBUG;

    public KDCRep(PAData[] pADataArray, PrincipalName principalName, Ticket ticket, EncryptedData encryptedData, int n) throws IOException {
        this.pvno = 5;
        this.msgType = n;
        if (pADataArray != null) {
            this.pAData = new PAData[pADataArray.length];
            for (int i = 0; i < pADataArray.length; ++i) {
                if (pADataArray[i] == null) {
                    throw new IOException("Cannot create a KDCRep");
                }
                this.pAData[i] = (PAData)pADataArray[i].clone();
            }
        }
        this.cname = principalName;
        this.ticket = ticket;
        this.encPart = encryptedData;
    }

    public KDCRep() {
    }

    public KDCRep(byte[] byArray, int n) throws Asn1Exception, KrbApErrException, RealmException, IOException {
        this.init(new DerValue(byArray), n);
    }

    public KDCRep(DerValue derValue, int n) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(derValue, n);
    }

    protected void init(DerValue derValue, int n) throws Asn1Exception, RealmException, IOException, KrbApErrException {
        Object object;
        if ((derValue.getTag() & 0x1F) != n) {
            if (this.DEBUG) {
                System.out.println(">>> KDCRep: init() encoding tag is " + derValue.getTag() + " req type is " + n);
                System.out.println(">>> KDCRep: Message in bytes is =>");
                byte[] byArray = derValue.getData().toByteArray();
                if (byArray != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < byArray.length; ++i) {
                        if (i % 16 == 0) {
                            stringBuilder.append(String.format("%06X", i));
                        }
                        stringBuilder.append(String.format(" %02X", byArray[i] & 0xFF));
                        if (i % 16 != 15) continue;
                        System.out.println(stringBuilder.toString());
                        stringBuilder.setLength(0);
                    }
                    if (stringBuilder.length() > 0) {
                        System.out.println(stringBuilder.toString());
                    }
                }
            }
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 0) {
            this.pvno = derValue3.getData().getBigInteger().intValue();
            if (this.pvno != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 1) {
            this.msgType = derValue3.getData().getBigInteger().intValue();
            if (this.msgType != n) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        if ((derValue2.getData().peekByte() & 0x1F) == 2) {
            derValue3 = derValue2.getData().getDerValue();
            object = derValue3.getData().getSequence(1);
            this.pAData = new PAData[((DerValue[])object).length];
            for (int i = 0; i < ((DerValue[])object).length; ++i) {
                this.pAData[i] = new PAData(object[i]);
            }
        } else {
            this.pAData = null;
        }
        object = Realm.parse(derValue2.getData(), (byte)3, false);
        this.cname = PrincipalName.parse(derValue2.getData(), (byte)4, false, (Realm)object);
        this.ticket = Ticket.parse(derValue2.getData(), (byte)5, false);
        this.encPart = EncryptedData.parse(derValue2.getData(), (byte)6, false);
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.pvno));
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.msgType));
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        if (this.pAData != null && this.pAData.length > 0) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            for (int i = 0; i < this.pAData.length; ++i) {
                derOutputStream3.write(this.pAData[i].asn1Encode());
            }
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.write((byte)48, derOutputStream3);
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream2);
        }
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)3), this.cname.getRealm().asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)4), this.cname.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)5), this.ticket.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)6), this.encPart.asn1Encode());
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }
}

