/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.CoreReaderSupport;
import com.ibm.dtfj.corereaders.CorruptCoreException;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.LittleEndianDumpReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.imageio.stream.ImageInputStream;

public abstract class NewWinDump
extends CoreReaderSupport {
    public String _processorSubtypeDescription;
    protected boolean _is64Bit;

    public static ICoreFileReader dumpFromFile(ImageInputStream imageInputStream) throws IOException {
        assert (NewWinDump.isSupportedDump(imageInputStream));
        if (NewWinDump.isMiniDump(imageInputStream)) {
            return new MiniDump(imageInputStream);
        }
        if (NewWinDump.isUserDump(imageInputStream)) {
            return new UserDump(imageInputStream);
        }
        return null;
    }

    private static boolean isMiniDump(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.seek(0L);
        byte[] byArray = new byte[4];
        imageInputStream.readFully(byArray);
        return new String(byArray).equalsIgnoreCase("mdmp");
    }

    public static boolean isSupportedDump(ImageInputStream imageInputStream) throws IOException {
        return NewWinDump.isMiniDump(imageInputStream) || NewWinDump.isUserDump(imageInputStream);
    }

    private static boolean isUserDump(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.seek(0L);
        byte[] byArray = new byte[8];
        imageInputStream.readFully(byArray);
        return new String(byArray).equalsIgnoreCase("userdump");
    }

    private NewWinDump(ImageInputStream imageInputStream, int n) throws IOException {
        super(new LittleEndianDumpReader(imageInputStream, 64 == n));
        this._is64Bit = 64 == n;
    }

    protected Properties getEnvironmentVariables(Builder builder) throws MemoryAccessException {
        if (0L == builder.getEnvironmentAddress()) {
            return null;
        }
        Properties properties = new Properties();
        IAbstractAddressSpace iAbstractAddressSpace = this.getAddressSpace();
        if (null != iAbstractAddressSpace) {
            long l = iAbstractAddressSpace.getPointerAt(0, builder.getEnvironmentAddress());
            long l2 = iAbstractAddressSpace.getPointerAt(0, l);
            while (0L != l2) {
                StringBuffer stringBuffer = new StringBuffer();
                byte by = iAbstractAddressSpace.getByteAt(0, l2);
                while (0 != by) {
                    stringBuffer.append(new String(new byte[]{by}));
                    by = iAbstractAddressSpace.getByteAt(0, ++l2);
                }
                String string = stringBuffer.toString();
                int n = string.indexOf(61);
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1, string.length());
                properties.put(string2, string3);
                l2 = iAbstractAddressSpace.getPointerAt(0, l);
                l += this.is64Bit() ? 8L : 4L;
            }
        }
        return properties;
    }

    @Override
    public boolean isLittleEndian() {
        return true;
    }

    private static int littleEndianReadInt(ImageInputStream imageInputStream) throws IOException {
        byte[] byArray = new byte[4];
        imageInputStream.readFully(byArray);
        return (0xFF & byArray[3]) << 24 | (0xFF & byArray[2]) << 16 | (0xFF & byArray[1]) << 8 | 0xFF & byArray[0];
    }

    private static class UserDump
    extends NewWinDump {
        private int _dataOffset;
        private List _memoryRanges;
        private int _regionCount;
        private int _regionOffset;

        public UserDump(ImageInputStream imageInputStream) throws IOException {
            super(imageInputStream, 32);
            this.parseHeader();
            this.parseMemory();
        }

        public long getCreationTime() {
            return 0L;
        }

        public Iterator getMemoryRanges() {
            return this._memoryRanges.iterator();
        }

        private void parseHeader() throws IOException {
            this.coreSeek(0L);
            this.coreReadBytes(8);
            this.coreReadInt();
            this.coreReadInt();
            this.coreReadInt();
            this.coreReadInt();
            this.coreReadInt();
            this._regionCount = this.coreReadInt();
            this.coreReadInt();
            this.coreReadInt();
            this._dataOffset = this.coreReadInt();
            this._regionOffset = this.coreReadInt();
            this.coreReadInt();
            this.coreReadInt();
            this.coreReadInt();
        }

        private void parseMemory() throws IOException {
            this.coreSeek(this._regionOffset);
            this._memoryRanges = new ArrayList();
            MemoryRange memoryRange = null;
            for (int i = 0; i < this._regionCount; ++i) {
                long l = this.coreReadInt();
                this.coreReadInt();
                this.coreReadInt();
                int n = this.coreReadInt();
                this.coreReadInt();
                this.coreReadInt();
                this.coreReadInt();
                if (null == memoryRange) {
                    memoryRange = new MemoryRange(l, this._dataOffset, n);
                    continue;
                }
                if (memoryRange.getVirtualAddress() + memoryRange.getSize() == l) {
                    memoryRange = new MemoryRange(memoryRange.getVirtualAddress(), memoryRange.getFileOffset(), memoryRange.getSize() + (long)n);
                    continue;
                }
                this._memoryRanges.add(memoryRange);
                memoryRange = new MemoryRange(l, memoryRange.getFileOffset() + memoryRange.getSize(), n);
            }
            if (null != memoryRange) {
                this._memoryRanges.add(memoryRange);
            }
        }

        @Override
        public void extract(Builder builder) {
            String string = "";
            if (null != this._j9rasReader) {
                try {
                    string = Long.toString(this._j9rasReader.getProcessID());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                builder.buildProcess(builder.buildAddressSpace("Windows UserDump Address Space", 0), string, "", this.getEnvironmentVariables(builder), null, Collections.EMPTY_LIST.iterator(), null, Collections.EMPTY_LIST.iterator(), 32);
            }
            catch (MemoryAccessException memoryAccessException) {
                // empty catch block
            }
        }

        @Override
        public Iterator getAdditionalFileNames() {
            return Collections.EMPTY_LIST.iterator();
        }

        @Override
        protected MemoryRange[] getMemoryRangesAsArray() {
            return this._memoryRanges.toArray(new MemoryRange[this._memoryRanges.size()]);
        }

        @Override
        protected boolean is64Bit() {
            return false;
        }
    }

    private static class MiniDump
    extends NewWinDump {
        private List _directory = null;
        private int _numberOfStreams = 0;
        private long _streamDirectoryRva = 0L;
        private int _timeAndDate = 0;
        private List _memoryRanges = null;
        private short _processorArchitecture = 0;
        private int _windowsMajorVersion = 0;
        private Object _executable = null;
        private List _threads = new ArrayList();
        private Object _failingThread = null;
        private List _libraries = new ArrayList();
        private Set _additionalFileNames = new TreeSet();
        private String _pid = null;
        private static final int INFO_BLOCK_ADDRESS = 131072;
        private static final int COMMAND_LINE_ADDRESS_ADDRESS_32 = 131140;
        private static final int COMMAND_LINE_ADDRESS_ADDRESS_64 = 131192;
        private static final int COMMAND_LINE_LENGTH_ADDRESS_32 = 131136;
        private static final int COMMAND_LINE_LENGTH_ADDRESS_64 = 131184;

        public MiniDump(ImageInputStream imageInputStream) throws IOException {
            super(imageInputStream, MiniDump._pointerSizeForMiniDump(imageInputStream));
            this.parseHeader();
            this.parseStreams();
        }

        private static int _pointerSizeForMiniDump(ImageInputStream imageInputStream) throws IOException {
            int n;
            imageInputStream.seek(0L);
            byte[] byArray = new byte[4];
            imageInputStream.readFully(byArray);
            NewWinDump.littleEndianReadInt(imageInputStream);
            int n2 = NewWinDump.littleEndianReadInt(imageInputStream);
            int n3 = NewWinDump.littleEndianReadInt(imageInputStream);
            NewWinDump.littleEndianReadInt(imageInputStream);
            NewWinDump.littleEndianReadInt(imageInputStream);
            imageInputStream.seek(n3);
            Vector<Stream> vector = new Vector<Stream>();
            for (int i = 0; i < n2; ++i) {
                int n4;
                int n5 = NewWinDump.littleEndianReadInt(imageInputStream);
                Stream stream = Stream.create(n5, n = NewWinDump.littleEndianReadInt(imageInputStream), n4 = NewWinDump.littleEndianReadInt(imageInputStream));
                if (null == stream) continue;
                vector.add(stream);
            }
            for (Stream stream : vector) {
                n = stream.readPtrSize(imageInputStream);
                if (0 == n) continue;
                return n;
            }
            return 0;
        }

        public void addModule(String string) {
            this._additionalFileNames.add(string);
        }

        @Override
        public Iterator getAdditionalFileNames() {
            return this._additionalFileNames.iterator();
        }

        public void addLibrary(Object object) {
            this._libraries.add(object);
        }

        public void setExecutable(Object object) {
            this._executable = object;
        }

        public void setProcessID(String string) {
            this._pid = string;
        }

        public void addThreads(List list) {
            this._threads.addAll(list);
        }

        protected void setProcessorArchitecture(short s, String string) {
            this._processorArchitecture = s;
            this._processorSubtypeDescription = string;
        }

        protected void setWindowsMajorVersion(int n) {
            this._windowsMajorVersion = n;
        }

        private long getCreationTime() {
            return (long)this._timeAndDate * 1000L;
        }

        protected short getProcessorArchitecture() {
            return this._processorArchitecture;
        }

        protected void setMemoryRanges(List list) {
            this._memoryRanges = list;
        }

        private void parseHeader() throws IOException {
            this.coreSeek(0L);
            this.coreReadBytes(4);
            this.coreReadInt();
            this._numberOfStreams = this.coreReadInt();
            this._streamDirectoryRva = this.coreReadInt();
            this.coreReadInt();
            this._timeAndDate = this.coreReadInt();
        }

        private void parseStreams() throws IOException {
            this.coreSeek(this._streamDirectoryRva);
            this._directory = new ArrayList();
            for (int i = 0; i < this._numberOfStreams; ++i) {
                int n;
                int n2;
                int n3 = this.coreReadInt();
                Stream stream = Stream.create(n3, n2 = this.coreReadInt(), n = this.coreReadInt());
                if (null == stream) continue;
                this._directory.add(stream);
            }
            for (Stream stream : this._directory) {
                stream.readFrom(this);
            }
        }

        @Override
        public void extract(Builder builder) {
            try {
                Object object3;
                Object object2 = builder.buildAddressSpace("Windows MiniDump Address Space", 0);
                for (Object object3 : this._directory) {
                    ((Stream)object3).readFrom(this, builder, object2, this.getAddressSpace(), this.is64Bit());
                }
                String string = this._extractCommandLine();
                object3 = this._pid;
                if (null != this._j9rasReader) {
                    try {
                        object3 = Long.toString(this._j9rasReader.getProcessID());
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                builder.buildProcess(object2, (String)object3, string, this.getEnvironmentVariables(builder), this._failingThread, this._threads.iterator(), this._executable, this._libraries.iterator(), this._is64Bit ? 64 : 32);
            }
            catch (IOException iOException) {
            }
            catch (MemoryAccessException memoryAccessException) {
            }
            catch (CorruptCoreException corruptCoreException) {
                // empty catch block
            }
            builder.setOSType("Windows");
            builder.setCPUType("x86");
            builder.setCPUSubType(this._processorSubtypeDescription);
            builder.setCreationTime(this.getCreationTime());
        }

        private String _extractCommandLine() {
            if (this._windowsMajorVersion >= 6) {
                return "[unknown]";
            }
            String string = null;
            try {
                IAbstractAddressSpace iAbstractAddressSpace = this.getAddressSpace();
                if (null != iAbstractAddressSpace) {
                    short s = iAbstractAddressSpace.getShortAt(0, this.is64Bit() ? 131184L : 131136L);
                    long l = iAbstractAddressSpace.getPointerAt(0, this.is64Bit() ? 131192L : 131140L);
                    byte[] byArray = new byte[s];
                    iAbstractAddressSpace.getBytesAt(0, l, byArray);
                    string = new String(byArray, "UTF-16LE");
                }
            }
            catch (MemoryAccessException memoryAccessException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (Exception exception) {
                return "[unknown]";
            }
            return string;
        }

        @Override
        public boolean is64Bit() {
            return this._is64Bit;
        }

        @Override
        protected MemoryRange[] getMemoryRangesAsArray() {
            if (null == this._memoryRanges) {
                return null;
            }
            return this._memoryRanges.toArray(new MemoryRange[this._memoryRanges.size()]);
        }

        private static class ThreadStream
        extends Stream {
            public ThreadStream(int n, int n2) {
                super(n, n2);
            }

            @Override
            public void readFrom(MiniDump miniDump) throws IOException {
            }

            @Override
            public void readFrom(MiniDump miniDump, Builder builder, Object object, IAbstractAddressSpace iAbstractAddressSpace, boolean bl) throws IOException {
                long l = -1L;
                if (null != miniDump._j9rasReader) {
                    try {
                        l = miniDump._j9rasReader.getThreadID();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                    }
                    catch (MemoryAccessException memoryAccessException) {
                    }
                    catch (CorruptCoreException corruptCoreException) {
                        // empty catch block
                    }
                }
                miniDump.coreSeek(this.getLocation());
                int n = miniDump.coreReadInt();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < n; ++i) {
                    miniDump.coreSeek(this.getLocation() + 4L + (long)(i * 48));
                    int n2 = miniDump.coreReadInt();
                    miniDump.coreReadInt();
                    int n3 = miniDump.coreReadInt();
                    int n4 = miniDump.coreReadInt();
                    miniDump.coreReadLong();
                    long l2 = miniDump.coreReadLong();
                    long l3 = 0xFFFFFFFFL & (long)miniDump.coreReadInt();
                    long l4 = 0xFFFFFFFFL & (long)miniDump.coreReadInt();
                    long l5 = 0xFFFFFFFFL & (long)miniDump.coreReadInt();
                    long l6 = 0xFFFFFFFFL & (long)miniDump.coreReadInt();
                    Properties properties = new Properties();
                    properties.setProperty("priorityClass", String.valueOf(n3));
                    properties.setProperty("priority", String.valueOf(n4));
                    List list = this.readRegisters(miniDump, builder, l6, l5);
                    long l7 = l2 + l3;
                    Object object2 = builder.buildStackSection(object, l2, l7);
                    List list2 = this.readStackFrames(miniDump, builder, object, l2, l7, l4, list, iAbstractAddressSpace, bl);
                    int n5 = 0;
                    Object object3 = builder.buildThread(String.valueOf(n2), list.iterator(), Collections.singletonList(object2).iterator(), list2.iterator(), properties, n5);
                    arrayList.add(object3);
                    if (-1L == l || l != (long)n2) continue;
                    miniDump._failingThread = object3;
                }
                miniDump.addThreads(arrayList);
            }

            private List readStackFrames(MiniDump miniDump, Builder builder, Object object, long l, long l2, long l3, List list, IAbstractAddressSpace iAbstractAddressSpace, boolean bl) {
                int n;
                long l4 = builder.getValueOfNamedRegister(list, "ebp");
                long l5 = builder.getValueOfNamedRegister(list, "eip");
                long l6 = builder.getValueOfNamedRegister(list, "esp");
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (-1L == l5 && l <= l6 && l6 < l2) {
                    try {
                        l5 = iAbstractAddressSpace.getPointerAt(0, l6);
                    }
                    catch (MemoryAccessException memoryAccessException) {
                        // empty catch block
                    }
                }
                int n2 = n = bl ? 8 : 4;
                if (l <= l4 && l4 < l2) {
                    arrayList.add(builder.buildStackFrame(object, l4, l5));
                } else if (l <= l6 && l6 < l2) {
                    arrayList.add(builder.buildStackFrame(object, l6, l5));
                    l4 = l6 + (long)n;
                }
                while (l <= l4 && l4 < l2) {
                    try {
                        long l7 = iAbstractAddressSpace.getPointerAt(0, l4);
                        long l8 = iAbstractAddressSpace.getPointerAt(0, l4 + (long)n);
                        arrayList.add(builder.buildStackFrame(object, l7, l8));
                        l4 = l7;
                    }
                    catch (MemoryAccessException memoryAccessException) {
                        break;
                    }
                }
                return arrayList;
            }

            private List readRegisters(MiniDump miniDump, Builder builder, long l, long l2) throws IOException {
                switch (miniDump.getProcessorArchitecture()) {
                    case 9: {
                        return this.readAmd64Registers(miniDump, builder, l, l2);
                    }
                    case 0: {
                        return this.readIntelRegisters(miniDump, builder, l, l2);
                    }
                }
                return Collections.EMPTY_LIST;
            }

            private List readIntelRegisters(MiniDump miniDump, Builder builder, long l, long l2) throws IOException {
                miniDump.coreSeek(l + 140L);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(builder.buildRegister("gs", miniDump.coreReadInt()));
                arrayList.add(builder.buildRegister("fs", miniDump.coreReadInt()));
                arrayList.add(builder.buildRegister("es", miniDump.coreReadInt()));
                arrayList.add(builder.buildRegister("ds", miniDump.coreReadInt()));
                arrayList.add(builder.buildRegister("edi", miniDump.coreReadInt()));
                arrayList.add(builder.buildRegister("esi", miniDump.coreReadInt()));
                arrayList.add(builder.buildRegister("ebx", miniDump.coreReadInt()));
                arrayList.add(builder.buildRegister("edx", miniDump.coreReadInt()));
                arrayList.add(builder.buildRegister("ecx", miniDump.coreReadInt()));
                arrayList.add(builder.buildRegister("eax", miniDump.coreReadInt()));
                arrayList.add(builder.buildRegister("ebp", miniDump.coreReadInt()));
                arrayList.add(builder.buildRegister("eip", miniDump.coreReadInt()));
                arrayList.add(builder.buildRegister("cs", miniDump.coreReadInt()));
                arrayList.add(builder.buildRegister("flags", miniDump.coreReadInt()));
                arrayList.add(builder.buildRegister("esp", miniDump.coreReadInt()));
                arrayList.add(builder.buildRegister("ss", miniDump.coreReadInt()));
                return arrayList;
            }

            private List readAmd64Registers(MiniDump miniDump, Builder builder, long l, long l2) throws IOException {
                miniDump.coreSeek(l + 56L);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(builder.buildRegister("cs", miniDump.coreReadShort()));
                arrayList.add(builder.buildRegister("ds", miniDump.coreReadShort()));
                arrayList.add(builder.buildRegister("es", miniDump.coreReadShort()));
                arrayList.add(builder.buildRegister("fs", miniDump.coreReadShort()));
                arrayList.add(builder.buildRegister("gs", miniDump.coreReadShort()));
                arrayList.add(builder.buildRegister("ss", miniDump.coreReadShort()));
                arrayList.add(builder.buildRegister("flags", miniDump.coreReadInt()));
                miniDump.coreSeek(l + 120L);
                arrayList.add(builder.buildRegister("eax", miniDump.coreReadLong()));
                arrayList.add(builder.buildRegister("ecx", miniDump.coreReadLong()));
                arrayList.add(builder.buildRegister("edx", miniDump.coreReadLong()));
                arrayList.add(builder.buildRegister("ebx", miniDump.coreReadLong()));
                arrayList.add(builder.buildRegister("esp", miniDump.coreReadLong()));
                arrayList.add(builder.buildRegister("ebp", miniDump.coreReadLong()));
                arrayList.add(builder.buildRegister("esi", miniDump.coreReadLong()));
                arrayList.add(builder.buildRegister("edi", miniDump.coreReadLong()));
                arrayList.add(builder.buildRegister("r8", miniDump.coreReadLong()));
                arrayList.add(builder.buildRegister("r9", miniDump.coreReadLong()));
                arrayList.add(builder.buildRegister("r10", miniDump.coreReadLong()));
                arrayList.add(builder.buildRegister("r11", miniDump.coreReadLong()));
                arrayList.add(builder.buildRegister("r12", miniDump.coreReadLong()));
                arrayList.add(builder.buildRegister("r13", miniDump.coreReadLong()));
                arrayList.add(builder.buildRegister("r14", miniDump.coreReadLong()));
                arrayList.add(builder.buildRegister("r15", miniDump.coreReadLong()));
                arrayList.add(builder.buildRegister("ip", miniDump.coreReadLong()));
                return arrayList;
            }
        }

        private static class SystemInfoStream
        extends Stream {
            public SystemInfoStream(int n, int n2) {
                super(n, n2);
            }

            @Override
            public void readFrom(MiniDump miniDump) throws IOException {
                miniDump.coreSeek(this.getLocation());
                short s = miniDump.coreReadShort();
                short s2 = miniDump.coreReadShort();
                short s3 = miniDump.coreReadShort();
                byte by = (byte)(s3 >> 8 & 0xFF);
                byte by2 = (byte)(s3 & 0xFF);
                String string = "Level " + s2 + " Model " + by + " Stepping " + by2;
                miniDump.setProcessorArchitecture(s, string);
                miniDump.coreReadByte();
                miniDump.coreReadByte();
                int n = miniDump.coreReadInt();
                miniDump.setWindowsMajorVersion(n);
            }

            @Override
            public int readPtrSize(ImageInputStream imageInputStream) {
                short s = 0;
                try {
                    imageInputStream.seek(this.getLocation());
                    byte[] byArray = new byte[2];
                    imageInputStream.readFully(byArray);
                    s = (short)((0xFF & byArray[1]) << 8 | 0xFF & byArray[0]);
                }
                catch (IOException iOException) {
                    return 0;
                }
                return 9 == s || 6 == s || 7 == s || 10 == s ? 64 : 32;
            }

            @Override
            public void readFrom(MiniDump miniDump, Builder builder, Object object, IAbstractAddressSpace iAbstractAddressSpace, boolean bl) throws IOException {
            }
        }

        private static class ModuleStream
        extends Stream {
            public ModuleStream(int n, int n2) {
                super(n, n2);
            }

            @Override
            public void readFrom(MiniDump miniDump) throws IOException {
            }

            @Override
            public void readFrom(MiniDump miniDump, Builder builder, Object object, IAbstractAddressSpace iAbstractAddressSpace, boolean bl) throws IOException {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                miniDump.coreSeek(this.getLocation());
                int n6 = miniDump.coreReadInt();
                class Module {
                    int nameAddress = -1;
                    long imageBaseAddress = -1L;
                    Properties properties = new Properties();

                    Module() {
                    }
                }
                Module[] moduleArray = new Module[n6];
                for (n5 = 0; n5 < n6; ++n5) {
                    moduleArray[n5] = new Module();
                    moduleArray[n5].imageBaseAddress = miniDump.coreReadLong();
                    int n7 = miniDump.coreReadInt();
                    n4 = miniDump.coreReadInt();
                    int n8 = miniDump.coreReadInt();
                    moduleArray[n5].nameAddress = miniDump.coreReadInt();
                    int n9 = miniDump.coreReadInt();
                    int n10 = miniDump.coreReadInt();
                    int n11 = miniDump.coreReadInt();
                    int n12 = miniDump.coreReadInt();
                    int n13 = miniDump.coreReadInt();
                    int n14 = miniDump.coreReadInt();
                    int n15 = miniDump.coreReadInt();
                    n3 = miniDump.coreReadInt();
                    n2 = miniDump.coreReadInt();
                    n = miniDump.coreReadInt();
                    int n16 = miniDump.coreReadInt();
                    int n17 = miniDump.coreReadInt();
                    int n18 = miniDump.coreReadInt();
                    miniDump.coreReadInt();
                    miniDump.coreReadInt();
                    miniDump.coreReadInt();
                    miniDump.coreReadInt();
                    miniDump.coreReadLong();
                    miniDump.coreReadLong();
                    moduleArray[n5].properties.setProperty("imageSize", Integer.toHexString(n7));
                    moduleArray[n5].properties.setProperty("checksum", Integer.toHexString(n4));
                    moduleArray[n5].properties.setProperty("timeDateStamp", new Date(1000L * ((long)n8 + 28800L)).toString());
                    moduleArray[n5].properties.setProperty("versionInfoDwSignature", Integer.toHexString(n9));
                    moduleArray[n5].properties.setProperty("versionInfoDwStrucVersion", Integer.toHexString(n10));
                    moduleArray[n5].properties.setProperty("versionInfoDwFileVersionMS", Integer.toHexString(n11));
                    moduleArray[n5].properties.setProperty("versionInfoDwFileVersionLS", Integer.toHexString(n12));
                    moduleArray[n5].properties.setProperty("versionInfoDwProductVersionMS", Integer.toHexString(n13));
                    moduleArray[n5].properties.setProperty("versionInfoDwProductVersionLS", Integer.toHexString(n14));
                    moduleArray[n5].properties.setProperty("versionInfoDwFileFlagsMask", Integer.toHexString(n15));
                    moduleArray[n5].properties.setProperty("versionInfoDwFileFlags", Integer.toHexString(n3));
                    moduleArray[n5].properties.setProperty("versionInfoDwFileOS", Integer.toHexString(n2));
                    moduleArray[n5].properties.setProperty("versionInfoDwFileType", Integer.toHexString(n));
                    moduleArray[n5].properties.setProperty("versionInfoDwFileSubtype", Integer.toHexString(n16));
                    moduleArray[n5].properties.setProperty("versionInfoDwFileDateMS", Integer.toHexString(n17));
                    moduleArray[n5].properties.setProperty("versionInfoDwFileDateLS", Integer.toHexString(n18));
                }
                for (n5 = 0; n5 < moduleArray.length; ++n5) {
                    String string = this.getModuleName(miniDump, moduleArray[n5].nameAddress);
                    try {
                        n4 = iAbstractAddressSpace.getShortAt(0, moduleArray[n5].imageBaseAddress);
                        if (23117 != n4) {
                            System.err.println("Magic number was: " + Integer.toHexString(0xFFFF & n4));
                        }
                    }
                    catch (MemoryAccessException memoryAccessException) {
                        memoryAccessException.printStackTrace();
                    }
                    long l = moduleArray[n5].imageBaseAddress + 60L;
                    Vector<Object> vector = new Vector<Object>();
                    try {
                        long l2 = 0xFFFFFFFFL & (long)iAbstractAddressSpace.getIntAt(0, l);
                        long l3 = l2 + moduleArray[n5].imageBaseAddress;
                        if (0L != l2) {
                            int n19 = iAbstractAddressSpace.getIntAt(0, l3);
                            l3 += 4L;
                            if (17744 != n19) {
                                System.err.println("PE Magic is: \"" + Integer.toHexString(n19));
                            }
                            n3 = iAbstractAddressSpace.getShortAt(0, l3 += 2L);
                            l3 += 2L;
                            l3 += 4L;
                            l3 += 4L;
                            n2 = iAbstractAddressSpace.getShortAt(0, l3 += 4L);
                            l3 += 2L;
                            l3 += 2L;
                            l3 = moduleArray[n5].imageBaseAddress + l2 + 24L + (0xFFFFL & (long)n2);
                            for (n = 0; n < n3; ++n) {
                                byte[] byArray = new byte[8];
                                iAbstractAddressSpace.getBytesAt(0, l3, byArray);
                                long l4 = iAbstractAddressSpace.getIntAt(0, l3 += 8L);
                                long l5 = iAbstractAddressSpace.getIntAt(0, l3 += 4L);
                                l3 += 4L;
                                l3 += 4L;
                                l3 += 4L;
                                l3 += 4L;
                                l3 += 4L;
                                l3 += 2L;
                                l3 += 2L;
                                l3 += 4L;
                                long l6 = l5 + moduleArray[n5].imageBaseAddress;
                                Object object2 = builder.buildModuleSection(object, new String(byArray).trim(), l6, l6 + l4);
                                vector.add(object2);
                            }
                        }
                        Object object3 = builder.buildModule(string, moduleArray[n5].properties, vector.iterator(), this._buildSymbolIterator(miniDump, iAbstractAddressSpace, builder, object, moduleArray[n5].imageBaseAddress, moduleArray[n5].imageBaseAddress), moduleArray[n5].imageBaseAddress);
                        if (string.toLowerCase().endsWith(".exe")) {
                            miniDump.setExecutable(object3);
                        } else {
                            miniDump.addLibrary(object3);
                        }
                    }
                    catch (MemoryAccessException memoryAccessException) {
                        // empty catch block
                    }
                    miniDump.addModule(string);
                }
            }

            private Iterator _buildSymbolIterator(MiniDump miniDump, IAbstractAddressSpace iAbstractAddressSpace, Builder builder, Object object, long l, long l2) {
                try {
                    short s;
                    int n;
                    int n2;
                    byte[] byArray = new byte[2];
                    iAbstractAddressSpace.getBytesAt(0, l, byArray);
                    String string = new String(byArray);
                    if (!string.equals("MZ")) {
                        return Collections.singleton(builder.buildCorruptData(object, "Invalid image magic number: \"" + string + "\"", l)).iterator();
                    }
                    int n3 = iAbstractAddressSpace.getIntAt(0, l + 60L);
                    long l3 = ((long)n3 & 0xFFFFFFFFL) + l;
                    iAbstractAddressSpace.getBytesAt(0, l3, byArray);
                    string = new String(byArray);
                    if (!string.equals("PE")) {
                        return Collections.singleton(builder.buildCorruptData(object, "Invalid PE magic number: \"" + string + "\"", l3)).iterator();
                    }
                    long l4 = l3 + 4L;
                    l4 += 2L;
                    l4 += 2L;
                    l4 += 4L;
                    l4 += 4L;
                    long l5 = l4 += 4L;
                    short s2 = iAbstractAddressSpace.getShortAt(0, l5);
                    l4 += 2L;
                    l4 += 2L;
                    if (224 == s2) {
                        n2 = iAbstractAddressSpace.getShortAt(0, l4);
                        if (267 != n2) {
                            return Collections.singleton(builder.buildCorruptData(object, "Invalid IMAGE_OPTIONAL_HEADER magic number: \"0x" + Integer.toHexString(0xFFFF & n2) + "\"", l4)).iterator();
                        }
                        l4 += 2L;
                        ++l4;
                        ++l4;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 2L;
                        l4 += 2L;
                        l4 += 2L;
                        l4 += 2L;
                        l4 += 2L;
                        l4 += 2L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 2L;
                        l4 += 2L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                    } else if (240 == s2) {
                        n2 = iAbstractAddressSpace.getShortAt(0, l4);
                        if (523 != n2) {
                            return Collections.singleton(builder.buildCorruptData(object, "Invalid IMAGE_OPTIONAL_HEADER64 magic number: \"0x" + Integer.toHexString(0xFFFF & n2) + "\"", l4)).iterator();
                        }
                        l4 += 2L;
                        ++l4;
                        ++l4;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 8L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 2L;
                        l4 += 2L;
                        l4 += 2L;
                        l4 += 2L;
                        l4 += 2L;
                        l4 += 2L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 4L;
                        l4 += 2L;
                        l4 += 2L;
                        l4 += 8L;
                        l4 += 8L;
                        l4 += 8L;
                        l4 += 8L;
                        l4 += 4L;
                        l4 += 4L;
                    } else {
                        return Collections.singleton(builder.buildCorruptData(object, "Invalid IMAGE_OPTIONAL_HEADER size: \"" + s2 + "\" bytes", l5)).iterator();
                    }
                    n2 = iAbstractAddressSpace.getIntAt(0, l4);
                    l4 += 4L;
                    if (0 == n2) {
                        return Collections.EMPTY_LIST.iterator();
                    }
                    l4 += 4L;
                    l4 = l2 + ((long)n2 & 0xFFFFFFFFL);
                    l4 += 4L;
                    l4 += 4L;
                    l4 += 2L;
                    l4 += 2L;
                    l4 += 4L;
                    long l6 = l4 += 4L;
                    int n4 = iAbstractAddressSpace.getIntAt(0, l6);
                    int n5 = iAbstractAddressSpace.getIntAt(0, l4 += 4L);
                    l4 += 4L;
                    if (n4 < n5) {
                        return Collections.singleton(builder.buildCorruptData(object, "IMAGE_EXPORT_DIRECTORY NumberOfFunctions (" + n4 + ") < NumberOfNames (" + n5 + ")", l6)).iterator();
                    }
                    long l7 = (long)iAbstractAddressSpace.getIntAt(0, l4) & 0xFFFFFFFFL;
                    long l8 = (long)iAbstractAddressSpace.getIntAt(0, l4 += 4L) & 0xFFFFFFFFL;
                    long l9 = (long)iAbstractAddressSpace.getIntAt(0, l4 += 4L) & 0xFFFFFFFFL;
                    l4 += 4L;
                    int[] nArray = new int[n5];
                    l4 = l8 + l2;
                    for (int i = 0; i < n5; ++i) {
                        nArray[i] = iAbstractAddressSpace.getIntAt(0, l4);
                        l4 += 4L;
                    }
                    long[] lArray = new long[n4];
                    l4 = l7 + l2;
                    for (int i = 0; i < n4; ++i) {
                        lArray[i] = iAbstractAddressSpace.getIntAt(0, l4);
                        l4 += 4L;
                    }
                    short[] sArray = new short[n5];
                    l4 = l9 + l2;
                    for (int i = 0; i < n5; ++i) {
                        sArray[i] = iAbstractAddressSpace.getShortAt(0, l4);
                        l4 += 2L;
                    }
                    String[] stringArray = new String[n5];
                    byte[] byArray2 = new byte[2048];
                    for (int i = 0; i < n5; ++i) {
                        l4 = ((long)nArray[i] & 0xFFFFFFFFL) + l2;
                        Arrays.fill(byArray2, (byte)0);
                        n = 0;
                        s = 0;
                        do {
                            s = iAbstractAddressSpace.getByteAt(0, l4);
                            ++l4;
                            byArray2[n] = s;
                        } while (0 != s && ++n < byArray2.length);
                        stringArray[i] = new String(byArray2, 0, n - 1);
                    }
                    Vector<Object> vector = new Vector<Object>();
                    for (n = 0; n < n5; ++n) {
                        s = sArray[n];
                        long l10 = lArray[s] + l2;
                        String string2 = stringArray[n];
                        Object object2 = builder.buildSymbol(object, string2, l10);
                        vector.add(object2);
                    }
                    return vector.iterator();
                }
                catch (MemoryAccessException memoryAccessException) {
                    return Collections.singleton(builder.buildCorruptData(object, memoryAccessException.getMessage(), memoryAccessException.getAddress())).iterator();
                }
            }

            private String getModuleName(MiniDump miniDump, int n) throws IOException {
                miniDump.coreSeek(n);
                int n2 = miniDump.coreReadInt();
                if (n2 <= 0 || 512 <= n2) {
                    n2 = 512;
                }
                byte[] byArray = miniDump.coreReadBytes(n2);
                return new String(byArray, "UTF-16LE");
            }
        }

        private static class Memory64Stream
        extends Stream {
            public Memory64Stream(int n, int n2) {
                super(n, n2);
            }

            @Override
            public void readFrom(MiniDump miniDump) throws IOException {
                long l = this.getLocation();
                miniDump.coreSeek(l);
                long l2 = miniDump.coreReadLong();
                long l3 = miniDump.coreReadLong();
                ArrayList<MemoryRange> arrayList = new ArrayList<MemoryRange>();
                MemoryRange memoryRange = null;
                int n = 0;
                while ((long)n < l2) {
                    long l4;
                    long l5 = miniDump.is64Bit() ? miniDump.coreReadLong() : miniDump.coreReadLong() & 0xFFFFFFFFL;
                    long l6 = l4 = miniDump.is64Bit() ? miniDump.coreReadLong() : miniDump.coreReadLong() & 0xFFFFFFFFL;
                    if (null == memoryRange) {
                        memoryRange = new MemoryRange(l5, l3, l4, 0, false, false, true);
                    } else if (memoryRange.getVirtualAddress() + memoryRange.getSize() == l5) {
                        memoryRange = new MemoryRange(memoryRange.getVirtualAddress(), memoryRange.getFileOffset(), memoryRange.getSize() + l4, 0, false, false, true);
                    } else {
                        arrayList.add(memoryRange);
                        memoryRange = new MemoryRange(l5, memoryRange.getFileOffset() + memoryRange.getSize(), l4, 0, false, false, true);
                    }
                    ++n;
                }
                if (null != memoryRange) {
                    arrayList.add(memoryRange);
                }
                miniDump.setMemoryRanges(arrayList);
            }

            @Override
            public void readFrom(MiniDump miniDump, Builder builder, Object object, IAbstractAddressSpace iAbstractAddressSpace, boolean bl) throws IOException {
            }
        }

        private static class MiscInfoStream
        extends Stream {
            private static final int MISC1_PROCESS_ID = 1;

            public MiscInfoStream(int n, int n2) {
                super(n, n2);
            }

            @Override
            public void readFrom(MiniDump miniDump) throws IOException {
            }

            @Override
            public void readFrom(MiniDump miniDump, Builder builder, Object object, IAbstractAddressSpace iAbstractAddressSpace, boolean bl) throws IOException {
                int n;
                miniDump.coreSeek(this.getLocation());
                if (this.getDataSize() < 4) {
                    return;
                }
                int n2 = miniDump.coreReadInt();
                if (n2 > this.getDataSize()) {
                    n2 = this.getDataSize();
                }
                if ((n2 = n2 / 4 - 1) <= 0) {
                    return;
                }
                int[] nArray = new int[n2];
                for (n = 0; n < n2; ++n) {
                    nArray[n] = miniDump.coreReadInt();
                }
                n = nArray[0];
                if ((n & 1) != 0 && n2 > 1) {
                    miniDump.setProcessID(String.valueOf(nArray[1]));
                }
            }
        }

        private static abstract class Stream {
            protected static final int PROCESSOR_ARCHITECTURE_INTEL = 0;
            protected static final int PROCESSOR_ARCHITECTURE_IA64 = 6;
            protected static final int PROCESSOR_ARCHITECTURE_ALPHA64 = 7;
            protected static final int PROCESSOR_ARCHITECTURE_AMD64 = 9;
            protected static final int PROCESSOR_ARCHITECTURE_IA32_ON_WIN64 = 10;
            private static final int THREADLIST = 3;
            private static final int MODULELIST = 4;
            private static final int SYSTEMINFO = 7;
            private static final int MEMORY64LIST = 9;
            private static final int MISCINFO = 15;
            private int _dataSize;
            private long _location;

            public static Stream create(int n, int n2, int n3) {
                switch (n) {
                    case 3: {
                        return new ThreadStream(n2, n3);
                    }
                    case 4: {
                        return new ModuleStream(n2, n3);
                    }
                    case 7: {
                        return new SystemInfoStream(n2, n3);
                    }
                    case 9: {
                        return new Memory64Stream(n2, n3);
                    }
                    case 15: {
                        return new MiscInfoStream(n2, n3);
                    }
                }
                return null;
            }

            protected Stream(int n, long l) {
                this._dataSize = n;
                this._location = l;
            }

            protected int getDataSize() {
                return this._dataSize;
            }

            protected long getLocation() {
                return this._location;
            }

            public int readPtrSize(ImageInputStream imageInputStream) {
                return 0;
            }

            public abstract void readFrom(MiniDump var1) throws IOException;

            public abstract void readFrom(MiniDump var1, Builder var2, Object var3, IAbstractAddressSpace var4, boolean var5) throws IOException;
        }
    }
}

