/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.ddrinteractive.BaseStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.ICommand;
import com.ibm.j9ddr.tools.ddrinteractive.IFieldFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.IStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.StructureCommandUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class BaseStructureCommand
implements ICommand {
    private final List<IFieldFormatter> fieldFormatters = new LinkedList<IFieldFormatter>();
    private final List<IStructureFormatter> structureFormatters = new LinkedList<IStructureFormatter>();

    public BaseStructureCommand() {
        this.registerStructureFormatter(new DefaultStructureFormatter());
    }

    @Override
    public final boolean recognises(String string, Context context) {
        if (string.length() < 2) {
            return false;
        }
        StructureReader.StructureDescriptor structureDescriptor = StructureCommandUtil.getStructureDescriptor(string = string.substring(1), context);
        return structureDescriptor != null;
    }

    protected void registerFieldFormatter(IFieldFormatter iFieldFormatter) {
        if (iFieldFormatter == null) {
            throw new IllegalArgumentException("Field formatter cannot be null");
        }
        this.fieldFormatters.add(0, iFieldFormatter);
    }

    protected void registerStructureFormatter(IStructureFormatter iStructureFormatter) {
        if (iStructureFormatter == null) {
            throw new IllegalArgumentException("Structure formatter cannot be null");
        }
        this.structureFormatters.add(0, iStructureFormatter);
    }

    protected void registerDefaultStructureFormatter(IStructureFormatter iStructureFormatter) {
        if (iStructureFormatter == null) {
            throw new IllegalArgumentException("Structure formatter cannot be null");
        }
        if (this.structureFormatters.size() > 0) {
            this.structureFormatters.remove(this.structureFormatters.size() - 1);
        }
        this.structureFormatters.add(iStructureFormatter);
    }

    @Override
    public final void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length < 1) {
            printStream.println("Missing address argument. Usage: " + string + " <address>");
            return;
        }
        boolean bl = context.process.bytesPerPointer() == 8;
        long l = CommandUtils.parsePointer(stringArray[0], bl);
        String[] stringArray2 = new String[stringArray.length - 1];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i + 1];
        }
        this.formatStructure(string.substring(1), l, printStream, context, stringArray2);
    }

    private void formatStructure(String string, long l, PrintStream printStream, Context context, String[] stringArray) {
        IStructureFormatter iStructureFormatter;
        FormatWalkResult formatWalkResult;
        Iterator<IStructureFormatter> iterator;
        FormatWalkResult object2;
        ArrayList<IFieldFormatter> arrayList = new ArrayList<IFieldFormatter>(this.fieldFormatters);
        Iterator<IStructureFormatter> iterator2 = this.structureFormatters.iterator();
        while (iterator2.hasNext() && (object2 = (iterator = iterator2.next()).preFormat(string, l, printStream, context, arrayList, stringArray)) != FormatWalkResult.STOP_WALKING) {
        }
        boolean bl = false;
        for (IStructureFormatter iStructureFormatter2 : this.structureFormatters) {
            formatWalkResult = iStructureFormatter2.format(string, l, printStream, context, arrayList, stringArray);
            if (formatWalkResult != FormatWalkResult.STOP_WALKING) continue;
            bl = true;
            break;
        }
        if (!bl) {
            printStream.println("<<Couldn't format " + string + ">>");
        }
        iterator = this.structureFormatters.iterator();
        while (iterator.hasNext() && (formatWalkResult = (iStructureFormatter = iterator.next()).postFormat(string, l, printStream, context, arrayList, stringArray)) != FormatWalkResult.STOP_WALKING) {
        }
    }

    @Override
    public final Collection<String> getCommandDescriptions() {
        return Collections.singleton("<struct> <address>\t\tFormat <struct> at <address>");
    }

    public Set<String> getCommandNames() {
        return null;
    }

    protected class DefaultStructureFormatter
    extends BaseStructureFormatter {
        protected DefaultStructureFormatter() {
        }

        @Override
        public FormatWalkResult format(String string, long l, PrintStream printStream, Context context, List<IFieldFormatter> list, String[] stringArray) {
            StructureReader.StructureDescriptor structureDescriptor;
            this.setFieldFormatters(list);
            LinkedList<StructureReader.StructureDescriptor> linkedList = new LinkedList<StructureReader.StructureDescriptor>();
            String string2 = string;
            while (string2 != null && string2.length() > 0) {
                structureDescriptor = StructureCommandUtil.getStructureDescriptor(string2, context);
                linkedList.add(0, structureDescriptor);
                string2 = structureDescriptor.getSuperName();
            }
            structureDescriptor = (StructureReader.StructureDescriptor)linkedList.get(linkedList.size() - 1);
            printStream.print(structureDescriptor.getName());
            printStream.print(" at ");
            printStream.print("0x");
            printStream.print(Long.toHexString(l));
            printStream.print(" {");
            printStream.println();
            for (StructureReader.StructureDescriptor structureDescriptor2 : linkedList) {
                printStream.println(String.format("  Fields for %s:", structureDescriptor2.getName()));
                for (StructureReader.FieldDescriptor fieldDescriptor : structureDescriptor2.getFields()) {
                    if (!fieldDescriptor.isPresent()) continue;
                    printStream.print("\t0x");
                    printStream.print(Integer.toHexString(fieldDescriptor.getOffset()));
                    printStream.print(": ");
                    printStream.print(fieldDescriptor.getDeclaredType());
                    printStream.print(" ");
                    printStream.print(fieldDescriptor.getName());
                    printStream.print(" = ");
                    try {
                        this.formatField(fieldDescriptor.getName(), fieldDescriptor.getType(), fieldDescriptor.getDeclaredType(), l + (long)fieldDescriptor.getOffset(), printStream, context);
                    }
                    catch (CorruptDataException corruptDataException) {
                        printStream.print("<FAULT>");
                    }
                    printStream.println();
                }
            }
            printStream.println("}");
            return FormatWalkResult.STOP_WALKING;
        }
    }
}

