/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools.utils;

import com.ibm.jvm.dtfjview.tools.utils.IMatchHandle;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class MatchHandle
implements IMatchHandle {
    private final String[] matchStringList;
    private final boolean ignoreCase;
    private final boolean negated;
    private final boolean isFixedString;

    public MatchHandle(String[] stringArray, boolean bl) {
        this(stringArray, bl, false, false);
    }

    public MatchHandle(String[] stringArray, boolean bl, boolean bl2, boolean bl3) {
        this.matchStringList = stringArray;
        this.ignoreCase = bl;
        this.negated = bl2;
        this.isFixedString = bl3;
    }

    @Override
    public boolean matches(String string) {
        for (String string2 : this.matchStringList) {
            if (this.negated == this.match(string, string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String process(String string) {
        return string;
    }

    private boolean match(String string, String string2) {
        if (this.isFixedString) {
            return this.matchFixedStrings(string, new String[]{string2});
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "*");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return this.matchFixedStrings(string, arrayList.toArray(new String[arrayList.size()]));
    }

    private boolean matchFixedStrings(String string, String[] stringArray) {
        if (this.ignoreCase) {
            string = string.toLowerCase();
        }
        for (String string2 : stringArray) {
            int n;
            if (this.ignoreCase) {
                string2 = string2.toLowerCase();
            }
            if ((n = string.indexOf(string2)) < 0) {
                return false;
            }
            string = string.substring(n + string2.length());
        }
        return true;
    }
}

