/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.store;

import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.store.StructureKey;
import com.ibm.j9ddr.tools.store.StructureMismatchError;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class J9DDRStructureStore {
    private File directory;
    private HashMap<StructureKey, String> keyMap = new HashMap();
    HashMap<String, HashSet<String>> superset = new HashMap();
    private byte[] structureBytes;
    private String supersetFilename;
    private static final String INDEX_FILE_NAME = "keymap.idx";
    public static final String DEFAULT_SUPERSET_FILE_NAME = "superset.dat";
    private static final byte[] SUPERSET_ID;
    private static final byte[] SUPERSET_ID_EBCDIC;
    private static final String CHARSET_EBCDIC = "Cp037";

    public void add(StructureKey structureKey, String string, boolean bl) throws IOException, StructureMismatchError {
        String string2 = this.digestStructure(string);
        if (!bl) {
            return;
        }
        String string3 = this.keyMap.get(structureKey);
        if (string3 != null) {
            if (string3.equals(string2)) {
                return;
            }
            throw new StructureMismatchError(String.format("%s exists in database but is not the same as the structure being added from %s", structureKey, string));
        }
        boolean bl2 = this.keyMap.containsValue(string2);
        this.keyMap.put(structureKey, string2);
        this.writeIndex();
        if (!bl2) {
            this.physicallyStore(structureKey, string2);
        }
    }

    public void updateSuperset() throws IOException {
        Object object;
        StructureReader structureReader = null;
        if (this.structureBytes.length > 2 && this.structureBytes[0] == SUPERSET_ID[0] && this.structureBytes[1] == SUPERSET_ID[1]) {
            object = new ByteArrayInputStream(this.structureBytes);
            structureReader = new StructureReader((InputStream)object);
        } else {
            object = new MemoryCacheImageInputStream(new ByteArrayInputStream(this.structureBytes));
            structureReader = new StructureReader((ImageInputStream)object);
        }
        for (StructureReader.StructureDescriptor structureDescriptor : structureReader.getStructures()) {
            String string = structureDescriptor.deflate();
            HashSet<String> hashSet = this.superset.get(string);
            if (hashSet == null) {
                hashSet = new HashSet();
                this.superset.put(string, hashSet);
            }
            for (StructureReader.FieldDescriptor fieldDescriptor : structureDescriptor.getFields()) {
                this.addFieldToSuperset(hashSet, fieldDescriptor);
            }
            for (StructureReader.ConstantDescriptor constantDescriptor : structureDescriptor.getConstants()) {
                String string2 = constantDescriptor.deflate();
                hashSet.add(string2);
            }
        }
        this.writeSuperset();
    }

    private boolean addFieldToSuperset(HashSet<String> hashSet, StructureReader.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getDeclaredName().startsWith("_j9padding")) {
            return false;
        }
        String string = null;
        Iterator<String> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string2.startsWith("F|" + fieldDescriptor.getName() + "|")) continue;
            String string3 = StructureReader.simplifyType(fieldDescriptor.getType());
            String string4 = StructureReader.simplifyType(fieldDescriptor.getDeclaredType());
            String[] stringArray = string2.split("\\|");
            for (int i = 3; i < stringArray.length; i += 2) {
                String string5 = StructureReader.simplifyType(stringArray[i]);
                String string6 = StructureReader.simplifyType(stringArray[i + 1]);
                if (!string5.equals(string3) || !string6.equals(string4)) continue;
                return false;
            }
            iterator.remove();
            string = string2 + "|" + string3 + "|" + string4;
            break;
        }
        if (string == null) {
            hashSet.add(fieldDescriptor.deflate());
        } else {
            hashSet.add(string);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSuperset() throws IOException {
        File file = new File(this.directory, this.supersetFilename);
        try (BufferedWriter bufferedWriter = null;){
            FileWriter fileWriter = new FileWriter(file);
            bufferedWriter = new BufferedWriter(fileWriter);
            ArrayList<String> arrayList = new ArrayList<String>(this.superset.size());
            arrayList.addAll(this.superset.keySet());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                bufferedWriter.write(string);
                bufferedWriter.newLine();
                Object[] objectArray = this.superset.get(string).toArray(new String[0]);
                Arrays.sort(objectArray);
                for (Object object : objectArray) {
                    bufferedWriter.write((String)object);
                    bufferedWriter.newLine();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSuperset() throws IOException {
        this.superset = new HashMap();
        File file = new File(this.directory, this.supersetFilename);
        if (!file.exists()) {
            return;
        }
        try (BufferedReader bufferedReader = null;){
            FileReader fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            String string = bufferedReader.readLine();
            HashSet<String> hashSet = null;
            while (string != null) {
                if (string.charAt(0) == 'S') {
                    hashSet = new HashSet<String>();
                    this.superset.put(string, hashSet);
                } else {
                    hashSet.add(string);
                }
                string = bufferedReader.readLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIndex() throws IOException {
        File file = new File(this.directory, INDEX_FILE_NAME);
        if (!file.exists()) {
            return;
        }
        try (BufferedReader bufferedReader = null;){
            FileReader fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            String string = bufferedReader.readLine();
            this.keyMap = new HashMap();
            while (string != null) {
                int n = string.indexOf(" ");
                if (n > -1) {
                    StructureKey structureKey = new StructureKey(string.substring(0, n));
                    String string2 = string.substring(n + 1);
                    this.keyMap.put(structureKey, string2);
                }
                string = bufferedReader.readLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndex() throws IOException {
        File file = new File(this.directory, INDEX_FILE_NAME);
        try (BufferedWriter bufferedWriter = null;){
            FileWriter fileWriter = new FileWriter(file);
            bufferedWriter = new BufferedWriter(fileWriter);
            for (Map.Entry<StructureKey, String> entry : this.keyMap.entrySet()) {
                bufferedWriter.write(entry.getKey().toString());
                bufferedWriter.write(" ");
                bufferedWriter.write(entry.getValue());
                bufferedWriter.write(System.getProperty("line.separator"));
            }
        }
    }

    private void physicallyStore(StructureKey structureKey, String string) throws IOException {
        File file = this.getZipFile(structureKey, string);
        if (file.exists()) {
            throw new IOException(String.format("Attempting to over write existing structure data %s with key %s", file.getAbsolutePath(), structureKey));
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        ZipEntry zipEntry = this.getZipEntry(structureKey, string);
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(this.structureBytes);
        zipOutputStream.closeEntry();
        zipOutputStream.close();
    }

    private File getZipFile(StructureKey structureKey, String string) {
        return new File(this.directory, structureKey.getPlatform() + "." + string + ".zip");
    }

    private ZipEntry getZipEntry(StructureKey structureKey, String string) {
        return new ZipEntry(structureKey.getPlatform() + "." + string + ".ddr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String digestStructure(String string) throws IOException {
        MessageDigest messageDigest = null;
        byte[] byArray = new byte[1024];
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException.getMessage());
        }
        DigestInputStream digestInputStream = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        digestInputStream = new DigestInputStream(fileInputStream, messageDigest);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = digestInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            digestInputStream.close();
        }
        finally {
            fileInputStream.close();
        }
        this.structureBytes = byteArrayOutputStream.toByteArray();
        if (this.structureBytes.length > 2 && this.structureBytes[0] == SUPERSET_ID_EBCDIC[0] && this.structureBytes[1] == SUPERSET_ID_EBCDIC[1]) {
            this.convertFromEBCDIC();
        }
        byte[] byArray2 = digestInputStream.getMessageDigest().digest();
        return this.byteArrayHexString(byArray2);
    }

    private void convertFromEBCDIC() throws IOException {
        try {
            System.out.println("Converting input file from EBCDIC to UTF-8");
            String string = new String(this.structureBytes, CHARSET_EBCDIC);
            this.structureBytes = string.getBytes("UTF-8");
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Failed to convert data from EBCDIC");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    private String byteArrayHexString(byte[] byArray) {
        StringWriter stringWriter = new StringWriter();
        for (int i = 0; i < byArray.length; ++i) {
            stringWriter.write(Integer.toHexString(256 + byArray[i] & 0xFF));
        }
        return stringWriter.toString();
    }

    public boolean remove(StructureKey structureKey) throws IOException {
        String string = this.keyMap.remove(structureKey);
        if (string == null) {
            return false;
        }
        if (!this.keyMap.containsValue(string)) {
            File file = this.getZipFile(structureKey, string);
            file.delete();
        }
        this.writeIndex();
        return true;
    }

    public ImageInputStream get(StructureKey structureKey) throws IOException {
        int n;
        String string = this.keyMap.get(structureKey);
        if (string == null) {
            return null;
        }
        ZipFile zipFile = new ZipFile(this.getZipFile(structureKey, string));
        ZipEntry zipEntry = zipFile.getEntry(this.getZipEntry(structureKey, string).getName());
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)zipEntry.getSize());
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        zipFile.close();
        return new MemoryCacheImageInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    public InputStream getSuperset() throws FileNotFoundException {
        return new FileInputStream(new File(this.directory, this.supersetFilename));
    }

    protected J9DDRStructureStore() {
    }

    public J9DDRStructureStore(String string, String string2) throws IOException {
        this.supersetFilename = string2 == null ? DEFAULT_SUPERSET_FILE_NAME : string2;
        this.initialize(string);
    }

    private void initialize(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("databaseDirectory may not be null");
        }
        this.directory = new File(string);
        if (!this.directory.exists()) {
            this.create();
        } else {
            this.open();
        }
    }

    private void create() throws IOException {
        if (!this.directory.mkdir()) {
            throw new IOException(String.format("Unable to create directory %s", this.directory.getAbsolutePath()));
        }
        this.writeIndex();
        this.writeSuperset();
    }

    private void open() throws IOException {
        this.readIndex();
        this.readSuperset();
    }

    public String getSuperSetFileName() {
        return this.supersetFilename;
    }

    static {
        try {
            SUPERSET_ID = "S|".getBytes("ASCII");
            SUPERSET_ID_EBCDIC = "S|".getBytes(CHARSET_EBCDIC);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not create SUPERSET identifier", exception);
        }
    }
}

