/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Util;
import com.ibm.oti.vm.VM;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.net.www.protocol.file.Handler;

public abstract class AbstractClassLoader
extends ClassLoader {
    private static ClassLoader systemClassLoader;
    String[] parsedPath;
    int[] types;
    Object[] cache;
    static Object cacheLock;
    FilePermission[] permissions;
    volatile SoftReference<ConcurrentHashMap<String, Vector>> resourceCacheRef;
    private static URLStreamHandler urlJarStreamHandler;
    private static URLStreamHandler urlFileStreamHandler;

    void fillCache(int n) {
        this.setTypeElement(n, VM.getClassPathEntryType(this, n));
        switch (this.types[n]) {
            case 0: {
                this.setCacheElement(n, this.cache);
                return;
            }
            case 1: 
            case 2: {
                String string;
                if (this.parsedPath[n] == null) {
                    this.setParsedPathElement(n, Util.toString(VM.getPathFromClassPath(n)));
                }
                File file = new File(this.parsedPath[n]);
                try {
                    string = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string = file.getAbsolutePath();
                }
                if (this.types[n] == 1) {
                    if (string.charAt(string.length() - 1) != File.separatorChar) {
                        StringBuilder stringBuilder = new StringBuilder(string.length() + 1);
                        string = stringBuilder.append(string).append(File.separatorChar).toString();
                    }
                    this.setParsedPathElement(n, string);
                    this.setCacheElement(n, this.cache);
                } else {
                    this.setParsedPathElement(n, string);
                    try {
                        JarFile jarFile = new JarFile(this.parsedPath[n]);
                        this.setCacheElement(n, jarFile);
                        return;
                    }
                    catch (IOException iOException) {
                        this.setTypeElement(n, 5);
                        this.setCacheElement(n, this.cache);
                    }
                }
                return;
            }
            case 3: 
            case 5: {
                this.setCacheElement(n, this.cache);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCacheElement(int n, Object object) {
        Object object2 = cacheLock;
        synchronized (object2) {
            this.cache[n] = object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTypeElement(int n, int n2) {
        Object object = cacheLock;
        synchronized (object) {
            this.types[n] = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParsedPathElement(int n, String string) {
        Object object = cacheLock;
        synchronized (object) {
            this.parsedPath[n] = string;
        }
    }

    static String toURLString(String string, int n) {
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        string2 = Util.urlEncode(string2);
        int n2 = string2.length() + 6;
        if (n == 2) {
            n2 += 4;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        if (n == 2) {
            stringBuilder.append("jar:file:");
        } else if (n == 1) {
            stringBuilder.append("file:");
        } else if (n == 3) {
            stringBuilder.append("jrt:");
        }
        if (!string2.startsWith("/")) {
            stringBuilder.append('/');
        }
        string2 = stringBuilder.append(string2).toString();
        return string2;
    }

    public static void setBootstrapClassLoader(ClassLoader classLoader) {
        if (systemClassLoader != null) {
            throw new IllegalArgumentException();
        }
        systemClassLoader = classLoader;
        urlJarStreamHandler = new sun.net.www.protocol.jar.Handler();
        urlFileStreamHandler = new Handler();
    }

    static String getPackageName(Class<?> clazz) {
        String string = VM.getClassNameImpl(clazz, false);
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    @Override
    protected URL findResource(final String string) {
        SecurityManager securityManager;
        URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < AbstractClassLoader.this.cache.length; ++i) {
                    URL uRL = AbstractClassLoader.this.findResourceImpl(i, string);
                    if (uRL == null) continue;
                    return uRL;
                }
                return null;
            }
        });
        if (uRL != null && (securityManager = System.getSecurityManager()) != null) {
            try {
                securityManager.checkPermission(uRL.openConnection().getPermission());
            }
            catch (IOException iOException) {
                return null;
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        return uRL;
    }

    private URL findResourceImpl(int n, String string) {
        if (string.length() > 0 && string.charAt(0) == '/') {
            return null;
        }
        if (this.cache[n] == null) {
            this.fillCache(n);
        }
        try {
            switch (this.types[n]) {
                case 2: {
                    ZipFile zipFile = (ZipFile)this.cache[n];
                    if (zipFile.getEntry(string) != null) {
                        return new URL(null, AbstractClassLoader.toURLString(this.parsedPath[n] + "!/" + string, this.types[n]), urlJarStreamHandler);
                    }
                    return null;
                }
                case 1: {
                    StringBuilder stringBuilder = new StringBuilder(this.parsedPath[n].length() + string.length());
                    String string2 = stringBuilder.append(this.parsedPath[n]).append(string).toString();
                    File file = new File(string2);
                    if (file.exists()) {
                        return new URL(null, AbstractClassLoader.toURLString(string2, this.types[n]), urlFileStreamHandler);
                    }
                    return null;
                }
                case 3: {
                    return null;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Enumeration findResources(final String string) throws IOException {
        Serializable serializable;
        Object object;
        Serializable serializable2;
        if (this.resourceCacheRef != null && (serializable2 = this.resourceCacheRef.get()) != null && (object = ((ConcurrentHashMap)serializable2).get(string)) != null) {
            return ((Vector)object).elements();
        }
        serializable2 = (Vector)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Vector<URL> vector = new Vector<URL>();
                for (int i = 0; i < AbstractClassLoader.this.cache.length; ++i) {
                    URL uRL = AbstractClassLoader.this.findResourceImpl(i, string);
                    if (uRL == null) continue;
                    vector.addElement(uRL);
                }
                return vector;
            }
        });
        int n = ((Vector)serializable2).size();
        if (n > 0 && (object = System.getSecurityManager()) != null) {
            serializable = new Vector(n);
            for (int i = 0; i < n; ++i) {
                URL uRL = (URL)((Vector)serializable2).elementAt(i);
                try {
                    ((SecurityManager)object).checkPermission(uRL.openConnection().getPermission());
                    ((Vector)serializable).addElement(uRL);
                    continue;
                }
                catch (IOException | SecurityException exception) {
                    // empty catch block
                }
            }
            serializable2 = serializable;
        }
        if (this.resourceCacheRef == null || (serializable = this.resourceCacheRef.get()) == null) {
            Object object2 = cacheLock;
            synchronized (object2) {
                if (this.resourceCacheRef == null || (serializable = this.resourceCacheRef.get()) == null) {
                    serializable = new ConcurrentHashMap(64);
                    this.resourceCacheRef = new SoftReference<Serializable>(serializable);
                }
            }
        }
        ((ConcurrentHashMap)serializable).put(string, serializable2);
        return ((Vector)serializable2).elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getResourceAsStream(String string) {
        int n;
        InputStream inputStream;
        if (string == null || string.length() < 1 || string.charAt(0) == '/') {
            return null;
        }
        if (this != systemClassLoader && (inputStream = this.getParent() == null ? systemClassLoader.getResourceAsStream(string) : this.getParent().getResourceAsStream(string)) != null) {
            return inputStream;
        }
        Object object = cacheLock;
        synchronized (object) {
            n = this.cache.length;
        }
        for (int i = 0; i < n; ++i) {
            try {
                if (this.cache[i] == null) {
                    this.fillCache(i);
                }
                switch (this.types[i]) {
                    case 2: {
                        ZipFile zipFile = (ZipFile)this.cache[i];
                        ZipEntry zipEntry = zipFile.getEntry(string);
                        if (zipEntry == null) break;
                        Object object2 = System.getSecurityManager();
                        if (object2 != null) {
                            this.initalizePermissions();
                            if (this.permissions[i] == null) {
                                this.setPermissionElement(i, new FilePermission(this.parsedPath[i], "read"));
                            }
                            ((SecurityManager)object2).checkPermission(this.permissions[i]);
                        }
                        try {
                            return zipFile.getInputStream(zipEntry);
                        }
                        catch (IOException iOException) {
                            break;
                        }
                    }
                    case 1: {
                        Object object2 = new StringBuilder(this.parsedPath[i].length() + string.length());
                        String string2 = ((StringBuilder)object2).append(this.parsedPath[i]).append(string).toString();
                        InputStream inputStream2 = AbstractClassLoader.openFile(string2);
                        if (inputStream2 == null) break;
                        return inputStream2;
                    }
                }
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initalizePermissions() {
        Object object = cacheLock;
        synchronized (object) {
            if (this.permissions == null) {
                this.permissions = new FilePermission[this.cache.length];
            }
        }
    }

    private static InputStream openFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            try {
                return new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPermissionElement(int n, FilePermission filePermission) {
        Object object = cacheLock;
        synchronized (object) {
            this.permissions[n] = filePermission;
        }
    }

    static {
        cacheLock = new CacheLock();
    }

    private static final class CacheLock {
        private CacheLock() {
        }
    }
}

