/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.AbstractClassLoader;
import com.ibm.oti.vm.BootstrapClassLoader;
import com.ibm.oti.vm.VM;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodType;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import sun.misc.Launcher;
import sun.reflect.CallerSensitive;
import sun.security.util.SecurityConstants;

public abstract class ClassLoader {
    private static CodeSource defaultCodeSource = new CodeSource(null, (Certificate[])null);
    static ClassLoader bootstrapClassLoader;
    private static final String DELEGATING_CL = "sun.reflect.DelegatingClassLoader";
    private boolean isDelegatingCL = false;
    private static ClassLoader applicationClassLoader;
    private static boolean initSystemClassLoader;
    private static final boolean isAssertOptionFound;
    private long vmRef;
    ClassLoader parent;
    private static boolean checkAssertionOptions;
    private final Object assertionLock = new AssertionLock();
    private boolean defaultAssertionStatus;
    private Map<String, Boolean> packageAssertionStatus;
    private Map<String, Boolean> classAssertionStatus;
    private final Hashtable<String, Package> packages = new Hashtable();
    private final Object lazyInitLock = new LazyInitLock();
    private volatile Hashtable<Class<?>, Object[]> classSigners;
    private volatile Hashtable<String, Certificate[]> packageSigners;
    private static Certificate[] emptyCertificates;
    private volatile ProtectionDomain defaultProtectionDomain;
    private static Map<Class<?>, Object> parallelCapableCollection;
    private volatile Hashtable<String, ClassNameLockRef> classNameBasedLock;
    private boolean isParallelCapable;
    private static final Package[] EMPTY_PACKAGE_ARRAY;
    private Map<String, MethodType> methodTypeFromMethodDescriptorStringCache;
    private static boolean allowArraySyntax;
    private static boolean lazyClassLoaderInit;
    private static boolean specialLoaderInited;
    private static InternalAnonymousClassLoader internalAnonClassLoader;

    private static native void initAnonClassLoader(InternalAnonymousClassLoader var0);

    static final void initializeClassLoaders() {
        String string;
        if (null != bootstrapClassLoader) {
            return;
        }
        parallelCapableCollection = Collections.synchronizedMap(new WeakHashMap());
        allowArraySyntax = "true".equalsIgnoreCase(System.internalGetProperties().getProperty("sun.lang.ClassLoader.allowArraySyntax"));
        String string2 = System.internalGetProperties().getProperty("reflect.cache");
        if (string2 != null) {
            string2 = string2.toLowerCase();
        }
        boolean bl = false;
        boolean bl2 = false;
        if (!"false".equals(string2)) {
            int n;
            bl = true;
            if (string2 != null && (n = string2.indexOf("debug")) >= 0) {
                bl2 = true;
            }
        }
        try {
            Class.forName("java.security.ProtectionDomain");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ClassLoader classLoader = null;
        String string3 = System.internalGetProperties().getProperty("systemClassLoader");
        if (null == string3) {
            classLoader = BootstrapClassLoader.singleton();
        } else {
            try {
                classLoader = (ClassLoader)Class.forName(string3, true, null).newInstance();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                System.exit(1);
            }
        }
        bootstrapClassLoader = classLoader;
        AbstractClassLoader.setBootstrapClassLoader(bootstrapClassLoader);
        lazyClassLoaderInit = true;
        applicationClassLoader = bootstrapClassLoader;
        internalAnonClassLoader = new InternalAnonymousClassLoader();
        ClassLoader.initAnonClassLoader(internalAnonClassLoader);
        String string4 = System.internalGetProperties().getProperty("java.lang.ClassLoader.lazyInitialization");
        if (null != string4 && "false".equals(string4 = string4.toLowerCase())) {
            lazyClassLoaderInit = false;
        }
        if ("allow".equals(string = System.internalGetProperties().getProperty("java.security.manager")) || "disallow".equals(string)) {
            System.internalGetProperties().remove("java.security.manager");
        }
        ClassLoader classLoader2 = applicationClassLoader = Launcher.getLauncher().getClassLoader();
        while (null != classLoader2.parent) {
            classLoader2 = classLoader2.parent;
        }
        VMAccess.setExtClassLoader(classLoader2);
        Class.initCacheIds(bl, bl2);
    }

    protected ClassLoader() {
        this(ClassLoader.checkSecurityPermission(), null, applicationClassLoader);
    }

    private static Void checkSecurityPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        return null;
    }

    protected ClassLoader(ClassLoader classLoader) {
        this(ClassLoader.checkSecurityPermission(), null, classLoader);
    }

    private ClassLoader(Void void_, String string, ClassLoader classLoader) {
        this.isDelegatingCL = DELEGATING_CL.equals(this.getClass().getName());
        if (parallelCapableCollection.containsKey(this.getClass())) {
            this.isParallelCapable = true;
        }
        this.parent = classLoader;
        boolean bl = specialLoaderInited = bootstrapClassLoader != null;
        if (specialLoaderInited && !lazyClassLoaderInit) {
            VM.initializeClassLoader(this, VM.J9_CLASSLOADER_TYPE_OTHERS, this.isParallelCapable);
        }
        if (isAssertOptionFound) {
            this.initializeClassLoaderAssertStatus();
        }
    }

    @Deprecated
    protected final Class<?> defineClass(byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(null, byArray, n, n2);
    }

    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(string, byArray, n, n2, null);
    }

    private String checkClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            if (string.startsWith("java.")) {
                throw new SecurityException(Msg.getString("K01d2", (Object)string2, string));
            }
            return string2;
        }
        return "";
    }

    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) throws ClassFormatError {
        return this.defineClassInternal(string, byArray, n, n2, protectionDomain, false);
    }

    final Class<?> defineClassInternal(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain, boolean bl) throws ClassFormatError {
        Object object;
        Object object2;
        Object[] objectArray = null;
        if (protectionDomain != null && (object2 = protectionDomain.getCodeSource()) != null) {
            objectArray = ((CodeSource)object2).getCertificates();
        }
        if (string != null) {
            object2 = this.checkClassName(string);
            if (protectionDomain != null || !bl) {
                this.checkPackageSigners((String)object2, string, (Certificate[])objectArray);
            }
        }
        if (n < 0 || n2 < 0 || n > byArray.length || n2 > byArray.length - n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (protectionDomain == null && !bl) {
            protectionDomain = this.getDefaultProtectionDomain();
        }
        object2 = protectionDomain;
        Class<?> clazz = this.defineClassImpl(string, byArray, n, n2, object2);
        if (objectArray != null) {
            this.setSigners(clazz, objectArray);
        }
        boolean bl2 = this.isVerboseImpl();
        URL uRL = null;
        if (bl2 && object2 != null && (object = ((ProtectionDomain)object2).getCodeSource()) != null) {
            uRL = ((CodeSource)object).getLocation();
        }
        if (bl2) {
            object = uRL != null ? uRL.toString() : "<unknown>";
            VM.dumpString("class load: " + clazz.getName() + " from: " + (String)object + "\n");
        }
        return clazz;
    }

    private native boolean isVerboseImpl();

    private static native boolean foundJavaAssertOption();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPackageSigners(String string, String string2, Certificate[] certificateArray) {
        Certificate[] certificateArray2 = null;
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.packageSigners != null) {
                certificateArray2 = this.packageSigners.get(string);
            } else {
                this.packageSigners = new Hashtable();
            }
        }
        if (certificateArray2 == null) {
            if (certificateArray == null) {
                this.packageSigners.put(string, emptyCertificates);
            } else {
                this.packageSigners.put(string, certificateArray);
            }
        } else {
            if (certificateArray == null && certificateArray2.length == 0 || certificateArray == certificateArray2) {
                return;
            }
            if (certificateArray != null && certificateArray.length == certificateArray2.length) {
                boolean bl = true;
                block3: for (int i = 0; i < certificateArray.length; ++i) {
                    if (certificateArray[i] == certificateArray2[i] || certificateArray[i].equals(certificateArray2[i])) continue;
                    for (int j = 0; j < certificateArray2.length; ++j) {
                        if (j != i && (certificateArray[i] == certificateArray2[j] || certificateArray[i].equals(certificateArray2[j]))) continue block3;
                    }
                    bl = false;
                    break;
                }
                if (bl) {
                    return;
                }
            }
            throw new SecurityException(Msg.getString("K01d1", string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProtectionDomain getDefaultProtectionDomain() {
        if (this.isParallelCapable) {
            if (this.defaultProtectionDomain == null) {
                Object object = this.lazyInitLock;
                synchronized (object) {
                    return this.getDefaultProtectionDomainHelper();
                }
            }
            return this.defaultProtectionDomain;
        }
        return this.getDefaultProtectionDomainHelper();
    }

    private final ProtectionDomain getDefaultProtectionDomainHelper() {
        if (this.defaultProtectionDomain == null) {
            this.defaultProtectionDomain = new ProtectionDomain(defaultCodeSource, null, this, null);
        }
        return this.defaultProtectionDomain;
    }

    private final native Class<?> defineClassImpl(String var1, byte[] var2, int var3, int var4, Object var5);

    protected Class<?> findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException();
    }

    protected final Class<?> findLoadedClass(String string) {
        if (!allowArraySyntax && string != null && string.length() > 0 && string.charAt(0) == '[') {
            return null;
        }
        return this.findLoadedClassImpl(string);
    }

    private native Class<?> findLoadedClassImpl(String var1);

    protected final Class<?> findSystemClass(String string) throws ClassNotFoundException {
        return applicationClassLoader.loadClass(string);
    }

    @CallerSensitive
    public final ClassLoader getParent() {
        ClassLoader classLoader;
        if (this.parent == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && ClassLoader.needsClassLoaderPermissionCheck(classLoader = ClassLoader.callerClassLoader(), this.parent)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return this.parent;
    }

    public URL getResource(String string) {
        URL uRL = null;
        uRL = null == this.parent ? bootstrapClassLoader.findResource(string) : this.parent.getResource(string);
        if (null == uRL) {
            uRL = this.findResource(string);
        }
        return uRL;
    }

    public Enumeration<URL> getResources(String string) throws IOException {
        Enumeration<URL> enumeration = null;
        if (this.parent != null) {
            enumeration = this.parent.getResources(string);
        } else if (this != bootstrapClassLoader) {
            enumeration = bootstrapClassLoader.getResources(string);
        }
        Enumeration<URL> enumeration2 = this.findResources(string);
        if (enumeration2 != null && !enumeration2.hasMoreElements()) {
            enumeration2 = null;
        }
        if (enumeration == null) {
            enumeration = enumeration2;
            if (enumeration == null) {
                enumeration = Collections.emptyEnumeration();
            }
        } else if (enumeration2 != null) {
            if (enumeration instanceof CompoundEnumeration) {
                ((CompoundEnumeration)enumeration).append(enumeration2);
            } else {
                enumeration = new CompoundEnumeration<URL>(enumeration, enumeration2);
            }
        }
        return enumeration;
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            if (uRL != null) {
                return uRL.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static void completeInitialization() {
        Class<Void> clazz = Void.TYPE;
        String string = System.internalGetProperties().getProperty("reflect.cache");
        if (string != null) {
            string = string.toLowerCase();
        }
        boolean bl = true;
        if (!"false".equals(string)) {
            bl = false;
            if (string != null) {
                int n = string.indexOf("boot");
                if (n >= 0) {
                    bl = false;
                } else {
                    int n2 = string.indexOf("app");
                    if (n2 >= 0) {
                        bl = true;
                    }
                }
            }
        }
        Class.setReflectCacheAppOnly(bl);
        initSystemClassLoader = true;
    }

    static ClassLoader getClassLoader(Class<?> clazz) {
        if (null != clazz) {
            return clazz.getClassLoader0();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallerSensitive
    public static ClassLoader getSystemClassLoader() {
        Object object;
        Object object2;
        Object object3;
        if (initSystemClassLoader) {
            object2 = object3 = ClassLoader.class;
            synchronized (object2) {
                if (initSystemClassLoader) {
                    initSystemClassLoader = false;
                    object = System.internalGetProperties().getProperty("java.system.class.loader");
                    if (object != null) {
                        try {
                            Class<?> clazz = Class.forName((String)object, true, applicationClassLoader);
                            Constructor<?> constructor = clazz.getConstructor(new Class[]{object3});
                            ClassLoader classLoader = applicationClassLoader = (ClassLoader)constructor.newInstance(applicationClassLoader);
                            while (classLoader.parent != null) {
                                classLoader = classLoader.parent;
                            }
                            VMAccess.setExtClassLoader(classLoader);
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof InvocationTargetException) {
                                throw new Error(throwable.getCause());
                            }
                            throw new Error(throwable);
                        }
                    }
                }
            }
        }
        object3 = applicationClassLoader;
        object2 = System.getSecurityManager();
        if (object2 != null && ClassLoader.needsClassLoaderPermissionCheck((ClassLoader)(object = ClassLoader.callerClassLoader()), (ClassLoader)object3)) {
            ((SecurityManager)object2).checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return object3;
    }

    public static URL getSystemResource(String string) {
        return ClassLoader.getSystemClassLoader().getResource(string);
    }

    public static Enumeration<URL> getSystemResources(String string) throws IOException {
        return ClassLoader.getSystemClassLoader().getResources(string);
    }

    public static InputStream getSystemResourceAsStream(String string) {
        return ClassLoader.getSystemClassLoader().getResourceAsStream(string);
    }

    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        return this.loadClassHelper(string, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<?> loadClassHelper(String string, boolean bl, boolean bl2) throws ClassNotFoundException {
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = this.isParallelCapable ? this.getClassLoadingLock(string) : this;
        synchronized (classLoader2) {
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz == null) {
                if (bl2) {
                    try {
                        if (this.parent == null) {
                            if (this.isDelegatingCL) {
                                clazz = bootstrapClassLoader.findLoadedClass(string);
                            }
                            if (clazz == null) {
                                clazz = bootstrapClassLoader.loadClass(string);
                            }
                        } else {
                            if (this.isDelegatingCL) {
                                clazz = this.parent.findLoadedClass(string);
                            }
                            if (clazz == null) {
                                clazz = this.parent.loadClass(string, bl);
                            }
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (clazz == null) {
                    clazz = this.findClass(string);
                }
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    @CallerSensitive
    protected static boolean registerAsParallelCapable() {
        Class clazz = System.getCallerClass();
        if (parallelCapableCollection.containsKey(clazz)) {
            return true;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 == ClassLoader.class || parallelCapableCollection.containsKey(clazz2)) {
            parallelCapableCollection.put(clazz, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getClassLoadingLock(String string) {
        Object object = this;
        if (this.isParallelCapable) {
            Hashtable<String, ClassNameLockRef> hashtable;
            if (this.classNameBasedLock == null) {
                hashtable = this.lazyInitLock;
                synchronized (hashtable) {
                    if (this.classNameBasedLock == null) {
                        this.classNameBasedLock = new Hashtable();
                    }
                }
            }
            hashtable = this.classNameBasedLock;
            synchronized (hashtable) {
                ClassNameLockRef classNameLockRef = this.classNameBasedLock.get(string);
                Object object2 = object = null != classNameLockRef ? (Object)classNameLockRef.get() : null;
                if (object == null) {
                    object = new ClassNameBasedLock();
                    this.classNameBasedLock.put(string, new ClassNameLockRef(object, string, this.classNameBasedLock));
                }
            }
        }
        return object;
    }

    protected final void resolveClass(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
    }

    private void setParent(ClassLoader classLoader) {
        this.parent = classLoader;
    }

    final boolean isASystemClassLoader() {
        if (this == bootstrapClassLoader) {
            return true;
        }
        ClassLoader classLoader = applicationClassLoader;
        while (classLoader != null) {
            if (this == classLoader) {
                return true;
            }
            classLoader = classLoader.parent;
        }
        return false;
    }

    final boolean isAncestorOf(ClassLoader classLoader) {
        if (classLoader == null) {
            return false;
        }
        if (this == bootstrapClassLoader) {
            return true;
        }
        ClassLoader classLoader2 = classLoader.parent;
        while (classLoader2 != null) {
            if (this == classLoader2) {
                return true;
            }
            classLoader2 = classLoader2.parent;
        }
        return false;
    }

    static final boolean needsClassLoaderPermissionCheck(ClassLoader classLoader, ClassLoader classLoader2) {
        return classLoader != null && classLoader != classLoader2 && !classLoader.isAncestorOf(classLoader2);
    }

    protected URL findResource(String string) {
        return null;
    }

    protected Enumeration<URL> findResources(String string) throws IOException {
        return new Vector().elements();
    }

    protected String findLibrary(String string) {
        return null;
    }

    final Package getDefinedPackage(String string) {
        return this.packages.get(string);
    }

    protected Package getPackage(String string) {
        if (this == bootstrapClassLoader) {
            return this.getDefinedPackage(string);
        }
        Package package_ = this.getDefinedPackage(string);
        if (package_ == null) {
            ClassLoader classLoader = this.parent;
            if (classLoader == null) {
                classLoader = bootstrapClassLoader;
            }
            package_ = classLoader.getPackage(string);
        }
        return package_;
    }

    private Package[] getPackagesHelper(Hashtable<?, Package> hashtable, Package[] packageArray) {
        int n = hashtable.size();
        if (packageArray != null) {
            n += packageArray.length;
        }
        Package[] packageArray2 = new Package[n];
        int n2 = 0;
        if (packageArray != null) {
            n2 = packageArray.length;
            System.arraycopy((Object)packageArray, 0, (Object)packageArray2, 0, n2);
        }
        Enumeration<Package> enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            packageArray2[n2++] = enumeration.nextElement();
        }
        return packageArray2;
    }

    protected Package[] getPackages() {
        Package[] packageArray = null;
        if (this.parent == null) {
            if (this != bootstrapClassLoader) {
                packageArray = bootstrapClassLoader.getPackages();
            }
        } else {
            packageArray = this.parent.getPackages();
        }
        Hashtable hashtable = this.packages;
        boolean bl = false;
        while (true) {
            try {
                Package[] packageArray2 = this.getPackagesHelper(hashtable, packageArray);
                return packageArray2;
            }
            catch (RuntimeException runtimeException) {
                if (bl) {
                    throw runtimeException;
                }
                bl = true;
                hashtable = (Hashtable)this.packages.clone();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        Hashtable<String, Package> hashtable = this.packages;
        synchronized (hashtable) {
            if (null != this.getPackage(string)) {
                throw new IllegalArgumentException(Msg.getString("K0053", string));
            }
            Package package_ = new Package(string, string2, string3, string4, string5, string6, string7, uRL, this);
            this.packages.put(string, package_);
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final Object[] getSigners(Class<?> clazz) {
        Object[] objectArray;
        Hashtable<Class<?>, Object[]> hashtable = this.classSigners;
        if (hashtable == null) {
            objectArray = this.lazyInitLock;
            // MONITORENTER : this.lazyInitLock
            hashtable = this.classSigners;
            if (hashtable == null) {
                // MONITOREXIT : objectArray
                return null;
            }
            // MONITOREXIT : objectArray
        }
        if ((objectArray = hashtable.get(clazz)) == null) return objectArray;
        return (Object[])objectArray.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSigners(Class<?> clazz, Object[] objectArray) {
        if (clazz.getClassLoaderImpl() == this) {
            if (objectArray == null) {
                if (this.classSigners == null) {
                    Object object = this.lazyInitLock;
                    synchronized (object) {
                        if (this.classSigners == null) {
                            return;
                        }
                    }
                }
                this.classSigners.remove(clazz);
            } else {
                if (this.classSigners == null) {
                    Object object = this.lazyInitLock;
                    synchronized (object) {
                        if (this.classSigners == null) {
                            this.classSigners = new Hashtable();
                        }
                    }
                }
                this.classSigners.put(clazz, objectArray);
            }
        } else {
            clazz.getClassLoaderImpl().setSigners(clazz, objectArray);
        }
    }

    @CallerSensitive
    static ClassLoader getCallerClassLoader() {
        ClassLoader classLoader = ClassLoader.getStackClassLoader(2);
        if (classLoader == bootstrapClassLoader) {
            return null;
        }
        return classLoader;
    }

    @CallerSensitive
    static final native ClassLoader getStackClassLoader(int var0);

    @CallerSensitive
    static ClassLoader callerClassLoader() {
        ClassLoader classLoader = ClassLoader.getStackClassLoader(2);
        if (classLoader == bootstrapClassLoader) {
            return null;
        }
        return classLoader;
    }

    static void loadLibraryWithClassLoader(String string, ClassLoader classLoader) {
        String string2;
        if (classLoader != null && (string2 = classLoader.findLibrary(string)) != null) {
            ClassLoader.loadLibraryWithPath(string2, classLoader, null);
            return;
        }
        try {
            ClassLoader.loadLibraryWithPath(string, classLoader, System.internalGetProperties().getProperty("com.ibm.oti.vm.bootstrap.library.path"));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (classLoader == null) {
                throw unsatisfiedLinkError;
            }
            ClassLoader.loadLibraryWithPath(string, classLoader, System.internalGetProperties().getProperty("java.library.path"));
        }
    }

    static void loadLibraryWithPath(String string, ClassLoader classLoader, String string2) {
        String string3;
        if (File.separatorChar == '\\' && string.startsWith("/") && Util.startsWithDriveLetter(string.substring(1))) {
            string = string.substring(1);
        }
        byte[] byArray = ClassLoader.loadLibraryWithPath(Util.getBytes(string), classLoader, string2 == null ? null : Util.getBytes(string2));
        if (System.internalGetProperties().getProperty("os.name").equals("Mac OS X") && byArray != null && string2 != null) {
            string3 = string2.replaceAll("/$", "") + "/lib" + string + ".jnilib";
            try {
                byte[] byArray2 = ClassLoader.loadLibraryWithPath(Util.getBytes(string3), classLoader, null);
                if (byArray2 == null) {
                    byArray = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (byArray != null) {
            try {
                string3 = Util.convertFromUTF8(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                string3 = Util.toString(byArray);
            }
            throw new UnsatisfiedLinkError(Msg.getString("K0649", (Object)string, string3));
        }
    }

    private static synchronized native byte[] loadLibraryWithPath(byte[] var0, ClassLoader var1, byte[] var2);

    static void loadLibrary(Class<?> clazz, String string, boolean bl) {
        if (bl) {
            ClassLoader.loadLibraryWithPath(string, clazz.getClassLoaderImpl(), null);
        } else {
            ClassLoader.loadLibraryWithClassLoader(string, clazz.getClassLoaderImpl());
        }
    }

    public void setClassAssertionStatus(String string, boolean bl) {
        this.setClassAssertionStatusImpl(string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClassAssertionStatusImpl(String string, boolean bl) {
        if (!this.isParallelCapable) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                this.setClassAssertionStatusHelper(string, bl);
            }
        }
        Object object = this.assertionLock;
        synchronized (object) {
            this.setClassAssertionStatusHelper(string, bl);
        }
    }

    private void setClassAssertionStatusHelper(String string, boolean bl) {
        if (this.classAssertionStatus == null) {
            this.classAssertionStatus = new HashMap<String, Boolean>();
        }
        this.classAssertionStatus.put(string, bl);
    }

    public void setPackageAssertionStatus(String string, boolean bl) {
        this.setPackageAssertionStatusImpl(string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPackageAssertionStatusImpl(String string, boolean bl) {
        if (!this.isParallelCapable) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                this.setPackageAssertionStatusHelper(string, bl);
            }
        }
        Object object = this.assertionLock;
        synchronized (object) {
            this.setPackageAssertionStatusHelper(string, bl);
        }
    }

    private void setPackageAssertionStatusHelper(String string, boolean bl) {
        if (this.packageAssertionStatus == null) {
            this.packageAssertionStatus = new HashMap<String, Boolean>();
        }
        this.packageAssertionStatus.put(string, bl);
    }

    public void setDefaultAssertionStatus(boolean bl) {
        this.setDefaultAssertionStatusImpl(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultAssertionStatusImpl(boolean bl) {
        if (!this.isParallelCapable) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                this.defaultAssertionStatus = bl;
            }
        }
        Object object = this.assertionLock;
        synchronized (object) {
            this.defaultAssertionStatus = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAssertionStatus() {
        if (!this.isParallelCapable) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                this.defaultAssertionStatus = false;
                this.classAssertionStatus = null;
                this.packageAssertionStatus = null;
            }
        }
        Object object = this.assertionLock;
        synchronized (object) {
            this.defaultAssertionStatus = false;
            this.classAssertionStatus = null;
            this.packageAssertionStatus = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getClassAssertionStatus(String string) {
        if (!this.isParallelCapable) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                return this.getClassAssertionStatusHelper(string);
            }
        }
        Object object = this.assertionLock;
        synchronized (object) {
            return this.getClassAssertionStatusHelper(string);
        }
    }

    private boolean getClassAssertionStatusHelper(String string) {
        int n = -1;
        if (this.classAssertionStatus != null) {
            Boolean bl = this.classAssertionStatus.get(string);
            if (bl != null) {
                return bl;
            }
            n = string.indexOf(36);
            if (n > 0 && (bl = this.classAssertionStatus.get(string.substring(0, n))) != null) {
                return bl;
            }
        }
        if ((n = string.lastIndexOf(46)) > 0) {
            return this.getPackageAssertionStatus(string.substring(0, n));
        }
        return this.getDefaultAssertionStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getPackageAssertionStatus(String string) {
        if (!this.isParallelCapable) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                return this.getPackageAssertionStatusHelper(string);
            }
        }
        Object object = this.assertionLock;
        synchronized (object) {
            return this.getPackageAssertionStatusHelper(string);
        }
    }

    private boolean getPackageAssertionStatusHelper(String string) {
        int n = -1;
        if (this.packageAssertionStatus != null) {
            Boolean bl = this.packageAssertionStatus.get(string);
            if (bl != null) {
                return bl;
            }
            n = string.lastIndexOf(46);
            if (n > 0) {
                return this.getPackageAssertionStatus(string.substring(0, n));
            }
        }
        return this.getDefaultAssertionStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getDefaultAssertionStatus() {
        if (!this.isParallelCapable) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                return this.defaultAssertionStatus;
            }
        }
        Object object = this.assertionLock;
        synchronized (object) {
            return this.defaultAssertionStatus;
        }
    }

    private void initializeClassLoaderAssertStatus() {
        boolean bl;
        boolean bl2 = bl = bootstrapClassLoader == null;
        if (!bl && !checkAssertionOptions) {
            return;
        }
        boolean bl3 = false;
        String[] stringArray = VM.getVMArgs();
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl4;
            String string;
            String string2;
            if (!stringArray[i].startsWith("-e") && !stringArray[i].startsWith("-d")) continue;
            int n = stringArray[i].indexOf(58);
            if (n == -1) {
                string2 = stringArray[i];
                string = null;
            } else {
                string2 = stringArray[i].substring(0, n);
                string = stringArray[i].substring(n + 1);
            }
            if (string2.compareTo("-ea") == 0 || string2.compareTo("-enableassertions") == 0 || string2.compareTo("-da") == 0 || string2.compareTo("-disableassertions") == 0) {
                bl3 = true;
                boolean bl5 = bl4 = string2.charAt(1) == 'e';
                if (string == null) {
                    if (bl) continue;
                    this.setDefaultAssertionStatusImpl(bl4);
                    continue;
                }
                String string3 = string;
                int n2 = string3.length();
                if (n2 > 3 && string3.charAt(n2 - 1) == '.' && string3.charAt(n2 - 2) == '.' && string3.charAt(n2 - 3) == '.') {
                    string3 = string3.substring(0, n2 - 3);
                    this.setPackageAssertionStatusImpl(string3, bl4);
                    continue;
                }
                this.setClassAssertionStatusImpl(string3, bl4);
                continue;
            }
            if (string2.compareTo("-esa") != 0 && string2.compareTo("-enablesystemassertions") != 0 && string2.compareTo("-dsa") != 0 && string2.compareTo("-disablesystemassertions") != 0 || !bl) continue;
            bl4 = string2.charAt(1) == 'e';
            this.setDefaultAssertionStatusImpl(bl4);
        }
        if (bl && bl3) {
            checkAssertionOptions = true;
        }
    }

    protected final Class<?> defineClass(String string, ByteBuffer byteBuffer, ProtectionDomain protectionDomain) throws ClassFormatError {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit() - n;
        if (byteBuffer.hasArray()) {
            return this.defineClass(string, byteBuffer.array(), n, n2, protectionDomain);
        }
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        return this.defineClass(string, byArray, 0, n2, protectionDomain);
    }

    private boolean compareCerts(Certificate[] certificateArray, Certificate[] certificateArray2) {
        if (certificateArray == null) {
            certificateArray = emptyCertificates;
        }
        if (certificateArray2 == null) {
            certificateArray2 = emptyCertificates;
        }
        if (certificateArray == certificateArray2) {
            return true;
        }
        if (certificateArray.length != certificateArray2.length) {
            return false;
        }
        boolean bl = true;
        block0: for (int i = 0; i < certificateArray.length; ++i) {
            if (certificateArray[i] == certificateArray2[i] || certificateArray[i].equals(certificateArray2[i])) continue;
            for (int j = 0; j < certificateArray2.length; ++j) {
                if (j != i && (certificateArray[i] == certificateArray2[j] || certificateArray[i].equals(certificateArray2[j]))) continue block0;
            }
            bl = false;
            break;
        }
        return bl;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    Map<String, MethodType> getMethodTypeCache() {
        if (null == this.methodTypeFromMethodDescriptorStringCache) {
            this.methodTypeFromMethodDescriptorStringCache = new ConcurrentHashMap<String, MethodType>(16, 0.75f, 8);
        }
        return this.methodTypeFromMethodDescriptorStringCache;
    }

    static {
        isAssertOptionFound = ClassLoader.foundJavaAssertOption();
        emptyCertificates = new Certificate[0];
        EMPTY_PACKAGE_ARRAY = new Package[0];
        lazyClassLoaderInit = false;
        specialLoaderInited = false;
    }

    private static final class CompoundEnumeration<T>
    implements Enumeration<T> {
        private final Queue<Enumeration<T>> queue;

        CompoundEnumeration(Enumeration<T> enumeration, Enumeration<T> enumeration2) {
            if (enumeration instanceof CompoundEnumeration) {
                this.queue = ((CompoundEnumeration)enumeration).queue;
            } else {
                this.queue = new LinkedList<Enumeration<T>>();
                this.queue.add(enumeration);
            }
            this.queue.add(enumeration2);
        }

        void append(Enumeration<T> enumeration) {
            this.queue.add(enumeration);
        }

        @Override
        public boolean hasMoreElements() {
            Enumeration<T> enumeration;
            while ((enumeration = this.queue.peek()) != null) {
                if (enumeration.hasMoreElements()) {
                    return true;
                }
                this.queue.remove();
            }
            return false;
        }

        @Override
        public T nextElement() {
            while (true) {
                Enumeration<T> enumeration;
                if ((enumeration = this.queue.peek()) == null) {
                    throw new NoSuchElementException();
                }
                if (enumeration.hasMoreElements()) {
                    return enumeration.nextElement();
                }
                this.queue.remove();
            }
        }
    }

    static final class ClassNameLockRef
    extends WeakReference<Object>
    implements Runnable {
        private static final ReferenceQueue<Object> queue = new ReferenceQueue();
        private final String key;
        private final Hashtable<?, ?> classNameLockHT;

        public ClassNameLockRef(Object object, String string, Hashtable<?, ?> hashtable) {
            super(object, queue);
            this.key = string;
            this.classNameLockHT = hashtable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Hashtable<?, ?> hashtable = this.classNameLockHT;
            synchronized (hashtable) {
                if (this.classNameLockHT.get(this.key) == this) {
                    this.classNameLockHT.remove(this.key);
                }
            }
        }
    }

    private static final class ClassNameBasedLock {
        ClassNameBasedLock() {
        }
    }

    private static final class LazyInitLock {
        LazyInitLock() {
        }
    }

    private static final class AssertionLock {
        AssertionLock() {
        }
    }
}

