/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class CommonPatternMatchers {
    public static final Matcher whitespace;
    public static final Matcher allButLineFeed;
    public static final Matcher allButControlChars;
    public static final Matcher quoted_stringvalue;
    public static final Matcher alpha_numeric_underscore_ascii_attribute;
    public static final Matcher non_whitespace_attribute;
    public static final Matcher hex_0x;
    public static final Matcher signed_hex_0x;
    public static final Matcher hex;
    public static final Matcher lettervalue;
    public static final Matcher dec;
    public static final Matcher quotation;
    public static final Matcher colon;
    public static final Matcher equals;
    public static final Matcher comma;
    public static final Matcher at_symbol;
    public static final Matcher dot;
    public static final Matcher forward_slash;
    public static final Matcher dash;
    public static final Matcher open_paren;
    public static final Matcher close_paren;
    private static final String pattern_java_name;
    private static final String pattern_sov_java_absolute_name;
    private static final String pattern_java_absolute_name;
    private static final String pattern_java_method_name;
    private static final String pattern_sov_java_absolute_method_name;
    private static final String pattern_java_absolute_method_name;
    public static final Matcher java_name;
    public static final Matcher java_absolute_name;
    public static final Matcher java_absolute_method_name;
    public static final Matcher java_absolute_name_array;
    public static final Matcher java_sov_absolute_method_name;
    public static final Matcher java_file_name;
    public static final Matcher[] hexadecimal;
    public static final Matcher at_string;
    public static final Matcher build_string;
    public static final Matcher enabled_string;
    public static final Matcher disabled_string;
    public static final Matcher bits64;
    public static final Matcher s390;

    public static Matcher generateMatcher(String string) {
        return Pattern.compile(string).matcher("");
    }

    public static Matcher generateMatcher(String string, int n) {
        return Pattern.compile(string, n).matcher("");
    }

    static {
        String string;
        whitespace = CommonPatternMatchers.generateMatcher("\\s+");
        allButLineFeed = CommonPatternMatchers.generateMatcher("[^\\n\\r]*");
        allButControlChars = CommonPatternMatchers.generateMatcher("\\P{Cntrl}+");
        quoted_stringvalue = CommonPatternMatchers.generateMatcher("\"[^\\n\\r]*\"");
        alpha_numeric_underscore_ascii_attribute = CommonPatternMatchers.generateMatcher("[a-zA-Z_][a-zA-Z0-9_]*");
        non_whitespace_attribute = CommonPatternMatchers.generateMatcher("\\S+");
        hex_0x = CommonPatternMatchers.generateMatcher("0x\\p{XDigit}+");
        signed_hex_0x = CommonPatternMatchers.generateMatcher("-?0x\\p{XDigit}+");
        hex = CommonPatternMatchers.generateMatcher("\\p{XDigit}+");
        lettervalue = CommonPatternMatchers.generateMatcher("\\w+");
        dec = CommonPatternMatchers.generateMatcher("\\d+");
        quotation = CommonPatternMatchers.generateMatcher("\"");
        colon = CommonPatternMatchers.generateMatcher(":");
        equals = CommonPatternMatchers.generateMatcher("=");
        comma = CommonPatternMatchers.generateMatcher(",");
        at_symbol = CommonPatternMatchers.generateMatcher("@");
        dot = CommonPatternMatchers.generateMatcher("\\.");
        forward_slash = CommonPatternMatchers.generateMatcher("/");
        dash = CommonPatternMatchers.generateMatcher("-");
        open_paren = CommonPatternMatchers.generateMatcher("\\(");
        close_paren = CommonPatternMatchers.generateMatcher("\\)");
        try {
            string = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
            Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            string = "[a-zA-Z_$][a-zA-Z_$0-9]*";
        }
        pattern_java_name = string;
        pattern_sov_java_absolute_name = pattern_java_name + "(\\." + pattern_java_name + ")*";
        pattern_java_absolute_name = pattern_java_name + "(/" + pattern_java_name + ")*";
        pattern_java_method_name = "\\<?" + pattern_java_name + "\\>?";
        pattern_sov_java_absolute_method_name = pattern_sov_java_absolute_name + "\\." + pattern_java_method_name;
        pattern_java_absolute_method_name = pattern_java_absolute_name + "\\." + pattern_java_method_name;
        java_name = CommonPatternMatchers.generateMatcher(pattern_java_name);
        java_absolute_name = CommonPatternMatchers.generateMatcher(pattern_java_absolute_name);
        java_absolute_method_name = CommonPatternMatchers.generateMatcher(pattern_java_absolute_method_name);
        java_absolute_name_array = CommonPatternMatchers.generateMatcher("[\\[]*" + pattern_java_absolute_name + ";?");
        java_sov_absolute_method_name = CommonPatternMatchers.generateMatcher(pattern_sov_java_absolute_method_name);
        java_file_name = CommonPatternMatchers.generateMatcher(pattern_java_absolute_name + "\\.java");
        hexadecimal = new Matcher[]{hex_0x, hex};
        at_string = CommonPatternMatchers.generateMatcher("at", 2);
        build_string = CommonPatternMatchers.generateMatcher("build", 2);
        enabled_string = CommonPatternMatchers.generateMatcher("enabled", 2);
        disabled_string = CommonPatternMatchers.generateMatcher("disabled", 2);
        bits64 = CommonPatternMatchers.generateMatcher("64");
        s390 = CommonPatternMatchers.generateMatcher("s390", 2);
    }
}

