/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Vector;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.serial.SerialException;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public class SerialJavaObject
implements Serializable,
Cloneable {
    private Object obj;
    private transient Field[] fields;
    static final long serialVersionUID = -1465795139032831023L;
    Vector<RowSetWarning> chain;

    public SerialJavaObject(Object object) throws SerialException {
        Class<? extends Object> clazz = object.getClass();
        if (!(object instanceof Serializable)) {
            this.setWarning(new RowSetWarning("Warning, the object passed to the constructor does not implement Serializable"));
        }
        this.fields = clazz.getFields();
        if (SerialJavaObject.hasStaticFields(this.fields)) {
            throw new SerialException("Located static fields in object instance. Cannot serialize");
        }
        this.obj = object;
    }

    public Object getObject() throws SerialException {
        return this.obj;
    }

    @CallerSensitive
    public Field[] getFields() throws SerialException {
        if (this.fields != null) {
            Class<?> clazz;
            Class<? extends Object> clazz2 = this.obj.getClass();
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && ReflectUtil.needsPackageAccessCheck((clazz = Reflection.getCallerClass()).getClassLoader(), clazz2.getClassLoader())) {
                ReflectUtil.checkPackageAccess(clazz2);
            }
            return clazz2.getFields();
        }
        throw new SerialException("SerialJavaObject does not contain a serialized object instance");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SerialJavaObject) {
            SerialJavaObject serialJavaObject = (SerialJavaObject)object;
            return this.obj.equals(serialJavaObject.obj);
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.obj.hashCode();
    }

    public Object clone() {
        try {
            SerialJavaObject serialJavaObject = (SerialJavaObject)super.clone();
            serialJavaObject.fields = Arrays.copyOf(this.fields, this.fields.length);
            if (this.chain != null) {
                serialJavaObject.chain = new Vector<RowSetWarning>(this.chain);
            }
            return serialJavaObject;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private void setWarning(RowSetWarning rowSetWarning) {
        if (this.chain == null) {
            this.chain = new Vector();
        }
        this.chain.add(rowSetWarning);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Vector vector = (Vector)getField.get("chain", null);
        if (vector != null) {
            this.chain = new Vector(vector);
        }
        this.obj = getField.get("obj", null);
        if (this.obj != null) {
            this.fields = this.obj.getClass().getFields();
            if (SerialJavaObject.hasStaticFields(this.fields)) {
                throw new IOException("Located static fields in object instance. Cannot serialize");
            }
        } else {
            throw new IOException("Object cannot be null!");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("obj", this.obj);
        putField.put("chain", this.chain);
        objectOutputStream.writeFields();
    }

    private static boolean hasStaticFields(Field[] fieldArray) {
        for (Field field : fieldArray) {
            if (field.getModifiers() != 8) continue;
            return true;
        }
        return false;
    }
}

