/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.java.javacore.JCJavaClass;
import com.ibm.dtfj.java.javacore.JCJavaObject;
import com.ibm.dtfj.java.javacore.JCJavaRuntime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;

public class JCJavaClassLoader
implements JavaClassLoader {
    private final ImagePointer fID;
    private LinkedHashMap fClassNames;
    private JCJavaRuntime fRuntime;
    private JCJavaObject fObject;

    public JCJavaClassLoader(JCJavaRuntime jCJavaRuntime, long l) throws JCInvalidArgumentsException {
        if (jCJavaRuntime == null) {
            throw new JCInvalidArgumentsException("Must pass a valid runtime.");
        }
        if (!jCJavaRuntime.getImageProcess().getImageAddressSpace().isValidAddressID(l)) {
            throw new JCInvalidArgumentsException("Must pass a valid class loader id");
        }
        this.fRuntime = jCJavaRuntime;
        this.fID = this.fRuntime.getImageProcess().getImageAddressSpace().getPointer(l);
        this.fClassNames = new LinkedHashMap();
        this.fObject = null;
        this.fRuntime.addJavaClassLoader(this);
    }

    @Override
    public JavaClass findClass(String string) {
        JCJavaClass jCJavaClass = null;
        if (this.fClassNames.containsKey(string)) {
            ImagePointer imagePointer = (ImagePointer)this.fClassNames.get(string);
            if (imagePointer != null) {
                long l = imagePointer.getAddress();
                jCJavaClass = this.fRuntime.findJavaClass(l);
            } else {
                jCJavaClass = this.fRuntime.findJavaClass(string);
            }
        }
        return jCJavaClass;
    }

    @Override
    public Iterator getCachedClasses() {
        return this.getClasses();
    }

    @Override
    public Iterator getDefinedClasses() {
        return this.getClasses();
    }

    private Iterator getClasses() {
        Vector<JavaClass> vector = new Vector<JavaClass>();
        for (Object k : this.fClassNames.keySet()) {
            vector.add(this.findClass((String)k));
        }
        return vector.iterator();
    }

    @Override
    public JavaObject getObject() throws CorruptDataException {
        return this.fObject;
    }

    public void setObject(JCJavaObject jCJavaObject) {
        this.fObject = jCJavaObject;
    }

    public JCJavaClass internalGetClass(String string) {
        return (JCJavaClass)this.findClass(string);
    }

    public JCJavaObject getInternalObject() {
        return this.fObject;
    }

    public void addClass(String string) {
        if (string != null && !this.fClassNames.containsKey(string)) {
            this.fClassNames.put(string, null);
        }
    }

    public void addClass(String string, ImagePointer imagePointer) {
        this.fClassNames.put(string, imagePointer);
    }

    public ImagePointer getPointerID() {
        return this.fID;
    }
}

