/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageFactory;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.utils.file.FileManager;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.jvm.dtfjview.CombinedContext;
import com.ibm.jvm.dtfjview.JdmpviewContextManager;
import com.ibm.jvm.dtfjview.Version;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.spi.ISession;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpenCommand
extends BaseJdmpviewCommand {
    private static final String CMD_NAME = "open";
    private static final String defaultFactoryName = "com.ibm.dtfj.image.j9.ImageFactory";
    private String factoryName = System.getProperty("com.ibm.dtfj.image.factoryclass", "com.ibm.dtfj.image.j9.ImageFactory");
    private int apiLevelMajor = 0;
    private int apiLevelMinor = 0;
    private ImageFactory factory;

    public OpenCommand() {
        this.addCommand(CMD_NAME, "[path to core or zip]", "opens the specified core or zip file");
        this.factory = this.getFactory();
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        switch (stringArray.length) {
            case 0: {
                printStream.println(Version.getAllVersionInfo(this.factory));
                return;
            }
            case 1: 
            case 2: {
                this.imagesFromCommandLine(stringArray);
                break;
            }
            default: {
                printStream.println("The open command requires at least one and at most two parameters. See 'help open'.");
                return;
            }
        }
    }

    private void imagesFromCommandLine(String[] stringArray) {
        block8: {
            this.apiLevelMajor = this.factory.getDTFJMajorVersion();
            this.apiLevelMinor = this.factory.getDTFJMinorVersion();
            this.out.println(Version.getAllVersionInfo(this.factory));
            this.out.println("Loading image from DTFJ...\n");
            try {
                if (this.ctx.hasPropertyBeenSet("verbose.mode")) {
                    Logger.getLogger("j9ddr.view.dtfj").setLevel(Level.WARNING);
                }
                long l = System.nanoTime();
                File file = new File(stringArray[0]);
                Image[] imageArray = new Image[1];
                if (stringArray.length == 1) {
                    if (FileManager.isArchive((File)file) && !this.ctx.hasPropertyBeenSet("zip.mode.legacy")) {
                        imageArray = this.factory.getImagesFromArchive(file, this.ctx.hasPropertyBeenSet("extract.mode"));
                    } else {
                        imageArray[0] = this.factory.getImage(file);
                    }
                } else {
                    File file2 = new File(stringArray[1]);
                    imageArray[0] = this.factory.getImage(file, file2);
                }
                long l2 = System.nanoTime() - l;
                this.logger.fine(String.format("Time taken to load image %d ns", l2));
                for (Image image : imageArray) {
                    this.createContexts(image, stringArray[0]);
                }
            }
            catch (IOException iOException) {
                this.out.println("Could not load dump file and/or could not load XML file: " + iOException.getMessage());
                if (!this.ctx.hasPropertyBeenSet("verbose.mode")) break block8;
                iOException.printStackTrace();
            }
        }
    }

    private ImageFactory getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        try {
            Class<?> clazz = Class.forName(this.factoryName);
            this.factory = (ImageFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.out.println("ClassNotFoundException while getting ImageFactory: " + classNotFoundException.getMessage());
            this.out.println("Use -Dcom.ibm.dtfj.image.factoryclass=<classname> to change the ImageFactory");
            System.exit(1);
        }
        catch (ClassCastException classCastException) {
            this.out.println("ClassCastException while getting ImageFactory: " + classCastException.getMessage());
            System.exit(1);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.out.println("IllegalAccessException while getting ImageFactory: " + illegalAccessException.getMessage());
            System.exit(1);
        }
        catch (InstantiationException instantiationException) {
            this.out.println("InstantiationException while getting ImageFactory: " + instantiationException.getMessage());
            System.exit(1);
        }
        return this.factory;
    }

    private void createContexts(Image image, String string) {
        Object object;
        Object object2;
        if (image == null) {
            return;
        }
        boolean bl = false;
        Iterator iterator = image.getAddressSpaces();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (!(object2 instanceof ImageAddressSpace)) {
                this.logger.fine("Skipping corrupt ImageAddress space");
                continue;
            }
            object = (ImageAddressSpace)object2;
            Iterator iterator2 = object.getProcesses();
            if (!iterator2.hasNext()) {
                this.createCombinedContext(image, this.apiLevelMajor, this.apiLevelMinor, (ImageAddressSpace)object, null, null, string);
                bl = true;
                continue;
            }
            while (iterator2.hasNext()) {
                object2 = iterator2.next();
                if (!(object2 instanceof ImageProcess)) continue;
                ImageProcess imageProcess = (ImageProcess)object2;
                Iterator iterator3 = imageProcess.getRuntimes();
                if (!iterator3.hasNext()) {
                    this.createCombinedContext(image, this.apiLevelMajor, this.apiLevelMinor, (ImageAddressSpace)object, imageProcess, null, string);
                    bl = true;
                    continue;
                }
                while (iterator3.hasNext()) {
                    object2 = iterator3.next();
                    if (object2 instanceof JavaRuntime) {
                        this.createCombinedContext(image, this.apiLevelMajor, this.apiLevelMinor, (ImageAddressSpace)object, imageProcess, (JavaRuntime)object2, string);
                        bl = true;
                        continue;
                    }
                    if (object2 instanceof CorruptData) {
                        this.logger.fine("CorruptData encountered in ImageProcess.getRuntimes(): " + object2);
                        this.createCombinedContext(image, this.apiLevelMajor, this.apiLevelMinor, (ImageAddressSpace)object, imageProcess, null, string);
                        bl = true;
                        continue;
                    }
                    this.logger.fine("Unexpected class encountered in ImageProcess.getRuntimes()");
                    this.createCombinedContext(image, this.apiLevelMajor, this.apiLevelMinor, (ImageAddressSpace)object, imageProcess, null, string);
                    bl = true;
                }
            }
        }
        if (!bl) {
            if (this.ctx.hasPropertyBeenSet("verbose.mode")) {
                this.out.println("Warning: no contexts were found, is this a valid core file?");
            }
        } else if (image.isTruncated()) {
            this.out.println("Warning: dump file is truncated. Extracted information may be incomplete.");
            this.out.println();
        } else {
            object2 = System.getProperty("java.vm.name");
            object = this.ctx.getProperties().getProperty("java.vm.name");
            if (object2 == null || object == null || !((String)object2).equals(object)) {
                this.out.format("Warning: dump file was produced by a different, possibly incompatible, VM.%n  core file: %s%n  this VM:   %s%n%n", object == null ? "(unknown)" : object, object2 == null ? "(unknown)" : object2);
            }
        }
    }

    private void createCombinedContext(Image image, int n, int n2, ImageAddressSpace imageAddressSpace, ImageProcess imageProcess, JavaRuntime javaRuntime, String string) {
        Object object = this.ctx.getProperties().get("session");
        if (object == null) {
            this.logger.fine("Could not create a new context as the session property has not been set");
            return;
        }
        if (!(object instanceof ISession)) {
            this.logger.fine("Could not create a new context as the session type was not recognised [" + object.getClass().getName() + "]");
            return;
        }
        JdmpviewContextManager jdmpviewContextManager = (JdmpviewContextManager)((ISession)object).getContextManager();
        CombinedContext combinedContext = (CombinedContext)jdmpviewContextManager.createContext(image, n, n2, imageAddressSpace, imageProcess, javaRuntime);
        combinedContext.startDDRInteractiveSession(image, this.out);
        combinedContext.getProperties().put("core_file_path", string);
        combinedContext.getProperties().put("image.factory", this.getFactory());
        if (this.ctx.hasPropertyBeenSet("verbose.mode")) {
            combinedContext.getProperties().put("verbose.mode", "true");
        }
        if (javaRuntime != null && combinedContext.isDDRAvailable()) {
            try {
                String string2 = javaRuntime.getSystemProperty("java.vm.name");
                if (string2 != null) {
                    this.ctx.getProperties().put("java.vm.name", string2);
                }
            }
            catch (CorruptDataException | DataUnavailable throwable) {
                // empty catch block
            }
        }
        try {
            boolean bl = true;
            String string3 = combinedContext.getImage().getSystemType().toLowerCase();
            if (string3.contains("linux") || string3.contains("aix")) {
                Iterator iterator;
                if (combinedContext.getProcess() != null && (iterator = combinedContext.getProcess().getLibraries()).hasNext() && (object = iterator.next()) instanceof ImageModule) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl) {
                this.out.println("Warning: native libraries are not available for " + string);
            }
        }
        catch (DataUnavailable dataUnavailable) {
            this.logger.log(Level.FINE, "Warning: native libraries are not available for " + string);
        }
        catch (Exception exception) {
            this.logger.log(Level.FINE, "Error determining if native libraries are required for " + string, exception);
        }
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("Opens a core file or zip file and loads it into jdmpview ready for further analysis.");
        printStream.println("Any resultant contexts are added to the list of currently available contexts.");
    }
}

