/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoLockCommand
extends BaseJdmpviewCommand {
    public InfoLockCommand() {
        this.addCommand("info lock", "", "outputs a list of system monitors and locked objects");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        if (stringArray.length != 0) {
            printStream.println("\"info lock\" command does not take any parameters");
            return;
        }
        this.showSystemLocks();
        this.showJavaUtilConcurrentLocks();
    }

    private void showSystemLocks() {
        Vector<JavaMonitor> vector = new Vector<JavaMonitor>();
        JavaRuntime javaRuntime = this.ctx.getRuntime();
        Iterator iterator = javaRuntime.getMonitors();
        this.out.println("\nSystem locks...");
        while (iterator.hasNext()) {
            JavaMonitor javaMonitor = (JavaMonitor)iterator.next();
            JavaObject javaObject = javaMonitor.getObject();
            try {
                String string = javaMonitor.getName().trim();
                if (string.equalsIgnoreCase("")) {
                    string = "<un-named monitor>";
                }
                this.out.println("id: 0x" + javaMonitor.getID() + " name: " + javaMonitor.getName());
                JavaThread javaThread = javaMonitor.getOwner();
                if (null != javaThread) {
                    try {
                        this.out.println("\towner thread id: " + javaThread.getImageThread().getID() + " name: " + javaThread.getName());
                    }
                    catch (DataUnavailable dataUnavailable) {
                        this.out.println("\towner thread id: " + Exceptions.getDataUnavailableString());
                        this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), dataUnavailable);
                    }
                }
                this.showWaiters(javaMonitor);
            }
            catch (CorruptDataException corruptDataException) {
                this.out.println("\nwarning, corrupt data encountered during scan for system locks...");
            }
            if (null == javaObject) continue;
            vector.add(javaMonitor);
        }
        this.showLockedObjects(vector);
    }

    private void showWaiters(JavaMonitor javaMonitor) throws CorruptDataException {
        Object object;
        Object object2;
        Iterator iterator = javaMonitor.getEnterWaiters();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (!(object2 instanceof JavaThread)) continue;
            object = (JavaThread)object2;
            try {
                this.out.println("\twaiting thread id: " + object.getImageThread().getID() + " name: " + object.getName());
            }
            catch (DataUnavailable dataUnavailable) {
                this.out.println("\twaiting thread id: <unknown>");
                this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), dataUnavailable);
            }
        }
        object2 = javaMonitor.getNotifyWaiters();
        while (object2.hasNext()) {
            object = object2.next();
            if (!(object instanceof JavaThread)) continue;
            Object object3 = object;
            try {
                this.out.println("\twaiting thread id: " + object3.getImageThread().getID() + " name: " + object3.getName());
            }
            catch (DataUnavailable dataUnavailable) {
                this.out.println("\twaiting thread id: <unknown>");
                this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), dataUnavailable);
            }
        }
    }

    private void showLockedObjects(Vector<JavaMonitor> vector) {
        this.out.println("\nObject Locks in use...");
        if (0 == vector.size()) {
            this.out.println("\t...None.");
            return;
        }
        for (JavaMonitor javaMonitor : vector) {
            JavaObject javaObject = javaMonitor.getObject();
            try {
                JavaThread javaThread = javaMonitor.getOwner();
                String string = "<unknown class>";
                JavaClass javaClass = javaObject.getJavaClass();
                if (null != javaClass) {
                    string = javaClass.getName();
                }
                String string2 = Long.toHexString(javaObject.getID().getAddress());
                if (null == javaThread) {
                    this.out.println(string + "@0x" + string2);
                } else {
                    String string3 = null;
                    try {
                        string3 = javaThread.getImageThread().getID();
                    }
                    catch (DataUnavailable dataUnavailable) {
                        string3 = Exceptions.getDataUnavailableString();
                    }
                    this.out.println(string + "@0x" + string2);
                    this.out.println("\towner thread id: " + string3 + " name: " + javaThread.getName());
                }
                this.showWaiters(javaMonitor);
            }
            catch (CorruptDataException corruptDataException) {
                this.logger.log(Level.FINE, Exceptions.getCorruptDataExceptionString(), corruptDataException);
            }
        }
    }

    private void showJavaUtilConcurrentLocks() {
        LinkedList<JavaThread> linkedList;
        JavaObject memoryAccessException;
        HashMap<JavaObject, LinkedList<JavaThread>> hashMap = new HashMap<JavaObject, LinkedList<JavaThread>>();
        JavaRuntime javaRuntime = this.ctx.getRuntime();
        Iterator iterator = javaRuntime.getThreads();
        while (iterator.hasNext()) {
            try {
                JavaThread object;
                Object object2 = iterator.next();
                if (!(object2 instanceof JavaThread) || ((object = (JavaThread)object2).getState() & 0x200) == 0 || (memoryAccessException = object.getBlockingObject()) == null) continue;
                linkedList = (LinkedList<JavaThread>)hashMap.get(memoryAccessException);
                if (linkedList == null) {
                    linkedList = new LinkedList<JavaThread>();
                    hashMap.put(memoryAccessException, linkedList);
                }
                linkedList.add(object);
            }
            catch (CorruptDataException corruptDataException) {
                this.out.println("\nwarning, corrupt data encountered during scan for java.util.concurrent locks...");
                this.logger.log(Level.FINE, Exceptions.getCorruptDataExceptionString(), corruptDataException);
            }
            catch (DataUnavailable dataUnavailable) {
                this.out.println("\nwarning, data unavailable encountered during scan for java.util.concurrent locks...");
                this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), dataUnavailable);
            }
        }
        this.out.println("\njava.util.concurrent locks in use...");
        if (hashMap.size() == 0) {
            this.out.println("\t...None.");
            this.out.println();
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            try {
                Object object;
                memoryAccessException = (JavaObject)entry.getKey();
                linkedList = (List)entry.getValue();
                String string = "<unowned>";
                JavaThread javaThread = Utils.getParkBlockerOwner(memoryAccessException, this.ctx.getRuntime());
                string = javaThread != null ? javaThread.getName() : ((object = Utils.getParkBlockerOwnerObject(memoryAccessException, this.ctx.getRuntime())) != null ? Utils.getThreadNameFromObject(object, this.ctx.getRuntime(), this.out) : "<unknown>");
                if (linkedList == null || linkedList.size() <= 0) continue;
                object = Long.toHexString(memoryAccessException.getID().getAddress());
                ImageThread imageThread = javaThread != null ? javaThread.getImageThread() : null;
                this.out.println(memoryAccessException.getJavaClass().getName() + "@0x" + (String)object + "\n\tlocked by java thread id: " + (imageThread != null ? imageThread.getID() : "<null>") + " name: " + string);
                for (Object e : linkedList) {
                    JavaThread javaThread2 = (JavaThread)e;
                    this.out.println("\twaiting thread id: " + javaThread2.getImageThread().getID() + " name: " + javaThread2.getName());
                }
            }
            catch (CorruptDataException dataUnavailable) {
                this.out.println("\nwarning, corrupt data encountered during scan for java.util.concurrent locks...");
                this.logger.log(Level.FINE, Exceptions.getCorruptDataExceptionString(), dataUnavailable);
            }
            catch (MemoryAccessException memoryAccessException2) {
                this.out.println("\nwarning, memory access error encountered during scan for java.util.concurrent locks...");
                this.logger.log(Level.FINE, Exceptions.getMemoryAccessExceptionString(), memoryAccessException2);
            }
            catch (DataUnavailable dataUnavailable) {
                this.out.println("\nwarning, data unavailable encountered during scan for java.util.concurrent locks...");
                this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), dataUnavailable);
            }
        }
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("outputs a list of system monitors and locked objects\n\nparameters: none\n\nThe info lock command outputs a list of system monitors and locked objects.");
    }
}

