/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.VMConstantPool;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassLoaderHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9VmconstantpoolConstants;
import java.util.Iterator;

public class JavaLangClassLoaderHelper {
    private static J9ObjectFieldOffset vmRefOffset;
    private static J9ObjectFieldOffset parentOffset;

    public static J9ObjectPointer getParent(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        if (j9ObjectPointer.isNull()) {
            return J9ObjectPointer.NULL;
        }
        if (parentOffset == null) {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9ClassPointer j9ClassPointer = J9ClassLoaderHelper.findClass(j9JavaVMPointer.systemClassLoader(), "Ljava/lang/ClassLoader;");
            Iterator<J9ObjectFieldOffset> iterator = J9ClassHelper.getFieldOffsets(j9ClassPointer);
            while (iterator.hasNext()) {
                J9ObjectFieldOffset j9ObjectFieldOffset;
                J9ObjectFieldOffset j9ObjectFieldOffset2 = iterator.next();
                if (!(j9ObjectFieldOffset2 instanceof J9ObjectFieldOffset) || !"parent".equals((j9ObjectFieldOffset = j9ObjectFieldOffset2).getName())) continue;
                parentOffset = j9ObjectFieldOffset;
                break;
            }
        }
        if (parentOffset != null) {
            return J9ObjectHelper.getObjectField(j9ObjectPointer, parentOffset);
        }
        throw new CorruptDataException("Unable to find field offset for the 'parent' field");
    }

    public static J9ClassLoaderPointer getClassLoader(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        if (j9ObjectPointer.isNull()) {
            return J9ClassLoaderPointer.NULL;
        }
        if (vmRefOffset == null) {
            vmRefOffset = VMConstantPool.getFieldOffset(J9VmconstantpoolConstants.J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_VMREF);
        }
        if (vmRefOffset != null) {
            long l = J9ObjectHelper.getLongField(j9ObjectPointer, vmRefOffset);
            return J9ClassLoaderPointer.cast(l);
        }
        throw new CorruptDataException("Unable to find field offset for the 'vmRef' field");
    }
}

