/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U64Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMStringRefPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.structure.J9ConstantPool;
import com.ibm.j9ddr.vm29.structure.J9ROMConstantPoolItem;
import java.io.PrintStream;

public class VMConstantPoolCommand
extends Command {
    static final String nl = System.getProperty("line.separator");

    public VMConstantPoolCommand() {
        this.addCommand("vmconstantpool", "[j9javavmAddress]", "Dump the jclconstantpool entries starting at the top and continuing through the end");
    }

    private void printUsage(PrintStream printStream) {
        printStream.println("vmconstantpool [j9javavmAddress] - Dump the jclconstantpool entries starting at the top and continuing through the end");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (stringArray.length == 1) {
                long l = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.J9VM_ENV_DATA64);
                if (l != j9JavaVMPointer.getAddress()) {
                    printStream.println(stringArray[0] + " is not a valid j9javavm address. Run !findvm to find out the j9javavm address of the current context");
                    return;
                }
            } else if (stringArray.length > 1) {
                this.printUsage(printStream);
            }
            J9ConstantPoolPointer j9ConstantPoolPointer = J9ConstantPoolPointer.cast(j9JavaVMPointer.jclConstantPoolEA());
            J9ROMClassPointer j9ROMClassPointer = j9ConstantPoolPointer.ramClass().romClass();
            U32Pointer u32Pointer = J9ROMClassHelper.cpShapeDescription(j9ROMClassPointer);
            long l = u32Pointer.at(0L).longValue();
            int n = j9ROMClassPointer.romConstantPoolCount().intValue();
            PointerPointer pointerPointer = PointerPointer.cast(J9ROMClassHelper.constantPool(j9ROMClassPointer));
            long l2 = 0L;
            for (int i = 0; i < n; ++i) {
                if (0L == l2) {
                    l = u32Pointer.at(0L).longValue();
                    u32Pointer = u32Pointer.add(1L);
                    l2 = J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32;
                }
                long l3 = l & J9ConstantPool.J9_CP_DESCRIPTION_MASK;
                AbstractPointer abstractPointer = PointerPointer.NULL;
                if (l3 == J9ConstantPool.J9CPTYPE_CLASS) {
                    abstractPointer = J9ROMClassRefPointer.cast(pointerPointer);
                } else if (l3 == J9ConstantPool.J9CPTYPE_STRING) {
                    abstractPointer = J9ROMStringRefPointer.cast(pointerPointer);
                } else if (l3 == J9ConstantPool.J9CPTYPE_INT || l3 == J9ConstantPool.J9CPTYPE_FLOAT) {
                    abstractPointer = J9ROMConstantPoolItemPointer.cast(pointerPointer);
                } else if (l3 == J9ConstantPool.J9CPTYPE_LONG) {
                    U64Pointer u64Pointer = U64Pointer.cast(pointerPointer);
                    printStream.println("Long at " + u64Pointer.getHexAddress() + " {\n\t0x0: U64:" + u64Pointer.getHexValue() + "\n}");
                } else if (l3 == J9ConstantPool.J9CPTYPE_DOUBLE) {
                    U64Pointer u64Pointer = U64Pointer.cast(pointerPointer);
                    printStream.println("Double at " + u64Pointer.getHexAddress() + " {\n\t0x0: U64:" + u64Pointer.at(0L).longValue() + "\n}");
                } else if (l3 == J9ConstantPool.J9CPTYPE_INSTANCE_METHOD || l3 == J9ConstantPool.J9CPTYPE_STATIC_METHOD || l3 == J9ConstantPool.J9CPTYPE_INTERFACE_METHOD || l3 == J9ConstantPool.J9CPTYPE_HANDLE_METHOD || l3 == J9ConstantPool.J9CPTYPE_FIELD) {
                    long l4;
                    if (l3 == J9ConstantPool.J9CPTYPE_FIELD) {
                        abstractPointer = J9ROMFieldRefPointer.cast(pointerPointer);
                        l4 = J9ROMFieldRefPointer.cast(abstractPointer).classRefCPIndex().longValue();
                    } else {
                        abstractPointer = J9ROMFieldRefPointer.cast(pointerPointer);
                        l4 = J9ROMMethodRefPointer.cast(abstractPointer).classRefCPIndex().longValue();
                    }
                    PointerPointer pointerPointer2 = PointerPointer.cast(J9ROMClassHelper.constantPool(j9ROMClassPointer)).addOffset(J9ROMConstantPoolItem.SIZEOF * l4);
                    String string2 = abstractPointer.formatFullInteractive();
                    String[] stringArray2 = string2.split(nl);
                    stringArray2[1] = stringArray2[1] + "(!j9romclassref " + pointerPointer2.getHexAddress() + ")";
                    printStream.print(VMConstantPoolCommand.join(nl, stringArray2));
                } else if (l3 == J9ConstantPool.J9CPTYPE_UNUSED || l3 == J9ConstantPool.J9CPTYPE_UNUSED8) {
                    U64Pointer u64Pointer = U64Pointer.cast(pointerPointer);
                    printStream.println("Unused at " + u64Pointer.getHexAddress() + " {\n\t0x0: U64:" + u64Pointer.at(0L).longValue() + "\n}");
                } else if (abstractPointer.notNull()) {
                    printStream.println(abstractPointer.formatFullInteractive());
                }
                pointerPointer = pointerPointer.addOffset(J9ROMConstantPoolItem.SIZEOF);
                l >>= (int)J9ConstantPool.J9_CP_BITS_PER_DESCRIPTION;
                --l2;
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private static String join(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : stringArray) {
            stringBuffer.append(string2).append(string);
        }
        return stringBuffer.toString();
    }
}

