/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.addressspace;

import com.ibm.dtfj.addressspace.CommonAddressSpace;
import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public class LayeredAddressSpace
extends CommonAddressSpace {
    private TreeMap _moduleRanges = new TreeMap();
    private IAbstractAddressSpace _base;
    private MemoryRange[] _moduleRangesArray = null;
    private Integer _lastModuleRange = 0;

    public LayeredAddressSpace(IAbstractAddressSpace iAbstractAddressSpace, boolean bl, boolean bl2) {
        super(LayeredAddressSpace._extractRanges(iAbstractAddressSpace.getMemoryRanges()), bl, bl2);
        this._base = iAbstractAddressSpace;
    }

    private static MemoryRange[] _extractRanges(Iterator iterator) {
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            vector.add(iterator.next());
        }
        return vector.toArray(new MemoryRange[vector.size()]);
    }

    @Override
    public Iterator getMemoryRanges() {
        return super.getMemoryRanges();
    }

    @Override
    public boolean isExecutable(int n, long l) throws MemoryAccessException {
        return false;
    }

    @Override
    public boolean isReadOnly(int n, long l) throws MemoryAccessException {
        return false;
    }

    @Override
    public boolean isShared(int n, long l) throws MemoryAccessException {
        return false;
    }

    @Override
    public int getBytesAt(int n, long l, byte[] byArray) throws MemoryAccessException {
        MemoryRange memoryRange;
        int n2;
        if (null == this._moduleRangesArray) {
            this._moduleRangesArray = this._moduleRanges.keySet().toArray(new MemoryRange[0]);
        }
        if ((n2 = LayeredAddressSpace.findWhichMemoryRange(n, l, this._moduleRangesArray, this._lastModuleRange, false)) > -1 && (memoryRange = this._moduleRangesArray[n2]).contains(l)) {
            ClosingFileReader closingFileReader = (ClosingFileReader)this._moduleRanges.get(memoryRange);
            try {
                long l2 = memoryRange.getFileOffset() + (l - memoryRange.getVirtualAddress());
                closingFileReader.seek(l2);
                closingFileReader.readFully(byArray);
                return byArray.length;
            }
            catch (IOException iOException) {
                System.out.println(">> Memory access exception in getBytesAt");
                throw new MemoryAccessException(n, l);
            }
        }
        return this._base.getBytesAt(n, l, byArray);
    }

    public void mapRegion(long l, ClosingFileReader closingFileReader, long l2, long l3) {
        MemoryRange memoryRange = new MemoryRange(l, l2, l3);
        this._moduleRanges.put(memoryRange, closingFileReader);
    }
}

