/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.tools.ddrinteractive.ExpressionEvaluatorException;
import java.util.ArrayList;

public class ExpressionEvaluator {
    private static final String _UNARY_OPERATORS = "+-";
    private static final String[] _BINARY_OPERATORS_IN_PRECEDENCE = new String[]{"*/%", "+-"};
    private static final String _LEFT_PARENTHESES = "{[(<";
    private static final String _RIGHT_PARENTHESES = "}])>";
    private static final String _HEXADECIMAL_INDICATOR = "0x";
    private static final String _DECIMAL_INDICATOR = "d";
    private static final String _BINARY_INDICATOR = "bi";
    private final ArrayList<String> _al;

    public ExpressionEvaluator(String string) {
        this(new String[]{string});
    }

    public ExpressionEvaluator(String[] stringArray) {
        this._al = this.format(stringArray);
    }

    public ExpressionEvaluator(ArrayList<String> arrayList) {
        this._al = this.format(arrayList);
    }

    public static long eval(String string) throws ExpressionEvaluatorException {
        return ExpressionEvaluator.eval(string, 10);
    }

    public static long eval(String string, int n) throws ExpressionEvaluatorException {
        return new ExpressionEvaluator(string).calculate(n);
    }

    public long calculate(int n) throws ExpressionEvaluatorException {
        try {
            return this.calculate(0, this._al.size() - 1, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExpressionEvaluatorException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ExpressionEvaluatorException(indexOutOfBoundsException);
        }
        catch (NullPointerException nullPointerException) {
            throw new ExpressionEvaluatorException(nullPointerException);
        }
    }

    private long calculate(int n, int n2, int n3) throws ExpressionEvaluatorException {
        if (n == n2) {
            return this.evaluateToken(this._al.get(n), n3);
        }
        ArrayList<Range> arrayList = this.topLevelRanges(n, n2);
        ArrayList<String> arrayList2 = this.topLevel(arrayList, n3);
        return this.calculateTopLevel(arrayList2);
    }

    private ArrayList<Range> topLevelRanges(int n, int n2) throws ExpressionEvaluatorException {
        ArrayList<Range> arrayList = new ArrayList<Range>();
        int n3 = n;
        while (n3 <= n2) {
            String string = this._al.get(n3);
            if (this.isLeftParenthesis(string)) {
                int n4 = this.findRightParenthesisIndex(n3 + 1, n2);
                arrayList.add(new Range(n3 + 1, n4 - 1));
                n3 = n4 + 1;
                continue;
            }
            arrayList.add(new Range(n3, n3));
            ++n3;
        }
        return arrayList;
    }

    private ArrayList<String> topLevel(ArrayList<Range> arrayList, int n) throws ExpressionEvaluatorException {
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            Range range = arrayList.get(i);
            if (range.start == range.end) {
                int n2 = range.start;
                if (this.isOperator(this._al.get(n2))) {
                    arrayList2.add(this._al.get(n2));
                    continue;
                }
                arrayList2.add("" + this.evaluateToken(this._al.get(n2), n));
                continue;
            }
            arrayList2.add("" + this.calculate(range.start, range.end, n));
        }
        return arrayList2;
    }

    private long calculateTopLevel(ArrayList<String> arrayList) throws ExpressionEvaluatorException {
        if (arrayList.size() == 1) {
            return this.evaluateToken(arrayList.get(0), 10);
        }
        arrayList = this.evaluateWithUnaryOperator(arrayList);
        for (int i = 0; i < _BINARY_OPERATORS_IN_PRECEDENCE.length; ++i) {
            String string = _BINARY_OPERATORS_IN_PRECEDENCE[i];
            arrayList = this.evaluateWithBinaryOperator(arrayList, string);
        }
        return this.evaluateToken(arrayList.get(0), 10);
    }

    private long evaluateToken(String string, int n) {
        if (this.startsWithCaseInsensitively(string, _HEXADECIMAL_INDICATOR.toLowerCase())) {
            return this.stripPrefixParseLong(string, 16, _HEXADECIMAL_INDICATOR);
        }
        if (this.startsWithCaseInsensitively(string, _BINARY_INDICATOR.toLowerCase())) {
            return this.stripPrefixParseLong(string, 2, _BINARY_INDICATOR);
        }
        if (this.startsWithCaseInsensitively(string, _DECIMAL_INDICATOR.toLowerCase())) {
            return this.stripPrefixParseLong(string, 10, _DECIMAL_INDICATOR);
        }
        return Long.parseLong(string, n);
    }

    private long stripPrefixParseLong(String string, int n, String string2) {
        while (this.startsWithCaseInsensitively(string, string2)) {
            string = string.substring(string2.length());
        }
        return Long.parseLong(string, n);
    }

    private boolean startsWithCaseInsensitively(String string, String string2) {
        return string.length() >= string2.length() && string.substring(0, string2.length()).equalsIgnoreCase(string2);
    }

    private ArrayList<String> evaluateWithUnaryOperator(ArrayList<String> arrayList) throws ExpressionEvaluatorException {
        String string = arrayList.get(0);
        if (!this.isUnaryOperator(string)) {
            return arrayList;
        }
        arrayList.remove(0);
        String string2 = arrayList.remove(0);
        String string3 = this.unaryCalculate(string, string2);
        arrayList.add(0, string3);
        return arrayList;
    }

    private ArrayList<String> evaluateWithBinaryOperator(ArrayList<String> arrayList, String string) throws ExpressionEvaluatorException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = arrayList.get(0);
        int n = 0;
        if (this.isUnaryOperator(string5)) {
            n = 1;
        }
        while (n < arrayList.size() - 1) {
            string5 = arrayList.get(n);
            string2 = arrayList.get(n + 1);
            if (string.indexOf(string2) < 0) {
                n += 2;
                string5 = null;
                continue;
            }
            string3 = arrayList.get(n + 2);
            string4 = "" + this.binaryCalculate(string5, string2, string3);
            arrayList.remove(n);
            arrayList.remove(n);
            arrayList.remove(n);
            arrayList.add(n, string4);
        }
        return arrayList;
    }

    private long binaryCalculate(String string, String string2, String string3) throws ExpressionEvaluatorException {
        char c = string2.charAt(0);
        if (c == '+') {
            return Long.parseLong(string) + Long.parseLong(string3);
        }
        if (c == '-') {
            return Long.parseLong(string) - Long.parseLong(string3);
        }
        if (c == '*') {
            return Long.parseLong(string) * Long.parseLong(string3);
        }
        if (c == '/') {
            return Long.parseLong(string) / Long.parseLong(string3);
        }
        if (c == '%') {
            return Long.parseLong(string) % Long.parseLong(string3);
        }
        throw new ExpressionEvaluatorException("unsupported binary operator:" + string2);
    }

    private String unaryCalculate(String string, String string2) throws ExpressionEvaluatorException {
        if (string.charAt(0) == '+') {
            return string2;
        }
        if (string.charAt(0) == '-') {
            return "" + -1L * Long.parseLong(string2);
        }
        throw new ExpressionEvaluatorException("Unrecognized unary operator: " + string);
    }

    private int findRightParenthesisIndex(int n, int n2) throws ExpressionEvaluatorException {
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            String string = this._al.get(i);
            if (this.isLeftParenthesis(string)) {
                --n3;
            }
            if (this.isRightParenthesis(string)) {
                ++n3;
            }
            if (n3 != 1) continue;
            return i;
        }
        throw new ExpressionEvaluatorException("Mis-matched parentheses.");
    }

    private ArrayList<String> format(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.addAll(this.format(stringArray[i]));
        }
        return arrayList;
    }

    private ArrayList<String> format(ArrayList<String> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList2.addAll(this.format(arrayList.get(i)));
        }
        return arrayList2;
    }

    private ArrayList<String> format(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\t') continue;
            if (this.isParenthesis(c) || this.isOperator(c)) {
                if (stringBuffer.length() > 0) {
                    arrayList.add(stringBuffer.toString());
                }
                arrayList.add("" + c);
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    private boolean isOperator(String string) {
        return string.length() == 1 && this.isOperator(string.charAt(0));
    }

    private boolean isOperator(char c) {
        return this.isBinaryOperator(c) || this.isUnaryOperator(c);
    }

    private boolean isBinaryOperator(char c) {
        for (int i = 0; i < _BINARY_OPERATORS_IN_PRECEDENCE.length; ++i) {
            if (_BINARY_OPERATORS_IN_PRECEDENCE[i].indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }

    private boolean isUnaryOperator(String string) {
        return string.length() == 1 && this.isUnaryOperator(string.charAt(0));
    }

    private boolean isUnaryOperator(char c) {
        return _UNARY_OPERATORS.indexOf(c) >= 0;
    }

    private boolean isParenthesis(char c) {
        return this.isLeftParenthesis(c) || this.isRightParenthesis(c);
    }

    private boolean isLeftParenthesis(String string) {
        return string.length() == 1 && this.isLeftParenthesis(string.charAt(0));
    }

    private boolean isLeftParenthesis(char c) {
        return _LEFT_PARENTHESES.indexOf(c) >= 0;
    }

    private boolean isRightParenthesis(String string) {
        return string.length() == 1 && this.isRightParenthesis(string.charAt(0));
    }

    private boolean isRightParenthesis(char c) {
        return _RIGHT_PARENTHESES.indexOf(c) >= 0;
    }

    private class Range {
        public int start;
        public int end;

        public Range(int n, int n2) {
            this.start = n;
            this.end = n2;
        }
    }
}

