/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.IBootstrapRunnable;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.util.logging.Logger;

public class FindVMTask
implements IBootstrapRunnable {
    private final Logger logger = CommandUtils.getLogger();
    private static final String J9VM_ADDRESS_PROPERTY = "com.ibm.j9ddr.vmaddr";

    @Override
    public void run(IVMData iVMData, Object[] objectArray) {
        long[] lArray = (long[])objectArray[0];
        String string = System.getProperty(J9VM_ADDRESS_PROPERTY);
        if (string != null) {
            long l = 0L;
            try {
                l = string.startsWith("0x") ? Long.parseLong(string.substring(2), 16) : Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.warning("System property com.ibm.j9ddr.vmaddr does not contain a valid pointer address, found: " + string);
                throw numberFormatException;
            }
            this.logger.warning("FindVMTask forcing J9JavaVMPointer to address from system property com.ibm.j9ddr.vmaddr : " + string);
            J9JavaVMPointer j9JavaVMPointer = J9JavaVMPointer.cast(l);
            J9RASHelper.setCachedVM(j9JavaVMPointer);
            lArray[0] = j9JavaVMPointer.getAddress();
        } else {
            try {
                lArray[0] = DataType.getJ9RASPointer().vm().longValue();
            }
            catch (CorruptDataException corruptDataException) {
                throw new RuntimeException(corruptDataException);
            }
        }
        this.logger.fine("FindVMTask passing back J9JavaVMPointer: 0x" + Long.toHexString(lArray[0]));
    }
}

