/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.utils.ManagedImage;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ILibraryDependentCore;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.view.dtfj.DTFJCorruptDataException;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageAddressSpace;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import com.ibm.j9ddr.view.dtfj.image.J9RASImageDataFactory;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import javax.imageio.stream.ImageInputStream;

public class J9DDRImage
implements ManagedImage {
    private final ICore coreFile;
    private J9RASImageDataFactory.MachineData j9MachineData;
    private boolean machineDataSet = false;
    private final URI source;
    private ManagedImageSource imageSource = null;
    private final ImageInputStream meta;
    private boolean closed = false;

    public J9DDRImage(ICore iCore) {
        this(null, iCore, null);
    }

    public J9DDRImage(URI uRI, ICore iCore, ImageInputStream imageInputStream) {
        this.coreFile = iCore;
        this.source = uRI;
        this.meta = imageInputStream;
        if (iCore instanceof ILibraryDependentCore) {
            this.passBackExecutablePath((ILibraryDependentCore)iCore);
        }
    }

    public ICore getCore() {
        return this.coreFile;
    }

    public URI getSource() {
        return this.source;
    }

    private void passBackExecutablePath(ILibraryDependentCore iLibraryDependentCore) {
        Iterator<J9DDRImageAddressSpace> iterator = this.getAddressSpaces();
        while (iterator.hasNext()) {
            J9DDRImageAddressSpace j9DDRImageAddressSpace = iterator.next();
            J9DDRImageProcess j9DDRImageProcess = j9DDRImageAddressSpace.getCurrentProcess();
            String string = j9DDRImageProcess.getExecutablePath();
            if (string == null) continue;
            iLibraryDependentCore.executablePathHint(string);
        }
    }

    private void checkJ9RASMachineData() {
        if (!this.machineDataSet) {
            this.j9MachineData = J9RASImageDataFactory.getMachineData(this.coreFile);
            this.machineDataSet = true;
        }
    }

    public Iterator<J9DDRImageAddressSpace> getAddressSpaces() {
        Collection<? extends IAddressSpace> collection = this.coreFile.getAddressSpaces();
        LinkedList<J9DDRImageAddressSpace> linkedList = new LinkedList<J9DDRImageAddressSpace>();
        for (IAddressSpace iAddressSpace : collection) {
            linkedList.add(new J9DDRImageAddressSpace(iAddressSpace));
        }
        return linkedList.iterator();
    }

    public long getCreationTime() throws DataUnavailable {
        Properties properties;
        String string;
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.dumpTimeMillis();
            }
            catch (CorruptDataException corruptDataException) {
            }
            catch (DataUnavailableException dataUnavailableException) {
                // empty catch block
            }
        }
        if ((string = (properties = this.coreFile.getProperties()).getProperty("core.creation.time")) != null) {
            return Long.parseLong(string);
        }
        throw new DataUnavailable();
    }

    public String getHostName() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.hostName();
            }
            catch (CorruptDataException corruptDataException) {
                throw new DataUnavailable();
            }
            catch (DataUnavailableException dataUnavailableException) {
                throw new DataUnavailable();
            }
        }
        throw new DataUnavailable();
    }

    public Iterator<?> getIPAddresses() throws DataUnavailable {
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.ipaddresses();
            }
            catch (CorruptDataException corruptDataException) {
                throw new DataUnavailable();
            }
            catch (DataUnavailableException dataUnavailableException) {
                throw new DataUnavailable();
            }
        }
        throw new DataUnavailable();
    }

    public long getInstalledMemory() throws DataUnavailable {
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.memoryBytes();
            }
            catch (CorruptDataException corruptDataException) {
                throw new DataUnavailable();
            }
        }
        throw new DataUnavailable();
    }

    public int getProcessorCount() throws DataUnavailable {
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.cpus();
            }
            catch (CorruptDataException corruptDataException) {
                throw new DataUnavailable();
            }
        }
        throw new DataUnavailable();
    }

    public String getProcessorSubType() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        Properties properties = this.coreFile.getProperties();
        String string = properties.getProperty("cpu.subtype");
        if (string != null) {
            return string;
        }
        throw new DataUnavailable();
    }

    public String getProcessorType() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.osArch();
            }
            catch (CorruptDataException corruptDataException) {
                throw new DTFJCorruptDataException(this.j9MachineData.getProcess(), corruptDataException);
            }
        }
        Properties properties = this.coreFile.getProperties();
        String string = properties.getProperty("cpu.type");
        if (string != null) {
            return string;
        }
        throw new DataUnavailable();
    }

    public String getSystemSubType() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        Properties properties;
        String string;
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.osVersion();
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
        }
        if ((string = (properties = this.coreFile.getProperties()).getProperty("system.subtype")) != null) {
            return string;
        }
        throw new DataUnavailable();
    }

    public String getSystemType() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        Properties properties;
        String string;
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.osName();
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
        }
        if ((string = (properties = this.coreFile.getProperties()).getProperty("system.type")) != null) {
            return string;
        }
        throw new DataUnavailable();
    }

    public void close() {
        this.closed = true;
        try {
            this.coreFile.close();
            if (this.meta != null) {
                this.meta.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.imageSource != null && this.imageSource.getExtractedTo() != null) {
            this.imageSource.getExtractedTo().delete();
            if (this.imageSource.hasMetaData() && this.imageSource.getMetadata().getExtractedTo() != null) {
                this.imageSource.getMetadata().getExtractedTo().delete();
            }
        }
    }

    public Properties getProperties() {
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.systemInfo();
            }
            catch (CorruptDataException corruptDataException) {
            }
            catch (DataUnavailableException dataUnavailableException) {
                // empty catch block
            }
        }
        return new Properties();
    }

    public boolean isTruncated() {
        if (this.coreFile == null) {
            return true;
        }
        return this.coreFile.isTruncated();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof J9DDRImage)) {
            return false;
        }
        J9DDRImage j9DDRImage = (J9DDRImage)object;
        return this.source.equals(j9DDRImage.source);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public ManagedImageSource getImageSource() {
        return this.imageSource;
    }

    public void setImageSource(ManagedImageSource managedImageSource) {
        this.imageSource = managedImageSource;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public long getCreationTimeNanos() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.dumpTimeNanos();
            }
            catch (CorruptDataException corruptDataException) {
                throw new DTFJCorruptDataException(this.j9MachineData.getProcess(), corruptDataException);
            }
            catch (DataUnavailableException dataUnavailableException) {
                // empty catch block
            }
        }
        throw new DataUnavailable();
    }
}

