/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.types;

import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.I8;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.U8;

public class I64
extends IDATA {
    public static final int SIZEOF = 8;
    public static final long MASK = -1L;
    public static final I64 MIN = new I64(Long.MIN_VALUE);
    public static final I64 MAX = new I64(Long.MAX_VALUE);

    public I64(long l) {
        super(l);
        this.data = l;
    }

    public I64(Scalar scalar) {
        super(scalar);
    }

    public I64 add(int n) {
        return new I64(this.data + (long)n);
    }

    public I64 add(long l) {
        return new I64(this.data + l);
    }

    @Override
    public I64 add(U8 u8) {
        return this.add(new I64(u8));
    }

    @Override
    public I64 add(U16 u16) {
        return this.add(new I64(u16));
    }

    @Override
    public I64 add(U32 u32) {
        return this.add(new I64(u32));
    }

    public U64 add(U64 u64) {
        return new U64(this).add(new I64(u64));
    }

    public boolean eq(U64 u64) {
        return new U64(this).eq(new I64(u64));
    }

    public I64 add(I8 i8) {
        return this.add(new I64(i8));
    }

    public I64 add(I16 i16) {
        return this.add(new I64(i16));
    }

    public I64 add(I32 i32) {
        return this.add(new I64(i32));
    }

    @Override
    public I64 add(I64 i64) {
        return new I64(this.data + i64.data);
    }

    @Override
    public I64 add(IDATA iDATA) {
        return this.add(new I64(iDATA));
    }

    public I64 sub(int n) {
        return new I64(this.data - (long)n);
    }

    @Override
    public I64 sub(long l) {
        return new I64(this.data - l);
    }

    @Override
    public I64 sub(U8 u8) {
        return this.sub(new I64(u8));
    }

    @Override
    public I64 sub(U16 u16) {
        return this.sub(new I64(u16));
    }

    @Override
    public I64 sub(U32 u32) {
        return this.sub(new I64(u32));
    }

    public U64 sub(U64 u64) {
        return new U64(this).sub(new I64(u64));
    }

    public I64 sub(I8 i8) {
        return this.sub(new I64(i8));
    }

    public I64 sub(I16 i16) {
        return this.sub(new I64(i16));
    }

    public I64 sub(I32 i32) {
        return this.sub(new I64(i32));
    }

    @Override
    public I64 sub(I64 i64) {
        return new I64(this.data - i64.data);
    }

    @Override
    public I64 sub(IDATA iDATA) {
        return this.sub(new I64(iDATA));
    }

    @Override
    public int intValue() {
        int n = (int)this.data;
        if (this.data != (long)n) {
            throw new InvalidDataTypeException("I64: conversion to int would lose data");
        }
        return n;
    }

    @Override
    public long longValue() {
        return this.data;
    }

    @Override
    public I64 bitOr(int n) {
        return new I64(this.data | (long)n);
    }

    public I64 bitOr(long l) {
        return new I64(this.data | l);
    }

    @Override
    public I64 bitOr(U8 u8) {
        return this.bitOr(new I64(u8));
    }

    @Override
    public I64 bitOr(U16 u16) {
        return this.bitOr(new I64(u16));
    }

    @Override
    public I64 bitOr(U32 u32) {
        return this.bitOr(new I64(u32));
    }

    public U64 bitOr(U64 u64) {
        return new U64(this).bitOr(new I64(u64));
    }

    public I64 bitOr(I8 i8) {
        return this.bitOr(new I64(i8));
    }

    public I64 bitOr(I16 i16) {
        return this.bitOr(new I64(i16));
    }

    public I64 bitOr(I32 i32) {
        return this.bitOr(new I64(i32));
    }

    @Override
    public I64 bitOr(I64 i64) {
        return new I64(this.data | i64.data);
    }

    @Override
    public I64 bitOr(IDATA iDATA) {
        return this.bitOr(new I64(iDATA));
    }

    @Override
    public I64 bitXor(int n) {
        return new I64(this.data ^ (long)n);
    }

    @Override
    public I64 bitXor(long l) {
        return new I64(this.data ^ l);
    }

    @Override
    public I64 bitXor(Scalar scalar) {
        return this.bitXor(new I64(scalar));
    }

    @Override
    public I64 bitXor(I64 i64) {
        return new I64(this.data ^ i64.data);
    }

    @Override
    public U64 bitXor(U64 u64) {
        return new U64(this).bitXor(u64);
    }

    @Override
    public I64 bitAnd(int n) {
        return new I64(this.data & (long)n);
    }

    public I64 bitAnd(long l) {
        return new I64(this.data & l);
    }

    @Override
    public I64 bitAnd(U8 u8) {
        return this.bitAnd(new I64(u8));
    }

    @Override
    public I64 bitAnd(U16 u16) {
        return this.bitAnd(new I64(u16));
    }

    @Override
    public I64 bitAnd(U32 u32) {
        return this.bitAnd(new I64(u32));
    }

    public U64 bitAnd(U64 u64) {
        return new U64(this).bitAnd(new I64(u64));
    }

    public I64 bitAnd(I8 i8) {
        return this.bitAnd(new I64(i8));
    }

    public I64 bitAnd(I16 i16) {
        return this.bitAnd(new I64(i16));
    }

    public I64 bitAnd(I32 i32) {
        return this.bitAnd(new I64(i32));
    }

    @Override
    public I64 bitAnd(I64 i64) {
        return new I64(this.data & i64.data);
    }

    @Override
    public I64 bitAnd(IDATA iDATA) {
        return this.bitAnd(new I64(iDATA));
    }

    @Override
    public I64 leftShift(int n) {
        return new I64(this.data << n);
    }

    @Override
    public I64 rightShift(int n) {
        return new I64(this.data >> n);
    }

    @Override
    public I64 bitNot() {
        return new I64(this.data ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public I64 mult(int n) {
        return new I64(this.data * (long)n);
    }

    public I64 mult(long l) {
        return new I64(this.data * l);
    }

    public boolean lt(I64 i64) {
        return this.data < i64.data;
    }

    public boolean gt(I64 i64) {
        return this.data > i64.data;
    }

    @Override
    public int sizeof() {
        return 8;
    }
}

