/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.DataEntry;
import com.ibm.j9ddr.corereaders.elf.ELFDumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ELFS39064DumpReader
extends ELFDumpReader {
    protected ELFS39064DumpReader(ELFFileReader eLFFileReader) throws IOException, InvalidDumpFormatException {
        super(eLFFileReader);
    }

    @Override
    protected long getBasePointerFrom(Map<String, Number> map) {
        return this.getStackPointerFrom(map);
    }

    @Override
    protected long getInstructionPointerFrom(Map<String, Number> map) {
        return map.get("addr").longValue();
    }

    @Override
    protected long getLinkRegisterFrom(Map<String, Number> map) {
        return 0L;
    }

    @Override
    protected String getProcessorType() {
        return "s390";
    }

    @Override
    protected String getStackPointerRegisterName() {
        return "addr";
    }

    @Override
    protected SortedMap<String, Number> readRegisters() throws IOException {
        int n;
        TreeMap<String, Number> treeMap = new TreeMap<String, Number>(new ELFDumpReader.RegisterComparator());
        treeMap.put("mask", this._reader.readLong());
        treeMap.put("addr", this._reader.readLong());
        for (n = 0; n < 16; ++n) {
            treeMap.put("gpr" + n, this._reader.readLong());
        }
        for (n = 0; n < 16; ++n) {
            treeMap.put("acr" + n, this._reader.readLong());
        }
        treeMap.put("origgpr2", this._reader.readLong());
        treeMap.put("trap", this._reader.readLong());
        treeMap.put("old_ilc", this._reader.readLong());
        return treeMap;
    }

    @Override
    protected String[] getDwarfRegisterKeys() {
        int n;
        String[] stringArray = new String[66];
        for (n = 0; n < 16; ++n) {
            stringArray[n] = "gpr" + n;
        }
        stringArray[16] = "fpr0";
        stringArray[17] = "fpr2";
        stringArray[18] = "fpr4";
        stringArray[19] = "fpr6";
        stringArray[20] = "fpr1";
        stringArray[21] = "fpr3";
        stringArray[22] = "fpr5";
        stringArray[23] = "fpr7";
        stringArray[24] = "fpr8";
        stringArray[25] = "fpr10";
        stringArray[26] = "fpr12";
        stringArray[27] = "fpr14";
        stringArray[28] = "fpr9";
        stringArray[29] = "fpr11";
        stringArray[30] = "fpr13";
        stringArray[31] = "fpr15";
        for (n = 0; n < 16; ++n) {
            stringArray[n + 32] = "cr" + n;
        }
        for (n = 0; n < 16; ++n) {
            stringArray[n + 48] = "ar" + n;
        }
        stringArray[64] = "mask";
        stringArray[65] = "addr";
        return stringArray;
    }

    @Override
    protected void readHighwordRegisters(DataEntry dataEntry, Map<String, Number> map) throws IOException, InvalidDumpFormatException {
        throw new InvalidDumpFormatException("Unexpected data entry in S39064 ELF dump");
    }

    @Override
    protected long readUID() throws IOException {
        return (long)this._reader.readInt() & 0xFFFFFFFFL;
    }
}

