/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.LinearDumper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.RomClassWalker;
import java.io.PrintStream;

public class DumpRomClassLinearCommand
extends Command {
    public DumpRomClassLinearCommand() {
        this.addCommand("dumpromclasslinear", "<addr>[,n]", "cfdump the specified J9ROMClass using Linear ROM Class Dumper");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length == 0) {
            throw new DDRInteractiveCommandException("This debug extension needs an address argument !dumpromclasslinear <addr>[,n]");
        }
        String[] stringArray2 = stringArray[0].split(",");
        long l = Long.decode(stringArray2[0]);
        long l2 = stringArray2.length > 1 ? Long.decode(stringArray2[1]) : 1L;
        J9ROMClassPointer j9ROMClassPointer = J9ROMClassPointer.cast(l);
        try {
            printStream.println(String.format("ROM Class '%s' at %s", J9UTF8Helper.stringValue(j9ROMClassPointer.className()), j9ROMClassPointer.getHexAddress()));
            RomClassWalker romClassWalker = new RomClassWalker(j9ROMClassPointer, context);
            new LinearDumper().gatherLayoutInfo(printStream, romClassWalker, l2);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

