/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.Pointer;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

public class FloatPointer
extends Pointer {
    public static final int SIZEOF = 4;
    public static final FloatPointer NULL = new FloatPointer(0L);

    protected FloatPointer(long l) {
        super(l);
    }

    public static FloatPointer cast(AbstractPointer abstractPointer) {
        return FloatPointer.cast(abstractPointer.getAddress());
    }

    public static FloatPointer cast(UDATA uDATA) {
        return FloatPointer.cast(uDATA.longValue());
    }

    public static FloatPointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new FloatPointer(l);
    }

    @Override
    public FloatPointer at(long l) throws CorruptDataException {
        throw new UnsupportedOperationException("Use floatAt(long index)");
    }

    @Override
    public FloatPointer at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    public long longAt(long l) throws CorruptDataException {
        return (long)this.floatAt(l);
    }

    public double doubleAt(long l) throws CorruptDataException {
        return this.floatAt(l);
    }

    public float floatAt(long l) throws CorruptDataException {
        return this.getFloatAtOffset(l * 4L);
    }

    @Override
    public FloatPointer add(long l) {
        return new FloatPointer(this.address + 4L * l);
    }

    @Override
    public FloatPointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public FloatPointer addOffset(long l) {
        return new FloatPointer(this.address + l);
    }

    @Override
    public FloatPointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public FloatPointer sub(long l) {
        return new FloatPointer(this.address - 4L * l);
    }

    @Override
    public FloatPointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public FloatPointer subOffset(long l) {
        return new FloatPointer(this.address - l);
    }

    @Override
    public FloatPointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    public FloatPointer untag() {
        return this.untag(3L);
    }

    @Override
    public FloatPointer untag(long l) {
        return new FloatPointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    protected long sizeOfBaseType() {
        return 4L;
    }
}

