/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.view.dtfj.image.J9DDRStubImageThread;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.J9JavaStackIterator;
import com.ibm.j9ddr.vm29.j9.stackwalker.BaseStackWalkerCallbacks;
import com.ibm.j9ddr.vm29.j9.stackwalker.FrameCallbackResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalker;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaStackPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9VMThreadHelper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaMethod;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaObject;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaReference;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaStackFrame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DTFJJavaThread
implements JavaThread {
    private static final String PRIORITY_FIELD = "priority";
    private static final String NAME_FIELD = "name";
    private static final String JAVA_LANG_THREAD_CLASS = "java/lang/Thread";
    private final J9VMThreadPointer thread;
    private String name = null;
    private int priority = Integer.MIN_VALUE;
    private ImageThread imageThread = null;
    private List<Object> frames = null;
    private List<Object> sections = null;

    public DTFJJavaThread(J9VMThreadPointer j9VMThreadPointer) {
        this.thread = j9VMThreadPointer;
    }

    public ImageThread getImageThread() throws com.ibm.dtfj.image.CorruptDataException, DataUnavailable {
        if (this.imageThread == null) {
            J9DDRImageProcess j9DDRImageProcess = DTFJContext.getImageProcess();
            try {
                long l = this.thread.osThread().tid().longValue();
                this.imageThread = j9DDRImageProcess.getThread(l);
                if (null == this.imageThread) {
                    this.imageThread = new J9DDRStubImageThread(DTFJContext.getProcess(), l);
                }
            }
            catch (Throwable throwable) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            }
        }
        return this.imageThread;
    }

    public ImagePointer getJNIEnv() throws com.ibm.dtfj.image.CorruptDataException {
        return DTFJContext.getImagePointer(this.thread.getAddress());
    }

    public String getName() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            if (this.name == null) {
                JavaField javaField = this.getField(NAME_FIELD);
                this.name = javaField != null ? javaField.getString(this.getObject()) : "vmthread @" + this.thread.getAddress();
            }
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
        return this.name;
    }

    public JavaObject getObject() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            if (this.thread.threadObject().isNull()) {
                return null;
            }
            DTFJJavaObject dTFJJavaObject = new DTFJJavaObject(this.thread.threadObject());
            dTFJJavaObject.getJavaClass().getName();
            return dTFJJavaObject;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public int getPriority() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            if (this.priority == Integer.MIN_VALUE) {
                JavaField javaField = this.getField(PRIORITY_FIELD);
                this.priority = javaField != null ? javaField.getInt(this.getObject()) : -1;
            }
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
        return this.priority;
    }

    private JavaField getField(String string) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        JavaClass javaClass;
        JavaObject javaObject = this.getObject();
        if (javaObject == null) {
            return null;
        }
        for (javaClass = javaObject.getJavaClass(); !JAVA_LANG_THREAD_CLASS.equals(javaClass.getName()) && javaClass != null; javaClass = javaClass.getSuperclass()) {
        }
        if (javaClass == null) {
            return null;
        }
        Iterator iterator = javaClass.getDeclaredFields();
        while (iterator.hasNext()) {
            JavaField javaField;
            Object e = iterator.next();
            if (!(e instanceof JavaField) || !string.equals((javaField = (JavaField)e).getName())) continue;
            return javaField;
        }
        return null;
    }

    public Iterator getStackFrames() {
        if (this.frames == null) {
            this.walkStack();
        }
        return this.frames.iterator();
    }

    private void walkStack() {
        this.frames = new LinkedList<Object>();
        WalkState walkState = new WalkState();
        walkState.walkThread = this.thread;
        walkState.flags = J9Consts.J9_STACKWALK_VISIBLE_ONLY | J9Consts.J9_STACKWALK_INCLUDE_NATIVES | J9Consts.J9_STACKWALK_ITERATE_FRAMES | J9Consts.J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET | J9Consts.J9_STACKWALK_ITERATE_O_SLOTS;
        walkState.callBacks = new StackWalkerCallbacks();
        EventManager.register((IEventListener)((Object)walkState.callBacks));
        StackWalkResult stackWalkResult = StackWalkResult.STACK_CORRUPT;
        try {
            stackWalkResult = StackWalker.walkStackFrames(walkState);
        }
        catch (Throwable throwable) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            stackWalkResult = StackWalkResult.STACK_CORRUPT;
        }
        EventManager.unregister((IEventListener)((Object)walkState.callBacks));
        if (stackWalkResult != StackWalkResult.NONE) {
            this.frames.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Bad return from stack walker walking thread 0x" + Long.toHexString(walkState.threadAddress) + ". Some stack frames may be missing. Final state = " + (Object)((Object)stackWalkResult)));
        }
    }

    public Iterator getStackSections() {
        if (this.sections == null) {
            this.walkSections();
        }
        return this.sections.iterator();
    }

    private void walkSections() {
        J9JavaStackIterator j9JavaStackIterator;
        this.sections = new ArrayList<Object>();
        try {
            j9JavaStackIterator = J9JavaStackIterator.fromJ9JavaStack(this.thread.stackObject());
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            this.sections.add(corruptData);
            return;
        }
        int n = 0;
        while (j9JavaStackIterator.hasNext() && n < 1) {
            J9JavaStackPointer j9JavaStackPointer = j9JavaStackIterator.next();
            try {
                long l = j9JavaStackPointer.size().longValue();
                long l2 = j9JavaStackPointer.end().longValue() - l;
                J9DDRImageSection j9DDRImageSection = DTFJContext.getImageSection(l2, this.getSectionName());
                j9DDRImageSection.setSize(l);
                this.sections.add(j9DDRImageSection);
                ++n;
            }
            catch (Throwable throwable) {
                CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                this.sections.add(corruptData);
            }
        }
    }

    private String getSectionName() {
        try {
            return "JavaStackSection for JavaThread: " + this.getName();
        }
        catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
            return "JavaStackSection for JavaThread: Invalid Thread Name";
        }
    }

    public boolean equals(Object object) {
        boolean bl;
        ImageThread imageThread = null;
        try {
            imageThread = this.getImageThread();
        }
        catch (DataUnavailable dataUnavailable) {
        }
        catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
            // empty catch block
        }
        boolean bl2 = null == imageThread ? this == object : (bl = false);
        if (null != imageThread && object instanceof DTFJJavaThread) {
            DTFJJavaThread dTFJJavaThread = (DTFJJavaThread)object;
            try {
                bl = imageThread.getID().equals(dTFJJavaThread.getImageThread().getID());
            }
            catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
            }
            catch (DataUnavailable dataUnavailable) {
                // empty catch block
            }
        }
        return bl;
    }

    public int hashCode() {
        try {
            return this.getImageThread().getID().hashCode();
        }
        catch (Throwable throwable) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            return super.hashCode();
        }
    }

    public int getState() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return J9VMThreadHelper.getDTFJState(this.thread);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("JavaThread @ 0x");
        stringBuilder.append(Long.toHexString(this.thread.getAddress()));
        return stringBuilder.toString();
    }

    public JavaObject getBlockingObject() throws com.ibm.dtfj.image.CorruptDataException, DataUnavailable {
        try {
            if (this.thread.blockingEnterObject().isNull()) {
                return null;
            }
            return new DTFJJavaObject(this.thread.blockingEnterObject());
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    private class StackWalkerCallbacks
    extends BaseStackWalkerCallbacks
    implements IEventListener {
        private Object frame = null;

        private StackWalkerCallbacks() {
        }

        @Override
        public FrameCallbackResult frameWalkFunction(WalkState walkState) {
            if (walkState.method.isNull()) {
                return FrameCallbackResult.KEEP_ITERATING;
            }
            if (this.frame == null || this.frame instanceof J9DDRCorruptData) {
                this.setupFrame(walkState);
            }
            DTFJJavaThread.this.frames.add(this.frame);
            this.frame = null;
            return FrameCallbackResult.KEEP_ITERATING;
        }

        @Override
        public void objectSlotWalkFunction(WalkState walkState, PointerPointer pointerPointer, VoidPointer voidPointer) {
            block5: {
                if (walkState.method.isNull()) {
                    return;
                }
                try {
                    J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(pointerPointer.at(0L));
                    this.addObjectReference(walkState, j9ObjectPointer);
                }
                catch (CorruptDataException corruptDataException) {
                    if (this.frame instanceof DTFJJavaStackFrame) {
                        ((DTFJJavaStackFrame)this.frame).addReference(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), corruptDataException));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!(this.frame instanceof DTFJJavaStackFrame)) break block5;
                    ((DTFJJavaStackFrame)this.frame).addReference(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), new CorruptDataException(illegalArgumentException)));
                }
            }
        }

        @Override
        public void fieldSlotWalkFunction(WalkState walkState, ObjectReferencePointer objectReferencePointer, VoidPointer voidPointer) {
            block5: {
                if (walkState.method.isNull()) {
                    return;
                }
                try {
                    J9ObjectPointer j9ObjectPointer = objectReferencePointer.at(0L);
                    this.addObjectReference(walkState, j9ObjectPointer);
                }
                catch (CorruptDataException corruptDataException) {
                    if (this.frame instanceof DTFJJavaStackFrame) {
                        ((DTFJJavaStackFrame)this.frame).addReference(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), corruptDataException));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!(this.frame instanceof DTFJJavaStackFrame)) break block5;
                    ((DTFJJavaStackFrame)this.frame).addReference(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), new CorruptDataException(illegalArgumentException)));
                }
            }
        }

        private void addObjectReference(WalkState walkState, J9ObjectPointer j9ObjectPointer) {
            if (this.frame == null) {
                this.setupFrame(walkState);
            }
            if (this.frame instanceof DTFJJavaStackFrame && j9ObjectPointer.notNull()) {
                DTFJJavaObject dTFJJavaObject = new DTFJJavaObject(j9ObjectPointer);
                DTFJJavaReference dTFJJavaReference = new DTFJJavaReference(this.frame, dTFJJavaObject, "StackFrame Root", 0, 4, 1);
                ((DTFJJavaStackFrame)this.frame).addReference(dTFJJavaReference);
            }
        }

        private void setupFrame(WalkState walkState) {
            try {
                J9DDRImagePointer j9DDRImagePointer = DTFJContext.getImagePointer(walkState.arg0EA.longValue());
                J9DDRImagePointer j9DDRImagePointer2 = DTFJContext.getImagePointer(walkState.pc.getAddress());
                J9DDRCorruptData j9DDRCorruptData = null;
                if (this.frame instanceof J9DDRCorruptData) {
                    j9DDRCorruptData = (J9DDRCorruptData)this.frame;
                }
                DTFJJavaClass dTFJJavaClass = new DTFJJavaClass(ConstantPoolHelpers.J9_CLASS_FROM_METHOD(walkState.method));
                boolean bl = walkState.jitInfo.notNull();
                this.frame = new DTFJJavaStackFrame(DTFJJavaThread.this, new DTFJJavaMethod(dTFJJavaClass, walkState.method), walkState.method, j9DDRImagePointer2, j9DDRImagePointer, walkState.bytecodePCOffset, bl);
                if (j9DDRCorruptData != null && this.frame instanceof DTFJJavaStackFrame) {
                    ((DTFJJavaStackFrame)this.frame).addReference(j9DDRCorruptData);
                }
            }
            catch (CorruptDataException corruptDataException) {
                this.frame = J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), corruptDataException);
            }
        }

        @Override
        public void corruptData(String string, CorruptDataException corruptDataException, boolean bl) {
            if (this.frame == null) {
                this.frame = J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), corruptDataException);
            } else if (this.frame instanceof DTFJJavaStackFrame) {
                ((DTFJJavaStackFrame)this.frame).addReference(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), corruptDataException));
            }
        }
    }
}

