/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;

public class MemoryRange
implements Comparable {
    private static final String[] printableEBCDIC = new String[]{"40", " ", "F0", "0", "F1", "1", "F2", "2", "F3", "3", "F4", "4", "F5", "5", "F6", "6", "F7", "7", "F8", "8", "F9", "9", "C1", "A", "C2", "B", "C3", "C", "C4", "D", "C5", "E", "C6", "F", "C7", "G", "C8", "H", "C9", "I", "D1", "J", "D2", "K", "D3", "L", "D4", "M", "D5", "N", "D6", "O", "D7", "P", "D8", "Q", "D9", "R", "E2", "S", "E3", "T", "E4", "U", "E5", "V", "E6", "W", "E7", "X", "E8", "Y", "E9", "Z", "81", "a", "82", "b", "83", "c", "84", "d", "85", "e", "86", "f", "87", "g", "88", "h", "89", "i", "91", "j", "92", "k", "93", "l", "94", "m", "95", "n", "96", "o", "97", "p", "98", "q", "99", "r", "A2", "s", "A3", "t", "A4", "u", "A5", "v", "A6", "w", "A7", "x", "A8", "y", "A9", "z"};
    private DumpReader _libraryReader = null;
    private long _virtualAddress;
    private long _fileOffset;
    private long _size;
    private boolean _inCoreFile = true;
    private int _asid = 0;
    private boolean _shared = false;
    private boolean _readOnly = false;
    private boolean _executable = true;
    private boolean _permissionsSupported = false;

    public MemoryRange(long l, long l2, long l3) {
        this._virtualAddress = l;
        this._fileOffset = l2;
        this._size = l3;
    }

    public MemoryRange(long l, long l2, long l3, int n) {
        this(l, l2, l3);
        this._asid = n;
    }

    public MemoryRange(long l, long l2, long l3, int n, boolean bl, boolean bl2, boolean bl3) {
        this(l, l2, l3, n);
        this._shared = bl;
        this._readOnly = bl2;
        this._executable = bl3;
        this._permissionsSupported = true;
    }

    public MemoryRange(long l, long l2, long l3, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(l, l2, l3, n, bl, bl2, bl3);
        this._inCoreFile = bl4;
    }

    public MemoryRange(MemoryRange memoryRange, int n) {
        this(memoryRange.getVirtualAddress(), memoryRange.getFileOffset(), memoryRange.getSize(), n);
        this._permissionsSupported = true;
        try {
            this._shared = memoryRange.isShared();
            this._readOnly = memoryRange.isReadOnly();
            this._executable = memoryRange.isExecutable();
            this._inCoreFile = memoryRange.isInCoreFile();
            this._libraryReader = memoryRange.getLibraryReader();
        }
        catch (MemoryAccessException memoryAccessException) {
            this._permissionsSupported = false;
        }
    }

    public boolean contains(long l) {
        return this.getVirtualAddress() <= l && l < this.getVirtualAddress() + this.getSize();
    }

    public boolean contains(int n, long l) {
        return n == this._asid && this.contains(l);
    }

    public long getFileOffset() {
        return this._fileOffset;
    }

    public long getSize() {
        return this._size;
    }

    public long getVirtualAddress() {
        return this._virtualAddress;
    }

    public boolean isInCoreFile() {
        return this._inCoreFile;
    }

    public DumpReader getLibraryReader() {
        return this._libraryReader;
    }

    public void setLibraryReader(DumpReader dumpReader) {
        this._libraryReader = dumpReader;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Addr: 0x" + Long.toHexString(this.getVirtualAddress()));
        stringBuffer.append("   Size: 0x" + Long.toHexString(this.getSize()) + " (" + this.getSize() + ")");
        stringBuffer.append("   File Offset: 0x" + Long.toHexString(this.getFileOffset()));
        stringBuffer.append(" (" + this.getFileOffset() + ")");
        if (this._asid != 0) {
            String string = Integer.toHexString(this._asid);
            boolean bl = false;
            StringBuffer stringBuffer2 = new StringBuffer("");
            if (8 == string.length()) {
                bl = true;
                for (int i = 0; i < 8 && bl; i += 2) {
                    String string2 = string.substring(i, i + 2);
                    String string3 = this.isPrintableEbcdic(string2);
                    if (null == string3) {
                        bl = false;
                        continue;
                    }
                    stringBuffer2.append(string3);
                }
            }
            if (bl) {
                stringBuffer.append("   asid: " + stringBuffer2);
            } else {
                stringBuffer.append("   asid: 0x" + Integer.toHexString(this._asid));
            }
        }
        return stringBuffer.toString();
    }

    private String isPrintableEbcdic(String string) {
        string = string.toUpperCase();
        for (int i = 0; i < printableEBCDIC.length; i += 2) {
            if (!string.equals(printableEBCDIC[i])) continue;
            return printableEBCDIC[i + 1];
        }
        return null;
    }

    public int getAsid() {
        return this._asid;
    }

    public boolean isExecutable() throws MemoryAccessException {
        if (this._permissionsSupported) {
            return this._executable;
        }
        throw new MemoryAccessException(this.getAsid(), this.getVirtualAddress());
    }

    public boolean isReadOnly() throws MemoryAccessException {
        if (this._permissionsSupported) {
            return this._readOnly;
        }
        throw new MemoryAccessException(this.getAsid(), this.getVirtualAddress());
    }

    public boolean isShared() throws MemoryAccessException {
        if (this._permissionsSupported) {
            return this._shared;
        }
        throw new MemoryAccessException(this.getAsid(), this.getVirtualAddress());
    }

    public int compareTo(Object object) {
        MemoryRange memoryRange = (MemoryRange)object;
        if (this._asid < memoryRange._asid) {
            return -1;
        }
        if (this._asid > memoryRange._asid) {
            return 1;
        }
        if (this._virtualAddress == memoryRange._virtualAddress) {
            return 0;
        }
        if (this._virtualAddress >= 0L && memoryRange._virtualAddress >= 0L || this._virtualAddress < 0L && memoryRange._virtualAddress < 0L) {
            return this._virtualAddress < memoryRange._virtualAddress ? -1 : 1;
        }
        return this._virtualAddress < memoryRange._virtualAddress ? 1 : -1;
    }
}

