/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import sun.print.PrinterGraphicsDevice;

public class PrinterGraphicsConfig
extends GraphicsConfiguration {
    static ColorModel theModel;
    GraphicsDevice gd;
    int pageWidth;
    int pageHeight;
    AffineTransform deviceTransform;

    public PrinterGraphicsConfig(String string, AffineTransform affineTransform, int n, int n2) {
        this.pageWidth = n;
        this.pageHeight = n2;
        this.deviceTransform = affineTransform;
        this.gd = new PrinterGraphicsDevice(this, string);
    }

    @Override
    public GraphicsDevice getDevice() {
        return this.gd;
    }

    @Override
    public ColorModel getColorModel() {
        if (theModel == null) {
            BufferedImage bufferedImage = new BufferedImage(1, 1, 5);
            theModel = bufferedImage.getColorModel();
        }
        return theModel;
    }

    @Override
    public ColorModel getColorModel(int n) {
        switch (n) {
            case 1: {
                return this.getColorModel();
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                return ColorModel.getRGBdefault();
            }
        }
        return null;
    }

    @Override
    public AffineTransform getDefaultTransform() {
        return new AffineTransform(this.deviceTransform);
    }

    @Override
    public AffineTransform getNormalizingTransform() {
        return new AffineTransform();
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.pageWidth, this.pageHeight);
    }
}

