/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.I64Pointer;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectCompressedPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectFullPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9Object;
import com.ibm.j9ddr.vm29.structure.J9ObjectCompressed;
import com.ibm.j9ddr.vm29.structure.J9ObjectFull;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class J9ObjectHelper {
    private static int cacheSize;
    private static J9ObjectPointer[] keys;
    private static J9ClassPointer[] values;
    private static int[] counts;
    private static long probes;
    private static long hits;
    public static final boolean mixedReferenceMode;
    public static final boolean compressObjectReferences;
    private static Boolean isStringBackedByByteArray;

    public static boolean isIndexable(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return ObjectModel.isIndexable(j9ObjectPointer);
    }

    public static U32 flags(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        long l = J9Consts.J9_REQUIRED_CLASS_ALIGNMENT - 1L;
        UDATA uDATA = J9ObjectHelper.rawClazz(j9ObjectPointer);
        return new U32(uDATA.bitAnd(l));
    }

    public static long headerSize() {
        if (mixedReferenceMode) {
            if (compressObjectReferences) {
                return J9ObjectCompressed.SIZEOF;
            }
            return J9ObjectFull.SIZEOF;
        }
        return J9Object.SIZEOF;
    }

    public static UDATA rawClazz(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        if (mixedReferenceMode) {
            try {
                if (compressObjectReferences) {
                    return J9ObjectCompressedPointer.cast(j9ObjectPointer).clazz();
                }
                return J9ObjectFullPointer.cast(j9ObjectPointer).clazz();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new CorruptDataException(noSuchFieldException);
            }
        }
        return UDATA.cast(j9ObjectPointer.clazz());
    }

    public static J9ClassPointer clazz(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        J9ClassPointer j9ClassPointer = J9ObjectHelper.checkClassCache(j9ObjectPointer);
        if (null == j9ClassPointer) {
            long l = J9Consts.J9_REQUIRED_CLASS_ALIGNMENT - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            UDATA uDATA = J9ObjectHelper.rawClazz(j9ObjectPointer);
            j9ClassPointer = J9ClassPointer.cast(uDATA.bitAnd(l));
            J9ObjectHelper.setClassCache(j9ObjectPointer, j9ClassPointer);
        }
        return j9ClassPointer;
    }

    public static UDATA monitor(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        throw new UnsupportedOperationException("lockNursery not supported yet");
    }

    public static String getClassName(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return J9ClassHelper.getName(J9ObjectHelper.clazz(j9ObjectPointer));
    }

    public static String getJavaName(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return J9ClassHelper.getJavaName(J9ObjectHelper.clazz(j9ObjectPointer));
    }

    public static String stringValue(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        Object[] objectArray;
        J9ObjectPointer j9ObjectPointer2;
        if (!J9ObjectHelper.getClassName(j9ObjectPointer).equals("java/lang/String")) {
            throw new IllegalArgumentException();
        }
        if (isStringBackedByByteArray == null) {
            try {
                J9ObjectHelper.getObjectField(j9ObjectPointer, J9ObjectHelper.getFieldOffset(j9ObjectPointer, "value", "[B"));
                isStringBackedByByteArray = true;
            }
            catch (NoSuchElementException noSuchElementException) {
                J9ObjectHelper.getObjectField(j9ObjectPointer, J9ObjectHelper.getFieldOffset(j9ObjectPointer, "value", "[C"));
                isStringBackedByByteArray = false;
            }
        }
        J9ObjectPointer j9ObjectPointer3 = j9ObjectPointer2 = isStringBackedByByteArray != false ? J9ObjectHelper.getObjectField(j9ObjectPointer, J9ObjectHelper.getFieldOffset(j9ObjectPointer, "value", "[B")) : J9ObjectHelper.getObjectField(j9ObjectPointer, J9ObjectHelper.getFieldOffset(j9ObjectPointer, "value", "[C"));
        if (j9ObjectPointer2.isNull()) {
            return "<Uninitialized String>";
        }
        int n = 0;
        boolean bl = false;
        J9IndexableObjectPointer j9IndexableObjectPointer = J9IndexableObjectPointer.cast(j9ObjectPointer2);
        if (isStringBackedByByteArray.booleanValue()) {
            byte by = J9ObjectHelper.getByteField(j9ObjectPointer, J9ObjectHelper.getFieldOffset(j9ObjectPointer, "coder", "B"));
            bl = by == 0;
            objectArray = (byte[])J9IndexableObjectHelper.getData(j9IndexableObjectPointer);
            n = objectArray.length >> by;
        } else {
            n = J9ObjectHelper.getIntField(j9ObjectPointer, J9ObjectHelper.getFieldOffset(j9ObjectPointer, "count", "I"));
            String string = AlgorithmVersion.getVersionOf("ALG_VM_JAVA_LANG_STRING_VERSION").getAlgorithmVersion() >= 1 ? "COMPACT_STRINGS" : "enableCompression";
            boolean bl2 = J9ObjectHelper.getBooleanField(j9ObjectPointer, J9ObjectHelper.getFieldOffset(j9ObjectPointer, string, "Z"));
            if (bl2) {
                if (n >= 0) {
                    bl = true;
                } else {
                    n &= Integer.MAX_VALUE;
                }
            }
        }
        char[] cArray = new char[n];
        if (isStringBackedByByteArray.booleanValue()) {
            objectArray = (byte[])J9IndexableObjectHelper.getData(j9IndexableObjectPointer);
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    cArray[i] = J9ObjectHelper.byteToCharUnsigned(J9ObjectHelper.getByteFromArrayByIndex(objectArray, i));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    cArray[i] = J9ObjectHelper.getCharFromArrayByIndex(objectArray, i);
                }
            }
        } else {
            objectArray = (char[])J9IndexableObjectHelper.getData(j9IndexableObjectPointer);
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    cArray[i] = J9ObjectHelper.byteToCharUnsigned(J9ObjectHelper.getByteFromArrayByIndex(objectArray, i));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    cArray[i] = J9ObjectHelper.getCharFromArrayByIndex(objectArray, i);
                }
            }
        }
        return new String(cArray);
    }

    public static String getStringField(J9ObjectPointer j9ObjectPointer, J9ObjectFieldOffset j9ObjectFieldOffset) throws CorruptDataException {
        J9ObjectPointer j9ObjectPointer2 = J9ObjectHelper.getObjectField(j9ObjectPointer, j9ObjectFieldOffset);
        if (j9ObjectPointer2.isNull()) {
            return null;
        }
        return J9ObjectHelper.stringValue(j9ObjectPointer2);
    }

    public static int getIntField(J9ObjectPointer j9ObjectPointer, J9ObjectFieldOffset j9ObjectFieldOffset) throws CorruptDataException {
        I32Pointer i32Pointer = j9ObjectFieldOffset.isStatic() ? I32Pointer.cast(J9ObjectHelper.clazz(j9ObjectPointer).ramStatics().addOffset(j9ObjectFieldOffset.getOffsetOrAddress())) : I32Pointer.cast(j9ObjectPointer.addOffset(j9ObjectFieldOffset.getOffsetOrAddress()).addOffset(ObjectModel.getHeaderSize(j9ObjectPointer)));
        return i32Pointer.at(0L).intValue();
    }

    public static short getShortField(J9ObjectPointer j9ObjectPointer, J9ObjectFieldOffset j9ObjectFieldOffset) throws CorruptDataException {
        return (short)(J9ObjectHelper.getIntField(j9ObjectPointer, j9ObjectFieldOffset) & 0xFFFF);
    }

    public static float getFloatField(J9ObjectPointer j9ObjectPointer, J9ObjectFieldOffset j9ObjectFieldOffset) throws CorruptDataException {
        int n = J9ObjectHelper.getIntField(j9ObjectPointer, j9ObjectFieldOffset);
        return Float.intBitsToFloat(n);
    }

    public static double getDoubleField(J9ObjectPointer j9ObjectPointer, J9ObjectFieldOffset j9ObjectFieldOffset) throws CorruptDataException {
        long l = J9ObjectHelper.getLongField(j9ObjectPointer, j9ObjectFieldOffset);
        return Double.longBitsToDouble(l);
    }

    public static char getCharField(J9ObjectPointer j9ObjectPointer, J9ObjectFieldOffset j9ObjectFieldOffset) throws CorruptDataException {
        return (char)(J9ObjectHelper.getIntField(j9ObjectPointer, j9ObjectFieldOffset) & 0xFFFF);
    }

    public static byte getByteField(J9ObjectPointer j9ObjectPointer, J9ObjectFieldOffset j9ObjectFieldOffset) throws CorruptDataException {
        return (byte)(J9ObjectHelper.getIntField(j9ObjectPointer, j9ObjectFieldOffset) & 0xFF);
    }

    public static boolean getBooleanField(J9ObjectPointer j9ObjectPointer, J9ObjectFieldOffset j9ObjectFieldOffset) throws CorruptDataException {
        return J9ObjectHelper.getIntField(j9ObjectPointer, j9ObjectFieldOffset) != 0;
    }

    public static long getLongField(J9ObjectPointer j9ObjectPointer, J9ObjectFieldOffset j9ObjectFieldOffset) throws CorruptDataException {
        I64Pointer i64Pointer = j9ObjectFieldOffset.isStatic() ? I64Pointer.cast(J9ObjectHelper.clazz(j9ObjectPointer).ramStatics().addOffset(j9ObjectFieldOffset.getOffsetOrAddress())) : I64Pointer.cast(j9ObjectPointer.addOffset(j9ObjectFieldOffset.getOffsetOrAddress()).addOffset(ObjectModel.getHeaderSize(j9ObjectPointer)));
        return i64Pointer.at(0L).longValue();
    }

    public static J9ObjectPointer getObjectField(J9ObjectPointer j9ObjectPointer, J9ObjectFieldOffset j9ObjectFieldOffset) throws CorruptDataException {
        if (j9ObjectFieldOffset.isStatic()) {
            UDATAPointer uDATAPointer = J9ObjectHelper.clazz(j9ObjectPointer).ramStatics().addOffset(j9ObjectFieldOffset.getOffsetOrAddress());
            return J9ObjectPointer.cast(uDATAPointer.at(0L));
        }
        return ObjectReferencePointer.cast(j9ObjectPointer.addOffset(ObjectModel.getHeaderSize(j9ObjectPointer)).addOffset(j9ObjectFieldOffset.getOffsetOrAddress())).at(0L);
    }

    public static J9ObjectFieldOffset getFieldOffset(J9ObjectPointer j9ObjectPointer, String string, String string2) throws CorruptDataException {
        J9ObjectFieldOffset j9ObjectFieldOffset = J9ClassHelper.checkFieldOffsetCache(J9ObjectHelper.clazz(j9ObjectPointer), string, string2);
        if (j9ObjectFieldOffset == null) {
            j9ObjectFieldOffset = J9ObjectHelper.readFieldOffset(j9ObjectPointer, string, string2);
            J9ClassHelper.setFieldOffsetCache(J9ObjectHelper.clazz(j9ObjectPointer), j9ObjectFieldOffset, string, string2);
        }
        return j9ObjectFieldOffset;
    }

    private static J9ObjectFieldOffset readFieldOffset(J9ObjectPointer j9ObjectPointer, String string, String string2) throws CorruptDataException {
        J9ClassPointer j9ClassPointer = J9ObjectHelper.clazz(j9ObjectPointer);
        while (j9ClassPointer.notNull()) {
            Iterator<J9ObjectFieldOffset> iterator = J9ClassHelper.getFieldOffsets(j9ClassPointer);
            while (iterator.hasNext()) {
                J9ObjectFieldOffset j9ObjectFieldOffset = iterator.next();
                if (!j9ObjectFieldOffset.getName().equals(string) || !j9ObjectFieldOffset.getSignature().equals(string2)) continue;
                return j9ObjectFieldOffset;
            }
            j9ClassPointer = J9ClassHelper.superclass(j9ClassPointer);
        }
        throw new NoSuchElementException(String.format("No field named %s with signature %s in %s", string, string2, J9ObjectHelper.getClassName(j9ObjectPointer)));
    }

    private static J9ClassPointer checkClassCache(J9ObjectPointer j9ObjectPointer) {
        ++probes;
        for (int i = 0; i < cacheSize; ++i) {
            if (!keys[i].equals(j9ObjectPointer)) continue;
            ++hits;
            int n = i;
            counts[n] = counts[n] + 1;
            return values[i];
        }
        return null;
    }

    private static void setClassCache(J9ObjectPointer j9ObjectPointer, J9ClassPointer j9ClassPointer) {
        int n = counts[0];
        int n2 = 0;
        for (int i = 1; i < cacheSize; ++i) {
            if (counts[i] >= n) continue;
            n = counts[i];
            n2 = i;
        }
        J9ObjectHelper.keys[n2] = j9ObjectPointer;
        J9ObjectHelper.values[n2] = j9ClassPointer;
        J9ObjectHelper.counts[n2] = 1;
    }

    private static void initializeCache() {
        keys = new J9ObjectPointer[cacheSize];
        values = new J9ClassPointer[cacheSize];
        counts = new int[cacheSize];
        probes = 0L;
        hits = 0L;
        for (int i = 0; i < cacheSize; ++i) {
            J9ObjectHelper.keys[i] = J9ObjectPointer.NULL;
        }
    }

    public static byte getByteFromArrayByIndex(Object object, int n) {
        Class<?> clazz = object.getClass();
        if (clazz == byte[].class) {
            return ((byte[])object)[n];
        }
        if (clazz == char[].class) {
            char[] cArray = (char[])object;
            if (J9BuildFlags.J9VM_ENV_LITTLE_ENDIAN) {
                if (n % 2 == 1) {
                    return (byte)((cArray[n / 2] & 0xFF00) >>> 8);
                }
                return (byte)(cArray[n / 2] & 0xFF);
            }
            if (n % 2 == 1) {
                return (byte)(cArray[n / 2] & 0xFF);
            }
            return (byte)((cArray[n / 2] & 0xFF00) >>> 8);
        }
        throw new RuntimeException("Unknown array type for bit manipulation");
    }

    private static char getCharFromArrayByIndex(Object object, int n) {
        Class<?> clazz = object.getClass();
        if (clazz == byte[].class) {
            n <<= 1;
            byte[] byArray = (byte[])object;
            if (J9BuildFlags.J9VM_ENV_LITTLE_ENDIAN) {
                return (char)(J9ObjectHelper.byteToCharUnsigned(byArray[n + 1]) << 8 | J9ObjectHelper.byteToCharUnsigned(byArray[n]) << 0);
            }
            return (char)(J9ObjectHelper.byteToCharUnsigned(byArray[n + 1]) << 0 | J9ObjectHelper.byteToCharUnsigned(byArray[n]) << 8);
        }
        if (clazz == char[].class) {
            return ((char[])object)[n];
        }
        throw new RuntimeException("Unknown array type for bit manipulation");
    }

    private static char byteToCharUnsigned(byte by) {
        return (char)((char)by & 0xFF);
    }

    public static void reportClassCacheStats() {
        double d = (double)hits / (double)probes * 100.0;
        System.out.println("J9ObjectHelper probes: " + probes + " hit rate: " + d + "%");
        J9ObjectHelper.initializeCache();
    }

    static {
        block5: {
            cacheSize = 32;
            isStringBackedByByteArray = null;
            J9ObjectHelper.initializeCache();
            try {
                boolean bl = mixedReferenceMode = AlgorithmVersion.getVersionOf("MIXED_REFERENCE_MODE").getAlgorithmVersion() > 0;
                if (mixedReferenceMode) {
                    J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
                    try {
                        compressObjectReferences = j9JavaVMPointer.extendedRuntimeFlags2().anyBitsIn(J9Consts.J9_EXTENDED_RUNTIME2_COMPRESS_OBJECT_REFERENCES);
                        break block5;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        throw new RuntimeException(noSuchFieldException);
                    }
                }
                compressObjectReferences = J9BuildFlags.J9VM_GC_COMPRESSED_POINTERS;
            }
            catch (CorruptDataException corruptDataException) {
                throw new RuntimeException(corruptDataException);
            }
        }
    }
}

