/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.reflect;

import com.ibm.oti.vm.VM;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import sun.reflect.ConstantPool;

public class AnnotationParser {
    public static Annotation[] parseAnnotations(Field field) {
        return AnnotationParser.parseAnnotations(AnnotationParser.getAnnotationsData(field), field.getDeclaringClass());
    }

    public static Annotation[] parseAnnotations(Constructor constructor) {
        return AnnotationParser.parseAnnotations(AnnotationParser.getAnnotationsData(constructor), constructor.getDeclaringClass());
    }

    public static Annotation[] parseAnnotations(Method method) {
        return AnnotationParser.parseAnnotations(AnnotationParser.getAnnotationsData(method), method.getDeclaringClass());
    }

    public static Annotation[][] parseParameterAnnotations(Constructor constructor) {
        return AnnotationParser.parseParameterAnnotations(AnnotationParser.getParameterAnnotationsData(constructor), constructor.getDeclaringClass(), constructor.getParameterTypes().length);
    }

    public static Annotation[][] parseParameterAnnotations(Method method) {
        return AnnotationParser.parseParameterAnnotations(AnnotationParser.getParameterAnnotationsData(method), method.getDeclaringClass(), method.getParameterTypes().length);
    }

    public static byte[] getAnnotationsData(Class clazz) {
        byte[] byArray = null;
        if (null != clazz) {
            byArray = AnnotationParser.getAnnotationsDataImpl(clazz);
        }
        return byArray;
    }

    public static Object parseDefaultValue(Method method) {
        byte[] byArray = AnnotationParser.getDefaultValueData(method);
        if (byArray == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        Class<?> clazz = method.getDeclaringClass();
        Object object = VM.getVMLangAccess().getInternalConstantPoolFromClass(clazz);
        Class<Object> clazz2 = method.getReturnType();
        if (clazz2.isPrimitive()) {
            if (clazz2 == Boolean.TYPE) {
                clazz2 = Boolean.class;
            } else if (clazz2 == Character.TYPE) {
                clazz2 = Character.class;
            } else if (clazz2 == Byte.TYPE) {
                clazz2 = Byte.class;
            } else if (clazz2 == Short.TYPE) {
                clazz2 = Short.class;
            } else if (clazz2 == Integer.TYPE) {
                clazz2 = Integer.class;
            } else if (clazz2 == Long.TYPE) {
                clazz2 = Long.class;
            } else if (clazz2 == Float.TYPE) {
                clazz2 = Float.class;
            } else if (clazz2 == Double.TYPE) {
                clazz2 = Double.class;
            }
        }
        return sun.reflect.annotation.AnnotationParser.parseMemberValue(clazz2, byteBuffer, AnnotationParser.getConstantPool(object), clazz);
    }

    public static Annotation[] parseAnnotations(byte[] byArray, Class clazz) {
        Object object = VM.getVMLangAccess().getInternalConstantPoolFromClass(clazz);
        return sun.reflect.annotation.AnnotationParser.toArray(sun.reflect.annotation.AnnotationParser.parseAnnotations(byArray, AnnotationParser.getConstantPool(object), clazz));
    }

    private static native byte[] getAnnotationsData(Field var0);

    private static native byte[] getAnnotationsData(Constructor var0);

    private static native byte[] getAnnotationsData(Method var0);

    private static native byte[] getParameterAnnotationsData(Constructor var0);

    private static native byte[] getParameterAnnotationsData(Method var0);

    private static native byte[] getDefaultValueData(Method var0);

    static native ConstantPool getConstantPool(Object var0);

    private static native byte[] getAnnotationsDataImpl(Class var0);

    private static Annotation[][] parseParameterAnnotations(byte[] byArray, Class<?> clazz, int n) {
        if (byArray == null) {
            Annotation[][] annotationArray = new Annotation[n][];
            for (int i = 0; i < n; ++i) {
                annotationArray[i] = new Annotation[0];
            }
            return annotationArray;
        }
        Object object = VM.getVMLangAccess().getInternalConstantPoolFromClass(clazz);
        return sun.reflect.annotation.AnnotationParser.parseParameterAnnotations(byArray, AnnotationParser.getConstantPool(object), clazz);
    }
}

