/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders;

import com.ibm.j9ddr.corereaders.ILibraryResolver;
import com.ibm.j9ddr.corereaders.LibraryDataSource;
import com.ibm.j9ddr.corereaders.ZipFileResolver;
import com.ibm.j9ddr.libraries.CoreFileResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.stream.ImageInputStream;

public class LibraryResolverFactory {
    private static final Logger logger;
    public static final String LIBRARY_PATH_SYSTEM_PROPERTY = "com.ibm.j9ddr.library.path";
    public static final String PATH_MAPPING_SYSTEM_PROPERTY = "com.ibm.j9ddr.path.mapping";
    private static final String MAPPING_SEPERATOR = "=";
    public static final String RESOLVER_LIST_PROPERTY = "com.ibm.j9ddr.library.resolvers";
    private static final String RESOLVER_DEFAULT_ORDER;
    private static final List<File> libraryPath;
    private static final Map<String, String> pathMap;
    private static final List<Class<? extends ILibraryResolver>> resolverClasses;

    public static ILibraryResolver getResolverForCoreFile(ImageInputStream imageInputStream) {
        LinkedList<ILibraryResolver> linkedList = new LinkedList<ILibraryResolver>();
        for (Class<? extends ILibraryResolver> clazz : resolverClasses) {
            try {
                Constructor<? extends ILibraryResolver> constructor = clazz.getConstructor(ImageInputStream.class);
                linkedList.add(constructor.newInstance(imageInputStream));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Skipping Library resolver class: {0} as it does not support an ImageInputStream constructor", new Object[]{clazz.getName()});
            }
            catch (Exception exception) {
                logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Failed to create instance of Library resolver class: {0}", new Object[]{clazz.getName()});
            }
        }
        return new DelegatingLibraryPathResolver(linkedList);
    }

    public static ILibraryResolver getResolverForCoreFile(File file) {
        LinkedList<ILibraryResolver> linkedList = new LinkedList<ILibraryResolver>();
        for (Class<? extends ILibraryResolver> clazz : resolverClasses) {
            try {
                Constructor<? extends ILibraryResolver> constructor = clazz.getConstructor(File.class);
                linkedList.add(constructor.newInstance(file));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Skipping Library resolver class: {0} as it does not support a File constructor", new Object[]{clazz.getName()});
            }
            catch (Exception exception) {
                logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Failed to create instance of Library resolver class: {0}", new Object[]{clazz.getName()});
            }
        }
        return new DelegatingLibraryPathResolver(linkedList);
    }

    private static String stripPath(String string) {
        File file = new File(string);
        return file.getName();
    }

    private static String mapPath(String string) {
        if (pathMap.isEmpty()) {
            return string;
        }
        for (Map.Entry<String, String> entry : pathMap.entrySet()) {
            string = string.replace(entry.getKey(), entry.getValue());
        }
        return string;
    }

    static {
        Object object;
        String[] stringArray;
        logger = Logger.getLogger("j9ddr.core_readers");
        RESOLVER_DEFAULT_ORDER = LibraryPathResolver.class.getName() + "," + CoreFileResolver.class.getName() + "," + NextToCoreResolver.class.getName() + "," + InPlaceResolver.class.getName() + "," + ZipFileResolver.class.getName();
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(LibraryResolverFactory.LIBRARY_PATH_SYSTEM_PROPERTY);
            }
        });
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(LibraryResolverFactory.PATH_MAPPING_SYSTEM_PROPERTY);
            }
        });
        String string3 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(LibraryResolverFactory.RESOLVER_LIST_PROPERTY, RESOLVER_DEFAULT_ORDER);
            }
        });
        String string4 = File.pathSeparator;
        LinkedList<File> linkedList = new LinkedList<File>();
        if (string != null) {
            logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Library search path set as: {0} by property {1}", new Object[]{string, LIBRARY_PATH_SYSTEM_PROPERTY});
            stringArray = string.split(string4);
            object = stringArray;
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                String string5 = object[i];
                linkedList.add(new File(string5));
            }
        } else {
            logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "No library search path set. Falling back on defaults");
        }
        stringArray = new HashMap();
        if (string2 != null) {
            logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Library path mappings paths set as: {0} by property {1}", new Object[]{string, PATH_MAPPING_SYSTEM_PROPERTY});
            for (String string6 : object = string2.split(string4)) {
                Object[] objectArray = string6.split(MAPPING_SEPERATOR);
                stringArray.put(objectArray[0], objectArray[1]);
                logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Mapping libraries paths containing {0} to {1}", objectArray);
            }
        } else {
            logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "No library path mappings set. Falling back on defaults");
        }
        object = new LinkedList();
        logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Library resolver search order: {0}", new Object[]{string3});
        for (String string6 : string3.split(",")) {
            try {
                object.add(Class.forName(string6).asSubclass(ILibraryResolver.class));
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Failed to find Library resolver class: {0}", new Object[]{string6});
            }
        }
        libraryPath = Collections.unmodifiableList(linkedList);
        pathMap = Collections.unmodifiableMap(stringArray);
        resolverClasses = Collections.unmodifiableList(object);
    }

    private static abstract class BaseResolver
    implements ILibraryResolver {
        private BaseResolver() {
        }

        protected static String normalise(String string, String string2) {
            int n;
            String[] stringArray = string.split(string2);
            if (1 >= stringArray.length) {
                return string;
            }
            int n2 = n = stringArray.length - 1;
            String string3 = new String();
            while (n >= 0) {
                if (stringArray[n2].equals("..")) {
                    --n;
                } else if (!stringArray[n2].equals(".")) {
                    string3 = string2 + stringArray[n] + string3;
                }
                --n2;
                --n;
            }
            if (string3.startsWith(string2)) {
                string3 = string3.substring(string2.length());
            }
            return string3;
        }

        @Override
        public LibraryDataSource getLibrary(String string) throws FileNotFoundException {
            return this.getLibrary(string, false);
        }

        @Override
        public void dispose() {
        }
    }

    private static final class InPlaceResolver
    extends BaseResolver
    implements ILibraryResolver {
        public InPlaceResolver(File file) {
        }

        @Override
        public LibraryDataSource getLibrary(String string, boolean bl) throws FileNotFoundException {
            File file = new File(LibraryResolverFactory.mapPath(string));
            logger.logp(Level.FINER, "LibraryResolverFactory$InPlaceResolver", "getLibrary", "Looking for {0}.", file);
            if (file.isFile()) {
                logger.logp(Level.FINER, "LibraryResolverFactory$InPlaceResolver", "getLibrary", "Found {0}.", file);
                return new LibraryDataSource(file);
            }
            logger.logp(Level.FINER, "LibraryResolverFactory$InPlaceResolver", "getLibrary", "Can't find " + string + " on disk");
            throw new FileNotFoundException("Can't find " + string + " on disk");
        }
    }

    private static final class NextToCoreResolver
    extends BaseResolver
    implements ILibraryResolver {
        private final File coreDirectory;

        public NextToCoreResolver(File file) {
            this.coreDirectory = file.getAbsoluteFile().getParentFile();
        }

        private boolean isAbsolutePath(String string) {
            if (null == string || string.length() == 0) {
                return false;
            }
            if (string.length() == 1) {
                return string.charAt(0) == '/';
            }
            return string.charAt(0) == '/' || string.charAt(1) == ':';
        }

        private File findFile(File file, String[] stringArray, int n) {
            File[] fileArray = file.listFiles();
            File file2 = null;
            for (int i = 0; fileArray != null && i < fileArray.length && null == file2; ++i) {
                File file3 = fileArray[i];
                if (file3.getName().equals(stringArray[n])) {
                    if (++n == stringArray.length) {
                        return file3;
                    }
                    if (!file3.isDirectory()) continue;
                    file2 = this.findFile(file3, stringArray, n);
                    continue;
                }
                if (!file3.isDirectory()) continue;
                file2 = this.findFile(file3, stringArray, 0);
            }
            return file2;
        }

        @Override
        public LibraryDataSource getLibrary(String string, boolean bl) throws FileNotFoundException {
            File[] fileArray;
            String string2;
            String[] stringArray;
            File file;
            String string3;
            String string4 = LibraryResolverFactory.stripPath(string);
            String string5 = null;
            if (string.indexOf(47) == -1) {
                if (string.indexOf(92) != -1) {
                    string5 = "\\\\";
                }
            } else {
                string5 = "/";
            }
            String string6 = string3 = string5 == null ? string : NextToCoreResolver.normalise(string, string5);
            if (!this.isAbsolutePath(string3) && string5 != null && (file = this.findFile(this.coreDirectory, stringArray = string3.split(string5), 0)) != null) {
                string2 = file.getAbsolutePath();
                string3 = string2.substring(this.coreDirectory.getAbsolutePath().length() + 1, string2.length());
            }
            stringArray = new File(this.coreDirectory, string4);
            file = new File(this.coreDirectory, string3);
            string2 = file.getName();
            for (File file2 : fileArray = new File[]{file, stringArray}) {
                File file3 = file2.getParentFile();
                if (file3 == null || !file3.isDirectory()) continue;
                logger.logp(Level.FINER, "LibraryResolverFactory$NextToCoreResolver", "getLibrary", "Trying {0}.", file2);
                String[] stringArray2 = file3.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.equalsIgnoreCase(string2) && new File(file, string).isFile();
                    }
                });
                if (stringArray2 == null || stringArray2.length == 0) continue;
                String string7 = null;
                for (String string8 : stringArray2) {
                    if (string8.equals(string2)) {
                        File file4 = new File(file3, string8);
                        logger.logp(Level.FINER, "LibraryResolverFactory$NextToCoreResolver", "getLibrary", "Found {0}.", file4);
                        return new LibraryDataSource(file4);
                    }
                    if (!string8.equalsIgnoreCase(string2)) continue;
                    string7 = string8;
                }
                if (string7 == null) continue;
                logger.logp(Level.SEVERE, "LibraryResolverFactory$NextToCoreResolver", "getLibrary", "Found {0} but not {1} in {2}. Case sensitive files may been copied to a case insensitive file system causing {1} to be lost or overwritten by {0}.", new String[]{string7, string2, file2.getParent()});
            }
            throw new FileNotFoundException("Can't find " + string4 + " in directory " + this.coreDirectory.getAbsolutePath());
        }
    }

    private static final class LibraryPathResolver
    extends BaseResolver
    implements ILibraryResolver {
        public LibraryPathResolver(File file) {
        }

        @Override
        public LibraryDataSource getLibrary(String string, boolean bl) throws FileNotFoundException {
            if (libraryPath.isEmpty()) {
                throw new FileNotFoundException("No library paths set.");
            }
            String string2 = LibraryResolverFactory.stripPath(string);
            logger.logp(Level.FINER, "LibraryResolverFactory$LibraryPathResolver", "getLibrary", "Looking for {0} in library path.", string2);
            for (File file : libraryPath) {
                File file2;
                if (file.isDirectory()) {
                    logger.logp(Level.FINEST, "LibraryResolverFactory$LibraryPathResolver", "getLibrary", "Looking in directory {0}.", file);
                    file2 = new File(file, string);
                    File file3 = new File(file, string2);
                    if (file2.isFile()) {
                        logger.logp(Level.FINER, "LibraryResolverFactory$LibraryPathResolver", "getLibrary", "Found {0} in directory {1}.", new Object[]{string2, file});
                        return new LibraryDataSource(file2);
                    }
                    if (!file3.isFile()) continue;
                    logger.logp(Level.FINER, "LibraryResolverFactory$LibraryPathResolver", "getLibrary", "Found {0} in directory {1}.", new Object[]{string2, file});
                    return new LibraryDataSource(file3);
                }
                logger.logp(Level.FINEST, "LibraryResolverFactory$LibraryPathResolver", "getLibrary", "Looking in file {0}.", file);
                file2 = this.readArchive(file, string, string2);
                if (file2 == null) continue;
                logger.logp(Level.FINER, "LibraryResolverFactory$LibraryPathResolver", "getLibrary", "Found {0} in zip file {1}.", new Object[]{string2, file});
                return new LibraryDataSource(file2);
            }
            logger.logp(Level.FINER, "LibraryResolverFactory$LibraryPathResolver", "getLibrary", "{0} not found in library path.", string2);
            throw new FileNotFoundException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private File readArchive(File file, String string, String string2) {
            try (ZipFile zipFile = new ZipFile(file);){
                Object object;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                Object object2 = null;
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (((ZipEntry)object).getName().equals(string)) {
                        object2 = object;
                        break;
                    }
                    if (!LibraryResolverFactory.stripPath(((ZipEntry)object).getName()).equals(string2)) continue;
                    object2 = object;
                }
                if (object2 != null) {
                    object = this.extractEntry((ZipEntry)object2, string2, zipFile);
                    return object;
                }
                object = null;
                return object;
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, "LibraryResolverFactory$LibraryPathResolver", "readArchive", "Problems reading " + file + " as a zip file", exception);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        private File extractEntry(ZipEntry zipEntry, String string, ZipFile zipFile) throws FileNotFoundException {
            try {
                File file = File.createTempFile(string, ".j9ddrlib");
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                try {
                    File file2;
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    try {
                        int n;
                        file.deleteOnExit();
                        byte[] byArray = new byte[4096];
                        while ((n = inputStream.read(byArray)) != -1) {
                            ((OutputStream)fileOutputStream).write(byArray, 0, n);
                        }
                        file2 = file;
                    }
                    catch (Throwable throwable) {
                        try {
                            ((OutputStream)fileOutputStream).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return file2;
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException iOException) {
                logger.logp(Level.WARNING, "LibraryResolverFactory$LibraryPathResolver", "extractEntry", "IOException trying to extract " + zipEntry.getName() + " from " + zipFile.getName(), iOException);
                return null;
            }
        }
    }

    private static final class DelegatingLibraryPathResolver
    extends BaseResolver
    implements ILibraryResolver {
        private final List<ILibraryResolver> resolvers;

        public DelegatingLibraryPathResolver(List<ILibraryResolver> list) {
            this.resolvers = list;
        }

        @Override
        public LibraryDataSource getLibrary(String string, boolean bl) throws FileNotFoundException {
            for (ILibraryResolver iLibraryResolver : this.resolvers) {
                try {
                    return iLibraryResolver.getLibrary(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
            if (!bl) {
                logger.logp(Level.FINER, "LibraryResolverFactory", "getLibrary", "Couldn't find shared library " + string + ". Some data may be unavailable.");
            }
            throw new FileNotFoundException();
        }

        @Override
        public void dispose() {
            for (ILibraryResolver iLibraryResolver : this.resolvers) {
                iLibraryResolver.dispose();
            }
        }
    }
}

