/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.util;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class PatternString
implements Serializable {
    private static final long serialVersionUID = 3257289149408162611L;
    private boolean isRegularString;
    private boolean alwaysMatches;
    final String pattern;
    final String[] tokens;
    public static final char wildCard = '*';
    public static final char singleCharWildCard = '?';
    private static int[] nullArray = new int[0];
    public static final PatternString ALWAYS_MATCHES = new PatternString(String.valueOf('*'));
    private MatchState savedState = new MatchState();

    public PatternString(String string) {
        this.pattern = string;
        if (string.equals(String.valueOf('*'))) {
            this.alwaysMatches = true;
            this.tokens = null;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf('*') + '?', true);
        LinkedList<String> linkedList = new LinkedList<String>();
        this.isRegularString = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.isRegularString) {
                switch (string2.charAt(0)) {
                    case '*': 
                    case '?': {
                        this.isRegularString = false;
                    }
                }
            }
            linkedList.add(string2);
        }
        this.tokens = linkedList.toArray(new String[linkedList.size()]);
    }

    int indexOfWildcard() {
        if (this.isRegularString) {
            return -1;
        }
        if (this.alwaysMatches) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.tokens.length; ++i) {
            String string = this.tokens[i];
            switch (string.charAt(0)) {
                case '*': 
                case '?': {
                    return n;
                }
            }
            n += string.length();
        }
        return -1;
    }

    public PatternStringPair split(int n) {
        char c = this.pattern.charAt(n);
        if (c == '*') {
            return new PatternStringPair(this.pattern.substring(0, n + 1), this.pattern.substring(n));
        }
        return new PatternStringPair(this.pattern.substring(0, n), this.pattern.substring(n + 1));
    }

    public int[] indexOf(int n) {
        int n2;
        int[] nArray = new int[this.pattern.length()];
        int n3 = this.pattern.indexOf(n);
        if (n3 == -1) {
            n2 = this.findAdditionalLocations(nArray, this.pattern, n, true);
        } else {
            n2 = this.findAdditionalLocations(nArray, this.pattern.substring(0, n3), n, true);
            nArray[n2++] = n3;
        }
        if (n2 == 0) {
            return nullArray;
        }
        if (n2 == this.pattern.length()) {
            return nArray;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    private int findAdditionalLocations(int[] nArray, String string, int n, boolean bl) {
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            int n4 = bl ? i : n3 - i - 1;
            char c = string.charAt(n4);
            if (c != '*' && c != '?') continue;
            nArray[n2++] = n4;
        }
        return n2;
    }

    public int[] lastIndexOf(int n) {
        int n2;
        int n3 = this.pattern.length();
        int[] nArray = new int[n3];
        int n4 = this.pattern.lastIndexOf(n);
        if (n4 == -1) {
            n2 = this.findAdditionalLocations(nArray, this.pattern, n, false);
        } else {
            int n5 = n4 + 1;
            n2 = this.findAdditionalLocations(nArray, this.pattern.substring(n5), n, false);
            int n6 = 0;
            while (n6 < n2) {
                int n7 = n6++;
                nArray[n7] = nArray[n7] + n5;
            }
            nArray[n2++] = n4;
        }
        if (n2 == 0) {
            return nullArray;
        }
        if (n2 == n3) {
            return nArray;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public boolean isRegularString() {
        return this.isRegularString;
    }

    public static boolean isWildcard(char c) {
        return c == '*' || c == '?';
    }

    public boolean endsWith(String string) {
        String string2 = new StringBuffer(this.pattern).reverse().toString();
        String string3 = new StringBuffer(string).reverse().toString();
        return new PatternString(string2).startsWith(string3);
    }

    public boolean isMatch(String string) {
        return this.alwaysMatches || (this.isRegularString ? this.pattern.equals(string) : this.isMatch(string, false));
    }

    public boolean startsWith(String string) {
        return this.alwaysMatches || (this.isRegularString ? this.pattern.startsWith(string) : this.isMatch(string, true));
    }

    private boolean isMatch(String string, boolean bl) {
        this.savedState.reset();
        return this.isMatch(string, 0, bl, 0, this.savedState);
    }

    private boolean isMatch(String string, int n, boolean bl, int n2, MatchState matchState) {
        for (int i = n2; i < this.tokens.length; ++i) {
            int n3;
            if (bl && matchState.matchesRemainder(string, n)) {
                return true;
            }
            String string2 = this.tokens[i];
            char c = string2.charAt(0);
            if (PatternString.isWildcard(c)) {
                matchState.matchWildcard(string2.charAt(0));
                continue;
            }
            int n4 = matchState.matchToken(string, n, n, string2);
            if (n4 < 0) {
                if (bl) {
                    return matchState.startsWithRemainder(string, n, string2);
                }
                return false;
            }
            int n5 = n4 + 1;
            while ((n3 = matchState.matchToken(string, n, n5, string2)) >= 0) {
                MatchState matchState2 = (MatchState)matchState.clone();
                matchState2.reset();
                if (this.isMatch(string, n3 + string2.length(), bl, i + 1, matchState2)) {
                    return true;
                }
                n5 = n3 + 1;
            }
            matchState.reset();
            n = n4 + string2.length();
        }
        return matchState.matchesRemainder(string, n);
    }

    public String toString() {
        return this.pattern;
    }

    class MatchState
    implements Cloneable {
        boolean onWildCard;
        boolean onSingleCharWildCard;
        int numChars;

        MatchState() {
        }

        void reset() {
            this.onSingleCharWildCard = false;
            this.onWildCard = false;
            this.numChars = 0;
        }

        boolean matchesRemainder(String string, int n) {
            return string.length() == n + this.numChars || this.onWildCard && string.length() >= n + this.numChars;
        }

        void matchWildcard(char c) {
            switch (c) {
                case '*': {
                    this.onWildCard = true;
                    return;
                }
                case '?': {
                    this.onSingleCharWildCard = true;
                    ++this.numChars;
                    return;
                }
            }
        }

        boolean startsWithRemainder(String string, int n, String string2) {
            String string3 = string.substring(n + this.numChars);
            return string2.startsWith(string3);
        }

        int matchToken(String string, int n, int n2, String string2) {
            int n3;
            if (this.onSingleCharWildCard) {
                n2 = Math.max(n + this.numChars, n2);
            }
            if ((n3 = string.indexOf(string2, n2)) < 0) {
                return -1;
            }
            switch (n3 - n) {
                default: {
                    if (this.onWildCard || this.onSingleCharWildCard && n + this.numChars == n3) break;
                    return -1;
                }
                case 0: 
            }
            return n3;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    public static class PatternStringPair {
        public final PatternString first;
        public final PatternString second;

        PatternStringPair(PatternString patternString, PatternString patternString2) {
            this.first = patternString;
            this.second = patternString2;
        }

        PatternStringPair(String string, String string2) {
            this(new PatternString(string), new PatternString(string2));
        }
    }
}

