/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ClassSummaryHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.LinearDumper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.RamClassWalker;
import java.io.PrintStream;

public class RamClassSummaryCommand
extends Command {
    private long numberOfClasses;
    private final String[] preferredOrder = new String[]{"jitVTables", "ramHeader", "vTable", "Extended method block", "RAM methods", "Constant Pool", "Ram static", "Superclasses", "InstanceDescription", "iTable"};

    public RamClassSummaryCommand() {
        this.addCommand("ramclasssummary", "", "Display ram class summary");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            ClassSummaryHelper classSummaryHelper = new ClassSummaryHelper(this.preferredOrder);
            ClassSegmentIterator classSegmentIterator = new ClassSegmentIterator(j9JavaVMPointer.classMemorySegments());
            while (classSegmentIterator.hasNext()) {
                J9ClassPointer j9ClassPointer = (J9ClassPointer)classSegmentIterator.next();
                ++this.numberOfClasses;
                RamClassWalker ramClassWalker = new RamClassWalker(j9ClassPointer, context);
                LinearDumper linearDumper = new LinearDumper();
                LinearDumper.J9ClassRegionNode j9ClassRegionNode = linearDumper.getAllRegions(ramClassWalker);
                classSummaryHelper.addRegionsForClass(j9ClassRegionNode);
            }
            classSummaryHelper.printStatistics(printStream);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    public long getNumberOfClasses() {
        return this.numberOfClasses;
    }
}

