/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DTFJException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageRegister;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageStackFrame;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.MonitorState;
import com.ibm.jvm.dtfjview.commands.helpers.StateToString;
import com.ibm.jvm.dtfjview.commands.helpers.ThreadData;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoThreadCommand
extends BaseJdmpviewCommand {
    private int _pointerSize;
    private boolean _is_zOS = false;
    private Map<JavaThread, MonitorState> monitors = new HashMap<JavaThread, MonitorState>();
    private long lastRTAddress = 0L;
    private static final String JAVA_LANG_THREAD_CLASS = "java/lang/Thread";

    public InfoThreadCommand() {
        this.addCommand("info thread", "[<native thread ID>|<zOS TCB>|all|*]", "Displays information about Java and native threads");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        try {
            long l = this.ctx.getRuntime().getJavaVM().getAddress();
            if (l != this.lastRTAddress) {
                this.lastRTAddress = l;
                this.monitors = new HashMap<JavaThread, MonitorState>();
            }
        }
        catch (Exception exception) {
            this.logger.fine("Error getting address of the JVM, cannot use cached monitor values. No JVM in process?");
            this.logger.log(Level.FINEST, "Error getting address of the JVM", exception);
            this.monitors = new HashMap<JavaThread, MonitorState>();
        }
        if (this.monitors.isEmpty() && this.ctx.getRuntime() != null) {
            this.getMonitors(this.ctx.getRuntime());
        }
        this.doCommand(stringArray);
    }

    public void doCommand(String[] stringArray) {
        try {
            this._is_zOS = this.ctx.getImage().getSystemType().toLowerCase().contains("z/os");
        }
        catch (DataUnavailable dataUnavailable) {
            this.out.print(Exceptions.getDataUnavailableString());
        }
        catch (CorruptDataException corruptDataException) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
        }
        String string = null;
        switch (stringArray.length) {
            case 0: {
                try {
                    ImageThread imageThread = this.ctx.getProcess().getCurrentThread();
                    if (null == imageThread) {
                        this.out.println();
                        this.out.println("No current (failing) thread, try specifying a native thread ID, \"all\" or \"*\"");
                        ImageProcess imageProcess = this.ctx.getProcess();
                        if (imageProcess != null) {
                            this.printThreadSummary(imageProcess);
                        }
                        return;
                    }
                    string = imageThread.getID();
                    break;
                }
                catch (CorruptDataException corruptDataException) {
                    this.out.println("exception encountered while getting information about current thread");
                    return;
                }
            }
            case 1: {
                string = stringArray[0];
                if (!"ALL".equalsIgnoreCase(string) && !"*".equals(string)) break;
                string = null;
                break;
            }
            default: {
                this.out.println("\"info thread\" takes at most one parameter, which, if specified, must be a native thread ID or \"all\" or \"*\"");
                return;
            }
        }
        this.printAddressSpaceInfo(string, this.getJavaThreads(string));
    }

    private void printAddressSpaceInfo(String string, Map<String, List<ThreadData>> map) {
        if (string == null) {
            this.out.println("native threads for address space");
        }
        this.printProcessInfo(string, map);
        if (!map.isEmpty()) {
            this.out.println("Java threads not associated with known native threads:");
            this.out.println();
            List<ThreadData> list = map.remove(null);
            if (list != null) {
                for (ThreadData object : list) {
                    this.printJavaThreadInfo(object.getThread(), false);
                }
            }
            for (List list2 : map.values()) {
                for (ThreadData threadData : list2) {
                    this.printJavaThreadInfo(threadData.getThread(), false);
                }
            }
        }
    }

    private void printProcessInfo(String string, Map<String, List<ThreadData>> map) {
        ImageProcess imageProcess = this.ctx.getProcess();
        this._pointerSize = imageProcess.getPointerSize();
        this.out.print(" process id: ");
        try {
            this.out.print(imageProcess.getID());
        }
        catch (DataUnavailable dataUnavailable) {
            this.out.print(Exceptions.getDataUnavailableString());
        }
        catch (CorruptDataException corruptDataException) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
        }
        this.out.println();
        this.out.println();
        boolean bl = this.printThreadInfo(string, map);
        if (!bl) {
            this.out.println(" no native threads found with specified id");
            this.out.println();
        }
    }

    private boolean printThreadInfo(String string, Map<String, List<ThreadData>> map) {
        boolean bl = false;
        Iterator iterator = this.ctx.getProcess().getThreads();
        while (iterator.hasNext()) {
            Object object;
            Object e = iterator.next();
            if (e instanceof CorruptData) {
                this.out.println();
                this.out.print("  <corrupt data>");
                continue;
            }
            ImageThread imageThread = (ImageThread)e;
            String string2 = null;
            String string3 = null;
            try {
                string2 = imageThread.getID();
                if (this._is_zOS) {
                    string3 = imageThread.getProperties().getProperty("TCB");
                }
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
            if (null != string && !string.equalsIgnoreCase(string2) && !string.equalsIgnoreCase(string3)) continue;
            this.out.print("  thread id: ");
            this.out.println(string2);
            this.printRegisters(imageThread);
            this.out.println("   native stack sections:");
            Iterator iterator2 = imageThread.getStackSections();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                if (object instanceof CorruptData) {
                    this.out.println("    " + Exceptions.getCorruptDataExceptionString());
                    continue;
                }
                ImageSection imageSection = (ImageSection)object;
                this.printStackSection(imageSection);
            }
            this.printStackFrameInfo(imageThread);
            this.out.println("   properties:");
            this.printProperties(imageThread);
            this.out.print("   associated Java thread: ");
            object = map.remove(string2);
            if (null == object || object.isEmpty()) {
                this.out.println("<no associated Java thread>");
            } else {
                this.out.println();
                this.printJavaThreadInfo(((ThreadData)object.get(0)).getThread(), true);
            }
            this.out.println();
            bl = true;
        }
        return bl;
    }

    public void printRegisters(ImageThread imageThread) {
        this.out.print("   registers:");
        int n = 0;
        Iterator iterator = imageThread.getRegisters();
        while (iterator.hasNext()) {
            if (n % 4 == 0) {
                this.out.println();
                this.out.print(" ");
            }
            this.out.print("   ");
            ImageRegister imageRegister = (ImageRegister)iterator.next();
            this.printRegisterInfo(imageRegister);
            ++n;
        }
        this.out.println();
    }

    public void printRegisterInfo(ImageRegister imageRegister) {
        this.out.print(Utils.padWithSpaces(imageRegister.getName(), 6) + " = ");
        try {
            BigInteger bigInteger;
            int n;
            Number number = imageRegister.getValue();
            if (number instanceof BigInteger && (n = (bigInteger = (BigInteger)number).bitLength()) > 64) {
                int n2 = (n - 1 | 0x3F) + 1;
                this.out.print("0x" + Utils.padWithZeroes(bigInteger.toString(16), n2 / 4));
                return;
            }
            long l = number.longValue();
            if (this._pointerSize > 32) {
                this.out.print("0x" + Utils.toFixedWidthHex(l));
            } else if (this._is_zOS) {
                this.out.print("0x" + Utils.toFixedWidthHex((int)(l >> 32)) + "_" + Utils.toFixedWidthHex((int)l));
            } else {
                this.out.print("0x" + Utils.toFixedWidthHex((int)l));
            }
        }
        catch (CorruptDataException corruptDataException) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
        }
    }

    public void printStackSection(ImageSection imageSection) {
        long l = imageSection.getBaseAddress().getAddress();
        long l2 = imageSection.getSize();
        long l3 = l + l2;
        this.out.print("    ");
        this.out.print(Utils.toHex(l));
        this.out.print(" to ");
        this.out.print(Utils.toHex(l3));
        this.out.print(" (length ");
        this.out.print(Utils.toHex(l2));
        this.out.println(")");
    }

    private void printStackFrameInfo(ImageThread imageThread) {
        Iterator iterator;
        try {
            iterator = imageThread.getStackFrames();
        }
        catch (DataUnavailable dataUnavailable) {
            this.out.println("   native stack frames: " + Exceptions.getDataUnavailableString());
            return;
        }
        this.out.println("   native stack frames:");
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CorruptData) {
                this.out.println("    <corrupt stack frame: " + ((CorruptData)e).toString() + ">");
                continue;
            }
            ImageStackFrame imageStackFrame = (ImageStackFrame)e;
            this.out.print("    bp: ");
            try {
                this.out.print(this.toAdjustedHex(imageStackFrame.getBasePointer().getAddress()));
            }
            catch (CorruptDataException corruptDataException) {
                if (this.getArtifactType() == BaseJdmpviewCommand.ArtifactType.javacore) {
                    this.out.print(Exceptions.getDataUnavailableString());
                }
                this.out.print(Exceptions.getCorruptDataExceptionString());
            }
            this.out.print(" pc: ");
            try {
                this.out.print(this.toAdjustedHex(imageStackFrame.getProcedureAddress().getAddress()));
            }
            catch (CorruptDataException corruptDataException) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
            }
            this.out.print(" ");
            try {
                this.out.print(imageStackFrame.getProcedureName());
            }
            catch (CorruptDataException corruptDataException) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
            }
            this.out.println();
        }
    }

    private Map<String, List<ThreadData>> getJavaThreads(String string) {
        HashMap<String, List<ThreadData>> hashMap = new HashMap<String, List<ThreadData>>();
        JavaRuntime javaRuntime = this.ctx.getRuntime();
        if (javaRuntime instanceof JavaRuntime) {
            JavaRuntime javaRuntime2 = javaRuntime;
            Iterator iterator = javaRuntime2.getThreads();
            while (iterator.hasNext()) {
                Object object;
                Object e = iterator.next();
                if (e instanceof CorruptData) continue;
                JavaThread javaThread = (JavaThread)e;
                String string2 = null;
                String string3 = null;
                try {
                    object = javaThread.getImageThread();
                    string2 = object.getID();
                    if (this._is_zOS) {
                        string3 = object.getProperties().getProperty("TCB");
                    }
                }
                catch (DTFJException dTFJException) {
                    // empty catch block
                }
                if (null != string && !string.equalsIgnoreCase(string2) && !string.equalsIgnoreCase(string3)) continue;
                object = (List)hashMap.get(string2);
                if (object == null) {
                    object = new ArrayList(1);
                    hashMap.put(string2, (List<ThreadData>)object);
                }
                object.add(new ThreadData(javaThread, javaRuntime2));
            }
        }
        return hashMap;
    }

    private void getMonitors(JavaRuntime javaRuntime) {
        Object object;
        int n = 0;
        int n2 = 0;
        Iterator iterator = javaRuntime.getMonitors();
        while (iterator.hasNext()) {
            Object object2;
            Object object3;
            object = iterator.next();
            if (object instanceof CorruptData) {
                ++n2;
                continue;
            }
            JavaMonitor javaMonitor = (JavaMonitor)object;
            Iterator iterator2 = javaMonitor.getEnterWaiters();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                if (object instanceof CorruptData) {
                    ++n;
                    continue;
                }
                object3 = (JavaThread)object;
                this.monitors.put((JavaThread)object3, new MonitorState(javaMonitor, MonitorState.WAITING_TO_ENTER));
            }
            if (n > 0) {
                object3 = String.format("Warning : %d corrupt thread(s) were found waiting to enter monitor %s", n, InfoThreadCommand.getMonitorName(javaMonitor));
                this.logger.fine((String)object3);
            }
            n = 0;
            object3 = javaMonitor.getNotifyWaiters();
            while (object3.hasNext()) {
                object = object3.next();
                if (object instanceof CorruptData) {
                    ++n;
                    continue;
                }
                object2 = (JavaThread)object;
                this.monitors.put((JavaThread)object2, new MonitorState(javaMonitor, MonitorState.WAITING_TO_BE_NOTIFIED_ON));
            }
            if (n <= 0) continue;
            object2 = String.format("Warning : %d corrupt thread(s) were found waiting to be notified on monitor %s", n, InfoThreadCommand.getMonitorName(javaMonitor));
            this.logger.fine((String)object2);
        }
        if (n2 > 0) {
            object = String.format("Warning : %d corrupt monitor(s) were found", n2);
            this.logger.fine((String)object);
        }
    }

    private static String getMonitorName(JavaMonitor javaMonitor) {
        try {
            return javaMonitor.getName();
        }
        catch (CorruptDataException corruptDataException) {
            return "<corrupt monitor name>";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printJavaThreadInfo(JavaThread javaThread, boolean bl) {
        Object object;
        block40: {
            this.out.print("    name:          ");
            try {
                this.out.print(javaThread.getName());
            }
            catch (CorruptDataException corruptDataException) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), corruptDataException);
            }
            this.out.println();
            if (!bl) {
                try {
                    if (javaThread.getImageThread() != null) {
                        this.out.print("    id:            ");
                        this.out.print(javaThread.getImageThread().getID());
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    this.out.print(Exceptions.getCorruptDataExceptionString());
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), corruptDataException);
                }
                catch (DataUnavailable dataUnavailable) {
                    this.out.print(Exceptions.getDataUnavailableString());
                    this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), dataUnavailable);
                }
                finally {
                    this.out.println();
                }
            }
            this.out.print("    Thread object: ");
            try {
                object = javaThread.getObject();
                if (null == object) {
                    this.out.print("<no associated Thread object>");
                    break block40;
                }
                try {
                    JavaClass javaClass = object.getJavaClass();
                    String string = javaClass.getName();
                    if (string != null) {
                        this.out.print(string + " @ ");
                    }
                    this.out.print(Utils.toHex(object.getID().getAddress()));
                    while (javaClass != null && !JAVA_LANG_THREAD_CLASS.equals(javaClass.getName())) {
                        javaClass = javaClass.getSuperclass();
                    }
                    if (javaClass != null) {
                        Iterator iterator = javaClass.getDeclaredFields();
                        boolean bl2 = false;
                        while (iterator.hasNext()) {
                            JavaField javaField = (JavaField)iterator.next();
                            switch (javaField.getName()) {
                                case "uniqueId": 
                                case "tid": {
                                    if (bl2) break;
                                    this.out.println();
                                    this.out.print("    ID:            " + Utils.getVal((JavaObject)object, javaField));
                                    bl2 = true;
                                    break;
                                }
                                case "isDaemon": {
                                    this.out.println();
                                    this.out.print("    Daemon:        " + Utils.getVal((JavaObject)object, javaField));
                                    break;
                                }
                                case "threadRef": {
                                    try {
                                        String string2 = Utils.toHex(javaField.getLong((JavaObject)object));
                                        this.out.println();
                                        this.out.print("    Native info:   !j9vmthread " + string2 + "  !stack " + string2);
                                    }
                                    catch (MemoryAccessException memoryAccessException) {}
                                    break;
                                }
                            }
                        }
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    this.out.print(" <in-flight or corrupt data encountered>");
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), corruptDataException);
                }
            }
            catch (CorruptDataException corruptDataException) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), corruptDataException);
            }
        }
        this.out.println();
        this.out.print("    Priority:      ");
        try {
            object = javaThread.getPriority();
            this.out.print(((Integer)object).toString());
        }
        catch (CorruptDataException corruptDataException) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
            this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), corruptDataException);
        }
        this.out.println();
        this.out.print("    Thread.State:  ");
        try {
            this.out.print(StateToString.getThreadStateString(javaThread.getState()));
        }
        catch (CorruptDataException corruptDataException) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
            this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), corruptDataException);
        }
        this.out.println();
        this.out.print("    JVMTI state:   ");
        try {
            this.out.print(StateToString.getJVMTIStateString(javaThread.getState()));
        }
        catch (CorruptDataException corruptDataException) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
            this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), corruptDataException);
        }
        this.out.println();
        this.printThreadBlocker(javaThread);
        this.out.print("    Java stack frames: ");
        this.printJavaStackFrameInfo(javaThread);
        this.out.println();
    }

    private void printThreadBlocker(JavaThread javaThread) {
        try {
            String string;
            String string2;
            Object object;
            if ((javaThread.getState() & 0x200) != 0) {
                this.out.print("      parked on: ");
                if (javaThread.getBlockingObject() == null) {
                    this.out.print("<unknown>");
                } else {
                    object = javaThread.getBlockingObject();
                    string2 = Long.toHexString(object.getID().getAddress());
                    this.out.print(object.getJavaClass().getName() + "@0x" + string2);
                    string = "<unknown>";
                    String string3 = "<null>";
                    this.out.print(" owner name: ");
                    JavaThread javaThread2 = Utils.getParkBlockerOwner((JavaObject)object, this.ctx.getRuntime());
                    if (javaThread2 != null) {
                        string = javaThread2.getName();
                        if (javaThread2.getImageThread() != null) {
                            string3 = javaThread2.getImageThread().getID();
                        }
                    } else {
                        JavaObject javaObject = Utils.getParkBlockerOwnerObject((JavaObject)object, this.ctx.getRuntime());
                        if (javaObject != null) {
                            string = Utils.getThreadNameFromObject(javaObject, this.ctx.getRuntime(), this.out);
                        }
                    }
                    this.out.print("\"" + string + "\"");
                    this.out.print(" owner id: " + string3);
                }
                this.out.println();
            } else if ((javaThread.getState() & 0x100) != 0) {
                this.out.print("      waiting to be notified on: ");
            } else if ((javaThread.getState() & 0x400) != 0) {
                this.out.print("      waiting to enter: ");
            }
            if ((javaThread.getState() & 0x500) != 0) {
                object = this.monitors.get(javaThread);
                if (object == null) {
                    this.out.println("<monitor information not available>");
                } else {
                    string2 = ((MonitorState)object).getMonitor().getObject();
                    if (null == string2) {
                        string = ((MonitorState)object).getMonitor().getName();
                        if (string.equals("")) {
                            string = "<unnamed>";
                        }
                        this.out.print("\"" + string + "\"");
                        this.out.print(" with ID ");
                        this.out.print(Utils.toHex(((MonitorState)object).getMonitor().getID().getAddress()));
                    } else {
                        string = Long.toHexString(string2.getID().getAddress());
                        this.out.print(string2.getJavaClass().getName() + "@0x" + string);
                    }
                    this.out.print(" owner name: ");
                    if (((MonitorState)object).getMonitor().getOwner() != null) {
                        this.out.print("\"" + ((MonitorState)object).getMonitor().getOwner().getName() + "\"");
                        if (((MonitorState)object).getMonitor().getOwner().getImageThread() != null) {
                            this.out.print(" owner id: " + ((MonitorState)object).getMonitor().getOwner().getImageThread().getID());
                        }
                    } else {
                        this.out.print("<unowned>");
                    }
                    this.out.println();
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
            this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), corruptDataException);
        }
        catch (DataUnavailable dataUnavailable) {
            this.out.print(Exceptions.getDataUnavailableString());
            this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), dataUnavailable);
        }
        catch (MemoryAccessException memoryAccessException) {
            this.out.print(Exceptions.getMemoryAccessExceptionString());
            this.logger.log(Level.FINEST, Exceptions.getMemoryAccessExceptionString(), memoryAccessException);
        }
    }

    private void printJavaStackFrameInfo(JavaThread javaThread) {
        Iterator iterator = javaThread.getStackFrames();
        if (!iterator.hasNext()) {
            this.out.println("<no frames to print>");
            return;
        }
        this.out.println();
        while (iterator.hasNext()) {
            JavaLocation javaLocation;
            Object e = iterator.next();
            if (e instanceof CorruptData) {
                this.out.println("     " + Exceptions.getCorruptDataExceptionString());
                return;
            }
            JavaStackFrame javaStackFrame = (JavaStackFrame)e;
            try {
                javaLocation = javaStackFrame.getLocation();
            }
            catch (CorruptDataException corruptDataException) {
                this.out.println("     " + Exceptions.getCorruptDataExceptionString());
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), corruptDataException);
                return;
            }
            this.out.print("     bp: ");
            try {
                this.out.print(this.toAdjustedHex(javaStackFrame.getBasePointer().getAddress()));
            }
            catch (CorruptDataException corruptDataException) {
                this.out.print(Exceptions.getDataUnavailableString());
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), corruptDataException);
            }
            this.out.print("  method: ");
            try {
                String string = null;
                try {
                    string = javaLocation.getMethod().getSignature();
                }
                catch (CorruptDataException corruptDataException) {
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), corruptDataException);
                }
                if (string == null) {
                    this.out.print(javaLocation.getMethod().getDeclaringClass().getName() + "." + javaLocation.getMethod().getName());
                } else {
                    this.out.print(Utils.getReturnValueName(string) + " " + javaLocation.getMethod().getDeclaringClass().getName() + "." + javaLocation.getMethod().getName() + Utils.getMethodSignatureName(string));
                }
            }
            catch (CorruptDataException corruptDataException) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), corruptDataException);
            }
            catch (DataUnavailable dataUnavailable) {
                this.out.print(Exceptions.getDataUnavailableString());
                this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), dataUnavailable);
            }
            boolean bl = false;
            try {
                bl = Modifier.isNative(javaLocation.getMethod().getModifiers());
            }
            catch (CorruptDataException corruptDataException) {
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), corruptDataException);
            }
            if (!bl) {
                this.out.print("  source: ");
                try {
                    this.out.print(javaLocation.getFilename());
                }
                catch (DataUnavailable dataUnavailable) {
                    this.out.print(Exceptions.getDataUnavailableString());
                    this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), dataUnavailable);
                }
                catch (CorruptDataException corruptDataException) {
                    this.out.print(Exceptions.getCorruptDataExceptionString());
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), corruptDataException);
                }
                this.out.print(":");
                try {
                    this.out.print(Integer.toString(javaLocation.getLineNumber()));
                }
                catch (DataUnavailable dataUnavailable) {
                    this.out.print(Exceptions.getDataUnavailableString());
                    this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), dataUnavailable);
                }
                catch (CorruptDataException corruptDataException) {
                    this.out.print(Exceptions.getCorruptDataExceptionString());
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), corruptDataException);
                }
            } else {
                this.out.print("  (Native Method)");
            }
            this.out.println();
            this.out.print("      objects:");
            Iterator iterator2 = javaStackFrame.getHeapRoots();
            if (!iterator2.hasNext()) {
                this.out.print(" <no objects in this frame>");
            }
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                if (e2 instanceof CorruptData) {
                    this.out.println(Exceptions.getCorruptDataExceptionString());
                    break;
                }
                JavaReference javaReference = (JavaReference)e2;
                try {
                    if (!javaReference.isObjectReference()) continue;
                    JavaObject javaObject = (JavaObject)javaReference.getTarget();
                    this.out.print(" " + Utils.toHex(javaObject.getID().getAddress()));
                }
                catch (DataUnavailable dataUnavailable) {
                    this.out.print(Exceptions.getDataUnavailableString());
                    this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), dataUnavailable);
                }
                catch (CorruptDataException corruptDataException) {
                    this.out.print(Exceptions.getCorruptDataExceptionString());
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), corruptDataException);
                }
                catch (NullPointerException nullPointerException) {
                    this.out.print(Exceptions.getDataUnavailableString());
                    this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), nullPointerException);
                }
            }
            this.out.println();
        }
    }

    private String toAdjustedHex(long l) {
        if (this._pointerSize > 32) {
            return "0x" + Utils.toFixedWidthHex(l);
        }
        if (31 == this._pointerSize) {
            return "0x" + Utils.toFixedWidthHex((int)(l & Integer.MAX_VALUE));
        }
        return "0x" + Utils.toFixedWidthHex((int)l);
    }

    private void printThreadSummary(ImageProcess imageProcess) {
        int n = 0;
        Iterator iterator = imageProcess.getThreads();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CorruptData) continue;
            ImageThread imageThread = (ImageThread)e;
            if (n % 8 == 0) {
                this.out.println();
                if (0 == n) {
                    this.out.println();
                    this.out.println("Native thread IDs for current process:");
                }
                this.out.print(" ");
            }
            try {
                this.out.print(Utils.padWithSpaces(imageThread.getID(), 8));
            }
            catch (CorruptDataException corruptDataException) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
            }
            ++n;
        }
        this.out.println();
    }

    private void printProperties(ImageThread imageThread) {
        List list = imageThread.getProperties().entrySet().stream().sorted(Comparator.comparing(entry -> String.valueOf(entry.getKey()))).map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.toCollection(ArrayList::new));
        int n = list.size();
        if (n % 2 != 0) {
            list.add("");
            ++n;
        }
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            n2 = Math.max(((String)list.get(i)).length(), n2);
        }
        String string = "    %-" + n2 + "s   %s%n";
        for (int i = 0; i < n; i += 2) {
            this.out.printf(string, list.get(i), list.get(i + 1));
        }
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.printf("Displays information about Java and native threads%n%nParameters: none, native thread ID, zOS TCB address, \"all\", or \"*\"%n%nIf no parameter is supplied, information is printed for the current or failing thread, if any%nIf a native thread ID or zOS TCB address is supplied, information is printed for that specific thread%nIf \"all\", or \"*\" is specified, information is printed for all threads%n%nThe following information is printed for each thread:%n - native thread ID%n - registers%n - native stack sections%n - native stack frames: procedure name and base pointer%n - thread properties%n - associated Java thread (if applicable):%n  - name of Java thread%n  - address of associated java.lang.Thread object%n  - current state according to JVMTI specification%n  - current state relative to java.lang.Thread.State%n  - the Java thread priority%n  - the monitor the thread is waiting to enter or waiting on notify%n  - Java stack frames: base pointer, method, source filename and objects on frame%n%nNote: the \"info proc\" command provides a summary list of native thread IDs%n", new Object[0]);
    }
}

