/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import sun.util.calendar.BaseCalendar;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.Era;
import sun.util.calendar.Gregorian;
import sun.util.calendar.LocalGregorianCalendar;
import sun.util.calendar.ZoneInfo;
import sun.util.locale.provider.CalendarDataUtility;

class JapaneseImperialCalendar
extends Calendar {
    public static final int BEFORE_MEIJI = 0;
    public static final int MEIJI = 1;
    public static final int TAISHO = 2;
    public static final int SHOWA = 3;
    public static final int HEISEI = 4;
    private static final int REIWA = 5;
    private static final int EPOCH_OFFSET = 719163;
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private static final LocalGregorianCalendar jcal;
    private static final Gregorian gcal;
    private static final Era BEFORE_MEIJI_ERA;
    private static final Era[] eras;
    private static final long[] sinceFixedDates;
    private static final int currentEra;
    static final int[] MIN_VALUES;
    static final int[] LEAST_MAX_VALUES;
    static final int[] MAX_VALUES;
    private static final long serialVersionUID = -3364572813905467929L;
    private transient LocalGregorianCalendar.Date jdate;
    private transient int[] zoneOffsets;
    private transient int[] originalFields;
    private transient long cachedFixedDate = Long.MIN_VALUE;

    JapaneseImperialCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.jdate = jcal.newCalendarDate(timeZone);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    JapaneseImperialCalendar(TimeZone timeZone, Locale locale, boolean bl) {
        super(timeZone, locale);
        this.jdate = jcal.newCalendarDate(timeZone);
    }

    @Override
    public String getCalendarType() {
        return "japanese";
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof JapaneseImperialCalendar && super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.jdate.hashCode();
    }

    @Override
    public void add(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n >= 15) {
            throw new IllegalArgumentException();
        }
        this.complete();
        if (n == 1) {
            LocalGregorianCalendar.Date date = (LocalGregorianCalendar.Date)this.jdate.clone();
            date.addYear(n2);
            this.pinDayOfMonth(date);
            this.set(0, JapaneseImperialCalendar.getEraIndex(date));
            this.set(1, date.getYear());
            this.set(2, date.getMonth() - 1);
            this.set(5, date.getDayOfMonth());
        } else if (n == 2) {
            LocalGregorianCalendar.Date date = (LocalGregorianCalendar.Date)this.jdate.clone();
            date.addMonth(n2);
            this.pinDayOfMonth(date);
            this.set(0, JapaneseImperialCalendar.getEraIndex(date));
            this.set(1, date.getYear());
            this.set(2, date.getMonth() - 1);
            this.set(5, date.getDayOfMonth());
        } else if (n == 0) {
            int n3 = this.internalGet(0) + n2;
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > eras.length - 1) {
                n3 = eras.length - 1;
            }
            this.set(0, n3);
        } else {
            long l = n2;
            long l2 = 0L;
            switch (n) {
                case 10: 
                case 11: {
                    l *= 3600000L;
                    break;
                }
                case 12: {
                    l *= 60000L;
                    break;
                }
                case 13: {
                    l *= 1000L;
                    break;
                }
                case 14: {
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    l *= 7L;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 9: {
                    l = n2 / 2;
                    l2 = 12 * (n2 % 2);
                }
            }
            if (n >= 10) {
                this.setTimeInMillis(this.time + l);
                return;
            }
            long l3 = this.cachedFixedDate;
            l2 += (long)this.internalGet(11);
            l2 *= 60L;
            l2 += (long)this.internalGet(12);
            l2 *= 60L;
            l2 += (long)this.internalGet(13);
            l2 *= 1000L;
            if ((l2 += (long)this.internalGet(14)) >= 86400000L) {
                ++l3;
                l2 -= 86400000L;
            } else if (l2 < 0L) {
                --l3;
                l2 += 86400000L;
            }
            int n4 = this.internalGet(15) + this.internalGet(16);
            this.setTimeInMillis(((l3 += l) - 719163L) * 86400000L + l2 - (long)n4);
            if ((n4 -= this.internalGet(15) + this.internalGet(16)) != 0) {
                this.setTimeInMillis(this.time + (long)n4);
                long l4 = this.cachedFixedDate;
                if (l4 != l3) {
                    this.setTimeInMillis(this.time - (long)n4);
                }
            }
        }
    }

    @Override
    public void roll(int n, boolean bl) {
        this.roll(n, bl ? 1 : -1);
    }

    @Override
    public void roll(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n >= 15) {
            throw new IllegalArgumentException();
        }
        this.complete();
        int n3 = this.getMinimum(n);
        int n4 = this.getMaximum(n);
        switch (n) {
            case 0: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 10: 
            case 11: {
                int n5 = n4 + 1;
                int n6 = this.internalGet(n);
                int n7 = (n6 + n2) % n5;
                if (n7 < 0) {
                    n7 += n5;
                }
                this.time += (long)(3600000 * (n7 - n6));
                LocalGregorianCalendar.Date date = jcal.getCalendarDate(this.time, this.getZone());
                if (this.internalGet(5) != date.getDayOfMonth()) {
                    ((CalendarDate)date).setEra(this.jdate.getEra());
                    date.setDate(this.internalGet(1), this.internalGet(2) + 1, this.internalGet(5));
                    if (n == 10) {
                        assert (this.internalGet(9) == 1);
                        date.addHours(12);
                    }
                    this.time = jcal.getTime(date);
                }
                int n8 = date.getHours();
                this.internalSet(n, n8 % n5);
                if (n == 10) {
                    this.internalSet(11, n8);
                } else {
                    this.internalSet(9, n8 / 12);
                    this.internalSet(10, n8 % 12);
                }
                int n9 = date.getZoneOffset();
                int n10 = date.getDaylightSaving();
                this.internalSet(15, n9 - n10);
                this.internalSet(16, n10);
                return;
            }
            case 1: {
                n3 = this.getActualMinimum(n);
                n4 = this.getActualMaximum(n);
                break;
            }
            case 2: {
                if (!this.isTransitionYear(this.jdate.getNormalizedYear())) {
                    int n11 = this.jdate.getYear();
                    if (n11 == this.getMaximum(1)) {
                        LocalGregorianCalendar.Date date = jcal.getCalendarDate(this.time, this.getZone());
                        LocalGregorianCalendar.Date date2 = jcal.getCalendarDate(Long.MAX_VALUE, this.getZone());
                        n4 = date2.getMonth() - 1;
                        int n12 = JapaneseImperialCalendar.getRolledValue(this.internalGet(n), n2, n3, n4);
                        if (n12 == n4) {
                            ((CalendarDate)date).addYear(-400);
                            date.setMonth(n12 + 1);
                            if (date.getDayOfMonth() > date2.getDayOfMonth()) {
                                date.setDayOfMonth(date2.getDayOfMonth());
                                jcal.normalize(date);
                            }
                            if (date.getDayOfMonth() == date2.getDayOfMonth() && date.getTimeOfDay() > date2.getTimeOfDay()) {
                                date.setMonth(n12 + 1);
                                date.setDayOfMonth(date2.getDayOfMonth() - 1);
                                jcal.normalize(date);
                                n12 = date.getMonth() - 1;
                            }
                            this.set(5, date.getDayOfMonth());
                        }
                        this.set(2, n12);
                    } else if (n11 == this.getMinimum(1)) {
                        LocalGregorianCalendar.Date date = jcal.getCalendarDate(this.time, this.getZone());
                        LocalGregorianCalendar.Date date3 = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
                        n3 = date3.getMonth() - 1;
                        int n13 = JapaneseImperialCalendar.getRolledValue(this.internalGet(n), n2, n3, n4);
                        if (n13 == n3) {
                            ((CalendarDate)date).addYear(400);
                            date.setMonth(n13 + 1);
                            if (date.getDayOfMonth() < date3.getDayOfMonth()) {
                                date.setDayOfMonth(date3.getDayOfMonth());
                                jcal.normalize(date);
                            }
                            if (date.getDayOfMonth() == date3.getDayOfMonth() && date.getTimeOfDay() < date3.getTimeOfDay()) {
                                date.setMonth(n13 + 1);
                                date.setDayOfMonth(date3.getDayOfMonth() + 1);
                                jcal.normalize(date);
                                n13 = date.getMonth() - 1;
                            }
                            this.set(5, date.getDayOfMonth());
                        }
                        this.set(2, n13);
                    } else {
                        int n14 = (this.internalGet(2) + n2) % 12;
                        if (n14 < 0) {
                            n14 += 12;
                        }
                        this.set(2, n14);
                        int n15 = this.monthLength(n14);
                        if (this.internalGet(5) > n15) {
                            this.set(5, n15);
                        }
                    }
                } else {
                    int n16 = JapaneseImperialCalendar.getEraIndex(this.jdate);
                    CalendarDate calendarDate = null;
                    if (this.jdate.getYear() == 1) {
                        calendarDate = eras[n16].getSinceDate();
                        n3 = calendarDate.getMonth() - 1;
                    } else if (n16 < eras.length - 1 && (calendarDate = eras[n16 + 1].getSinceDate()).getYear() == this.jdate.getNormalizedYear()) {
                        n4 = calendarDate.getMonth() - 1;
                        if (calendarDate.getDayOfMonth() == 1) {
                            --n4;
                        }
                    }
                    if (n3 == n4) {
                        return;
                    }
                    int n17 = JapaneseImperialCalendar.getRolledValue(this.internalGet(n), n2, n3, n4);
                    this.set(2, n17);
                    if (n17 == n3) {
                        if ((calendarDate.getMonth() != 1 || calendarDate.getDayOfMonth() != 1) && this.jdate.getDayOfMonth() < calendarDate.getDayOfMonth()) {
                            this.set(5, calendarDate.getDayOfMonth());
                        }
                    } else if (n17 == n4 && calendarDate.getMonth() - 1 == n17) {
                        int n18 = calendarDate.getDayOfMonth();
                        if (this.jdate.getDayOfMonth() >= n18) {
                            this.set(5, n18 - 1);
                        }
                    }
                }
                return;
            }
            case 3: {
                int n19 = this.jdate.getNormalizedYear();
                n4 = this.getActualMaximum(3);
                this.set(7, this.internalGet(7));
                int n20 = this.internalGet(3);
                int n21 = n20 + n2;
                if (!this.isTransitionYear(this.jdate.getNormalizedYear())) {
                    int n22 = this.jdate.getYear();
                    if (n22 == this.getMaximum(1)) {
                        n4 = this.getActualMaximum(3);
                    } else if (n22 == this.getMinimum(1)) {
                        n3 = this.getActualMinimum(3);
                        n4 = this.getActualMaximum(3);
                        if (n21 > n3 && n21 < n4) {
                            this.set(3, n21);
                            return;
                        }
                    }
                    if (n21 > n3 && n21 < n4) {
                        this.set(3, n21);
                        return;
                    }
                    long l = this.cachedFixedDate;
                    long l2 = l - (long)(7 * (n20 - n3));
                    if (n22 != this.getMinimum(1)) {
                        if (gcal.getYearFromFixedDate(l2) != n19) {
                            ++n3;
                        }
                    } else {
                        LocalGregorianCalendar.Date date = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
                        if (l2 < jcal.getFixedDate(date)) {
                            ++n3;
                        }
                    }
                    if (gcal.getYearFromFixedDate(l += (long)(7 * (n4 - this.internalGet(3)))) == n19) break;
                    --n4;
                    break;
                }
                long l = this.cachedFixedDate;
                long l3 = l - (long)(7 * (n20 - n3));
                LocalGregorianCalendar.Date date = JapaneseImperialCalendar.getCalendarDate(l3);
                if (date.getEra() != this.jdate.getEra() || date.getYear() != this.jdate.getYear()) {
                    ++n3;
                }
                jcal.getCalendarDateFromFixedDate(date, l += (long)(7 * (n4 - n20)));
                if (date.getEra() != this.jdate.getEra() || date.getYear() != this.jdate.getYear()) {
                    --n4;
                }
                n21 = JapaneseImperialCalendar.getRolledValue(n20, n2, n3, n4) - 1;
                date = JapaneseImperialCalendar.getCalendarDate(l3 + (long)(n21 * 7));
                this.set(2, date.getMonth() - 1);
                this.set(5, date.getDayOfMonth());
                return;
            }
            case 4: {
                int n23;
                long l;
                boolean bl = this.isTransitionYear(this.jdate.getNormalizedYear());
                int n24 = this.internalGet(7) - this.getFirstDayOfWeek();
                if (n24 < 0) {
                    n24 += 7;
                }
                long l4 = this.cachedFixedDate;
                if (bl) {
                    l = this.getFixedDateMonth1(this.jdate, l4);
                    n23 = this.actualMonthLength();
                } else {
                    l = l4 - (long)this.internalGet(5) + 1L;
                    n23 = jcal.getMonthLength(this.jdate);
                }
                long l5 = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(l + 6L, this.getFirstDayOfWeek());
                if ((int)(l5 - l) >= this.getMinimalDaysInFirstWeek()) {
                    l5 -= 7L;
                }
                n4 = this.getActualMaximum(n);
                int n25 = JapaneseImperialCalendar.getRolledValue(this.internalGet(n), n2, 1, n4) - 1;
                long l6 = l5 + (long)(n25 * 7) + (long)n24;
                if (l6 < l) {
                    l6 = l;
                } else if (l6 >= l + (long)n23) {
                    l6 = l + (long)n23 - 1L;
                }
                this.set(5, JapaneseImperialCalendar.getCalendarDate(l6).getDayOfMonth());
                return;
            }
            case 5: {
                if (!this.isTransitionYear(this.jdate.getNormalizedYear())) {
                    n4 = jcal.getMonthLength(this.jdate);
                    break;
                }
                long l = this.getFixedDateMonth1(this.jdate, this.cachedFixedDate);
                int n26 = JapaneseImperialCalendar.getRolledValue((int)(this.cachedFixedDate - l), n2, 0, this.actualMonthLength() - 1);
                LocalGregorianCalendar.Date date = JapaneseImperialCalendar.getCalendarDate(l + (long)n26);
                assert (JapaneseImperialCalendar.getEraIndex(date) == this.internalGetEra() && date.getYear() == this.internalGet(1) && date.getMonth() - 1 == this.internalGet(2));
                this.set(5, date.getDayOfMonth());
                return;
            }
            case 6: {
                n4 = this.getActualMaximum(n);
                if (!this.isTransitionYear(this.jdate.getNormalizedYear())) break;
                int n27 = JapaneseImperialCalendar.getRolledValue(this.internalGet(6), n2, n3, n4);
                long l = this.cachedFixedDate - (long)this.internalGet(6);
                LocalGregorianCalendar.Date date = JapaneseImperialCalendar.getCalendarDate(l + (long)n27);
                assert (JapaneseImperialCalendar.getEraIndex(date) == this.internalGetEra() && date.getYear() == this.internalGet(1));
                this.set(2, date.getMonth() - 1);
                this.set(5, date.getDayOfMonth());
                return;
            }
            case 7: {
                long l;
                int n28;
                int n29 = this.jdate.getNormalizedYear();
                if (!this.isTransitionYear(n29) && !this.isTransitionYear(n29 - 1) && (n28 = this.internalGet(3)) > 1 && n28 < 52) {
                    this.set(3, this.internalGet(3));
                    n4 = 7;
                    break;
                }
                if ((n2 %= 7) == 0) {
                    return;
                }
                long l7 = this.cachedFixedDate;
                if ((l7 += (long)n2) < (l = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(l7, this.getFirstDayOfWeek()))) {
                    l7 += 7L;
                } else if (l7 >= l + 7L) {
                    l7 -= 7L;
                }
                LocalGregorianCalendar.Date date = JapaneseImperialCalendar.getCalendarDate(l7);
                this.set(0, JapaneseImperialCalendar.getEraIndex(date));
                this.set(date.getYear(), date.getMonth() - 1, date.getDayOfMonth());
                return;
            }
            case 8: {
                n3 = 1;
                if (!this.isTransitionYear(this.jdate.getNormalizedYear())) {
                    int n30 = this.internalGet(5);
                    int n31 = jcal.getMonthLength(this.jdate);
                    int n32 = n31 % 7;
                    n4 = n31 / 7;
                    int n33 = (n30 - 1) % 7;
                    if (n33 < n32) {
                        ++n4;
                    }
                    this.set(7, this.internalGet(7));
                    break;
                }
                long l = this.cachedFixedDate;
                long l8 = this.getFixedDateMonth1(this.jdate, l);
                int n34 = this.actualMonthLength();
                int n35 = n34 % 7;
                n4 = n34 / 7;
                int n36 = (int)(l - l8) % 7;
                if (n36 < n35) {
                    ++n4;
                }
                int n37 = JapaneseImperialCalendar.getRolledValue(this.internalGet(n), n2, n3, n4) - 1;
                l = l8 + (long)(n37 * 7) + (long)n36;
                LocalGregorianCalendar.Date date = JapaneseImperialCalendar.getCalendarDate(l);
                this.set(5, date.getDayOfMonth());
                return;
            }
        }
        this.set(n, JapaneseImperialCalendar.getRolledValue(this.internalGet(n), n2, n3, n4));
    }

    @Override
    public String getDisplayName(int n, int n2, Locale locale) {
        if (!this.checkDisplayNameParams(n, n2, 1, 4, locale, 647)) {
            return null;
        }
        int n3 = this.get(n);
        if (n == 1 && (this.getBaseStyle(n2) != 2 || n3 != 1 || this.get(0) == 0)) {
            return null;
        }
        String string = CalendarDataUtility.retrieveFieldValueName(this.getCalendarType(), n, n3, n2, locale);
        if ((string == null || string.isEmpty()) && n == 0 && n3 < eras.length) {
            Era era = eras[n3];
            string = n2 == 1 ? era.getAbbreviation() : era.getName();
        }
        return string;
    }

    @Override
    public Map<String, Integer> getDisplayNames(int n, int n2, Locale locale) {
        if (!this.checkDisplayNameParams(n, n2, 0, 4, locale, 647)) {
            return null;
        }
        Map<String, Integer> map = CalendarDataUtility.retrieveFieldValueNames(this.getCalendarType(), n, n2, locale);
        if (map != null && n == 0) {
            int n3 = map.size();
            if (n2 == 0) {
                HashSet<Integer> hashSet = new HashSet<Integer>();
                for (String object : map.keySet()) {
                    hashSet.add(map.get(object));
                }
                n3 = hashSet.size();
            }
            if (n3 < eras.length) {
                int n4 = this.getBaseStyle(n2);
                for (int i = n3; i < eras.length; ++i) {
                    Era era = eras[i];
                    if (n4 == 0 || n4 == 1 || n4 == 4) {
                        map.put(era.getAbbreviation(), i);
                    }
                    if (n4 != 0 && n4 != 2) continue;
                    map.put(era.getName(), i);
                }
            }
        }
        return map;
    }

    @Override
    public int getMinimum(int n) {
        return MIN_VALUES[n];
    }

    @Override
    public int getMaximum(int n) {
        switch (n) {
            case 1: {
                LocalGregorianCalendar.Date date = jcal.getCalendarDate(Long.MAX_VALUE, this.getZone());
                return Math.max(LEAST_MAX_VALUES[1], date.getYear());
            }
        }
        return MAX_VALUES[n];
    }

    @Override
    public int getGreatestMinimum(int n) {
        return n == 1 ? 1 : MIN_VALUES[n];
    }

    @Override
    public int getLeastMaximum(int n) {
        switch (n) {
            case 1: {
                return Math.min(LEAST_MAX_VALUES[1], this.getMaximum(1));
            }
        }
        return LEAST_MAX_VALUES[n];
    }

    @Override
    public int getActualMinimum(int n) {
        if (!JapaneseImperialCalendar.isFieldSet(14, n)) {
            return this.getMinimum(n);
        }
        int n2 = 0;
        JapaneseImperialCalendar japaneseImperialCalendar = this.getNormalizedCalendar();
        LocalGregorianCalendar.Date date = jcal.getCalendarDate(japaneseImperialCalendar.getTimeInMillis(), this.getZone());
        int n3 = JapaneseImperialCalendar.getEraIndex(date);
        switch (n) {
            case 1: {
                if (n3 > 0) {
                    n2 = 1;
                    long l = eras[n3].getSince(this.getZone());
                    LocalGregorianCalendar.Date date2 = jcal.getCalendarDate(l, this.getZone());
                    date.setYear(date2.getYear());
                    jcal.normalize(date);
                    assert (date.isLeapYear() == date2.isLeapYear());
                    if (this.getYearOffsetInMillis(date) >= this.getYearOffsetInMillis(date2)) break;
                    ++n2;
                    break;
                }
                n2 = this.getMinimum(n);
                LocalGregorianCalendar.Date date3 = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
                int n4 = date3.getYear();
                if (n4 > 400) {
                    n4 -= 400;
                }
                date.setYear(n4);
                jcal.normalize(date);
                if (this.getYearOffsetInMillis(date) >= this.getYearOffsetInMillis(date3)) break;
                ++n2;
                break;
            }
            case 2: {
                if (n3 <= 1 || date.getYear() != 1) break;
                long l = eras[n3].getSince(this.getZone());
                LocalGregorianCalendar.Date date4 = jcal.getCalendarDate(l, this.getZone());
                n2 = date4.getMonth() - 1;
                if (date.getDayOfMonth() >= date4.getDayOfMonth()) break;
                ++n2;
                break;
            }
            case 3: {
                n2 = 1;
                LocalGregorianCalendar.Date date5 = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
                ((CalendarDate)date5).addYear(400);
                jcal.normalize(date5);
                date.setEra(date5.getEra());
                date.setYear(date5.getYear());
                jcal.normalize(date);
                long l = jcal.getFixedDate(date5);
                long l2 = jcal.getFixedDate(date);
                int n5 = this.getWeekNumber(l, l2);
                long l3 = l2 - (long)(7 * (n5 - 1));
                if (l3 >= l && (l3 != l || date.getTimeOfDay() >= date5.getTimeOfDay())) break;
                ++n2;
            }
        }
        return n2;
    }

    @Override
    public int getActualMaximum(int n) {
        if ((0x1FE81 & 1 << n) != 0) {
            return this.getMaximum(n);
        }
        JapaneseImperialCalendar japaneseImperialCalendar = this.getNormalizedCalendar();
        LocalGregorianCalendar.Date date = japaneseImperialCalendar.jdate;
        int n2 = date.getNormalizedYear();
        int n3 = -1;
        switch (n) {
            case 2: {
                n3 = 11;
                if (this.isTransitionYear(date.getNormalizedYear())) {
                    int n4 = JapaneseImperialCalendar.getEraIndex(date);
                    if (date.getYear() != 1) assert (++n4 < eras.length);
                    long l = japaneseImperialCalendar.cachedFixedDate;
                    long l2 = sinceFixedDates[n4];
                    if (l >= l2) break;
                    LocalGregorianCalendar.Date date2 = (LocalGregorianCalendar.Date)date.clone();
                    jcal.getCalendarDateFromFixedDate(date2, l2 - 1L);
                    n3 = date2.getMonth() - 1;
                    break;
                }
                LocalGregorianCalendar.Date date3 = jcal.getCalendarDate(Long.MAX_VALUE, this.getZone());
                if (date.getEra() != date3.getEra() || date.getYear() != date3.getYear()) break;
                n3 = date3.getMonth() - 1;
                break;
            }
            case 5: {
                n3 = jcal.getMonthLength(date);
                break;
            }
            case 6: {
                if (this.isTransitionYear(date.getNormalizedYear())) {
                    int n5 = JapaneseImperialCalendar.getEraIndex(date);
                    if (date.getYear() != 1) assert (++n5 < eras.length);
                    long l = sinceFixedDates[n5];
                    long l3 = japaneseImperialCalendar.cachedFixedDate;
                    Gregorian.Date date4 = gcal.newCalendarDate(TimeZone.NO_TIMEZONE);
                    date4.setDate(date.getNormalizedYear(), 1, 1);
                    if (l3 < l) {
                        n3 = (int)(l - gcal.getFixedDate(date4));
                        break;
                    }
                    date4.addYear(1);
                    n3 = (int)(gcal.getFixedDate(date4) - l);
                    break;
                }
                LocalGregorianCalendar.Date date5 = jcal.getCalendarDate(Long.MAX_VALUE, this.getZone());
                if (date.getEra() == date5.getEra() && date.getYear() == date5.getYear()) {
                    long l = jcal.getFixedDate(date5);
                    long l4 = this.getFixedDateJan1(date5, l);
                    n3 = (int)(l - l4) + 1;
                    break;
                }
                if (date.getYear() == this.getMinimum(1)) {
                    LocalGregorianCalendar.Date date6 = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
                    long l = jcal.getFixedDate(date6);
                    ((CalendarDate)date6).addYear(1);
                    date6.setMonth(1).setDayOfMonth(1);
                    jcal.normalize(date6);
                    long l5 = jcal.getFixedDate(date6);
                    n3 = (int)(l5 - l);
                    break;
                }
                n3 = jcal.getYearLength(date);
                break;
            }
            case 3: {
                if (!this.isTransitionYear(date.getNormalizedYear())) {
                    LocalGregorianCalendar.Date date7 = jcal.getCalendarDate(Long.MAX_VALUE, this.getZone());
                    if (date.getEra() == date7.getEra() && date.getYear() == date7.getYear()) {
                        long l = jcal.getFixedDate(date7);
                        long l6 = this.getFixedDateJan1(date7, l);
                        n3 = this.getWeekNumber(l6, l);
                        break;
                    }
                    if (date.getEra() == null && date.getYear() == this.getMinimum(1)) {
                        LocalGregorianCalendar.Date date8 = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
                        ((CalendarDate)date8).addYear(400);
                        jcal.normalize(date8);
                        date7.setEra(date8.getEra());
                        date7.setDate(date8.getYear() + 1, 1, 1);
                        jcal.normalize(date7);
                        long l = jcal.getFixedDate(date8);
                        long l7 = jcal.getFixedDate(date7);
                        long l8 = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(l7 + 6L, this.getFirstDayOfWeek());
                        int n6 = (int)(l8 - l7);
                        if (n6 >= this.getMinimalDaysInFirstWeek()) {
                            l8 -= 7L;
                        }
                        n3 = this.getWeekNumber(l, l8);
                        break;
                    }
                    Gregorian.Date date9 = gcal.newCalendarDate(TimeZone.NO_TIMEZONE);
                    date9.setDate(date.getNormalizedYear(), 1, 1);
                    int n7 = gcal.getDayOfWeek(date9);
                    if ((n7 -= this.getFirstDayOfWeek()) < 0) {
                        n7 += 7;
                    }
                    n3 = 52;
                    int n8 = n7 + this.getMinimalDaysInFirstWeek() - 1;
                    if (n8 != 6 && (!date.isLeapYear() || n8 != 5 && n8 != 12)) break;
                    ++n3;
                    break;
                }
                if (japaneseImperialCalendar == this) {
                    japaneseImperialCalendar = (JapaneseImperialCalendar)japaneseImperialCalendar.clone();
                }
                int n9 = this.getActualMaximum(6);
                japaneseImperialCalendar.set(6, n9);
                n3 = japaneseImperialCalendar.get(3);
                if (n3 != 1 || n9 <= 7) break;
                japaneseImperialCalendar.add(3, -1);
                n3 = japaneseImperialCalendar.get(3);
                break;
            }
            case 4: {
                LocalGregorianCalendar.Date date10 = jcal.getCalendarDate(Long.MAX_VALUE, this.getZone());
                if (date.getEra() != date10.getEra() || date.getYear() != date10.getYear()) {
                    Gregorian.Date date11 = gcal.newCalendarDate(TimeZone.NO_TIMEZONE);
                    date11.setDate(date.getNormalizedYear(), date.getMonth(), 1);
                    int n10 = gcal.getDayOfWeek(date11);
                    int n11 = this.actualMonthLength();
                    if ((n10 -= this.getFirstDayOfWeek()) < 0) {
                        n10 += 7;
                    }
                    int n12 = 7 - n10;
                    n3 = 3;
                    if (n12 >= this.getMinimalDaysInFirstWeek()) {
                        ++n3;
                    }
                    if ((n11 -= n12 + 21) <= 0) break;
                    ++n3;
                    if (n11 <= 7) break;
                    ++n3;
                    break;
                }
                long l = jcal.getFixedDate(date10);
                long l9 = l - (long)date10.getDayOfMonth() + 1L;
                n3 = this.getWeekNumber(l9, l);
                break;
            }
            case 8: {
                int n13 = date.getDayOfWeek();
                BaseCalendar.Date date12 = (BaseCalendar.Date)date.clone();
                int n14 = jcal.getMonthLength(date12);
                date12.setDayOfMonth(1);
                jcal.normalize(date12);
                int n15 = date12.getDayOfWeek();
                int n16 = n13 - n15;
                if (n16 < 0) {
                    n16 += 7;
                }
                n3 = ((n14 -= n16) + 6) / 7;
                break;
            }
            case 1: {
                LocalGregorianCalendar.Date date13;
                LocalGregorianCalendar.Date date14 = jcal.getCalendarDate(japaneseImperialCalendar.getTimeInMillis(), this.getZone());
                int n17 = JapaneseImperialCalendar.getEraIndex(date);
                if (n17 == eras.length - 1) {
                    date13 = jcal.getCalendarDate(Long.MAX_VALUE, this.getZone());
                    n3 = date13.getYear();
                    if (n3 > 400) {
                        ((CalendarDate)date14).setYear(n3 - 400);
                    }
                } else {
                    date13 = jcal.getCalendarDate(eras[n17 + 1].getSince(this.getZone()) - 1L, this.getZone());
                    n3 = date13.getYear();
                    ((CalendarDate)date14).setYear(n3);
                }
                jcal.normalize(date14);
                if (this.getYearOffsetInMillis(date14) <= this.getYearOffsetInMillis(date13)) break;
                --n3;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(n);
            }
        }
        return n3;
    }

    private long getYearOffsetInMillis(CalendarDate calendarDate) {
        long l = (jcal.getDayOfYear(calendarDate) - 1L) * 86400000L;
        return l + calendarDate.getTimeOfDay() - (long)calendarDate.getZoneOffset();
    }

    @Override
    public Object clone() {
        JapaneseImperialCalendar japaneseImperialCalendar = (JapaneseImperialCalendar)super.clone();
        japaneseImperialCalendar.jdate = (LocalGregorianCalendar.Date)this.jdate.clone();
        japaneseImperialCalendar.originalFields = null;
        japaneseImperialCalendar.zoneOffsets = null;
        return japaneseImperialCalendar;
    }

    @Override
    public TimeZone getTimeZone() {
        TimeZone timeZone = super.getTimeZone();
        this.jdate.setZone(timeZone);
        return timeZone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        super.setTimeZone(timeZone);
        this.jdate.setZone(timeZone);
    }

    @Override
    protected void computeFields() {
        int n = 0;
        if (this.isPartiallyNormalized()) {
            n = this.getSetStateFields();
            int n2 = ~n & 0x1FFFF;
            if (n2 != 0 || this.cachedFixedDate == Long.MIN_VALUE) {
                n |= this.computeFields(n2, n & 0x18000);
                assert (n == 131071);
            }
        } else {
            n = 131071;
            this.computeFields(n, 0);
        }
        this.setFieldsComputed(n);
    }

    private int computeFields(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        TimeZone timeZone = this.getZone();
        if (this.zoneOffsets == null) {
            this.zoneOffsets = new int[2];
        }
        if (n2 != 98304) {
            if (timeZone instanceof ZoneInfo) {
                n5 = ((ZoneInfo)timeZone).getOffsets(this.time, this.zoneOffsets);
            } else {
                n5 = timeZone.getOffset(this.time);
                this.zoneOffsets[0] = timeZone.getRawOffset();
                this.zoneOffsets[1] = n5 - this.zoneOffsets[0];
            }
        }
        if (n2 != 0) {
            if (JapaneseImperialCalendar.isFieldSet(n2, 15)) {
                this.zoneOffsets[0] = this.internalGet(15);
            }
            if (JapaneseImperialCalendar.isFieldSet(n2, 16)) {
                this.zoneOffsets[1] = this.internalGet(16);
            }
            n5 = this.zoneOffsets[0] + this.zoneOffsets[1];
        }
        long l = (long)n5 / 86400000L;
        int n6 = n5 % 86400000;
        l += this.time / 86400000L;
        if ((long)(n6 += (int)(this.time % 86400000L)) >= 86400000L) {
            n6 = (int)((long)n6 - 86400000L);
            ++l;
        } else {
            while (n6 < 0) {
                n6 = (int)((long)n6 + 86400000L);
                --l;
            }
        }
        if ((l += 719163L) != this.cachedFixedDate || l < 0L) {
            jcal.getCalendarDateFromFixedDate(this.jdate, l);
            this.cachedFixedDate = l;
        }
        int n7 = JapaneseImperialCalendar.getEraIndex(this.jdate);
        int n8 = this.jdate.getYear();
        this.internalSet(0, n7);
        this.internalSet(1, n8);
        int n9 = n | 3;
        int n10 = this.jdate.getMonth() - 1;
        int n11 = this.jdate.getDayOfMonth();
        if ((n & 0xA4) != 0) {
            this.internalSet(2, n10);
            this.internalSet(5, n11);
            this.internalSet(7, this.jdate.getDayOfWeek());
            n9 |= 0xA4;
        }
        if ((n & 0x7E00) != 0) {
            if (n6 != 0) {
                n4 = n6 / 3600000;
                this.internalSet(11, n4);
                this.internalSet(9, n4 / 12);
                this.internalSet(10, n4 % 12);
                n3 = n6 % 3600000;
                this.internalSet(12, n3 / 60000);
                this.internalSet(13, (n3 %= 60000) / 1000);
                this.internalSet(14, n3 % 1000);
            } else {
                this.internalSet(11, 0);
                this.internalSet(9, 0);
                this.internalSet(10, 0);
                this.internalSet(12, 0);
                this.internalSet(13, 0);
                this.internalSet(14, 0);
            }
            n9 |= 0x7E00;
        }
        if ((n & 0x18000) != 0) {
            this.internalSet(15, this.zoneOffsets[0]);
            this.internalSet(16, this.zoneOffsets[1]);
            n9 |= 0x18000;
        }
        if ((n & 0x158) != 0) {
            int n12;
            long l2;
            n4 = this.jdate.getNormalizedYear();
            n3 = this.isTransitionYear(this.jdate.getNormalizedYear());
            if (n3 != 0) {
                l2 = this.getFixedDateJan1(this.jdate, l);
                n12 = (int)(l - l2) + 1;
            } else if (n4 == MIN_VALUES[1]) {
                LocalGregorianCalendar.Date date = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
                l2 = jcal.getFixedDate(date);
                n12 = (int)(l - l2) + 1;
            } else {
                n12 = (int)jcal.getDayOfYear(this.jdate);
                l2 = l - (long)n12 + 1L;
            }
            long l3 = n3 != 0 ? this.getFixedDateMonth1(this.jdate, l) : l - (long)n11 + 1L;
            this.internalSet(6, n12);
            this.internalSet(8, (n11 - 1) / 7 + 1);
            int n13 = this.getWeekNumber(l2, l);
            if (n13 == 0) {
                long l4;
                long l5 = l2 - 1L;
                LocalGregorianCalendar.Date date = JapaneseImperialCalendar.getCalendarDate(l5);
                if (n3 == 0 && !this.isTransitionYear(date.getNormalizedYear())) {
                    l4 = l2 - 365L;
                    if (date.isLeapYear()) {
                        --l4;
                    }
                } else if (n3 != 0) {
                    if (this.jdate.getYear() == 1) {
                        if (n7 > 5) {
                            CalendarDate calendarDate = eras[n7 - 1].getSinceDate();
                            if (n4 == calendarDate.getYear()) {
                                date.setMonth(calendarDate.getMonth()).setDayOfMonth(calendarDate.getDayOfMonth());
                            }
                        } else {
                            date.setMonth(1).setDayOfMonth(1);
                        }
                        jcal.normalize(date);
                        l4 = jcal.getFixedDate(date);
                    } else {
                        l4 = l2 - 365L;
                        if (date.isLeapYear()) {
                            --l4;
                        }
                    }
                } else {
                    CalendarDate calendarDate = eras[JapaneseImperialCalendar.getEraIndex(this.jdate)].getSinceDate();
                    date.setMonth(calendarDate.getMonth()).setDayOfMonth(calendarDate.getDayOfMonth());
                    jcal.normalize(date);
                    l4 = jcal.getFixedDate(date);
                }
                n13 = this.getWeekNumber(l4, l5);
            } else if (n3 == 0) {
                if (n13 >= 52) {
                    long l6;
                    int n14;
                    long l7 = l2 + 365L;
                    if (this.jdate.isLeapYear()) {
                        ++l7;
                    }
                    if ((n14 = (int)((l6 = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(l7 + 6L, this.getFirstDayOfWeek())) - l7)) >= this.getMinimalDaysInFirstWeek() && l >= l6 - 7L) {
                        n13 = 1;
                    }
                }
            } else {
                long l8;
                LocalGregorianCalendar.Date date = (LocalGregorianCalendar.Date)this.jdate.clone();
                if (this.jdate.getYear() == 1) {
                    date.addYear(1);
                    date.setMonth(1).setDayOfMonth(1);
                    l8 = jcal.getFixedDate(date);
                } else {
                    int n15 = JapaneseImperialCalendar.getEraIndex(date) + 1;
                    CalendarDate calendarDate = eras[n15].getSinceDate();
                    date.setEra(eras[n15]);
                    date.setDate(1, calendarDate.getMonth(), calendarDate.getDayOfMonth());
                    jcal.normalize(date);
                    l8 = jcal.getFixedDate(date);
                }
                long l9 = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(l8 + 6L, this.getFirstDayOfWeek());
                int n16 = (int)(l9 - l8);
                if (n16 >= this.getMinimalDaysInFirstWeek() && l >= l9 - 7L) {
                    n13 = 1;
                }
            }
            this.internalSet(3, n13);
            this.internalSet(4, this.getWeekNumber(l3, l));
            n9 |= 0x158;
        }
        return n9;
    }

    private int getWeekNumber(long l, long l2) {
        int n;
        long l3 = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(l + 6L, this.getFirstDayOfWeek());
        int n2 = (int)(l3 - l);
        assert (n2 <= 7);
        if (n2 >= this.getMinimalDaysInFirstWeek()) {
            l3 -= 7L;
        }
        if ((n = (int)(l2 - l3)) >= 0) {
            return n / 7 + 1;
        }
        return CalendarUtils.floorDivide(n, 7) + 1;
    }

    @Override
    protected void computeTime() {
        int n;
        int n2;
        int n3;
        int n4;
        if (!this.isLenient()) {
            if (this.originalFields == null) {
                this.originalFields = new int[17];
            }
            for (n4 = 0; n4 < 17; ++n4) {
                n3 = this.internalGet(n4);
                if (this.isExternallySet(n4) && (n3 < this.getMinimum(n4) || n3 > this.getMaximum(n4))) {
                    throw new IllegalArgumentException(JapaneseImperialCalendar.getFieldName(n4));
                }
                this.originalFields[n4] = n3;
            }
        }
        n4 = this.selectFields();
        if (this.isSet(0)) {
            n2 = this.internalGet(0);
            n3 = this.isSet(1) ? this.internalGet(1) : 1;
        } else if (this.isSet(1)) {
            n2 = currentEra;
            n3 = this.internalGet(1);
        } else {
            n2 = 3;
            n3 = 45;
        }
        long l = 0L;
        if (JapaneseImperialCalendar.isFieldSet(n4, 11)) {
            l += (long)this.internalGet(11);
        } else {
            l += (long)this.internalGet(10);
            if (JapaneseImperialCalendar.isFieldSet(n4, 9)) {
                l += (long)(12 * this.internalGet(9));
            }
        }
        l *= 60L;
        l += (long)this.internalGet(12);
        l *= 60L;
        l += (long)this.internalGet(13);
        l *= 1000L;
        long l2 = (l += (long)this.internalGet(14)) / 86400000L;
        l %= 86400000L;
        while (l < 0L) {
            l += 86400000L;
            --l2;
        }
        long l3 = ((l2 += this.getFixedDate(n2, n3, n4)) - 719163L) * 86400000L + l;
        TimeZone timeZone = this.getZone();
        if (this.zoneOffsets == null) {
            this.zoneOffsets = new int[2];
        }
        if ((n = n4 & 0x18000) != 98304) {
            if (timeZone instanceof ZoneInfo) {
                ((ZoneInfo)timeZone).getOffsetsByWall(l3, this.zoneOffsets);
            } else {
                timeZone.getOffsets(l3 - (long)timeZone.getRawOffset(), this.zoneOffsets);
            }
        }
        if (n != 0) {
            if (JapaneseImperialCalendar.isFieldSet(n, 15)) {
                this.zoneOffsets[0] = this.internalGet(15);
            }
            if (JapaneseImperialCalendar.isFieldSet(n, 16)) {
                this.zoneOffsets[1] = this.internalGet(16);
            }
        }
        this.time = l3 -= (long)(this.zoneOffsets[0] + this.zoneOffsets[1]);
        int n5 = this.computeFields(n4 | this.getSetStateFields(), n);
        if (!this.isLenient()) {
            for (int i = 0; i < 17; ++i) {
                if (!this.isExternallySet(i) || this.originalFields[i] == this.internalGet(i)) continue;
                int n6 = this.internalGet(i);
                System.arraycopy((Object)this.originalFields, 0, (Object)this.fields, 0, this.fields.length);
                throw new IllegalArgumentException(JapaneseImperialCalendar.getFieldName(i) + "=" + n6 + ", expected " + this.originalFields[i]);
            }
        }
        this.setFieldsNormalized(n5);
    }

    private long getFixedDate(int n, int n2, int n3) {
        Object object;
        Object object2 = 0;
        int n4 = 1;
        if (JapaneseImperialCalendar.isFieldSet(n3, 2)) {
            object2 = this.internalGet(2);
            if (object2 > 11) {
                n2 += object2 / 12;
                object2 %= 12;
            } else if (object2 < 0) {
                object = new int[1];
                n2 += CalendarUtils.floorDivide(object2, 12, (int[])object);
                object2 = object[0];
            }
        } else if (n2 == 1 && n != 0) {
            object = eras[n].getSinceDate();
            object2 = ((CalendarDate)object).getMonth() - 1;
            n4 = ((CalendarDate)object).getDayOfMonth();
        }
        if (n2 == MIN_VALUES[1]) {
            object = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
            Object object3 = ((CalendarDate)object).getMonth() - 1;
            if (object2 < object3) {
                object2 = object3;
            }
            if (object2 == object3) {
                n4 = ((CalendarDate)object).getDayOfMonth();
            }
        }
        object = jcal.newCalendarDate(TimeZone.NO_TIMEZONE);
        ((LocalGregorianCalendar.Date)object).setEra(n > 0 ? eras[n] : null);
        ((CalendarDate)object).setDate(n2, object2 + 1, n4);
        jcal.normalize((CalendarDate)object);
        long l = jcal.getFixedDate((CalendarDate)object);
        if (JapaneseImperialCalendar.isFieldSet(n3, 2)) {
            if (JapaneseImperialCalendar.isFieldSet(n3, 5)) {
                if (this.isSet(5)) {
                    l += (long)this.internalGet(5);
                    l -= (long)n4;
                }
            } else if (JapaneseImperialCalendar.isFieldSet(n3, 4)) {
                long l2 = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(l + 6L, this.getFirstDayOfWeek());
                if (l2 - l >= (long)this.getMinimalDaysInFirstWeek()) {
                    l2 -= 7L;
                }
                if (JapaneseImperialCalendar.isFieldSet(n3, 7)) {
                    l2 = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(l2 + 6L, this.internalGet(7));
                }
                l = l2 + (long)(7 * (this.internalGet(4) - 1));
            } else {
                int n5 = JapaneseImperialCalendar.isFieldSet(n3, 7) ? this.internalGet(7) : this.getFirstDayOfWeek();
                int n6 = JapaneseImperialCalendar.isFieldSet(n3, 8) ? this.internalGet(8) : 1;
                if (n6 >= 0) {
                    l = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(l + (long)(7 * n6) - 1L, n5);
                } else {
                    int n7 = this.monthLength((int)object2, n2) + 7 * (n6 + 1);
                    l = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(l + (long)n7 - 1L, n5);
                }
            }
        } else if (JapaneseImperialCalendar.isFieldSet(n3, 6)) {
            if (this.isTransitionYear(((LocalGregorianCalendar.Date)object).getNormalizedYear())) {
                l = this.getFixedDateJan1((LocalGregorianCalendar.Date)object, l);
            }
            l += (long)this.internalGet(6);
            --l;
        } else {
            int n8;
            long l3 = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(l + 6L, this.getFirstDayOfWeek());
            if (l3 - l >= (long)this.getMinimalDaysInFirstWeek()) {
                l3 -= 7L;
            }
            if (JapaneseImperialCalendar.isFieldSet(n3, 7) && (n8 = this.internalGet(7)) != this.getFirstDayOfWeek()) {
                l3 = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(l3 + 6L, n8);
            }
            l = l3 + 7L * ((long)this.internalGet(3) - 1L);
        }
        return l;
    }

    private long getFixedDateJan1(LocalGregorianCalendar.Date date, long l) {
        Era era = date.getEra();
        if (date.getEra() != null && date.getYear() == 1) {
            for (int i = JapaneseImperialCalendar.getEraIndex(date); i > 0; --i) {
                CalendarDate calendarDate = eras[i].getSinceDate();
                long l2 = gcal.getFixedDate(calendarDate);
                if (l2 > l) continue;
                return l2;
            }
        }
        Gregorian.Date date2 = gcal.newCalendarDate(TimeZone.NO_TIMEZONE);
        date2.setDate(date.getNormalizedYear(), 1, 1);
        return gcal.getFixedDate(date2);
    }

    private long getFixedDateMonth1(LocalGregorianCalendar.Date date, long l) {
        long l2;
        int n = JapaneseImperialCalendar.getTransitionEraIndex(date);
        if (n != -1 && (l2 = sinceFixedDates[n]) <= l) {
            return l2;
        }
        return l - (long)date.getDayOfMonth() + 1L;
    }

    private static LocalGregorianCalendar.Date getCalendarDate(long l) {
        LocalGregorianCalendar.Date date = jcal.newCalendarDate(TimeZone.NO_TIMEZONE);
        jcal.getCalendarDateFromFixedDate(date, l);
        return date;
    }

    private int monthLength(int n, int n2) {
        return CalendarUtils.isGregorianLeapYear(n2) ? GregorianCalendar.LEAP_MONTH_LENGTH[n] : GregorianCalendar.MONTH_LENGTH[n];
    }

    private int monthLength(int n) {
        assert (this.jdate.isNormalized());
        return this.jdate.isLeapYear() ? GregorianCalendar.LEAP_MONTH_LENGTH[n] : GregorianCalendar.MONTH_LENGTH[n];
    }

    private int actualMonthLength() {
        int n = jcal.getMonthLength(this.jdate);
        int n2 = JapaneseImperialCalendar.getTransitionEraIndex(this.jdate);
        if (n2 != -1) {
            long l = sinceFixedDates[n2];
            CalendarDate calendarDate = eras[n2].getSinceDate();
            n = l <= this.cachedFixedDate ? (n -= calendarDate.getDayOfMonth() - 1) : calendarDate.getDayOfMonth() - 1;
        }
        return n;
    }

    private static int getTransitionEraIndex(LocalGregorianCalendar.Date date) {
        int n = JapaneseImperialCalendar.getEraIndex(date);
        CalendarDate calendarDate = eras[n].getSinceDate();
        if (calendarDate.getYear() == date.getNormalizedYear() && calendarDate.getMonth() == date.getMonth()) {
            return n;
        }
        if (n < eras.length - 1 && (calendarDate = eras[++n].getSinceDate()).getYear() == date.getNormalizedYear() && calendarDate.getMonth() == date.getMonth()) {
            return n;
        }
        return -1;
    }

    private boolean isTransitionYear(int n) {
        for (int i = eras.length - 1; i > 0; --i) {
            int n2 = eras[i].getSinceDate().getYear();
            if (n == n2) {
                return true;
            }
            if (n > n2) break;
        }
        return false;
    }

    private static int getEraIndex(LocalGregorianCalendar.Date date) {
        Era era = date.getEra();
        for (int i = eras.length - 1; i > 0; --i) {
            if (eras[i] != era) continue;
            return i;
        }
        return 0;
    }

    private JapaneseImperialCalendar getNormalizedCalendar() {
        JapaneseImperialCalendar japaneseImperialCalendar;
        if (this.isFullyNormalized()) {
            japaneseImperialCalendar = this;
        } else {
            japaneseImperialCalendar = (JapaneseImperialCalendar)this.clone();
            japaneseImperialCalendar.setLenient(true);
            japaneseImperialCalendar.complete();
        }
        return japaneseImperialCalendar;
    }

    private void pinDayOfMonth(LocalGregorianCalendar.Date date) {
        int n = date.getYear();
        int n2 = date.getDayOfMonth();
        if (n != this.getMinimum(1)) {
            date.setDayOfMonth(1);
            jcal.normalize(date);
            int n3 = jcal.getMonthLength(date);
            if (n2 > n3) {
                date.setDayOfMonth(n3);
            } else {
                date.setDayOfMonth(n2);
            }
            jcal.normalize(date);
        } else {
            LocalGregorianCalendar.Date date2 = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
            LocalGregorianCalendar.Date date3 = jcal.getCalendarDate(this.time, this.getZone());
            long l = date3.getTimeOfDay();
            date3.addYear(400);
            date3.setMonth(date.getMonth());
            date3.setDayOfMonth(1);
            jcal.normalize(date3);
            int n4 = jcal.getMonthLength(date3);
            if (n2 > n4) {
                date3.setDayOfMonth(n4);
            } else if (n2 < date2.getDayOfMonth()) {
                date3.setDayOfMonth(date2.getDayOfMonth());
            } else {
                date3.setDayOfMonth(n2);
            }
            if (date3.getDayOfMonth() == date2.getDayOfMonth() && l < date2.getTimeOfDay()) {
                date3.setDayOfMonth(Math.min(n2 + 1, n4));
            }
            date.setDate(n, date3.getMonth(), date3.getDayOfMonth());
        }
    }

    private static int getRolledValue(int n, int n2, int n3, int n4) {
        assert (n >= n3 && n <= n4);
        int n5 = n4 - n3 + 1;
        int n6 = n + (n2 %= n5);
        if (n6 > n4) {
            n6 -= n5;
        } else if (n6 < n3) {
            n6 += n5;
        }
        assert (n6 >= n3 && n6 <= n4);
        return n6;
    }

    private int internalGetEra() {
        return this.isSet(0) ? this.internalGet(0) : currentEra;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.jdate == null) {
            this.jdate = jcal.newCalendarDate(this.getZone());
            this.cachedFixedDate = Long.MIN_VALUE;
        }
    }

    static {
        int n;
        jcal = (LocalGregorianCalendar)CalendarSystem.forName("japanese");
        gcal = CalendarSystem.getGregorianCalendar();
        BEFORE_MEIJI_ERA = new Era("BeforeMeiji", "BM", Long.MIN_VALUE, false);
        MIN_VALUES = new int[]{0, -292275055, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, -46800000, 0};
        LEAST_MAX_VALUES = new int[]{0, 0, 0, 0, 4, 28, 0, 7, 4, 1, 11, 23, 59, 59, 999, 50400000, 1200000};
        MAX_VALUES = new int[]{0, 292278994, 11, 53, 6, 31, 366, 7, 6, 1, 11, 23, 59, 59, 999, 50400000, 0x6DDD00};
        Era[] eraArray = jcal.getEras();
        int n2 = eraArray.length + 1;
        eras = new Era[n2];
        sinceFixedDates = new long[n2];
        int n3 = n = 0;
        JapaneseImperialCalendar.sinceFixedDates[n] = gcal.getFixedDate(BEFORE_MEIJI_ERA.getSinceDate());
        JapaneseImperialCalendar.eras[n++] = BEFORE_MEIJI_ERA;
        for (Era era : eraArray) {
            if (era.getSince(TimeZone.NO_TIMEZONE) < System.currentTimeMillis()) {
                n3 = n;
            }
            CalendarDate calendarDate = era.getSinceDate();
            JapaneseImperialCalendar.sinceFixedDates[n] = gcal.getFixedDate(calendarDate);
            JapaneseImperialCalendar.eras[n++] = era;
        }
        currentEra = n3;
        JapaneseImperialCalendar.LEAST_MAX_VALUES[0] = JapaneseImperialCalendar.MAX_VALUES[0] = eras.length - 1;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        Gregorian.Date date = gcal.newCalendarDate(TimeZone.NO_TIMEZONE);
        for (int i = 1; i < eras.length; ++i) {
            long l = sinceFixedDates[i];
            CalendarDate calendarDate = eras[i].getSinceDate();
            date.setDate(calendarDate.getYear(), 1, 1);
            long l2 = gcal.getFixedDate(date);
            if (l != l2) {
                n5 = Math.min((int)(l - l2) + 1, n5);
            }
            date.setDate(calendarDate.getYear(), 12, 31);
            l2 = gcal.getFixedDate(date);
            if (l != l2) {
                n5 = Math.min((int)(l2 - l) + 1, n5);
            }
            LocalGregorianCalendar.Date date2 = JapaneseImperialCalendar.getCalendarDate(l - 1L);
            int n6 = date2.getYear();
            if (date2.getMonth() != 1 || date2.getDayOfMonth() != 1) {
                --n6;
            }
            n4 = Math.min(n6, n4);
        }
        JapaneseImperialCalendar.LEAST_MAX_VALUES[1] = n4;
        JapaneseImperialCalendar.LEAST_MAX_VALUES[6] = n5;
    }
}

