/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.plugins;

import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.ICommand;
import com.ibm.j9ddr.tools.ddrinteractive.annotations.DebugExtension;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.PluginConfig;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.internal.org.objectweb.asm.AnnotationVisitor;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassVisitor;

public class DDRInteractiveClassLoader
extends ClassLoader {
    public static final String PLUGIN_SYSTEM_PROPERTY = "plugins";
    public static final String PLUGIN_ENV_VAR = "com.ibm.java.diagnostics.plugins";
    public static final String PLUGIN_ENV_VAR_ALT = "com_ibm_java_diagnostics_plugins";
    private static final String FILE_EXT_JAR = ".jar";
    private static final String FILE_EXT_CLASS = ".class";
    private static final String VM_ALLVERSIONS = "*";
    private static Logger logger = Logger.getLogger(DDRInteractiveClassLoader.class.getName());
    Level logLevelForPluginLoadFailures = Level.WARNING;
    private final String vmversion;
    private final ArrayList<PluginConfig> pluginCache = new ArrayList();
    private final ArrayList<PluginConfig> pluginFailures = new ArrayList();
    protected static ArrayList<String> runtimeCommandClasses = new ArrayList();
    private final ArrayList<File> pluginSearchPath = new ArrayList();
    static final String extensionClassname = DebugExtension.class.getName().replace('.', '/');
    static final String extensionDescriptor = "L" + extensionClassname + ";";
    private Map<String, ClassFile> classFilesOnClasspath = new HashMap<String, ClassFile>();

    public DDRInteractiveClassLoader(IVMData iVMData) throws DDRInteractiveCommandException {
        this(iVMData, (ClassLoader)iVMData.getClassLoader());
    }

    public DDRInteractiveClassLoader(IVMData iVMData, ClassLoader classLoader) throws DDRInteractiveCommandException {
        super(classLoader);
        this.vmversion = iVMData.getVersion();
        this.configureSearchPath();
        this.loadPlugins();
    }

    private void examineClass(URL uRL, Class<?> clazz) {
        DebugExtension debugExtension;
        if (clazz.isAnnotationPresent(DebugExtension.class) && null != (debugExtension = clazz.getAnnotation(DebugExtension.class))) {
            String[] stringArray;
            String string = debugExtension.VMVersion();
            for (String string2 : stringArray = string.split(",")) {
                Object object;
                if (string2.equals(this.vmversion) || string2.equals(VM_ALLVERSIONS)) {
                    if (this.hasCommandIFace(clazz)) {
                        object = new PluginConfig(clazz.getName(), this.vmversion, clazz, true, uRL);
                        this.pluginCache.add((PluginConfig)object);
                        logger.fine("Added command " + clazz.getName());
                        continue;
                    }
                    logger.fine("Skipping annotated command which did not implement the ICommand interface : " + clazz.getName());
                    continue;
                }
                object = String.format("Skipping %s as wrong VM version [allowed = %s, * : actual = %s]", clazz.getName(), this.vmversion, string2);
                logger.fine((String)object);
            }
        }
    }

    private void definePackage(String string) {
        String string2;
        int n = string.lastIndexOf(47);
        if (n != -1 && this.getPackage(string2 = string.substring(0, n)) == null) {
            this.definePackage(string2, "J9DDR", "0.1", "IBM", "J9DDR", "0.1", "IBM", null);
        }
    }

    private void configureSearchPath() {
        String[] stringArray;
        String string = System.getProperty(PLUGIN_SYSTEM_PROPERTY);
        if (null == string && (string = System.getenv(PLUGIN_ENV_VAR)) == null) {
            string = System.getenv(PLUGIN_ENV_VAR_ALT);
        }
        if (null == string || string.length() == 0) {
            logger.fine("No system property called plugins was found");
            return;
        }
        logger.fine("Plugins search path = " + string);
        for (String string2 : stringArray = string.split(File.pathSeparator)) {
            try {
                File file = new File(string2);
                this.pluginSearchPath.add(file);
            }
            catch (Exception exception) {
                logger.warning("Failed to create a URI or URL from " + string2);
            }
        }
    }

    public void loadPlugins() throws DDRInteractiveCommandException {
        this.scanForClassFiles();
        for (Map.Entry<String, ClassFile> entry : this.classFilesOnClasspath.entrySet()) {
            String string = entry.getKey();
            ClassFile classFile = entry.getValue();
            try {
                DTFJPluginSnifferVisitor dTFJPluginSnifferVisitor = DDRInteractiveClassLoader.sniffClassFile(classFile.getStreamForByteCode());
                if (!dTFJPluginSnifferVisitor.isDebugExtension) continue;
                Class<?> clazz = this.loadClass(string);
                this.examineClass(classFile.toURL(), clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(this.logLevelForPluginLoadFailures, "Exception while loading plugins : " + classNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                logger.fine(iOException.getMessage());
            }
        }
        this.addRuntimeCommands();
    }

    private void addRuntimeCommands() {
        for (String string : runtimeCommandClasses) {
            try {
                this.loadCommandClass(string, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(this.logLevelForPluginLoadFailures, "Could not load a runtime command class", classNotFoundException);
            }
        }
    }

    private void scanForClassFiles() throws DDRInteractiveCommandException {
        for (File file : this.pluginSearchPath) {
            logger.fine("Scanning path " + file + " in search of DDR plugins");
            if (!file.exists()) {
                logger.fine(String.format("Abandoning scan of DDR plugins search path: %s does not exist", file.getAbsolutePath()));
                throw new DDRInteractiveCommandException(file.getAbsolutePath() + " was specified on the plugins search path but it does not exist");
            }
            if (file.isDirectory()) {
                this.scanDirectory(file);
                continue;
            }
            this.scanFile(file);
        }
    }

    private void scanDirectory(File file) {
        File[] fileArray;
        logger.fine("Scanning directory " + file.getAbsolutePath());
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                this.scanDirectory(file2);
                continue;
            }
            this.scanFile(file2);
        }
    }

    private static String getExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (-1 == n || string.length() == n + 1) {
            return "";
        }
        return string.substring(n);
    }

    private void scanFile(File file) {
        logger.fine("Scanning file " + file.getAbsolutePath());
        String string = DDRInteractiveClassLoader.getExtension(file);
        if (string.equals(FILE_EXT_JAR)) {
            this.examineJarFile(file);
            return;
        }
        if (string.equals(FILE_EXT_CLASS)) {
            this.examineClassFile(file);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void examineClassFile(File file) {
        logger.fine("Found class file " + file.getAbsolutePath());
        if (file.length() > Integer.MAX_VALUE) {
            logger.fine("Skipping file " + file.getAbsolutePath() + " as the file size is > Integer.MAX_VALUE");
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            DTFJPluginSnifferVisitor dTFJPluginSnifferVisitor = DDRInteractiveClassLoader.sniffClassFile(fileInputStream);
            this.classFilesOnClasspath.put(dTFJPluginSnifferVisitor.className, new StandaloneClassFile(file));
        }
        catch (IOException iOException) {
            logger.log(this.logLevelForPluginLoadFailures, iOException.getMessage());
        }
        finally {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (IOException iOException) {
                logger.log(this.logLevelForPluginLoadFailures, "Error closing file " + file.getAbsolutePath(), iOException);
            }
        }
    }

    private static DTFJPluginSnifferVisitor sniffClassFile(InputStream inputStream) throws IOException {
        DTFJPluginSnifferVisitor dTFJPluginSnifferVisitor = new DTFJPluginSnifferVisitor();
        ClassReader classReader = new ClassReader(inputStream);
        classReader.accept(dTFJPluginSnifferVisitor, 7);
        return dTFJPluginSnifferVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void examineJarFile(File file) {
        logger.fine("Found jar file " + file.getAbsolutePath());
        JarInputStream jarInputStream = null;
        try {
            jarInputStream = new JarInputStream(new FileInputStream(file));
            JarEntry jarEntry = null;
            while (null != (jarEntry = jarInputStream.getNextJarEntry())) {
                if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(FILE_EXT_CLASS)) continue;
                if (jarEntry.getSize() > Integer.MAX_VALUE) {
                    logger.fine("Skipping jar entry " + jarEntry.getName() + " as the uncompressed size is > Integer.MAX_VALUE");
                    continue;
                }
                ClassFileWithinJarFile classFileWithinJarFile = new ClassFileWithinJarFile(file, jarEntry.getName());
                InputStream inputStream = ((ClassFile)classFileWithinJarFile).getStreamForByteCode();
                DTFJPluginSnifferVisitor dTFJPluginSnifferVisitor = DDRInteractiveClassLoader.sniffClassFile(inputStream);
                inputStream.close();
                this.classFilesOnClasspath.put(dTFJPluginSnifferVisitor.className, classFileWithinJarFile);
            }
        }
        catch (IOException iOException) {
            logger.log(this.logLevelForPluginLoadFailures, "Error reading from file " + file.getAbsolutePath(), iOException);
        }
        finally {
            if (null != jarInputStream) {
                try {
                    jarInputStream.close();
                }
                catch (IOException iOException) {
                    logger.log(this.logLevelForPluginLoadFailures, "Error closing file " + file.getAbsolutePath(), iOException);
                }
            }
        }
    }

    protected boolean hasCommandIFace(Class<?> clazz) {
        return ICommand.class.isAssignableFrom(clazz);
    }

    public ArrayList<PluginConfig> getPlugins() {
        return this.pluginCache;
    }

    public ArrayList<PluginConfig> getPluginFailures() {
        return this.pluginFailures;
    }

    @Override
    public Class<?> findClass(String string) throws ClassNotFoundException {
        logger.finest("Entered findClass with class name of " + string);
        if (this.classFilesOnClasspath.containsKey(string)) {
            logger.finest("Found match for with class " + string);
            return this.classFilesOnClasspath.get(string).loadByteCode();
        }
        throw new ClassNotFoundException("Unable to load class " + string);
    }

    private synchronized Class<?> loadCommandClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.loadClass(string, bl);
        try {
            URL uRL = new File("RuntimeLoad").toURI().toURL();
            this.examineClass(uRL, clazz);
        }
        catch (MalformedURLException malformedURLException) {
            logger.log(this.logLevelForPluginLoadFailures, "Exception thrown when forming URL from file \"RuntimeLoad\" : " + malformedURLException);
        }
        return clazz;
    }

    public void addCommandClass(String string) {
        runtimeCommandClasses.add(string);
    }

    public void removeCommandClass(String string) {
        if (!runtimeCommandClasses.remove(string)) {
            logger.fine(String.format("Ignored call to remove command %s as it was not previously added", new Object[0]));
        }
    }

    private class StandaloneClassFile
    extends ClassFile {
        private File classFile;

        public StandaloneClassFile(File file) {
            super(file.getAbsolutePath());
            this.classFile = file;
        }

        @Override
        public URL toURL() {
            try {
                return this.classFile.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                logger.log(DDRInteractiveClassLoader.this.logLevelForPluginLoadFailures, "Exception thrown when constructing URL from class file name " + this.classFile.getName());
                return null;
            }
        }

        @Override
        public InputStream getStreamForByteCode() throws FileNotFoundException, IOException {
            return new FileInputStream(this.classFile);
        }
    }

    private class ClassFileWithinJarFile
    extends ClassFile {
        private File jarFile;

        public ClassFileWithinJarFile(File file, String string) {
            super(string);
            this.jarFile = file;
        }

        @Override
        public URL toURL() {
            try {
                return new URL("jar:file:" + this.jarFile.getAbsolutePath() + "!/" + this.classFilePathName);
            }
            catch (MalformedURLException malformedURLException) {
                logger.log(DDRInteractiveClassLoader.this.logLevelForPluginLoadFailures, "Exception thrown when constructing URL from jar file name " + this.jarFile.getAbsolutePath() + " and class file name " + this.classFilePathName);
                return null;
            }
        }

        @Override
        public InputStream getStreamForByteCode() throws FileNotFoundException, IOException {
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(this.jarFile));
            JarEntry jarEntry = null;
            while (null != (jarEntry = jarInputStream.getNextJarEntry())) {
                if (!jarEntry.getName().equals(this.classFilePathName)) continue;
                return jarInputStream;
            }
            throw new FileNotFoundException();
        }
    }

    private abstract class ClassFile {
        protected String classFilePathName;
        boolean loaded = false;

        ClassFile(String string) {
            this.classFilePathName = string;
        }

        public abstract URL toURL();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Class<?> loadByteCode() {
            if (this.loaded) {
                logger.finest("Would load " + this.toURL() + " but it is already loaded (presumably because required by an earlier class)");
                return null;
            }
            InputStream inputStream = null;
            try {
                inputStream = this.getStreamForByteCode();
                byte[] byArray = this.readByteCodeFromStream(inputStream);
                Class<?> clazz = this.loadByteCodeFromBuffer(this.toURL(), null, byArray, 0, byArray.length);
                return clazz;
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.log(Level.FINE, "Unable to find file " + this.toURL(), fileNotFoundException);
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, "Error reading from file " + this.toURL(), iOException);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    logger.log(Level.FINE, "Error closing file " + this.toURL(), iOException);
                }
            }
            return null;
        }

        public abstract InputStream getStreamForByteCode() throws FileNotFoundException, IOException;

        private byte[] readByteCodeFromStream(InputStream inputStream) throws IOException {
            byte[] byArray = new byte[4096];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
            int n = 0;
            while (-1 != (n = inputStream.read(byArray))) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            return byteArrayOutputStream.toByteArray();
        }

        private Class<?> loadByteCodeFromBuffer(URL uRL, String string, byte[] byArray, int n, int n2) {
            try {
                logger.finer("About to call defineClass with byte code from " + uRL);
                Class clazz = DDRInteractiveClassLoader.this.defineClass(null, byArray, n, n2);
                logger.finer("Successful call to defineClass, loaded class is " + clazz.getName());
                this.loaded = true;
                if (null == string) {
                    DDRInteractiveClassLoader.this.definePackage(clazz.getName());
                } else {
                    DDRInteractiveClassLoader.this.definePackage(string);
                }
                return clazz;
            }
            catch (ClassFormatError classFormatError) {
                logger.log(DDRInteractiveClassLoader.this.logLevelForPluginLoadFailures, "ClassFormatError thrown when processing byte code from " + uRL + " : " + classFormatError);
                PluginConfig pluginConfig = new PluginConfig(uRL.toString(), classFormatError, uRL);
                DDRInteractiveClassLoader.this.pluginFailures.add(pluginConfig);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                logger.log(DDRInteractiveClassLoader.this.logLevelForPluginLoadFailures, "NoClassDefFoundError thrown when processing byte code from " + uRL + " : " + noClassDefFoundError);
                PluginConfig pluginConfig = new PluginConfig(uRL.toString(), noClassDefFoundError, uRL);
                DDRInteractiveClassLoader.this.pluginFailures.add(pluginConfig);
            }
            catch (SecurityException securityException) {
                logger.log(DDRInteractiveClassLoader.this.logLevelForPluginLoadFailures, "SecurityException thrown when processing byte code from " + uRL + " : " + securityException);
                PluginConfig pluginConfig = new PluginConfig(uRL.toString(), securityException, uRL);
                DDRInteractiveClassLoader.this.pluginFailures.add(pluginConfig);
            }
            catch (LinkageError linkageError) {
                logger.log(DDRInteractiveClassLoader.this.logLevelForPluginLoadFailures, "LinkageError thrown when processing byte code from " + uRL + " : " + linkageError);
                PluginConfig pluginConfig = new PluginConfig(uRL.toString(), linkageError, uRL);
                DDRInteractiveClassLoader.this.pluginFailures.add(pluginConfig);
            }
            return null;
        }
    }

    private static final class DTFJPluginSnifferVisitor
    extends ClassVisitor {
        boolean isDebugExtension;
        String className;

        DTFJPluginSnifferVisitor() {
            super(262144, null);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String string, boolean bl) {
            logger.finest("Inspecting annotation " + string + " looking for annotation " + extensionClassname);
            if (extensionDescriptor.equals(string)) {
                logger.finest("Found DebugExtension annotation");
                this.isDebugExtension = true;
            } else {
                logger.finest("Did not find DebugExtension annotation");
                this.isDebugExtension = false;
            }
            return null;
        }

        @Override
        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
            this.className = string.replace('/', '.');
        }
    }
}

