/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaStackPointer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class J9JavaStackIterator
implements Iterator<J9JavaStackPointer> {
    protected J9JavaStackPointer initialStack;
    protected J9JavaStackPointer currentStack;
    protected boolean consumedInitial;

    protected J9JavaStackIterator(J9JavaStackPointer j9JavaStackPointer) throws CorruptDataException {
        this.initialStack = j9JavaStackPointer;
        this.currentStack = j9JavaStackPointer;
    }

    public static J9JavaStackIterator fromJ9JavaStack(J9JavaStackPointer j9JavaStackPointer) throws CorruptDataException {
        return new J9JavaStackIterator(j9JavaStackPointer);
    }

    @Override
    public boolean hasNext() {
        return this.currentStack.notNull();
    }

    @Override
    public J9JavaStackPointer next() {
        try {
            if (this.hasNext()) {
                J9JavaStackPointer j9JavaStackPointer = this.currentStack;
                this.currentStack = this.currentStack.previous();
                return j9JavaStackPointer;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException corruptDataException) {
            this.currentStack = J9JavaStackPointer.NULL;
            EventManager.raiseCorruptDataEvent("Error getting next stack section", corruptDataException, false);
            return null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The image is read only and cannot be modified.");
    }
}

