/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.ByteDataWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ShrOffsetPointer;
import com.ibm.j9ddr.vm29.pointer.helper.SharedClassesMetaDataHelper;
import com.ibm.j9ddr.vm29.structure.ByteDataWrapper;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;

public class ByteDataWrapperHelper {
    public static I32 BDWEXTBLOCK(ByteDataWrapperPointer byteDataWrapperPointer, U8Pointer[] u8PointerArray) throws CorruptDataException {
        PointerPointer pointerPointer = byteDataWrapperPointer.externalBlockOffsetEA();
        if (null == u8PointerArray) {
            return I32Pointer.cast(pointerPointer).at(0L);
        }
        try {
            UDATA uDATA = J9ShrOffsetPointer.cast(pointerPointer).offset();
            return new I32(uDATA);
        }
        catch (NoClassDefFoundError | NoSuchFieldException throwable) {
            throw new CorruptDataException(throwable);
        }
    }

    public static U32 BDWLEN(ByteDataWrapperPointer byteDataWrapperPointer) throws CorruptDataException {
        return new U32(byteDataWrapperPointer.dataLength());
    }

    public static U8 BDWTYPE(ByteDataWrapperPointer byteDataWrapperPointer) throws CorruptDataException {
        return byteDataWrapperPointer.dataType();
    }

    public static U8Pointer getDataFromByteDataWrapper(ByteDataWrapperPointer byteDataWrapperPointer, U8Pointer[] u8PointerArray) throws CorruptDataException {
        PointerPointer pointerPointer = byteDataWrapperPointer.externalBlockOffsetEA();
        if (null == u8PointerArray) {
            I32 i32 = I32Pointer.cast(pointerPointer).at(0L);
            if (!i32.isZero()) {
                return U8Pointer.cast(byteDataWrapperPointer).add(i32);
            }
        } else {
            try {
                J9ShrOffsetPointer j9ShrOffsetPointer = J9ShrOffsetPointer.cast(pointerPointer);
                UDATA uDATA = j9ShrOffsetPointer.offset();
                if (!uDATA.isZero()) {
                    int n = SharedClassesMetaDataHelper.getCacheLayerFromJ9shrOffset(j9ShrOffsetPointer);
                    return u8PointerArray[n].add(uDATA);
                }
            }
            catch (NoClassDefFoundError | NoSuchFieldException throwable) {
                // empty catch block
            }
        }
        return U8Pointer.cast(byteDataWrapperPointer).add(ByteDataWrapper.SIZEOF);
    }

    public static U8 BDWINPRIVATEUSE(ByteDataWrapperPointer byteDataWrapperPointer) throws CorruptDataException {
        return byteDataWrapperPointer.inPrivateUse();
    }

    public static U16 BDWPRIVATEOWNERID(ByteDataWrapperPointer byteDataWrapperPointer) throws CorruptDataException {
        return byteDataWrapperPointer.privateOwnerID();
    }

    public static AbstractPointer BDWTOKEN(ByteDataWrapperPointer byteDataWrapperPointer, U8Pointer[] u8PointerArray) throws CorruptDataException {
        PointerPointer pointerPointer = byteDataWrapperPointer.tokenOffsetEA();
        if (null == u8PointerArray) {
            I32 i32 = I32Pointer.cast(pointerPointer).at(0L);
            if (!i32.isZero()) {
                return U8Pointer.cast(byteDataWrapperPointer).add(i32);
            }
        } else {
            try {
                J9ShrOffsetPointer j9ShrOffsetPointer = J9ShrOffsetPointer.cast(pointerPointer);
                UDATA uDATA = j9ShrOffsetPointer.offset();
                if (!uDATA.isZero()) {
                    int n = SharedClassesMetaDataHelper.getCacheLayerFromJ9shrOffset(j9ShrOffsetPointer);
                    return u8PointerArray[n].add(uDATA);
                }
            }
            catch (NoClassDefFoundError | NoSuchFieldException throwable) {
                throw new CorruptDataException(throwable);
            }
        }
        return U8Pointer.NULL;
    }
}

