/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ObjectToSparseDataHashTable;
import com.ibm.j9ddr.vm29.j9.gc.GCBase;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_SparseAddressOrderedFixedSizeDataPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_SparseDataTableEntryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_SparseVirtualMemoryPointer;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.Iterator;

public class DumpAllOffHeapEntriesCommand
extends Command {
    public DumpAllOffHeapEntriesCommand() {
        this.addCommand("dumpalloffheapentries", "[help]", "dump all off-heap entries");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        String string2;
        if (0 != stringArray.length && (string2 = stringArray[0]).equalsIgnoreCase("help")) {
            DumpAllOffHeapEntriesCommand.help(printStream);
            return;
        }
        boolean bl = false;
        try {
            J9HashTablePointer j9HashTablePointer;
            MM_SparseAddressOrderedFixedSizeDataPoolPointer mM_SparseAddressOrderedFixedSizeDataPoolPointer;
            MM_GCExtensionsPointer mM_GCExtensionsPointer = GCBase.getExtensions();
            MM_SparseVirtualMemoryPointer mM_SparseVirtualMemoryPointer = mM_GCExtensionsPointer.largeObjectVirtualMemory();
            if (mM_SparseVirtualMemoryPointer.notNull() && (mM_SparseAddressOrderedFixedSizeDataPoolPointer = mM_SparseVirtualMemoryPointer._sparseDataPool()).notNull() && (j9HashTablePointer = mM_SparseAddressOrderedFixedSizeDataPoolPointer._objectToSparseDataTable()).notNull()) {
                bl = true;
                HashTable<MM_SparseDataTableEntryPointer> hashTable = ObjectToSparseDataHashTable.fromJ9HashTable(j9HashTablePointer);
                Iterator iterator = hashTable.iterator();
                long l = hashTable.getCount();
                printStream.format("Off-heap entries (%,d entries)%n", l);
                if (0L < l) {
                    printStream.format("+------------------+------------------+------------------%n", new Object[0]);
                    printStream.format("| array object     | data address     | size             %n", new Object[0]);
                    printStream.format("+------------------+------------------+------------------%n", new Object[0]);
                    while (iterator.hasNext()) {
                        MM_SparseDataTableEntryPointer mM_SparseDataTableEntryPointer = MM_SparseDataTableEntryPointer.cast(iterator.nextAddress());
                        VoidPointer voidPointer = mM_SparseDataTableEntryPointer._dataPtr();
                        VoidPointer voidPointer2 = mM_SparseDataTableEntryPointer._proxyObjPtr();
                        UDATA uDATA = mM_SparseDataTableEntryPointer._size();
                        printStream.format(" 0x%016x 0x%016x 0x%016x%n", voidPointer2.getAddress(), voidPointer.getAddress(), uDATA.longValue());
                    }
                    printStream.format("+------------------+------------------+------------------%n", new Object[0]);
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            bl = false;
        }
        if (!bl) {
            printStream.format("This command requires a core file in which off-heap is enabled.%n", new Object[0]);
        }
    }

    private static void help(PrintStream printStream) {
        printStream.println("!dumpalloffheapentries       -- dump all off-heap entries");
    }
}

