/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.orb;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.spi.orb.DataCollector;
import com.sun.corba.se.spi.orb.PropertyParser;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class ParserImplBase {
    private ORBUtilSystemException wrapper = ORBUtilSystemException.get("orb.lifecycle");

    protected abstract PropertyParser makeParser();

    protected void complete() {
    }

    public void init(DataCollector dataCollector) {
        PropertyParser propertyParser = this.makeParser();
        dataCollector.setParser(propertyParser);
        Properties properties = dataCollector.getProperties();
        Map map = propertyParser.parse(properties);
        this.setFields(map);
    }

    private Field getAnyField(String string) {
        Field field = null;
        try {
            Class<? extends Object> clazz = this.getClass();
            field = clazz.getDeclaredField(string);
            while (field == null && (clazz = clazz.getSuperclass()) != null) {
                field = clazz.getDeclaredField(string);
            }
        }
        catch (Exception exception) {
            throw this.wrapper.fieldNotFound(exception, (Object)string);
        }
        if (field == null) {
            throw this.wrapper.fieldNotFound(string);
        }
        return field;
    }

    protected void setFields(Map map) {
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            final String string = (String)entry.getKey();
            final Object v = entry.getValue();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException, IllegalArgumentException {
                        Field field = ParserImplBase.this.getAnyField(string);
                        field.setAccessible(true);
                        field.set(ParserImplBase.this, v);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw this.wrapper.errorSettingField(privilegedActionException.getCause(), (Object)string, (Object)v.toString());
            }
        }
        this.complete();
    }
}

