/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.PrintStream;

public class LookupSymbolCommand
extends Command {
    protected String hexformat = null;

    public LookupSymbolCommand() {
        this.addCommand("sym", "<address>", "Display the symbol, or closest symbol to <address>");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length != 1) {
            printStream.println("Please supply a function pointer to lookup.");
            return;
        }
        boolean bl = context.process.bytesPerPointer() == 8;
        long l = CommandUtils.parsePointer(stringArray[0], bl);
        try {
            String string2 = context.process.getProcedureNameForAddress(l);
            printStream.println("Closest match:");
            printStream.println(string2);
        }
        catch (DataUnavailableException dataUnavailableException) {
            throw new DDRInteractiveCommandException(dataUnavailableException);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

