/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins;

import com.ibm.java.diagnostics.utils.plugins.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ClassInfo {
    private final List<String> ifaces = new ArrayList<String>();
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final String classname;
    private final URL url;
    private String superclass = null;

    public ClassInfo(String string, URL uRL) {
        this.classname = string;
        this.url = uRL;
    }

    public List<String> getInterfaces() {
        return this.ifaces;
    }

    public void addInterface(String string) {
        this.ifaces.add(string);
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public boolean hasInterface(Class<?> clazz) {
        return this.ifaces.contains(clazz.getName());
    }

    public boolean hasInterface(String string) {
        return this.ifaces.contains(string);
    }

    public boolean hasAnnotation(String string) {
        Annotation annotation = new Annotation(string);
        return this.annotations.contains(annotation);
    }

    public Annotation getAnnotation(String string) {
        Annotation annotation = new Annotation(string);
        int n = this.annotations.indexOf(annotation);
        if (n == -1) {
            return null;
        }
        return this.annotations.get(n);
    }

    public Annotation addAnnotation(String string) {
        int n = this.annotations.indexOf(string);
        if (n == -1) {
            Annotation annotation = new Annotation(string);
            this.annotations.add(annotation);
            return annotation;
        }
        return this.annotations.get(n);
    }

    public String getClassname() {
        return this.classname;
    }

    public URL getURL() {
        return this.url;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(String string) {
        this.superclass = string;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ClassInfo)) {
            return false;
        }
        ClassInfo classInfo = (ClassInfo)object;
        return this.classname.equals(classInfo.classname);
    }

    public int hashCode() {
        return this.classname.hashCode();
    }
}

