/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.ICommand;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public abstract class Command
implements ICommand {
    protected static final String nl = System.getProperty("line.separator");
    private HashMap<String, CommandDescription> _commandNames = new HashMap();

    public CommandDescription addCommand(String string, String string2, String string3) {
        CommandDescription commandDescription = new CommandDescription(string, string2, string3);
        this._commandNames.put(string, commandDescription);
        return commandDescription;
    }

    public void addSubCommand(CommandDescription commandDescription, String string, String string2, String string3) {
        commandDescription.addSubCommand(string, string2, string3);
    }

    @Override
    public boolean recognises(String string, Context context) {
        if (string.charAt(0) == '!') {
            string = string.substring(1);
        }
        Iterator<String> iterator = this._commandNames.keySet().iterator();
        while (iterator.hasNext()) {
            if (!string.equalsIgnoreCase(iterator.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> getCommandDescriptions() {
        String string = new String();
        for (CommandDescription commandDescription : this._commandNames.values()) {
            string = string + String.format("%-25s %-20s %s\n", commandDescription.commandName, commandDescription.argumentDescription, commandDescription.helpDescription);
        }
        return Collections.singleton(string);
    }

    public Set<String> getCommandNames() {
        return this._commandNames.keySet();
    }

    public void printDetailedHelp(PrintStream printStream) {
        for (CommandDescription commandDescription : this._commandNames.values()) {
            printStream.println(commandDescription.getCommandName() + "\t" + commandDescription.getArgumentDescription() + "\t\t" + commandDescription.helpDescription);
            for (CommandDescription commandDescription2 : commandDescription._subCommandNames.values()) {
                printStream.println("\t" + commandDescription2.getCommandName() + "\t" + commandDescription2.getArgumentDescription() + "\t\t" + commandDescription2.helpDescription);
            }
        }
    }

    protected long dbgFindPatternInRange(Context context, byte[] byArray, int n, long l, BigInteger bigInteger) throws MemoryFault {
        long l2 = l;
        BigInteger bigInteger2 = new BigInteger(Long.toBinaryString(l), 2);
        BigInteger bigInteger3 = context.process.bytesPerPointer() == 4 ? CommandUtils.UDATA_MAX_32BIT : CommandUtils.UDATA_MAX_64BIT;
        if (bigInteger2.add(bigInteger).compareTo(bigInteger3) == 1) {
            bigInteger = bigInteger3.subtract(bigInteger2);
        }
        while ((l2 & 0xFFFL) != 0L) {
            --l2;
            bigInteger = bigInteger.add(BigInteger.ONE);
        }
        BigInteger bigInteger4 = BigInteger.ZERO;
        while (true) {
            byte[] byArray2 = new byte[4096];
            try {
                int n2 = context.process.getBytesAt(l2, byArray2);
                bigInteger4 = bigInteger4.add(new BigInteger(Integer.toString(n2)));
                for (int i = 0; i < n2 - byArray.length; i += n) {
                    if (!this.compare(byArray2, byArray, i) || l2 + (long)i < l) continue;
                    return l2 + (long)i;
                }
            }
            catch (MemoryFault memoryFault) {
                // empty catch block
            }
            if (bigInteger.compareTo(new BigInteger("4096")) == -1) break;
            l2 += 4096L;
            bigInteger = bigInteger.subtract(new BigInteger("4096"));
        }
        return 0L;
    }

    private boolean compare(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    protected class CommandDescription {
        private String commandName;
        private String argumentDescription;
        private String helpDescription;
        private HashMap<String, CommandDescription> _subCommandNames = new HashMap();

        public CommandDescription(String string, String string2, String string3) {
            this.commandName = string;
            this.argumentDescription = string2;
            this.helpDescription = string3;
        }

        public void addSubCommand(String string, String string2, String string3) {
            CommandDescription commandDescription = new CommandDescription(string, string2, string3);
            this._subCommandNames.put(string, commandDescription);
        }

        public String getCommandName() {
            return this.commandName;
        }

        public String getArgumentDescription() {
            return this.argumentDescription;
        }

        public String getCommandDescription() {
            return this.helpDescription;
        }
    }
}

