/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.util.PatternString;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.walkers.FilteredROMClassesIterator;
import com.ibm.j9ddr.vm29.j9.walkers.J9ROMClassAndMethod;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMNameAndSignaturePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilteredROMMethodsIterator
implements Iterator<J9ROMClassAndMethod>,
Iterable<J9ROMClassAndMethod> {
    J9ROMClassAndMethod nextMethod = null;
    J9ROMClassPointer currentRomClass = null;
    final FilteredROMClassesIterator classIterator;
    private PatternString classPattern = null;
    private PatternString methodPattern;
    private PatternString signaturePattern;
    private J9ROMMethodPointer currentRomMethod;
    private int remainingMethods = 0;

    public FilteredROMMethodsIterator(PrintStream printStream, Context context, String string) throws CorruptDataException {
        this.setPatterns(string);
        J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (null == j9JavaVMPointer) {
            throw new CorruptDataException("Unable to find the VM in core dump!");
        }
        this.classIterator = new FilteredROMClassesIterator(printStream, j9JavaVMPointer.classMemorySegments(), this.classPattern);
        this.resetMethodIterationState();
    }

    private void resetMethodIterationState() {
        this.currentRomClass = null;
        this.currentRomMethod = null;
        this.remainingMethods = 0;
    }

    private void setPatterns(String string) {
        String string2 = "*";
        String string3 = "*";
        String string4 = "*";
        int n = string.indexOf(40);
        int n2 = string.indexOf(46);
        if (n2 != -1) {
            int n3 = n >= 0 ? n : string.length();
            string2 = string.substring(0, n2);
            string3 = string.substring(n2 + 1, n3);
        } else {
            string3 = string;
        }
        if (n != -1) {
            string4 = string.substring(n);
        }
        this.classPattern = new PatternString(string2);
        this.methodPattern = new PatternString(string3);
        this.signaturePattern = new PatternString(string4);
    }

    @Override
    public boolean hasNext() {
        if (null == this.nextMethod) {
            this.nextMethod = this.next();
        }
        return null != this.nextMethod;
    }

    @Override
    public J9ROMClassAndMethod next() {
        J9ROMClassAndMethod j9ROMClassAndMethod = this.nextMethod;
        this.nextMethod = null;
        if (null == j9ROMClassAndMethod) {
            do {
                try {
                    if (null != this.currentRomMethod && this.remainingMethods > 0) {
                        String string;
                        J9ROMMethodPointer j9ROMMethodPointer = this.currentRomMethod;
                        J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer = j9ROMMethodPointer.nameAndSignature();
                        J9UTF8Pointer j9UTF8Pointer = j9ROMNameAndSignaturePointer.name();
                        String string2 = J9UTF8Helper.stringValue(j9UTF8Pointer);
                        if (this.methodPattern.isMatch(string2) && this.signaturePattern.isMatch(string = J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.signature()))) {
                            j9ROMClassAndMethod = new J9ROMClassAndMethod(j9ROMMethodPointer, this.currentRomClass);
                        }
                        this.currentRomMethod = ROMHelp.nextROMMethod(this.currentRomMethod);
                        --this.remainingMethods;
                        continue;
                    }
                    if (this.goToNextClass()) continue;
                    break;
                }
                catch (CorruptDataException corruptDataException) {
                    throw new NoSuchElementException();
                }
            } while (null == j9ROMClassAndMethod);
        }
        return j9ROMClassAndMethod;
    }

    private boolean goToNextClass() throws CorruptDataException {
        this.resetMethodIterationState();
        boolean bl = false;
        while (null == this.currentRomMethod && this.classIterator.hasNext()) {
            J9ROMClassPointer j9ROMClassPointer = this.classIterator.next();
            String string = J9UTF8Helper.stringValue(j9ROMClassPointer.className());
            if (!this.classPattern.isMatch(string) || j9ROMClassPointer.romMethodCount().longValue() <= 0L) continue;
            this.currentRomClass = j9ROMClassPointer;
            this.currentRomMethod = this.currentRomClass.romMethods();
            this.remainingMethods = this.currentRomClass.romMethodCount().intValue();
            bl = true;
        }
        return bl;
    }

    @Override
    public Iterator<J9ROMClassAndMethod> iterator() {
        return this;
    }

    @Override
    public void remove() {
    }
}

