/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.structure.J9BCTranslationData;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.commands.J9BCUtil;
import java.io.PrintStream;

public class BytecodesCommand
extends Command {
    public BytecodesCommand() {
        this.addCommand("bytecodes", "<address>[,maps]", "cfdump the specified J9Method. (maps is optional)");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            long l = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.J9VM_ENV_DATA64);
            J9MethodPointer j9MethodPointer = J9MethodPointer.cast(l);
            long l2 = 0L;
            if (j9MethodPointer.isNull()) {
                CommandUtils.dbgPrint(printStream, "bad or missing ram method addr\n");
                return;
            }
            J9ClassPointer j9ClassPointer = ConstantPoolHelpers.J9_CLASS_FROM_METHOD(j9MethodPointer);
            if (stringArray.length == 2 && stringArray[1].equals("maps")) {
                l2 |= J9BCTranslationData.BCT_DumpMaps;
            }
            l2 = J9BuildFlags.J9VM_ENV_LITTLE_ENDIAN ? (l2 |= J9BCTranslationData.BCT_LittleEndianOutput) : (l2 |= J9BCTranslationData.BCT_BigEndianOutput);
            J9ROMMethodPointer j9ROMMethodPointer = J9MethodHelper.romMethod(j9MethodPointer);
            J9ROMClassPointer j9ROMClassPointer = j9ClassPointer.romClass();
            J9BCUtil.j9bcutil_dumpRomMethod(printStream, j9ROMMethodPointer, j9ROMClassPointer, l2, 0);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

