/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.J9ROMFieldShapeIterator;
import com.ibm.j9ddr.vm29.j9.OptInfo;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.walkers.LineNumber;
import com.ibm.j9ddr.vm29.j9.walkers.LineNumberIterator;
import com.ibm.j9ddr.vm29.j9.walkers.LocalVariableTable;
import com.ibm.j9ddr.vm29.j9.walkers.LocalVariableTableIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.FloatPointer;
import com.ibm.j9ddr.vm29.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9EnclosingObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ExceptionHandlerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ExceptionInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodDebugInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodParameterPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodParametersDataPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodHandleRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodTypeRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMNameAndSignaturePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMSingleSlotConstantRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMStringRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SourceDebugExtensionPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodDebugInfoHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMFieldShapeHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.pointer.helper.ValueTypeHelper;
import com.ibm.j9ddr.vm29.structure.J9BCTranslationData;
import com.ibm.j9ddr.vm29.structure.J9CfrClassFile;
import com.ibm.j9ddr.vm29.structure.J9ConstantPool;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9DescriptionBits;
import com.ibm.j9ddr.vm29.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9ROMMethodHandleRef;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.commands.ByteCodeDumper;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class J9BCUtil {
    private static final String nl = System.getProperty("line.separator");
    private static final int MODIFIERSOURCE_CLASS = 1;
    private static final int MODIFIERSOURCE_METHOD = 2;
    private static final int MODIFIERSOURCE_FIELD = 3;
    private static final int MODIFIERSOURCE_METHODPARAMETER = 4;
    private static final int ONLY_SPEC_MODIFIERS = 1;
    private static final int INCLUDE_INTERNAL_MODIFIERS = 2;
    public static int BCUtil_DumpAnnotations = 1;
    private static final long CFR_ACC_STRICT_INIT = J9CfrClassFile.CFR_ACC_STRICT;

    public static void j9bcutil_dumpRomMethod(PrintStream printStream, J9ROMMethodPointer j9ROMMethodPointer, J9ROMClassPointer j9ROMClassPointer, long l, int n) throws CorruptDataException {
        J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer = j9ROMMethodPointer.nameAndSignature();
        J9UTF8Pointer j9UTF8Pointer = j9ROMNameAndSignaturePointer.name();
        J9UTF8Pointer j9UTF8Pointer2 = j9ROMNameAndSignaturePointer.signature();
        J9ROMConstantPoolItemPointer j9ROMConstantPoolItemPointer = J9ROMClassHelper.constantPool(j9ROMClassPointer);
        printStream.append("  Name: " + J9UTF8Helper.stringValue(j9UTF8Pointer) + nl);
        printStream.append("  Signature: " + J9UTF8Helper.stringValue(j9UTF8Pointer2) + nl);
        printStream.append(String.format("  Access Flags (%s): ", Long.toHexString(j9ROMMethodPointer.modifiers().longValue())));
        J9BCUtil.dumpModifiers(printStream, j9ROMMethodPointer.modifiers().longValue(), 2, 2, false);
        printStream.append(nl);
        printStream.append("  Internal Attribute Flags:");
        J9BCUtil.dumpMethodJ9Modifiers(printStream, j9ROMMethodPointer.modifiers(), J9ROMMethodHelper.getExtendedModifiersDataFromROMMethod(j9ROMMethodPointer));
        printStream.append(nl);
        printStream.append("  Max Stack: " + j9ROMMethodPointer.maxStack().longValue() + nl);
        if (J9ROMMethodHelper.hasExceptionInfo(j9ROMMethodPointer)) {
            long l2;
            StructurePointer structurePointer;
            J9ExceptionInfoPointer j9ExceptionInfoPointer = ROMHelp.J9_EXCEPTION_DATA_FROM_ROM_METHOD(j9ROMMethodPointer);
            long l3 = j9ExceptionInfoPointer.catchCount().longValue();
            if (l3 > 0L) {
                J9ExceptionHandlerPointer j9ExceptionHandlerPointer = ROMHelp.J9EXCEPTIONINFO_HANDLERS(j9ExceptionInfoPointer);
                printStream.append(String.format("  Caught Exceptions (%d):", l3));
                printStream.append(nl);
                printStream.append("     start   end   handler   catch type" + nl);
                printStream.append("     -----   ---   -------   ----------" + nl);
                int n2 = 0;
                while ((long)n2 < l3) {
                    printStream.append(String.format("     %d  %d  %d   ", j9ExceptionHandlerPointer.startPC().longValue(), j9ExceptionHandlerPointer.endPC().longValue(), j9ExceptionHandlerPointer.handlerPC().longValue()));
                    long l4 = j9ExceptionHandlerPointer.exceptionClassIndex().longValue();
                    if (l4 != 0L) {
                        J9ROMConstantPoolItemPointer j9ROMConstantPoolItemPointer2 = j9ROMConstantPoolItemPointer.add(l4);
                        structurePointer = J9ROMStringRefPointer.cast(j9ROMConstantPoolItemPointer2.longValue());
                        printStream.append(J9UTF8Helper.stringValue(((J9ROMStringRefPointer)structurePointer).utf8Data()));
                    } else {
                        printStream.append("(any)");
                    }
                    printStream.append(nl);
                    j9ExceptionHandlerPointer = j9ExceptionHandlerPointer.add(1L);
                    ++n2;
                }
            }
            if ((l2 = j9ExceptionInfoPointer.throwCount().longValue()) > 0L) {
                printStream.append(String.format("  Thrown Exceptions (%d):", l2));
                printStream.append(nl);
                SelfRelativePointer selfRelativePointer = ROMHelp.J9EXCEPTIONINFO_THROWNAMES(j9ExceptionInfoPointer);
                for (long i = 0L; i < l2; ++i) {
                    structurePointer = J9UTF8Pointer.cast(selfRelativePointer.get());
                    printStream.append("    ");
                    printStream.append(J9UTF8Helper.stringValue((J9UTF8Pointer)structurePointer));
                    printStream.append(nl);
                }
            }
        }
        if (j9ROMMethodPointer.modifiers().anyBitsIn(J9CfrClassFile.CFR_ACC_NATIVE)) {
            J9BCUtil.dumpNative(printStream, j9ROMMethodPointer, l);
        } else {
            J9BCUtil.dumpBytecodes(printStream, j9ROMClassPointer, j9ROMMethodPointer, l);
        }
        J9BCUtil.dumpMethodDebugInfo(printStream, j9ROMClassPointer, j9ROMMethodPointer, l);
        J9BCUtil.dumpStackMapTable(printStream, j9ROMClassPointer, j9ROMMethodPointer, l);
        J9BCUtil.dumpMethodParameters(printStream, j9ROMClassPointer, j9ROMMethodPointer, l);
        if (0 != (BCUtil_DumpAnnotations & n)) {
            J9BCUtil.dumpMethodAnnotations(printStream, j9ROMMethodPointer);
        }
        printStream.append(nl);
    }

    private static void dumpModifiers(PrintStream printStream, long l, int n, int n2, boolean bl) {
        switch (n) {
            case 1: {
                l &= J9CfrClassFile.CFR_CLASS_ACCESS_MASK;
                break;
            }
            case 2: {
                if (1 == n2) {
                    l &= J9CfrClassFile.CFR_METHOD_ACCESS_MASK;
                    break;
                }
                l &= J9CfrClassFile.CFR_METHOD_ACCESS_MASK | J9CfrClassFile.CFR_ACC_EMPTY_METHOD | J9CfrClassFile.CFR_ACC_FORWARDER_METHOD;
                break;
            }
            case 3: {
                if (1 == n2) {
                    l &= J9CfrClassFile.CFR_FIELD_ACCESS_MASK;
                    break;
                }
                l &= J9CfrClassFile.CFR_FIELD_ACCESS_MASK | J9FieldFlags.J9FieldFlagConstant | J9FieldFlags.J9FieldFlagIsNullRestricted;
                break;
            }
            case 4: {
                if (1 == n2) {
                    l &= J9CfrClassFile.CFR_ATTRIBUTE_METHOD_PARAMETERS_MASK;
                    break;
                }
                l &= J9CfrClassFile.CFR_ATTRIBUTE_METHOD_PARAMETERS_MASK;
                break;
            }
            default: {
                printStream.append("TYPE OF MODIFIER IS INVALID");
                return;
            }
        }
        if (2 == n2) {
            if (2 == n) {
                if ((l & J9CfrClassFile.CFR_ACC_EMPTY_METHOD) != 0L) {
                    printStream.append("(empty) ");
                    l &= J9CfrClassFile.CFR_ACC_EMPTY_METHOD ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if ((l & J9CfrClassFile.CFR_ACC_FORWARDER_METHOD) != 0L) {
                    printStream.append("(forwarder) ");
                    l &= J9CfrClassFile.CFR_ACC_FORWARDER_METHOD ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if ((l & J9CfrClassFile.CFR_ACC_VTABLE) != 0L) {
                    printStream.append("(vtable) ");
                    l &= J9CfrClassFile.CFR_ACC_VTABLE ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if ((l & J9CfrClassFile.CFR_ACC_HAS_EXCEPTION_INFO) != 0L) {
                    printStream.append("(hasExceptionInfo) ");
                    l &= J9CfrClassFile.CFR_ACC_HAS_EXCEPTION_INFO ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
            if (3 == n) {
                if ((l & J9FieldFlags.J9FieldFlagConstant) != 0L) {
                    printStream.append("(constant) ");
                    l &= J9FieldFlags.J9FieldFlagConstant ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if ((l & J9FieldFlags.J9FieldFlagIsNullRestricted) != 0L) {
                    printStream.append("(NullRestricted) ");
                    l &= J9FieldFlags.J9FieldFlagIsNullRestricted ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
        }
        if (4 != n) {
            if ((l & J9CfrClassFile.CFR_PUBLIC_PRIVATE_PROTECTED_MASK) == 0L) {
                printStream.append("default ");
            } else {
                if ((l & J9CfrClassFile.CFR_ACC_PUBLIC) != 0L) {
                    printStream.append("public ");
                    l &= J9CfrClassFile.CFR_ACC_PUBLIC ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if ((l & J9CfrClassFile.CFR_ACC_PROTECTED) != 0L) {
                    printStream.append("protected ");
                    l &= J9CfrClassFile.CFR_ACC_PROTECTED ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if ((l & J9CfrClassFile.CFR_ACC_PRIVATE) != 0L) {
                    printStream.append("private ");
                    l &= J9CfrClassFile.CFR_ACC_PRIVATE ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
        }
        if ((l & J9CfrClassFile.CFR_ACC_STATIC) != 0L) {
            printStream.append("static ");
            l &= J9CfrClassFile.CFR_ACC_STATIC ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if ((l & J9CfrClassFile.CFR_ACC_FINAL) != 0L) {
            printStream.append("final ");
            l &= J9CfrClassFile.CFR_ACC_FINAL ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if ((l & J9CfrClassFile.CFR_ACC_SYNTHETIC) != 0L) {
            printStream.append("synthetic ");
            l &= J9CfrClassFile.CFR_ACC_SYNTHETIC ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (4 == n && 0L != (l & J9CfrClassFile.CFR_ACC_MANDATED)) {
            printStream.append("mandated");
            l &= J9CfrClassFile.CFR_ACC_MANDATED ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (n != 2) {
            if ((l & J9CfrClassFile.CFR_ACC_ABSTRACT) != 0L) {
                printStream.append("abstract ");
                l &= J9CfrClassFile.CFR_ACC_ABSTRACT ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((l & J9CfrClassFile.CFR_ACC_ENUM) != 0L) {
                printStream.append("enum ");
                l &= J9CfrClassFile.CFR_ACC_ENUM ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (n == 1) {
            if ((l & J9CfrClassFile.CFR_ACC_INTERFACE) != 0L) {
                printStream.append("interface ");
                l &= J9CfrClassFile.CFR_ACC_INTERFACE ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((l & J9CfrClassFile.CFR_ACC_SUPER) != 0L) {
                printStream.append("super ");
                l &= J9CfrClassFile.CFR_ACC_SUPER ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((l & J9CfrClassFile.CFR_ACC_ANNOTATION) != 0L) {
                printStream.append("annotation ");
                l &= J9CfrClassFile.CFR_ACC_ANNOTATION ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (bl) {
                printStream.append("value ");
            }
        }
        if (n == 2) {
            if ((l & J9CfrClassFile.CFR_ACC_SYNCHRONIZED) != 0L) {
                printStream.append("synchronized ");
                l &= J9CfrClassFile.CFR_ACC_SYNCHRONIZED ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((l & J9CfrClassFile.CFR_ACC_BRIDGE) != 0L) {
                printStream.append("bridge ");
                l &= J9CfrClassFile.CFR_ACC_BRIDGE ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((l & J9CfrClassFile.CFR_ACC_VARARGS) != 0L) {
                printStream.append("varargs ");
                l &= J9CfrClassFile.CFR_ACC_VARARGS ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((l & J9CfrClassFile.CFR_ACC_NATIVE) != 0L) {
                printStream.append("native ");
                l &= J9CfrClassFile.CFR_ACC_NATIVE ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((l & J9CfrClassFile.CFR_ACC_STRICT) != 0L) {
                printStream.append("strict ");
                l &= J9CfrClassFile.CFR_ACC_STRICT ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (n == 3) {
            if ((l & J9CfrClassFile.CFR_ACC_VOLATILE) != 0L) {
                printStream.append("volatile ");
                l &= J9CfrClassFile.CFR_ACC_VOLATILE ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((l & J9CfrClassFile.CFR_ACC_TRANSIENT) != 0L) {
                printStream.append("transient ");
                l &= J9CfrClassFile.CFR_ACC_TRANSIENT ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((l & CFR_ACC_STRICT_INIT) != 0L) {
                printStream.append("strict ");
                l &= CFR_ACC_STRICT_INIT ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (l != 0L) {
            printStream.append(String.format("unknown_flags = 0x%X", l));
        }
    }

    private static void dumpNative(PrintStream printStream, J9ROMMethodPointer j9ROMMethodPointer, long l) throws CorruptDataException {
        U8Pointer u8Pointer = J9ROMMethodHelper.bytecodes(j9ROMMethodPointer);
        long l2 = u8Pointer.at(0L).longValue();
        U8 u8 = u8Pointer.at(1L);
        U8Pointer u8Pointer2 = u8Pointer.add(2L);
        String[] stringArray = new String[]{"void", "boolean", "byte", "char", "short", "float", "int", "double", "long", "object"};
        printStream.append(String.format("  Argument Count: %d", j9ROMMethodPointer.argCount().longValue()));
        printStream.append(nl);
        printStream.append(String.format("  Temp Count: %d", j9ROMMethodPointer.tempCount().longValue()));
        printStream.append(nl);
        printStream.append(String.format("  Native Argument Count: %d, types: (", l2));
        for (long i = l2; i > 0L; --i) {
            printStream.append(stringArray[u8Pointer2.at(0L).intValue()]);
            u8Pointer2 = u8Pointer2.add(1L);
            if (i == 1L) continue;
            printStream.append(",");
        }
        printStream.append(String.format(") %s ", stringArray[u8.intValue()]));
        printStream.append(nl);
    }

    private static void dumpBytecodes(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer, J9ROMMethodPointer j9ROMMethodPointer, long l) throws CorruptDataException {
        try {
            ByteCodeDumper.dumpBytecodes(printStream, j9ROMClassPointer, j9ROMMethodPointer, new U32(l));
        }
        catch (Exception exception) {
            throw new CorruptDataException(exception);
        }
    }

    private static void dumpMethodDebugInfo(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer, J9ROMMethodPointer j9ROMMethodPointer, long l) throws CorruptDataException {
        J9MethodDebugInfoPointer j9MethodDebugInfoPointer;
        if ((l & J9BCTranslationData.BCT_StripDebugAttributes) == 0L && !(j9MethodDebugInfoPointer = ROMHelp.getMethodDebugInfoFromROMMethod(j9ROMMethodPointer)).isNull()) {
            Object object;
            Object object2;
            printStream.append(nl);
            printStream.append("  Debug Info:");
            printStream.append(nl);
            printStream.append(String.format("    Line Number Table (%d):", J9MethodDebugInfoHelper.getLineNumberCount(j9MethodDebugInfoPointer).intValue()));
            printStream.append(nl);
            LineNumberIterator lineNumberIterator = LineNumberIterator.lineNumberIteratorFor(j9MethodDebugInfoPointer);
            while (lineNumberIterator.hasNext()) {
                object2 = (LineNumber)lineNumberIterator.next();
                if (null == object2) {
                    printStream.append("      Bad compressed data \n");
                    object = lineNumberIterator.getLineNumberTablePtr();
                    int n = J9MethodDebugInfoHelper.getLineNumberCompressedSize(j9MethodDebugInfoPointer).sub(((AbstractPointer)object).sub(J9MethodDebugInfoHelper.getLineNumberTableForROMClass(j9MethodDebugInfoPointer))).intValue();
                    while (0 < n--) {
                        printStream.append("      " + ((U8Pointer)object).at(0L));
                        printStream.append(nl);
                        object = ((U8Pointer)object).add(1L);
                    }
                    break;
                }
                printStream.append(String.format("      Line: %5d PC: %5d", ((LineNumber)object2).getLineNumber().longValue(), ((LineNumber)object2).getLocation().longValue()));
                printStream.append(nl);
            }
            printStream.append(nl);
            printStream.append(String.format("    Variables (%d):", j9MethodDebugInfoPointer.varInfoCount().longValue()));
            printStream.append(nl);
            object2 = LocalVariableTableIterator.localVariableTableIteratorFor(j9MethodDebugInfoPointer);
            while (object2.hasNext()) {
                object = (LocalVariableTable)object2.next();
                printStream.append(String.format("      Slot: %d", ((LocalVariableTable)object).getSlotNumber().intValue()));
                printStream.append(nl);
                printStream.append(String.format("      Visibility Start: %d", ((LocalVariableTable)object).getStartVisibility().intValue()));
                printStream.append(nl);
                printStream.append(String.format("      Visibility End: %d", ((LocalVariableTable)object).getStartVisibility().intValue() + ((LocalVariableTable)object).getVisibilityLength().intValue()));
                printStream.append(nl);
                printStream.append(String.format("      Visibility Length: %d", ((LocalVariableTable)object).getVisibilityLength().intValue()));
                printStream.append(nl);
                printStream.append("      Name: ");
                if (null != ((LocalVariableTable)object).getName() && !((LocalVariableTable)object).getName().isNull()) {
                    printStream.append(String.format("%s", J9UTF8Helper.stringValue(((LocalVariableTable)object).getName())));
                } else {
                    printStream.append("None");
                }
                printStream.append(nl);
                printStream.append("      Signature: ");
                if (null != ((LocalVariableTable)object).getSignature() && !((LocalVariableTable)object).getSignature().isNull()) {
                    printStream.append(String.format("%s", J9UTF8Helper.stringValue(((LocalVariableTable)object).getSignature())));
                } else {
                    printStream.append("None");
                }
                printStream.append(nl);
                printStream.append("      Generic Signature: ");
                if (null != ((LocalVariableTable)object).getGenericSignature() && !((LocalVariableTable)object).getGenericSignature().isNull()) {
                    printStream.append(String.format("%s", J9UTF8Helper.stringValue(((LocalVariableTable)object).getGenericSignature())));
                } else {
                    printStream.append("None");
                }
                printStream.append(nl);
            }
        }
    }

    public static void j9bcutil_dumpRomClass(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer, long l) throws CorruptDataException {
        StructurePointer structurePointer;
        int n;
        long l2;
        AbstractPointer abstractPointer;
        printStream.append(String.format("ROM Size: 0x%s (%d)", Long.toHexString(j9ROMClassPointer.romSize().longValue()), j9ROMClassPointer.romSize().longValue()));
        printStream.append(nl);
        printStream.append(String.format("Class Name: %s", J9UTF8Helper.stringValue(j9ROMClassPointer.className())));
        printStream.append(nl);
        if (j9ROMClassPointer.superclassName().isNull()) {
            printStream.append("Superclass Name: <none>");
        } else {
            printStream.append(String.format("Superclass Name: %s", J9UTF8Helper.stringValue(j9ROMClassPointer.superclassName())));
        }
        printStream.append(nl);
        J9BCUtil.dumpSourceFileName(printStream, j9ROMClassPointer, l);
        J9BCUtil.dumpSimpleName(printStream, j9ROMClassPointer, l);
        J9BCUtil.dumpGenericSignature(printStream, j9ROMClassPointer, l);
        J9BCUtil.dumpEnclosingMethod(printStream, j9ROMClassPointer, l);
        printStream.append(String.format("Basic Access Flags (0x%s): ", Long.toHexString(j9ROMClassPointer.modifiers().longValue())));
        J9BCUtil.dumpModifiers(printStream, j9ROMClassPointer.modifiers().longValue(), 1, 1, ValueTypeHelper.getValueTypeHelper().isRomClassAValueType(j9ROMClassPointer));
        printStream.append(nl);
        printStream.append(String.format("J9 Access Flags (0x%s): ", Long.toHexString(j9ROMClassPointer.extraModifiers().longValue())));
        J9BCUtil.dumpClassJ9ExtraModifiers(printStream, j9ROMClassPointer.extraModifiers().longValue());
        printStream.append(nl);
        printStream.append(String.format("Class file version: %d.%d", j9ROMClassPointer.majorVersion().longValue(), j9ROMClassPointer.minorVersion().longValue()));
        printStream.append(nl);
        printStream.append(String.format("Instance Shape: 0x%s", Long.toHexString(j9ROMClassPointer.instanceShape().longValue())));
        printStream.append(nl);
        printStream.append(String.format("Intermediate Class Data (%d bytes): %s", j9ROMClassPointer.intermediateClassDataLength().longValue(), Long.toHexString(j9ROMClassPointer.intermediateClassData().longValue())));
        printStream.append(nl);
        printStream.append(String.format("Maximum Branch Count: %d", j9ROMClassPointer.maxBranchCount().longValue()));
        printStream.append(nl);
        printStream.append(String.format("Interfaces (%d):" + nl, j9ROMClassPointer.interfaceCount().longValue()));
        if (!j9ROMClassPointer.interfaceCount().eq(0L)) {
            abstractPointer = j9ROMClassPointer.interfaces();
            l2 = j9ROMClassPointer.interfaceCount().longValue();
            n = 0;
            while ((long)n < l2) {
                printStream.append("  ");
                J9UTF8Pointer j9UTF8Pointer = J9UTF8Pointer.cast(((SelfRelativePointer)abstractPointer).get());
                printStream.append(J9UTF8Helper.stringValue(j9UTF8Pointer));
                printStream.append(nl);
                abstractPointer = ((SelfRelativePointer)abstractPointer).add(1L);
                ++n;
            }
        }
        if (!(abstractPointer = j9ROMClassPointer.outerClassName()).isNull()) {
            printStream.append("Declaring Class: " + J9UTF8Helper.stringValue(j9ROMClassPointer.outerClassName()));
            printStream.append(nl);
            printStream.append(String.format("Member Access Flags (0x%s): ", Long.toHexString(j9ROMClassPointer.memberAccessFlags().longValue())));
            J9BCUtil.dumpModifiers(printStream, j9ROMClassPointer.memberAccessFlags().longValue(), 1, 1, ValueTypeHelper.getValueTypeHelper().isRomClassAValueType(j9ROMClassPointer));
            printStream.append(nl);
            abstractPointer = ((J9UTF8Pointer)abstractPointer).add(1L);
        }
        if ((l2 = j9ROMClassPointer.innerClassCount().longValue()) != 0L) {
            SelfRelativePointer selfRelativePointer = j9ROMClassPointer.innerClasses();
            printStream.format("Declared Classes (%d):%n", l2);
            int n2 = 0;
            while ((long)n2 < l2) {
                structurePointer = J9UTF8Pointer.cast(selfRelativePointer.get());
                printStream.format("   %s%n", J9UTF8Helper.stringValue((J9UTF8Pointer)structurePointer));
                selfRelativePointer = selfRelativePointer.add(1L);
                ++n2;
            }
        }
        if (J9ROMClassHelper.isSealed(j9ROMClassPointer)) {
            n = OptInfo.getPermittedSubclassCount(j9ROMClassPointer);
            printStream.format("Permitted subclasses (%d):%n", n);
            for (int i = 0; i < n; ++i) {
                structurePointer = OptInfo.getPermittedSubclassNameAtIndex(j9ROMClassPointer, i);
                printStream.format("   %s%n", J9UTF8Helper.stringValue((J9UTF8Pointer)structurePointer));
            }
        }
        if (J9ROMClassHelper.hasLoadableDescriptorsAttribute(j9ROMClassPointer)) {
            n = OptInfo.getLoadableDescriptorsCount(j9ROMClassPointer);
            printStream.format("Loadable Descriptors (%d):%n", n);
            for (int i = 0; i < n; ++i) {
                structurePointer = OptInfo.getLoadableDescriptorAtIndex(j9ROMClassPointer, i);
                printStream.format("   %s%n", J9UTF8Helper.stringValue((J9UTF8Pointer)structurePointer));
            }
        }
        UDATA uDATA = j9ROMClassPointer.romFieldCount();
        printStream.append(String.format("Fields (%d):" + nl, uDATA.longValue()));
        J9ROMFieldShapeIterator j9ROMFieldShapeIterator = new J9ROMFieldShapeIterator(j9ROMClassPointer.romFields(), uDATA);
        while (j9ROMFieldShapeIterator.hasNext()) {
            structurePointer = (J9ROMFieldShapePointer)j9ROMFieldShapeIterator.next();
            if (!((J9ROMFieldShapePointer)structurePointer).modifiers().bitAnd(J9JavaAccessFlags.J9AccStatic).eq(0L)) {
                J9BCUtil.dumpRomStaticField(printStream, (J9ROMFieldShapePointer)structurePointer, l);
            } else {
                J9BCUtil.dumpRomField(printStream, (J9ROMFieldShapePointer)structurePointer, l);
            }
            printStream.append(nl);
        }
        J9BCUtil.dumpCPShapeDescription(printStream, j9ROMClassPointer, l);
        long l3 = j9ROMClassPointer.romMethodCount().longValue();
        printStream.append(String.format("Methods (%d):" + nl, l3));
        J9ROMMethodPointer j9ROMMethodPointer = j9ROMClassPointer.romMethods();
        for (int i = 0; i < j9ROMClassPointer.romMethodCount().intValue(); ++i) {
            J9BCUtil.j9bcutil_dumpRomMethod(printStream, j9ROMMethodPointer, j9ROMClassPointer, l, 0);
            j9ROMMethodPointer = ROMHelp.nextROMMethod(j9ROMMethodPointer);
        }
        J9BCUtil.dumpSourceDebugExtension(printStream, j9ROMClassPointer, l);
        J9BCUtil.dumpAnnotationInfo(printStream, j9ROMClassPointer, l);
        J9BCUtil.dumpCallSiteData(printStream, j9ROMClassPointer);
        J9BCUtil.dumpStaticSplitSideTable(printStream, j9ROMClassPointer);
        J9BCUtil.dumpSpecialSplitSideTable(printStream, j9ROMClassPointer);
    }

    private static void dumpCPShapeDescription(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer, long l) throws CorruptDataException {
        U32Pointer u32Pointer = J9ROMClassHelper.cpShapeDescription(j9ROMClassPointer);
        char[] cArray = new char[]{'.', 'C', 'S', 'I', 'F', 'J', 'D', 'i', 's', 'v', 'x', 'y', 'z', 'T', 'H', 'A', '.', 'c', 'x', 'v'};
        cArray[(int)J9ConstantPool.J9CPTYPE_UNUSED8] = 46;
        long l2 = (j9ROMClassPointer.romConstantPoolCount().longValue() + J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32 - 1L) / J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32;
        printStream.append("CP Shape Description:" + nl);
        long l3 = j9ROMClassPointer.romConstantPoolCount().longValue();
        for (long i = 0L; i < l2; ++i) {
            printStream.append("  ");
            long l4 = u32Pointer.at(i).longValue();
            for (long j = 0L; j < J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32 && l3 != 0L; ++j, --l3) {
                printStream.append(String.format("%c ", Character.valueOf(cArray[(int)(l4 & J9ConstantPool.J9_CP_DESCRIPTION_MASK)])));
                l4 >>= (int)J9ConstantPool.J9_CP_BITS_PER_DESCRIPTION;
            }
            printStream.append(nl);
        }
        printStream.append(nl);
    }

    private static void dumpRomField(PrintStream printStream, J9ROMFieldShapePointer j9ROMFieldShapePointer, long l) throws CorruptDataException {
        printStream.append("  Name: " + J9UTF8Helper.stringValue(j9ROMFieldShapePointer.nameAndSignature().name()) + nl);
        printStream.append("  Signature: " + J9UTF8Helper.stringValue(j9ROMFieldShapePointer.nameAndSignature().signature()) + nl);
        printStream.append(String.format("  Access Flags (%s): ", Long.toHexString(j9ROMFieldShapePointer.modifiers().longValue())));
        J9BCUtil.dumpModifiers(printStream, j9ROMFieldShapePointer.modifiers().longValue(), 3, 2, false);
        printStream.append(nl);
    }

    private static void dumpRomStaticField(PrintStream printStream, J9ROMFieldShapePointer j9ROMFieldShapePointer, long l) throws CorruptDataException {
        printStream.append("  Name: " + J9UTF8Helper.stringValue(j9ROMFieldShapePointer.nameAndSignature().name()) + nl);
        printStream.append("  Signature: " + J9UTF8Helper.stringValue(j9ROMFieldShapePointer.nameAndSignature().signature()) + nl);
        printStream.append(String.format("  Access Flags (%s): ", Long.toHexString(j9ROMFieldShapePointer.modifiers().longValue())));
        J9BCUtil.dumpModifiers(printStream, j9ROMFieldShapePointer.modifiers().longValue(), 3, 2, false);
        printStream.append(nl);
    }

    private static void dumpClassJ9ExtraModifiers(PrintStream printStream, long l) {
        if ((l & J9CfrClassFile.CFR_ACC_REFERENCE_WEAK) != 0L) {
            printStream.append("(weak) ");
        }
        if ((l & J9CfrClassFile.CFR_ACC_REFERENCE_SOFT) != 0L) {
            printStream.append("(soft) ");
        }
        if ((l & J9CfrClassFile.CFR_ACC_REFERENCE_PHANTOM) != 0L) {
            printStream.append("(phantom) ");
        }
        if ((l & J9CfrClassFile.CFR_ACC_HAS_FINAL_FIELDS) != 0L) {
            printStream.append("(final fields) ");
        }
        if ((l & J9CfrClassFile.CFR_ACC_HAS_VERIFY_DATA) != 0L) {
            printStream.append("(preverified) ");
        }
        if ((l & J9JavaAccessFlags.J9AccClassAnonClass) != 0L) {
            printStream.append("(anonClass) ");
        }
        if ((l & J9JavaAccessFlags.J9AccClassIsUnmodifiable) != 0L) {
            printStream.append("(unmodifiable) ");
        }
        if ((l & J9JavaAccessFlags.J9AccRecord) != 0L) {
            printStream.append("(record) ");
        }
        if ((l & J9JavaAccessFlags.J9AccSealed) != 0L) {
            printStream.append("(sealed) ");
        }
    }

    private static void dumpMethodJ9Modifiers(PrintStream printStream, UDATA uDATA, UDATA uDATA2) {
        if (uDATA.allBitsIn(J9JavaAccessFlags.J9AccMethodCallerSensitive)) {
            printStream.append(" @CallerSensitive");
        }
        if (uDATA.allBitsIn(J9JavaAccessFlags.J9AccMethodFrameIteratorSkip)) {
            printStream.append(" @FrameIteratorSkip");
        }
        if (uDATA2.allBitsIn(J9CfrClassFile.CFR_METHOD_EXT_NOT_CHECKPOINT_SAFE_ANNOTATION)) {
            printStream.append(" @NotCheckpointSafe");
        }
        if (uDATA2.allBitsIn(J9CfrClassFile.CFR_METHOD_EXT_HAS_SCOPED_ANNOTATION)) {
            printStream.append(" @Scoped");
        }
    }

    private static void dumpEnclosingMethod(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer, long l) throws CorruptDataException {
        J9EnclosingObjectPointer j9EnclosingObjectPointer = OptInfo.getEnclosingMethodForROMClass(j9ROMClassPointer);
        if (!j9EnclosingObjectPointer.isNull()) {
            J9ROMConstantPoolItemPointer j9ROMConstantPoolItemPointer = ConstantPoolHelpers.J9_ROM_CP_FROM_ROM_CLASS(j9ROMClassPointer);
            J9ROMClassRefPointer j9ROMClassRefPointer = J9ROMClassRefPointer.cast(j9ROMConstantPoolItemPointer);
            String string = j9ROMClassRefPointer.name().toString();
            J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer = j9EnclosingObjectPointer.nameAndSignature();
            if (!j9ROMNameAndSignaturePointer.isNull()) {
                printStream.append(String.format("Enclosing Method: %s%s%s", string, J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.name()), J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.signature())));
            } else {
                printStream.append(String.format("Enclosing Class: %s", string));
            }
        }
    }

    private static void dumpGenericSignature(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer, long l) throws CorruptDataException {
        String string = OptInfo.getGenericSignatureForROMClass(j9ROMClassPointer);
        if (string != null) {
            printStream.append(String.format("Generic Signature: %s", string));
            printStream.append(nl);
        }
    }

    private static void dumpSimpleName(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer, long l) throws CorruptDataException {
        String string = OptInfo.getSimpleNameForROMClass(j9ROMClassPointer);
        if (string != null) {
            printStream.append(String.format("Simple Name: %s", string));
            printStream.append(nl);
        }
    }

    private static void dumpSourceFileName(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer, long l) throws CorruptDataException {
        String string;
        if ((l & J9BCTranslationData.BCT_StripDebugAttributes) == 0L && (string = OptInfo.getSourceFileNameForROMClass(j9ROMClassPointer)) != null) {
            printStream.append(String.format("Source File Name: %s", string));
            printStream.append(nl);
        }
    }

    private static void dumpSourceDebugExtension(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer, long l) throws CorruptDataException {
        UDATA uDATA;
        J9SourceDebugExtensionPointer j9SourceDebugExtensionPointer;
        if (J9BuildFlags.J9VM_OPT_DEBUG_INFO_SERVER && (l & J9BCTranslationData.BCT_StripDebugAttributes) == 0L && !(j9SourceDebugExtensionPointer = OptInfo.getSourceDebugExtensionForROMClass(j9ROMClassPointer)).isNull() && !(uDATA = j9SourceDebugExtensionPointer.size()).eq(0L)) {
            U8Pointer u8Pointer = U8Pointer.cast(j9SourceDebugExtensionPointer.add(1L));
            printStream.append(String.format("  Source debug extension (%d bytes):    ", uDATA.longValue()));
            printStream.append(nl);
            while (!uDATA.eq(0L)) {
                uDATA = uDATA.sub(1L);
                U8 u8 = u8Pointer.at(0L);
                u8Pointer = u8Pointer.add(1L);
                if (u8.eq(13L)) {
                    if (uDATA.eq(0L)) continue;
                    if (u8Pointer.at(0L).eq(10L)) {
                        u8Pointer = u8Pointer.add(1L);
                    }
                    printStream.append(nl + "    ");
                    continue;
                }
                if (u8.eq(10L)) {
                    printStream.append(nl + "    ");
                    continue;
                }
                printStream.append((char)u8.intValue());
            }
        }
    }

    private static void dumpAnnotationInfo(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer, long l) throws CorruptDataException {
        AbstractPointer abstractPointer;
        Object object;
        U32Pointer u32Pointer = OptInfo.getClassAnnotationsDataForROMClass(j9ROMClassPointer);
        U32Pointer u32Pointer2 = OptInfo.getClassTypeAnnotationsDataForROMClass(j9ROMClassPointer);
        printStream.append("  Annotation Info:" + nl);
        if (!u32Pointer.isNull()) {
            object = u32Pointer.at(0L);
            abstractPointer = u32Pointer.add(1L);
            printStream.append(String.format("    Class Annotations (%d bytes): %s" + nl, ((U32)object).intValue(), abstractPointer.getHexAddress()));
        }
        if (!u32Pointer2.isNull()) {
            object = u32Pointer2.at(0L);
            abstractPointer = u32Pointer2.add(1L);
            printStream.append(String.format("    Class Type Annotations (%d bytes): %s" + nl, ((U32)object).intValue(), abstractPointer.getHexAddress()));
        }
        object = new J9ROMFieldShapeIterator(j9ROMClassPointer.romFields(), j9ROMClassPointer.romFieldCount());
        printStream.append("    Field Annotations:" + nl);
        while (((J9ROMFieldShapeIterator)object).hasNext()) {
            U32Pointer u32Pointer3;
            U32 u32;
            abstractPointer = (J9ROMFieldShapePointer)((J9ROMFieldShapeIterator)object).next();
            U32Pointer u32Pointer4 = J9ROMFieldShapeHelper.getFieldAnnotationsDataFromROMField((J9ROMFieldShapePointer)abstractPointer);
            U32Pointer u32Pointer5 = J9ROMFieldShapeHelper.getFieldTypeAnnotationsDataFromROMField((J9ROMFieldShapePointer)abstractPointer);
            if (!u32Pointer4.isNull()) {
                u32 = u32Pointer4.at(0L);
                u32Pointer3 = u32Pointer4.add(1L);
                printStream.append("     Name: " + J9UTF8Helper.stringValue(((J9ROMFieldShapePointer)abstractPointer).nameAndSignature().name()) + nl);
                printStream.append("     Signature: " + J9UTF8Helper.stringValue(((J9ROMFieldShapePointer)abstractPointer).nameAndSignature().signature()) + nl);
                printStream.append(String.format("      Annotations (%d bytes): %s" + nl, u32.intValue(), u32Pointer3.getHexAddress()));
            }
            if (u32Pointer5.isNull()) continue;
            u32 = u32Pointer5.at(0L);
            u32Pointer3 = u32Pointer5.add(1L);
            printStream.append(String.format("      Type Annotations (%d bytes): %s" + nl, u32.intValue(), u32Pointer3.getHexAddress()));
        }
        printStream.append(nl);
        abstractPointer = j9ROMClassPointer.romMethods();
        printStream.append("    Method Annotations:" + nl);
        for (int i = 0; i < j9ROMClassPointer.romMethodCount().intValue(); ++i) {
            J9BCUtil.dumpMethodAnnotations(printStream, (J9ROMMethodPointer)abstractPointer);
            abstractPointer = ROMHelp.nextROMMethod((J9ROMMethodPointer)abstractPointer);
        }
        printStream.append(nl);
    }

    private static void dumpMethodAnnotations(PrintStream printStream, J9ROMMethodPointer j9ROMMethodPointer) throws CorruptDataException {
        AbstractPointer abstractPointer;
        DataType dataType;
        U32Pointer u32Pointer = ROMHelp.getMethodAnnotationsDataFromROMMethod(j9ROMMethodPointer);
        U32Pointer u32Pointer2 = ROMHelp.getParameterAnnotationsDataFromROMMethod(j9ROMMethodPointer);
        U32Pointer u32Pointer3 = ROMHelp.getDefaultAnnotationDataFromROMMethod(j9ROMMethodPointer);
        U32Pointer u32Pointer4 = ROMHelp.getMethodTypeAnnotationDataFromROMMethod(j9ROMMethodPointer);
        U32Pointer u32Pointer5 = ROMHelp.getCodeTypeAnnotationDataFromROMMethod(j9ROMMethodPointer);
        if (!(u32Pointer.isNull() && u32Pointer2.isNull() && u32Pointer3.isNull())) {
            dataType = j9ROMMethodPointer.nameAndSignature();
            abstractPointer = ((J9ROMNameAndSignaturePointer)dataType).name();
            J9UTF8Pointer j9UTF8Pointer = ((J9ROMNameAndSignaturePointer)dataType).signature();
            printStream.append("      Name: " + J9UTF8Helper.stringValue((J9UTF8Pointer)abstractPointer) + nl);
            printStream.append("      Signature: " + J9UTF8Helper.stringValue(j9UTF8Pointer) + nl);
        }
        if (!u32Pointer.isNull()) {
            dataType = u32Pointer.at(0L);
            abstractPointer = u32Pointer.add(1L);
            printStream.append(String.format("      Annotations (%d bytes): %s" + nl, ((U32)dataType).intValue(), abstractPointer.getHexAddress()));
        }
        if (!u32Pointer2.isNull()) {
            dataType = u32Pointer2.at(0L);
            abstractPointer = u32Pointer2.add(1L);
            printStream.append(String.format("      Parameters Annotations (%d bytes): %s" + nl, ((U32)dataType).intValue(), abstractPointer.getHexAddress()));
        }
        if (!u32Pointer3.isNull()) {
            dataType = u32Pointer3.at(0L);
            abstractPointer = u32Pointer3.add(1L);
            printStream.append(String.format("      Default Annotations (%d bytes): %s" + nl, ((U32)dataType).intValue(), abstractPointer.getHexAddress()));
        }
        if (!u32Pointer4.isNull()) {
            dataType = u32Pointer4.at(0L);
            abstractPointer = u32Pointer4.add(1L);
            printStream.append(String.format("      Method Type Annotations (%d bytes): %s" + nl, ((U32)dataType).intValue(), abstractPointer.getHexAddress()));
        }
        if (!u32Pointer5.isNull()) {
            dataType = u32Pointer5.at(0L);
            abstractPointer = u32Pointer5.add(1L);
            printStream.append(String.format("      Code Type Annotations (%d bytes): %s" + nl, ((U32)dataType).intValue(), abstractPointer.getHexAddress()));
        }
    }

    private static void dumpCallSiteData(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        AbstractPointer abstractPointer;
        int n = 16;
        long l = j9ROMClassPointer.callSiteCount().longValue();
        long l2 = j9ROMClassPointer.bsmCount().longValue();
        SelfRelativePointer selfRelativePointer = SelfRelativePointer.cast(j9ROMClassPointer.callSiteData());
        U16Pointer u16Pointer = U16Pointer.cast(selfRelativePointer.addOffset(4L * l));
        if (0L != l) {
            printStream.println(String.format("  Call Sites (%d):\n", l));
            int n2 = 0;
            while ((long)n2 < l) {
                abstractPointer = J9ROMNameAndSignaturePointer.cast(selfRelativePointer.add(n2).get());
                printStream.println("    Name: " + J9UTF8Helper.stringValue(((J9ROMNameAndSignaturePointer)abstractPointer).name()));
                printStream.println("    Signature: " + J9UTF8Helper.stringValue(((J9ROMNameAndSignaturePointer)abstractPointer).signature()));
                printStream.println("    Bootstrap Method Index: " + u16Pointer.at(n2).longValue());
                printStream.println();
                ++n2;
            }
        }
        if (0L != l2) {
            J9ROMConstantPoolItemPointer j9ROMConstantPoolItemPointer = ConstantPoolHelpers.J9_ROM_CP_FROM_ROM_CLASS(j9ROMClassPointer);
            abstractPointer = J9ROMClassHelper.cpShapeDescription(j9ROMClassPointer);
            U16Pointer u16Pointer2 = u16Pointer.add(l);
            printStream.println(String.format("  Bootstrap Methods (%d):", l2));
            int n3 = 0;
            while ((long)n3 < l2) {
                J9ROMMethodHandleRefPointer j9ROMMethodHandleRefPointer = J9ROMMethodHandleRefPointer.cast(j9ROMConstantPoolItemPointer.add(u16Pointer2.at(0L).longValue()));
                u16Pointer2 = u16Pointer2.add(1L);
                J9ROMMethodRefPointer j9ROMMethodRefPointer = J9ROMMethodRefPointer.cast(j9ROMConstantPoolItemPointer.add(j9ROMMethodHandleRefPointer.methodOrFieldRefIndex().longValue()));
                J9ROMClassRefPointer j9ROMClassRefPointer = J9ROMClassRefPointer.cast(j9ROMConstantPoolItemPointer.add(j9ROMMethodRefPointer.classRefCPIndex().longValue()));
                J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer = j9ROMMethodRefPointer.nameAndSignature();
                long l3 = u16Pointer2.at(0L).longValue();
                u16Pointer2 = u16Pointer2.add(1L);
                printStream.println("    Name: " + J9UTF8Helper.stringValue(j9ROMClassRefPointer.name()) + "." + J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.name()));
                printStream.println("    Signature: " + J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.signature()));
                printStream.println(String.format("    Bootstrap Method Arguments (%d):", l3));
                while (0L != l3) {
                    long l4 = u16Pointer2.at(0L).longValue();
                    u16Pointer2 = u16Pointer2.add(1L);
                    J9ROMConstantPoolItemPointer j9ROMConstantPoolItemPointer2 = j9ROMConstantPoolItemPointer.add(l4);
                    long l5 = ConstantPoolHelpers.J9_CP_TYPE((U32Pointer)abstractPointer, (int)l4);
                    if (l5 == J9ConstantPool.J9CPTYPE_CLASS) {
                        J9ROMClassRefPointer j9ROMClassRefPointer2 = J9ROMClassRefPointer.cast(j9ROMConstantPoolItemPointer2);
                        printStream.println("      Class: " + J9UTF8Helper.stringValue(j9ROMClassRefPointer2.name()));
                    } else if (l5 == J9ConstantPool.J9CPTYPE_STRING) {
                        J9ROMStringRefPointer j9ROMStringRefPointer = J9ROMStringRefPointer.cast(j9ROMConstantPoolItemPointer2);
                        printStream.println("      String: " + J9UTF8Helper.stringValue(j9ROMStringRefPointer.utf8Data()));
                    } else if (l5 == J9ConstantPool.J9CPTYPE_INT) {
                        J9ROMSingleSlotConstantRefPointer j9ROMSingleSlotConstantRefPointer = J9ROMSingleSlotConstantRefPointer.cast(j9ROMConstantPoolItemPointer2);
                        printStream.println("      Int: " + j9ROMSingleSlotConstantRefPointer.data().getHexValue());
                    } else if (l5 == J9ConstantPool.J9CPTYPE_FLOAT) {
                        J9ROMSingleSlotConstantRefPointer j9ROMSingleSlotConstantRefPointer = J9ROMSingleSlotConstantRefPointer.cast(j9ROMConstantPoolItemPointer2);
                        FloatPointer floatPointer = FloatPointer.cast(j9ROMSingleSlotConstantRefPointer.dataEA());
                        printStream.println("      Float: " + floatPointer.getHexValue() + " (" + floatPointer.floatAt(0L) + ")");
                    } else if (l5 == J9ConstantPool.J9CPTYPE_LONG) {
                        String string = "";
                        if (J9BuildFlags.J9VM_ENV_LITTLE_ENDIAN) {
                            string = string + j9ROMConstantPoolItemPointer2.slot2().getHexValue();
                            string = string + j9ROMConstantPoolItemPointer2.slot1().getHexValue().substring(2);
                        } else {
                            string = string + j9ROMConstantPoolItemPointer2.slot1().getHexValue();
                            string = string + j9ROMConstantPoolItemPointer2.slot2().getHexValue().substring(2);
                        }
                        long l6 = Long.parseLong(string.substring(2), n);
                        printStream.println("      Long: " + string + "(" + l6 + ")");
                    } else if (l5 == J9ConstantPool.J9CPTYPE_DOUBLE) {
                        String string = "";
                        if (J9BuildFlags.J9VM_ENV_LITTLE_ENDIAN) {
                            string = string + j9ROMConstantPoolItemPointer2.slot2().getHexValue();
                            string = string + j9ROMConstantPoolItemPointer2.slot1().getHexValue().substring(2);
                        } else {
                            string = string + j9ROMConstantPoolItemPointer2.slot1().getHexValue();
                            string = string + j9ROMConstantPoolItemPointer2.slot2().getHexValue().substring(2);
                        }
                        long l7 = Long.parseLong(string.substring(2), n);
                        double d = Double.longBitsToDouble(l7);
                        printStream.println("      Double: " + string + "(" + Double.toString(d) + ")");
                    } else if (l5 == J9ConstantPool.J9CPTYPE_FIELD) {
                        J9ROMFieldRefPointer j9ROMFieldRefPointer = J9ROMFieldRefPointer.cast(j9ROMConstantPoolItemPointer2);
                        j9ROMClassRefPointer = J9ROMClassRefPointer.cast(j9ROMConstantPoolItemPointer.add(j9ROMFieldRefPointer.classRefCPIndex()));
                        j9ROMNameAndSignaturePointer = j9ROMFieldRefPointer.nameAndSignature();
                        printStream.println("      Field: " + J9UTF8Helper.stringValue(j9ROMClassRefPointer.name()) + "." + J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.name()) + " " + J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.signature()));
                    } else if (l5 == J9ConstantPool.J9CPTYPE_INSTANCE_METHOD || l5 == J9ConstantPool.J9CPTYPE_STATIC_METHOD || l5 == J9ConstantPool.J9CPTYPE_HANDLE_METHOD || l5 == J9ConstantPool.J9CPTYPE_INTERFACE_METHOD) {
                        J9ROMMethodRefPointer j9ROMMethodRefPointer2 = J9ROMMethodRefPointer.cast(j9ROMConstantPoolItemPointer2);
                        j9ROMClassRefPointer = J9ROMClassRefPointer.cast(j9ROMConstantPoolItemPointer.add(j9ROMMethodRefPointer2.classRefCPIndex()));
                        j9ROMNameAndSignaturePointer = j9ROMMethodRefPointer2.nameAndSignature();
                        printStream.println("      Method: " + J9UTF8Helper.stringValue(j9ROMClassRefPointer.name()) + "." + J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.name()) + " " + J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.signature()));
                    } else if (l5 == J9ConstantPool.J9CPTYPE_METHOD_TYPE) {
                        J9ROMMethodTypeRefPointer j9ROMMethodTypeRefPointer = J9ROMMethodTypeRefPointer.cast(j9ROMConstantPoolItemPointer2);
                        printStream.println("      Method Type: " + J9UTF8Helper.stringValue(J9UTF8Pointer.cast(j9ROMMethodTypeRefPointer.signature())));
                    } else if (l5 == J9ConstantPool.J9CPTYPE_METHODHANDLE) {
                        j9ROMMethodHandleRefPointer = J9ROMMethodHandleRefPointer.cast(j9ROMConstantPoolItemPointer2);
                        j9ROMMethodRefPointer = J9ROMMethodRefPointer.cast(j9ROMConstantPoolItemPointer.add(j9ROMMethodHandleRefPointer.methodOrFieldRefIndex()));
                        j9ROMClassRefPointer = J9ROMClassRefPointer.cast(j9ROMConstantPoolItemPointer.add(j9ROMMethodRefPointer.classRefCPIndex()));
                        j9ROMNameAndSignaturePointer = j9ROMMethodRefPointer.nameAndSignature();
                        printStream.print("      Method Handle: " + J9UTF8Helper.stringValue(j9ROMClassRefPointer.name()) + "." + J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.name()));
                        long l8 = j9ROMMethodHandleRefPointer.handleTypeAndCpType().rightShift((int)J9DescriptionBits.J9DescriptionCpTypeShift).longValue();
                        if (l8 == J9ROMMethodHandleRef.MH_REF_GETFIELD || l8 == J9ROMMethodHandleRef.MH_REF_PUTFIELD || l8 == J9ROMMethodHandleRef.MH_REF_GETSTATIC || l8 == J9ROMMethodHandleRef.MH_REF_PUTSTATIC) {
                            printStream.print(" ");
                        }
                        printStream.println(J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.signature()));
                    } else {
                        printStream.println("      <unknown type>");
                    }
                    --l3;
                }
                ++n3;
            }
        }
    }

    private static void dumpStaticSplitSideTable(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        int n = j9ROMClassPointer.staticSplitMethodRefCount().intValue();
        if (n > 0) {
            printStream.println(String.format("Static Split Table (%d):\n", n));
            printStream.println("    SplitTable Index -> CP Index");
            U16Pointer u16Pointer = j9ROMClassPointer.staticSplitMethodRefIndexes();
            for (int i = 0; i < n; ++i) {
                u16Pointer.add(i);
                printStream.println(String.format("    %16d -> %d", i, u16Pointer.at(i).intValue()));
            }
        }
    }

    private static void dumpSpecialSplitSideTable(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        int n = j9ROMClassPointer.specialSplitMethodRefCount().intValue();
        if (n > 0) {
            printStream.println(String.format("Special Split Table (%d):\n", n));
            printStream.println("    SplitTable Index -> CP Index");
            U16Pointer u16Pointer = j9ROMClassPointer.specialSplitMethodRefIndexes();
            for (int i = 0; i < n; ++i) {
                u16Pointer.add(i);
                printStream.println(String.format("    %16d -> %d", i, u16Pointer.at(i).intValue()));
            }
        }
    }

    private static void dumpStackMapTable(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer, J9ROMMethodPointer j9ROMMethodPointer, long l) throws CorruptDataException {
        boolean bl;
        U32Pointer u32Pointer = ROMHelp.getStackMapFromROMMethod(j9ROMMethodPointer);
        long l2 = -1L;
        boolean bl2 = bl = J9Consts.STRICT_FIELDS_MAJOR_VERSION >= j9ROMClassPointer.majorVersion().longValue() && J9Consts.PREVIEW_MINOR_VERSION == j9ROMClassPointer.minorVersion().longValue();
        if (u32Pointer.notNull()) {
            U8Pointer u8Pointer = U8Pointer.cast(u32Pointer.add(1L));
            U16 u16 = new U16(u8Pointer.at(0L)).leftShift(8).bitOr(u8Pointer.at(1L));
            u8Pointer = u8Pointer.add(2L);
            printStream.println("\n  StackMapTable\n    Stackmaps(" + u16.intValue() + "):");
            boolean bl3 = false;
            int n = 0;
            while (n < u16.intValue()) {
                long l3 = u8Pointer.at(0L).longValue();
                u8Pointer = u8Pointer.add(1L);
                if (bl3) {
                    bl3 = false;
                    printStream.print("        base: ");
                } else {
                    ++l2;
                    printStream.print("      ");
                }
                if (l3 < 64L) {
                    printStream.println("pc: " + (l2 += l3) + " same");
                } else if (l3 < 128L) {
                    printStream.print("pc: " + (l2 += l3 - 64L) + " same_locals_1_stack_item: ");
                    u8Pointer = J9BCUtil.dumpStackMapSlots(printStream, j9ROMClassPointer, u8Pointer, 1L);
                    printStream.println();
                } else if (l3 < (long)(bl ? 246 : 247)) {
                    printStream.format("UNKNOWN FRAME TAG: (" + l3 + ")%n%n", new Object[0]);
                } else {
                    long l4;
                    if (bl && l3 == 246L) {
                        printStream.println("early_larval:");
                        u8Pointer = J9BCUtil.dumpUnsetFields(printStream, j9ROMClassPointer, u8Pointer);
                        bl3 = true;
                        continue;
                    }
                    if (l3 == 247L) {
                        l4 = new U16(u8Pointer.at(0L)).leftShift(8).add(u8Pointer.at(1L)).longValue();
                        u8Pointer = u8Pointer.add(2L);
                        printStream.print("pc: " + (l2 += l4) + " same_locals_1_stack_item_extended: ");
                        u8Pointer = J9BCUtil.dumpStackMapSlots(printStream, j9ROMClassPointer, u8Pointer, 1L);
                        printStream.println();
                    } else if (l3 < 251L) {
                        l4 = new U16(u8Pointer.at(0L)).leftShift(8).add(u8Pointer.at(1L)).longValue();
                        u8Pointer = u8Pointer.add(2L);
                        printStream.println("pc: " + (l2 += l4) + " chop " + (251L - l3));
                    } else if (l3 == 251L) {
                        l4 = new U16(u8Pointer.at(0L)).leftShift(8).add(u8Pointer.at(1L)).longValue();
                        u8Pointer = u8Pointer.add(2L);
                        printStream.println("pc: " + (l2 += l4) + " same_extended\n");
                    } else if (l3 < 255L) {
                        l4 = new U16(u8Pointer.at(0L)).leftShift(8).add(u8Pointer.at(1L)).longValue();
                        u8Pointer = u8Pointer.add(2L);
                        printStream.print("pc: " + (l2 += l4) + " append: ");
                        u8Pointer = J9BCUtil.dumpStackMapSlots(printStream, j9ROMClassPointer, u8Pointer, l3 - 251L);
                        printStream.println();
                    } else if (l3 == 255L) {
                        l4 = new U16(u8Pointer.at(0L)).leftShift(8).add(u8Pointer.at(1L)).longValue();
                        u8Pointer = u8Pointer.add(2L);
                        printStream.print("pc: " + (l2 += l4) + " full, local(s): ");
                        l4 = new U16(u8Pointer.at(0L)).leftShift(8).add(u8Pointer.at(1L)).longValue();
                        u8Pointer = u8Pointer.add(2L);
                        u8Pointer = J9BCUtil.dumpStackMapSlots(printStream, j9ROMClassPointer, u8Pointer, l4);
                        printStream.print(", stack: ");
                        l4 = new U16(u8Pointer.at(0L)).leftShift(8).add(u8Pointer.at(1L)).longValue();
                        u8Pointer = u8Pointer.add(2L);
                        u8Pointer = J9BCUtil.dumpStackMapSlots(printStream, j9ROMClassPointer, u8Pointer, l4);
                        printStream.println();
                    }
                }
                ++n;
            }
        }
    }

    private static void dumpMethodParameters(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer, J9ROMMethodPointer j9ROMMethodPointer, long l) throws CorruptDataException {
        J9MethodParametersDataPointer j9MethodParametersDataPointer = ROMHelp.getMethodParametersFromROMMethod(j9ROMMethodPointer);
        if (j9MethodParametersDataPointer != J9MethodParametersDataPointer.NULL) {
            J9MethodParameterPointer j9MethodParameterPointer = j9MethodParametersDataPointer.parameters();
            printStream.println(String.format("  Method Parameters (%d):\n", j9MethodParametersDataPointer.parameterCount().longValue()));
            int n = 0;
            while ((long)n < j9MethodParametersDataPointer.parameterCount().longValue()) {
                J9UTF8Pointer j9UTF8Pointer = J9UTF8Pointer.cast(j9MethodParameterPointer.nameEA().get());
                long l2 = j9MethodParameterPointer.flags().longValue();
                if (j9UTF8Pointer.isNull()) {
                    printStream.print("    <no name>");
                } else {
                    printStream.print("    " + J9UTF8Helper.stringValue(j9UTF8Pointer));
                }
                printStream.print(String.format("    0x%x ( ", l2));
                J9BCUtil.dumpModifiers(printStream, l2, 4, 1, false);
                printStream.println(" )\n");
                ++n;
            }
            printStream.println("\n");
        }
    }

    static U8Pointer dumpStackMapSlots(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer, U8Pointer u8Pointer, long l) throws CorruptDataException {
        String[] stringArray = new String[]{"top", "int", "float", "double", "long", "null", "uninitialized_this"};
        String[] stringArray2 = new String[]{"I", "F", "D", "J", "S", "B", "C", "Z"};
        printStream.print("(");
        int n = 0;
        while ((long)n < l) {
            int n2 = u8Pointer.at(0L).intValue();
            u8Pointer = u8Pointer.add(1L);
            if (n2 <= 6) {
                printStream.print(stringArray[n2]);
            } else if (n2 == 7) {
                long l2 = new U16(u8Pointer.at(0L)).leftShift(8).add(u8Pointer.at(1L)).longValue();
                J9ROMConstantPoolItemPointer j9ROMConstantPoolItemPointer = ConstantPoolHelpers.J9_ROM_CP_FROM_ROM_CLASS(j9ROMClassPointer);
                J9ROMStringRefPointer j9ROMStringRefPointer = J9ROMStringRefPointer.cast(j9ROMConstantPoolItemPointer.add(l2));
                J9UTF8Pointer j9UTF8Pointer = j9ROMStringRefPointer.utf8Data();
                String string = J9UTF8Helper.stringValue(j9UTF8Pointer);
                if (string.charAt(0) != '[') {
                    printStream.print("L");
                }
                printStream.print(string);
                u8Pointer = u8Pointer.add(2L);
            } else if (n2 == 8) {
                long l3 = new U16(u8Pointer.at(0L)).leftShift(8).add(u8Pointer.at(1L)).longValue();
                printStream.print("this pc:" + l3);
                u8Pointer = u8Pointer.add(2L);
            } else {
                StringBuffer stringBuffer = new StringBuffer("[");
                long l4 = new U16(u8Pointer.at(0L)).leftShift(8).add(u8Pointer.at(1L)).longValue();
                while (l4-- > 0L) {
                    stringBuffer.append("[");
                }
                stringBuffer.append(stringArray2[n2 - 9]);
                printStream.print(stringBuffer.toString());
                u8Pointer = u8Pointer.add(2L);
            }
            if ((long)n != l - 1L) {
                printStream.print(", ");
            }
            ++n;
        }
        printStream.print(")");
        return u8Pointer;
    }

    static U8Pointer dumpUnsetFields(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer, U8Pointer u8Pointer) throws CorruptDataException {
        int n = new U16(u8Pointer.at(0L)).leftShift(8).add(u8Pointer.at(1L)).intValue();
        u8Pointer = u8Pointer.add(2L);
        printStream.format("        unset_fields: %d%n", n);
        SelfRelativePointer selfRelativePointer = SelfRelativePointer.cast(u8Pointer);
        for (int i = 0; i < n; ++i) {
            J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer = J9ROMNameAndSignaturePointer.cast(selfRelativePointer.add(i).get());
            J9UTF8Pointer j9UTF8Pointer = j9ROMNameAndSignaturePointer.name();
            J9UTF8Pointer j9UTF8Pointer2 = j9ROMNameAndSignaturePointer.signature();
            printStream.format("          %s:%s%n", J9UTF8Helper.stringValue(j9UTF8Pointer), J9UTF8Helper.stringValue(j9UTF8Pointer2));
        }
        return u8Pointer.add(n * 4);
    }
}

