/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.AbstractCoreReader;
import com.ibm.j9ddr.corereaders.ClosingFileReader;
import com.ibm.j9ddr.corereaders.CoreReader;
import com.ibm.j9ddr.corereaders.CorruptCoreException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ICoreFileReader;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemory;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.minidump.EarlyInitializedStream;
import com.ibm.j9ddr.corereaders.minidump.LateInitializedStream;
import com.ibm.j9ddr.corereaders.minidump.Memory64Stream;
import com.ibm.j9ddr.corereaders.minidump.MemoryInfoStream;
import com.ibm.j9ddr.corereaders.minidump.MiscInfoStream;
import com.ibm.j9ddr.corereaders.minidump.ModuleStream;
import com.ibm.j9ddr.corereaders.minidump.SystemInfoStream;
import com.ibm.j9ddr.corereaders.minidump.ThreadInfoStream;
import com.ibm.j9ddr.corereaders.minidump.ThreadStream;
import com.ibm.j9ddr.corereaders.minidump.WindowsProcessAddressSpace;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public class MiniDumpReader
extends AbstractCoreReader
implements ICoreFileReader {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    private static final int INFO_BLOCK_ADDRESS = 131072;
    private static final int COMMAND_LINE_ADDRESS_ADDRESS_32 = 131140;
    private static final int COMMAND_LINE_ADDRESS_ADDRESS_64 = 131192;
    private static final int COMMAND_LINE_LENGTH_ADDRESS_32 = 131136;
    private static final int COMMAND_LINE_LENGTH_ADDRESS_64 = 131184;
    public static final String WINDOWS_BUILDNO_PROPERTY = "os.windows.buildno";
    private int _numberOfStreams = 0;
    private long _streamDirectoryRva = 0L;
    private short _processorArchitecture = 0;
    private int _windowsMajorVersion = 0;
    private Set<String> _additionalFileNames = new TreeSet<String>();
    private int _pid;
    private final Properties properties = new Properties();
    private List<LateInitializedStream> threadStreams = new LinkedList<LateInitializedStream>();
    private List<ThreadInfoStream> threadInfoStreams = new LinkedList<ThreadInfoStream>();
    private List<MemoryInfoStream> memoryInfoStreams = new LinkedList<MemoryInfoStream>();
    private List<LateInitializedStream> moduleStreams = new LinkedList<LateInitializedStream>();
    private boolean modulesRead = false;
    private List<IModule> modules;
    private IModule executable;
    private List<IOSThread> threads;
    private List<IAddressSpace> addressSpaces;
    private static boolean _is64bit = false;

    public ICore processDump(File file) throws FileNotFoundException, InvalidDumpFormatException, IOException {
        this.coreFile = file;
        ClosingFileReader closingFileReader = new ClosingFileReader(file, ByteOrder.LITTLE_ENDIAN);
        if (!MiniDumpReader.isMiniDump(closingFileReader)) {
            throw new InvalidDumpFormatException("The file " + file.getAbsolutePath() + " is not a valid MiniDump file.");
        }
        this.setReader(closingFileReader);
        return this;
    }

    @Override
    public ICore processDump(ImageInputStream imageInputStream) throws FileNotFoundException, InvalidDumpFormatException, IOException {
        imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.coreFile = null;
        if (!MiniDumpReader.isMiniDump(imageInputStream)) {
            throw new InvalidDumpFormatException("The passed input stream is not a valid MiniDump file.");
        }
        this.setReader(imageInputStream);
        return this;
    }

    public boolean validDump(byte[] byArray, long l) {
        try {
            return new String(byArray, 0, 4, "UTF-8").equalsIgnoreCase("mdmp");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    @Override
    public ICore processDump(String string) throws FileNotFoundException, InvalidDumpFormatException, IOException {
        File file;
        this.coreFile = file = new File(string);
        ClosingFileReader closingFileReader = new ClosingFileReader(file, ByteOrder.LITTLE_ENDIAN);
        if (!MiniDumpReader.isMiniDump(closingFileReader)) {
            throw new InvalidDumpFormatException("The file " + file.getAbsolutePath() + " is not a valid MiniDump file.");
        }
        this.setReader(closingFileReader);
        return this;
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(String string) throws IOException {
        if (!new File(string).exists()) {
            return ICoreFileReader.DumpTestResult.FILE_NOT_FOUND;
        }
        byte[] byArray = CoreReader.getFileHeader(string);
        try {
            return new String(byArray, 0, 4, "ASCII").equalsIgnoreCase("mdmp") ? ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT : ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(ImageInputStream imageInputStream) throws IOException {
        byte[] byArray = CoreReader.getFileHeader(imageInputStream);
        try {
            return new String(byArray, 0, 4, "ASCII").equalsIgnoreCase("mdmp") ? ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT : ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    @Override
    public void setReader(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        super.setReader(imageInputStream);
        try {
            this.readCore();
        }
        catch (CorruptCoreException corruptCoreException) {
            throw new IOException("Failed to read the core : " + corruptCoreException.getMessage());
        }
    }

    private void readCore() throws IOException, CorruptCoreException {
        this.parseHeader();
        this.parseStreams();
    }

    private void parseHeader() throws IOException {
        this.seek(0L);
        this.readBytes(4);
        this.readInt();
        this._numberOfStreams = this.readInt();
        this._streamDirectoryRva = this.readInt();
        this.readInt();
        int n = this.readInt();
        this.properties.setProperty("core.creation.time", Long.toString((long)n * 1000L));
    }

    private void parseStreams() throws IOException, CorruptCoreException {
        int n;
        this.seek(this._streamDirectoryRva);
        LinkedList<EarlyInitializedStream> linkedList = new LinkedList<EarlyInitializedStream>();
        block11: for (int i = 0; i < this._numberOfStreams; ++i) {
            int n2 = this.readInt();
            n = this.readInt();
            int n3 = this.readInt();
            switch (n2) {
                case 3: {
                    this.threadStreams.add(new ThreadStream(n, n3));
                    continue block11;
                }
                case 4: {
                    this.moduleStreams.add(new ModuleStream(n, n3));
                    continue block11;
                }
                case 7: {
                    linkedList.add(0, new SystemInfoStream(n, n3));
                    continue block11;
                }
                case 9: {
                    linkedList.add(new Memory64Stream(n, n3));
                    continue block11;
                }
                case 15: {
                    linkedList.add(new MiscInfoStream(n, n3));
                    continue block11;
                }
                case 17: {
                    this.threadInfoStreams.add(new ThreadInfoStream(n, n3));
                    continue block11;
                }
                case 16: {
                    this.memoryInfoStreams.add(new MemoryInfoStream(n, n3));
                }
            }
        }
        for (EarlyInitializedStream earlyInitializedStream : linkedList) {
            earlyInitializedStream.readFrom(this);
            n = earlyInitializedStream.readPtrSize(this);
            if (0 == n) continue;
            _is64bit = n == 64;
        }
        for (MemoryInfoStream memoryInfoStream : this.memoryInfoStreams) {
            memoryInfoStream.readFrom(this, this.is64Bit(), this._memoryRanges);
        }
        if (_is64bit) {
            int n4 = 0;
            for (IModule iModule : this.getModules()) {
                try {
                    String string = iModule.getName().toLowerCase();
                    if (!string.contains("syswow64")) continue;
                    ++n4;
                }
                catch (CorruptDataException corruptDataException) {}
            }
            if (n4 > 5) {
                _is64bit = false;
                this.addressSpaces = null;
            }
        }
    }

    String getCommandLine() throws CorruptDataException, DataUnavailableException {
        if (this._windowsMajorVersion >= 6) {
            throw new DataUnavailableException("Command line not available from Windows core dump");
        }
        String string = null;
        try {
            long l;
            short s;
            IMemory iMemory = this.getMemory();
            if (this.is64Bit()) {
                s = iMemory.getShortAt(131184L);
                l = iMemory.getLongAt(131192L);
            } else {
                s = iMemory.getShortAt(131136L);
                l = 0xFFFFFFFF & iMemory.getIntAt(131140L);
            }
            if (l == 0L) {
                throw new DataUnavailableException("Command line not in core file");
            }
            byte[] byArray = new byte[s];
            iMemory.getBytesAt(l, byArray);
            string = new String(byArray, "UTF-16LE");
            return string;
        }
        catch (Exception exception) {
            throw new CorruptDataException("Failed to read command line from core file", exception);
        }
    }

    private static boolean isMiniDump(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.seek(0L);
        byte[] byArray = new byte[4];
        imageInputStream.readFully(byArray);
        return new String(byArray, "UTF-8").equalsIgnoreCase("mdmp");
    }

    public boolean is64Bit() {
        return _is64bit;
    }

    protected void setProcessorArchitecture(short s, String string, int n) {
        this._processorArchitecture = s;
        this.properties.setProperty("cpu.count", Integer.toString(n));
        if (s == 0) {
            this.properties.setProperty("cpu.type", "x86");
        } else if (s == 9) {
            this.properties.setProperty("cpu.type", "AMD64");
        } else {
            this.properties.setProperty("cpu.type", "Unknown: " + s);
        }
        this.properties.setProperty("cpu.subtype", string);
    }

    protected void setWindowsType(byte by, int n, int n2, int n3) {
        this._windowsMajorVersion = n;
        this.properties.setProperty("system.type", this.decodeWindowsVersionNumber(n, n2, n3, by));
        this.properties.setProperty("system.subtype", n + "." + n2 + " build " + n3);
        this.properties.setProperty(WINDOWS_BUILDNO_PROPERTY, Integer.toString(n3));
    }

    private String decodeWindowsVersionNumber(int n, int n2, int n3, byte by) {
        switch (n) {
            case 5: {
                switch (n2) {
                    case 0: {
                        return "Windows 2000";
                    }
                    case 1: {
                        return "Windows XP";
                    }
                    case 2: {
                        return "Windows Server 2003";
                    }
                }
                break;
            }
            case 6: {
                switch (n2) {
                    case 0: {
                        switch (by) {
                            case 1: {
                                return "Windows Vista";
                            }
                            case 3: {
                                return "Windows Server 2008";
                            }
                        }
                    }
                    case 1: {
                        switch (by) {
                            case 1: {
                                return "Windows 7";
                            }
                            case 3: {
                                return "Windows Server 2008 R2";
                            }
                        }
                    }
                }
            }
        }
        return "Unknown Windows variant: " + n + "." + n2 + "." + n3 + " type " + by;
    }

    public void setProcessID(int n) {
        this._pid = n;
    }

    public void addModule(String string) {
        this._additionalFileNames.add(string);
    }

    protected short getProcessorArchitecture() {
        return this._processorArchitecture;
    }

    protected void setMemorySources(Collection<? extends IMemorySource> collection) {
        this._memoryRanges = collection;
    }

    @Override
    public String getDumpFormat() {
        return "minidump";
    }

    public List<IAddressSpace> getAddressSpaces() {
        if (null == this.addressSpaces) {
            WindowsProcessAddressSpace windowsProcessAddressSpace = new WindowsProcessAddressSpace(this.is64Bit() ? 8 : 4, ByteOrder.LITTLE_ENDIAN, this);
            windowsProcessAddressSpace.addMemorySources(this._memoryRanges);
            this.addressSpaces = new ArrayList<IAddressSpace>(1);
            this.addressSpaces.add(windowsProcessAddressSpace);
        }
        return this.addressSpaces;
    }

    private IMemory getMemory() {
        return (IMemory)this.getAddressSpaces().get(0);
    }

    @Override
    public Platform getPlatform() {
        return Platform.WINDOWS;
    }

    public IModule getExecutable() {
        this.readModulesInfo();
        return this.executable;
    }

    public List<IModule> getModules() {
        this.readModulesInfo();
        return this.modules;
    }

    private void readModulesInfo() {
        if (!this.modulesRead) {
            this.modules = new LinkedList<IModule>();
            for (LateInitializedStream lateInitializedStream : this.moduleStreams) {
                try {
                    lateInitializedStream.readFrom(this, (IAddressSpace)this.getAddressSpaces().get(0), this.is64Bit());
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, "MiniDumpReader", "readModulesInfo", "Problem processing module stream", exception);
                }
            }
            this.modulesRead = true;
        }
    }

    void setExecutable(IModule iModule) {
        this.executable = iModule;
    }

    void addLibrary(IModule iModule) {
        this.modules.add(iModule);
    }

    public int getPid() {
        return this._pid;
    }

    public List<IOSThread> getThreads() {
        if (this.threads == null) {
            this.threads = new LinkedList<IOSThread>();
            for (LateInitializedStream stream : this.threadStreams) {
                try {
                    stream.readFrom(this, (IAddressSpace)this.getAddressSpaces().get(0), this.is64Bit());
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, "MiniDumpReader", "getThreads", "Problem processing thread stream", exception);
                }
            }
            for (ThreadInfoStream threadInfoStream : this.threadInfoStreams) {
                try {
                    threadInfoStream.readFrom(this, (IAddressSpace)this.getAddressSpaces().get(0), this.is64Bit(), this.threads);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, "MiniDumpReader", "getThreads", "Problem processing thread info stream", exception);
                }
            }
        }
        return Collections.unmodifiableList(this.threads);
    }

    void addThread(IOSThread iOSThread) {
        this.threads.add(iOSThread);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }
}

