/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.events.DefaultEventListener;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.LiveSetWalker;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.RootSet;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.Stack;

public class RootPathCommand
extends Command {
    boolean _verboseEnabled = false;
    DefaultEventListener _listener = new DefaultEventListener();

    public RootPathCommand() {
        this.addCommand("rootpathfindall", "<address>", "prints out all the paths from a (strong) root to an object");
        this.addCommand("rootpathfind", "<address>", "prints out a path from a (strong) root to an object");
        this.addCommand("isobjectalive", "<address>", "determines whether an object is reachable from a (strong) roots or not.  Use !rootfind <address> or !rootfindall <address> to print out the path(s)");
        this.addCommand("strongrootpathfindall", "<address>", "prints out all the paths from a (strong) root to an object");
        this.addCommand("strongrootpathfind", "<address>", "prints out a path from a (strong) root to an object");
        this.addCommand("anyrootpathfindall", "<address>", "same as rootpathfindall but also includes weak roots e.g. classes, classloaders, weak references");
        this.addCommand("anyrootpathfind", "<address>", "same as rootpathfind but also includes weak roots e.g. classes, classloaders, weak references");
        this.addCommand("weakrootpathfindall", "<address>", "same as rootpathfindall but only for weak roots e.g. classes, classloaders, weak references");
        this.addCommand("weakrootpathfind", "<address>", "same as rootpathfind but only weak for roots e.g. classes, classloaders, weak references");
        this.addCommand("rootpathverbose", "", "enables displaying errors when walking live set");
        this.addCommand("rootpathnoverbose", "", "disables displaying errors when walking live set");
    }

    public static String objectToString(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        J9ClassPointer j9ClassPointer = J9ObjectHelper.clazz(j9ObjectPointer);
        StringWriter stringWriter = new StringWriter();
        String string = J9ClassHelper.getJavaName(j9ClassPointer);
        if (string.equals("java/lang/Class")) {
            stringWriter.write("class ");
            stringWriter.write(J9ClassHelper.getJavaName(ConstantPoolHelpers.J9VM_J9CLASS_FROM_HEAPCLASS(j9ObjectPointer)));
            stringWriter.write(64);
            stringWriter.write(j9ObjectPointer.getHexAddress());
        } else if (string.equals("java/lang/String")) {
            stringWriter.write(34);
            stringWriter.write(J9ObjectHelper.stringValue(j9ObjectPointer));
            stringWriter.write("\"@");
            stringWriter.write(j9ObjectPointer.getHexAddress());
        } else {
            stringWriter.write(string);
            stringWriter.write(64);
            stringWriter.write(j9ObjectPointer.getHexAddress());
            if (ObjectModel.isIndexable(j9ObjectPointer)) {
                stringWriter.write(" = ");
                stringWriter.write(J9IndexableObjectHelper.getDataAsString(J9IndexableObjectPointer.cast(j9ObjectPointer)));
            }
        }
        return stringWriter.toString();
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        switch (stringArray.length) {
            case 0: {
                if (stringArray.length != 0) break;
                if (string.equals("!rootpathverbose")) {
                    printStream.println("verbose output enabled for rootpath command.  run !rootpathnoverbose to disable verbose output");
                    this._verboseEnabled = true;
                    break;
                }
                if (string.equals("!rootpathnoverbose")) {
                    printStream.println("verbose output disabled for rootpath command.  run !rootpathverbose to enable verbose output");
                    this._verboseEnabled = false;
                    break;
                }
                throw new UnsupportedOperationException("Unrecognized command passed to RoothPathCommand");
            }
            case 1: {
                Object object;
                long l = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.J9VM_ENV_DATA64);
                J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(l);
                try {
                    object = J9ObjectHelper.clazz(j9ObjectPointer);
                    if (!J9ClassHelper.hasValidEyeCatcher((J9ClassPointer)object)) {
                        throw new DDRInteractiveCommandException("object class is not valid (eyecatcher is not 0x99669966)");
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    throw new DDRInteractiveCommandException("memory fault de-referencing address argument", corruptDataException);
                }
                try {
                    object = new RootPathCommandListener();
                    EventManager.register((IEventListener)object);
                    if (string.equals("!rootpathfindall") || string.equals("!strongrootpathfindall")) {
                        LiveSetWalker.walkLiveSet(new RootPathsFinder(j9ObjectPointer, printStream), RootSet.RootSetType.STRONG_REACHABLE);
                    } else if (string.equals("!anyrootpathfindall")) {
                        LiveSetWalker.walkLiveSet(new RootPathsFinder(j9ObjectPointer, printStream), RootSet.RootSetType.ALL);
                    } else if (string.equals("!weakrootpathfindall")) {
                        LiveSetWalker.walkLiveSet(new RootPathsFinder(j9ObjectPointer, printStream), RootSet.RootSetType.WEAK_REACHABLE);
                    } else if (string.equals("!rootpathfind") || string.equals("!strongrootpathfind")) {
                        RootPathFinder rootPathFinder = new RootPathFinder(j9ObjectPointer, printStream);
                        LiveSetWalker.walkLiveSet(rootPathFinder, RootSet.RootSetType.STRONG_REACHABLE);
                        if (!rootPathFinder._pathFound) {
                            printStream.println("No paths from roots found");
                        }
                    } else if (string.equals("!anyrootpathfind")) {
                        RootPathFinder rootPathFinder = new RootPathFinder(j9ObjectPointer, printStream);
                        LiveSetWalker.walkLiveSet(rootPathFinder, RootSet.RootSetType.ALL);
                        if (!rootPathFinder._pathFound) {
                            printStream.println("No paths from roots found");
                        }
                    } else if (string.equals("!weakrootpathfindall")) {
                        RootPathFinder rootPathFinder = new RootPathFinder(j9ObjectPointer, printStream);
                        LiveSetWalker.walkLiveSet(rootPathFinder, RootSet.RootSetType.WEAK_REACHABLE);
                        if (!rootPathFinder._pathFound) {
                            printStream.println("No paths from roots found");
                        }
                    } else if (string.equals("!isobjectalive")) {
                        ObjectFinderVisitor objectFinderVisitor = new ObjectFinderVisitor(j9ObjectPointer);
                        LiveSetWalker.walkLiveSet(objectFinderVisitor);
                        if (objectFinderVisitor._objectFound) {
                            printStream.println("Object is live");
                        } else {
                            printStream.println("Object is not live");
                        }
                    }
                    if (((RootPathCommandListener)object)._corruptionFound) {
                        printStream.println("Corruption detected walking live set");
                        if (!this._verboseEnabled) {
                            printStream.println("run !rootpathverbose and re-run command to see corruptions");
                        }
                    }
                    EventManager.unregister((IEventListener)object);
                    break;
                }
                catch (CorruptDataException corruptDataException) {
                    throw new DDRInteractiveCommandException("Memory fault while walking live set", corruptDataException);
                }
            }
            default: {
                throw new DDRInteractiveCommandException("Invalid number of arguments");
            }
        }
    }

    private class RootPathCommandListener
    implements IEventListener {
        public boolean _corruptionFound = false;

        private RootPathCommandListener() {
        }

        @Override
        public void corruptData(String string, CorruptDataException corruptDataException, boolean bl) {
            this._corruptionFound = true;
            if (RootPathCommand.this._verboseEnabled) {
                RootPathCommand.this._listener.corruptData(string, corruptDataException, bl);
            }
        }
    }

    private class RootPathsFinder
    implements LiveSetWalker.ObjectVisitor {
        Stack<J9ObjectPointer> _scanStack = new Stack();
        J9ObjectPointer _objectToFind;
        PrintStream _out;

        public RootPathsFinder(J9ObjectPointer j9ObjectPointer, PrintStream printStream) {
            this._objectToFind = j9ObjectPointer;
            this._out = printStream;
        }

        @Override
        public boolean visit(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
            this._scanStack.push(j9ObjectPointer);
            if (j9ObjectPointer.equals(this._objectToFind)) {
                this.dumpTree();
                this._scanStack.pop();
                return false;
            }
            return true;
        }

        private void dumpTree() {
            this._out.println("\n========================================");
            for (int i = 0; i < this._scanStack.size(); ++i) {
                for (int j = i; j > 0; --j) {
                    this._out.print("  ");
                }
                try {
                    this._out.println(RootPathCommand.objectToString((J9ObjectPointer)this._scanStack.get(i)));
                    continue;
                }
                catch (CorruptDataException corruptDataException) {
                    this._out.println("Invalid Object");
                }
            }
        }

        @Override
        public void finishVisit(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
            this._scanStack.pop();
        }
    }

    private class ObjectFinderVisitor
    implements LiveSetWalker.ObjectVisitor {
        boolean _objectFound = false;
        J9ObjectPointer _objectToFind;

        public ObjectFinderVisitor(J9ObjectPointer j9ObjectPointer) {
            this._objectToFind = j9ObjectPointer;
        }

        @Override
        public boolean visit(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
            if (this._objectFound) {
                return false;
            }
            if (j9ObjectPointer.equals(this._objectToFind)) {
                this._objectFound = true;
                return false;
            }
            return true;
        }

        @Override
        public void finishVisit(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        }
    }

    private class RootPathFinder
    implements LiveSetWalker.ObjectVisitor {
        boolean _pathFound = false;
        J9ObjectPointer _objectToFind;
        Stack<J9ObjectPointer> _scanStack = new Stack();
        PrintStream _out;

        public RootPathFinder(J9ObjectPointer j9ObjectPointer, PrintStream printStream) {
            this._objectToFind = j9ObjectPointer;
            this._out = printStream;
        }

        @Override
        public boolean visit(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
            if (this._pathFound) {
                return false;
            }
            this._scanStack.push(j9ObjectPointer);
            if (j9ObjectPointer.equals(this._objectToFind)) {
                this.dumpTree();
                this._pathFound = true;
                this._scanStack.pop();
                return false;
            }
            return true;
        }

        private void dumpTree() {
            this._out.println("\n========================================");
            for (int i = 0; i < this._scanStack.size(); ++i) {
                for (int j = i; j > 0; --j) {
                    this._out.print("  ");
                }
                try {
                    this._out.println(RootPathCommand.objectToString((J9ObjectPointer)this._scanStack.get(i)));
                    continue;
                }
                catch (CorruptDataException corruptDataException) {
                    this._out.println("Invalid Object");
                }
            }
        }

        @Override
        public void finishVisit(J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
            this._scanStack.pop();
        }
    }
}

